<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class MaintenanceType extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'default_interval_km',
        'default_interval_days',
        'estimated_cost',
        'status',
    ];

    protected $casts = [
        'estimated_cost' => 'decimal:2',
        'default_interval_km' => 'integer',
        'default_interval_days' => 'integer',
    ];

    public function maintenances()
    {
        return $this->hasMany(VehicleMaintenance::class);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }
}
