@extends('layouts.app')

@section('title', __('edit') . ' ' . __('costs') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admincreatepage.css') }}">
@endpush

@section('content')
<div class="create-page-container">
    {{-- Page Header --}}
    <div class="create-page-header">
        <div class="create-page-header-content">
            <div class="create-page-breadcrumb">
                <a href="{{ route('admin.dashboard') }}">{{ __('dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.costs.index') }}">{{ __('costs') }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ __('edit') }} - {{ $cost->trip->trip_number }}</span>
            </div>
            <h1 class="create-page-title">
                <div class="create-page-title-icon">
                    <i class="bi bi-pencil"></i>
                </div>
                {{ __('edit') }} {{ __('costs') }}
            </h1>
            <p class="create-page-subtitle">{{ __('Update cost record for') }} {{ $cost->trip->trip_number }}</p>
        </div>
        <div class="create-page-actions">
            <a href="{{ route('admin.costs.index') }}" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('back') }}
            </a>
        </div>
    </div>

    {{-- Validation Errors --}}
    @if($errors->any())
        <div class="create-alert danger">
            <div class="create-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="create-alert-content">
                <div class="create-alert-title">{{ __('Please fix the following errors') }}</div>
                <div class="create-alert-text">
                    <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    @endif

    <form action="{{ route('admin.costs.update', $cost) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="create-form-layout">
            {{-- Main Form --}}
            <div class="create-form-main">
                {{-- Trip Information Card (Read-only) --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon primary">
                            <i class="bi bi-geo-alt"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('trip') }} {{ __('information') }}</h5>
                            <p class="create-card-subtitle">{{ __('Associated trip details') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="alert alert-info mb-0">
                            <h6 class="fw-bold mb-2">
                                {{ __('trip_details') }}:
                                <a href="{{ route('admin.trips.show', $cost->trip) }}" class="float-end text-decoration-none">
                                    <i class="bi bi-box-arrow-up-right"></i> {{ __('view') }} {{ __('trip') }}
                                </a>
                            </h6>
                            <div class="row g-2">
                                <div class="col-md-6">
                                    <small class="text-muted">{{ __('trip_number') }}:</small><br>
                                    <strong>{{ $cost->trip->trip_number }}</strong>
                                </div>
                                <div class="col-md-6">
                                    <small class="text-muted">{{ __('vehicle') }}:</small><br>
                                    <strong>{{ $cost->trip->vehicle->vehicle_number ?? 'N/A' }}</strong>
                                </div>
                                <div class="col-md-6">
                                    <small class="text-muted">{{ __('driver') }}:</small><br>
                                    <strong>{{ $cost->trip->driver->name ?? 'N/A' }}</strong>
                                </div>
                                <div class="col-md-6">
                                    <small class="text-muted">{{ __('shipment') }}:</small><br>
                                    <strong>{{ $cost->trip->shipment_reference ?? 'N/A' }}</strong>
                                </div>
                                <div class="col-md-6">
                                    <small class="text-muted">{{ __('pickup_location') }}:</small><br>
                                    <strong>{{ $cost->trip->pickup_location }}</strong>
                                </div>
                                <div class="col-md-6">
                                    <small class="text-muted">{{ __('drop_location') }}:</small><br>
                                    <strong>{{ $cost->trip->drop_location ?? 'N/A' }}</strong>
                                </div>
                                <div class="col-md-12">
                                    <small class="text-muted">{{ __('completed_at') }}:</small><br>
                                    <strong>
                                        {{ $cost->trip->end_date ? \Carbon\Carbon::parse($cost->trip->end_date)->format('M d, Y H:i') : 'N/A' }}
                                    </strong>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Cost Details Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon success">
                            <i class="bi bi-cash-stack"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('cost') }} {{ __('details') }}</h5>
                            <p class="create-card-subtitle">{{ __('Update trip related costs') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-cash"></i>
                                    {{ __('base_cost') }} (USD)
                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-group">
                                    <span class="create-input-addon create-input-addon-left">$</span>
                                    <input type="number" 
                                           class="create-input @error('base_cost') is-invalid @enderror" 
                                           id="base_cost" 
                                           name="base_cost" 
                                           step="0.01" 
                                           min="0"
                                           value="{{ old('base_cost', $cost->base_cost) }}"
                                           required
                                           onchange="calculateTotal()">
                                </div>
                                @error('base_cost')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                                <p class="create-form-hint">
                                    <i class="bi bi-lightbulb"></i>
                                    Base transportation cost
                                </p>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-signpost-split"></i>
                                    {{ __('toll_cost') }} (USD)
                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-group">
                                    <span class="create-input-addon create-input-addon-left">$</span>
                                    <input type="number" 
                                           class="create-input @error('toll_cost') is-invalid @enderror" 
                                           id="toll_cost" 
                                           name="toll_cost" 
                                           step="0.01" 
                                           min="0"
                                           value="{{ old('toll_cost', $cost->toll_cost) }}"
                                           required
                                           onchange="calculateTotal()">
                                </div>
                                @error('toll_cost')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                                <p class="create-form-hint">
                                    <i class="bi bi-lightbulb"></i>
                                    Toll charges during the trip
                                </p>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-person-badge"></i>
                                    {{ __('driver_allowance') }} (USD)
                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-group">
                                    <span class="create-input-addon create-input-addon-left">$</span>
                                    <input type="number" 
                                           class="create-input @error('driver_allowance') is-invalid @enderror" 
                                           id="driver_allowance" 
                                           name="driver_allowance" 
                                           step="0.01" 
                                           min="0"
                                           value="{{ old('driver_allowance', $cost->driver_allowance) }}"
                                           required
                                           onchange="calculateTotal()">
                                </div>
                                @error('driver_allowance')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                                <p class="create-form-hint">
                                    <i class="bi bi-lightbulb"></i>
                                    Daily allowance for driver
                                </p>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-fuel-pump"></i>
                                    {{ __('fuel_cost') }} (USD)
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-group">
                                    <span class="create-input-addon create-input-addon-left">$</span>
                                    <input type="number" 
                                           class="create-input @error('fuel_cost') is-invalid @enderror" 
                                           id="fuel_cost" 
                                           name="fuel_cost" 
                                           step="0.01" 
                                           min="0"
                                           value="{{ old('fuel_cost', $cost->fuel_cost) }}"
                                           onchange="calculateTotal()">
                                </div>
                                @error('fuel_cost')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                                <p class="create-form-hint">
                                    <i class="bi bi-lightbulb"></i>
                                    Fuel expenses
                                </p>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-three-dots"></i>
                                    {{ __('other_costs') }} (USD)
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-group">
                                    <span class="create-input-addon create-input-addon-left">$</span>
                                    <input type="number" 
                                           class="create-input @error('other_costs') is-invalid @enderror" 
                                           id="other_costs" 
                                           name="other_costs" 
                                           step="0.01" 
                                           min="0"
                                           value="{{ old('other_costs', $cost->other_costs) }}"
                                           onchange="calculateTotal()">
                                </div>
                                @error('other_costs')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                                <p class="create-form-hint">
                                    <i class="bi bi-lightbulb"></i>
                                    Miscellaneous expenses
                                </p>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-calculator"></i>
                                    {{ __('total_cost') }} (USD)
                                </label>
                                <div class="create-input-group">
                                    <span class="create-input-addon create-input-addon-left bg-success text-white">$</span>
                                    <input type="text" 
                                           class="create-input fw-bold text-success" 
                                           id="total_cost_display" 
                                           value="{{ number_format($cost->total_cost, 2) }}"
                                           readonly>
                                </div>
                                <p class="create-form-hint">
                                    <i class="bi bi-info-circle"></i>
                                    Auto-calculated total
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Notes Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon info">
                            <i class="bi bi-journal-text"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('notes') }}</h5>
                            <p class="create-card-subtitle">{{ __('Additional remarks') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-group">
                            <label class="create-form-label">
                                <i class="bi bi-pencil"></i>
                                {{ __('notes') }}
                                <span class="create-form-optional">({{ __('Optional') }})</span>
                            </label>
                            <textarea class="create-textarea @error('notes') is-invalid @enderror" 
                                      id="notes" 
                                      name="notes" 
                                      rows="3"
                                      placeholder="Additional cost notes or remarks...">{{ old('notes', $cost->notes) }}</textarea>
                            @error('notes')
                                <div class="create-form-error">
                                    <i class="bi bi-exclamation-circle"></i>
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        {{-- Audit Info --}}
                        <div class="alert alert-light mb-0 mt-3">
                            <small class="text-muted">
                                <i class="bi bi-info-circle"></i>
                                <strong>{{ __('created_by') }}:</strong> {{ $cost->creator->name ?? 'N/A' }} on 
                                {{ \Carbon\Carbon::parse($cost->created_at)->format('M d, Y H:i') }}
                                @if($cost->updated_at != $cost->created_at)
                                <br>
                                <strong>{{ __('last_updated') }}:</strong> 
                                {{ \Carbon\Carbon::parse($cost->updated_at)->format('M d, Y H:i') }}
                                @endif
                            </small>
                        </div>
                    </div>

                    {{-- Form Actions --}}
                    <div class="create-card-actions">
                        <div class="create-card-actions-left">
                            <a href="{{ route('admin.costs.index') }}" class="create-btn create-btn-secondary">
                                <i class="bi bi-x-circle"></i>
                                {{ __('cancel') }}
                            </a>
                        </div>
                        <div class="create-card-actions-right">
                            <button type="submit" class="create-btn create-btn-primary">
                                <i class="bi bi-check-circle"></i>
                                {{ __('update') }} {{ __('costs') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Sidebar --}}
            <div class="create-form-sidebar">
                {{-- Current Total Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon success">
                            <i class="bi bi-currency-dollar"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Current Total') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-status-preview">
                            <span class="create-status-badge active">
                                <i class="bi bi-calculator"></i>
                                $<span id="sidebar-total">{{ number_format($cost->total_cost, 2) }}</span>
                            </span>
                            <p class="create-status-description">
                                {{ __('Total cost for this trip') }}
                            </p>
                        </div>
                    </div>
                </div>

                {{-- Cost Breakdown Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon warning">
                            <i class="bi bi-pie-chart"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Cost Breakdown') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-truck text-primary"></i>
                                <span>{{ __('base_cost') }}: $<span id="breakdown-base">{{ number_format($cost->base_cost, 2) }}</span></span>
                            </li>
                            <li>
                                <i class="bi bi-signpost-split text-warning"></i>
                                <span>{{ __('toll_cost') }}: $<span id="breakdown-toll">{{ number_format($cost->toll_cost, 2) }}</span></span>
                            </li>
                            <li>
                                <i class="bi bi-person-badge text-info"></i>
                                <span>{{ __('driver_allowance') }}: $<span id="breakdown-driver">{{ number_format($cost->driver_allowance, 2) }}</span></span>
                            </li>
                            <li>
                                <i class="bi bi-fuel-pump text-danger"></i>
                                <span>{{ __('fuel_cost') }}: $<span id="breakdown-fuel">{{ number_format($cost->fuel_cost, 2) }}</span></span>
                            </li>
                            <li>
                                <i class="bi bi-three-dots text-secondary"></i>
                                <span>{{ __('other_costs') }}: $<span id="breakdown-other">{{ number_format($cost->other_costs, 2) }}</span></span>
                            </li>
                        </ul>
                    </div>
                </div>

                {{-- Record Info Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon info">
                            <i class="bi bi-clock-history"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Record Info') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-hash text-muted"></i>
                                <span><strong>ID:</strong> #{{ $cost->id }}</span>
                            </li>
                            <li>
                                <i class="bi bi-person text-muted"></i>
                                <span><strong>{{ __('created_by') }}:</strong> {{ $cost->creator->name ?? 'N/A' }}</span>
                            </li>
                            <li>
                                <i class="bi bi-calendar text-muted"></i>
                                <span><strong>{{ __('created_at') }}:</strong> {{ \Carbon\Carbon::parse($cost->created_at)->format('M d, Y') }}</span>
                            </li>
                            @if($cost->updated_at != $cost->created_at)
                            <li>
                                <i class="bi bi-clock text-muted"></i>
                                <span><strong>{{ __('last_updated') }}:</strong> {{ \Carbon\Carbon::parse($cost->updated_at)->format('M d, Y H:i') }}</span>
                            </li>
                            @endif
                        </ul>
                    </div>
                </div>

                {{-- Quick Actions Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon primary">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Quick Actions') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="{{ route('admin.costs.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                <span>{{ __('View All') }} {{ __('costs') }}</span>
                            </a>
                            <a href="{{ route('admin.trips.show', $cost->trip) }}" class="create-quick-action-btn">
                                <i class="bi bi-geo-alt"></i>
                                <span>{{ __('view') }} {{ __('trip') }}</span>
                            </a>
                            <a href="{{ route('admin.costs.create') }}" class="create-quick-action-btn">
                                <i class="bi bi-plus-circle"></i>
                                <span>{{ __('add') }} {{ __('New Cost') }}</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
    // Calculate total cost and update displays
    function calculateTotal() {
        const baseCost = parseFloat(document.getElementById('base_cost').value) || 0;
        const tollCost = parseFloat(document.getElementById('toll_cost').value) || 0;
        const driverAllowance = parseFloat(document.getElementById('driver_allowance').value) || 0;
        const fuelCost = parseFloat(document.getElementById('fuel_cost').value) || 0;
        const otherCosts = parseFloat(document.getElementById('other_costs').value) || 0;

        const total = baseCost + tollCost + driverAllowance + fuelCost + otherCosts;
        
        // Update main total display
        document.getElementById('total_cost_display').value = total.toFixed(2);
        
        // Update sidebar total
        document.getElementById('sidebar-total').textContent = total.toFixed(2);
        
        // Update breakdown values
        document.getElementById('breakdown-base').textContent = baseCost.toFixed(2);
        document.getElementById('breakdown-toll').textContent = tollCost.toFixed(2);
        document.getElementById('breakdown-driver').textContent = driverAllowance.toFixed(2);
        document.getElementById('breakdown-fuel').textContent = fuelCost.toFixed(2);
        document.getElementById('breakdown-other').textContent = otherCosts.toFixed(2);
    }

    // Initialize on page load
    document.addEventListener('DOMContentLoaded', function() {
        calculateTotal();
    });
</script>
@endsection