@extends('layouts.app')

@section('title', __('costs') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/adminlistpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header --}}
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-currency-dollar"></i>
                {{ __('costs') }}
            </h1>
            <p class="list-page-subtitle">{{ __('manage') }} {{ __('trip') }} {{ __('costs') }} {{ __('and') }} {{ __('expenses') }}</p>
        </div>
        <div class="list-page-header-actions">
            @if(auth()->user()->hasPermission('trips.create'))
            <a href="{{ route('admin.costs.create') }}" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                {{ __('add') }} {{ __('costs') }}
            </a>
            @endif
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- Stats Bar --}}
    <div class="list-stats-bar">
        <div class="list-stat-card gradient-violet">
            <div class="list-stat-icon">
                <i class="bi bi-receipt"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $costs->total() }}</div>
                <div class="list-stat-label">{{ __('total') }} {{ __('records') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-graph-up-arrow"></i>
                {{ __('All time') }}
            </div>
        </div>
        <div class="list-stat-card gradient-blue">
            <div class="list-stat-icon">
                <i class="bi bi-cash"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">${{ number_format($costs->sum('base_cost'), 0) }}</div>
                <div class="list-stat-label">{{ __('base_cost') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-truck"></i>
                {{ __('Transportation') }}
            </div>
        </div>
        <div class="list-stat-card gradient-amber">
            <div class="list-stat-icon">
                <i class="bi bi-fuel-pump"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">${{ number_format($costs->sum('fuel_cost'), 0) }}</div>
                <div class="list-stat-label">{{ __('fuel_cost') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-droplet"></i>
                {{ __('Fuel') }}
            </div>
        </div>
        <div class="list-stat-card gradient-green">
            <div class="list-stat-icon">
                <i class="bi bi-calculator"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">${{ number_format($costs->sum('total_cost'), 0) }}</div>
                <div class="list-stat-label">{{ __('total_cost') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-check-circle"></i>
                {{ __('Grand Total') }}
            </div>
        </div>
    </div>

    {{-- Filter Bar --}}
    <div class="list-filter-bar">
        <form method="GET" action="{{ route('admin.costs.index') }}">
            <div class="list-filter-row">
                <div class="list-filter-group search-group">
                    <div class="list-search-box">
                        <input type="text" 
                               name="search" 
                               placeholder="{{ __('search') }} {{ __('trip_number') }}..." 
                               value="{{ request('search') }}">
                        <i class="bi bi-search"></i>
                    </div>
                </div>
                <div class="list-filter-actions">
                    <button type="submit" class="btn-filter">
                        <i class="bi bi-funnel"></i>
                        {{ __('filter') }}
                    </button>
                    <a href="{{ route('admin.costs.index') }}" class="btn-filter-clear">
                        <i class="bi bi-x-circle"></i>
                        {{ __('clear') }}
                    </a>
                </div>
            </div>
        </form>
    </div>

    {{-- Costs Table --}}
    <div class="list-table-container">
        <div class="list-table-header">
            <h5 class="list-table-title">
                <i class="bi bi-table me-2"></i>
                {{ __('cost') }} {{ __('records') }}
                <span class="list-table-count">({{ $costs->total() }} {{ __('total') }})</span>
            </h5>
        </div>

        @if($costs->isEmpty())
            <div class="list-empty-state">
                <div class="list-empty-icon">
                    <i class="bi bi-currency-dollar"></i>
                </div>
                <h4>{{ __('no_records') }}</h4>
                <p>{{ __('no') }} {{ __('cost') }} {{ __('records') }} {{ __('found') }}. {{ __('add') }} {{ __('costs') }} {{ __('for') }} {{ __('completed') }} {{ __('trips') }}.</p>
                @if(auth()->user()->hasPermission('trips.create'))
                <a href="{{ route('admin.costs.create') }}" class="btn-create">
                    <i class="bi bi-plus-lg"></i>
                    {{ __('add') }} {{ __('costs') }}
                </a>
                @endif
            </div>
        @else
            <div class="table-responsive">
                <table class="list-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('trip_number') }}</th>
                            <th>{{ __('vehicle') }}</th>
                            <th>{{ __('driver') }}</th>
                            <th class="text-end">{{ __('base_cost') }}</th>
                            <th class="text-end">{{ __('toll_cost') }}</th>
                            <th class="text-end">{{ __('fuel_cost') }}</th>
                            <th class="text-end">{{ __('other_costs') }}</th>
                            <th class="text-end">{{ __('total_cost') }}</th>
                            <th class="text-center">{{ __('actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($costs as $cost)
                        <tr>
                            <td>
                                <span class="text-muted">{{ $costs->firstItem() + $loop->index }}</span>
                            </td>
                            <td>
                                <a href="{{ route('admin.trips.show', $cost->trip) }}" class="table-cell-id">
                                    {{ $cost->trip->trip_number }}
                                </a>
                            </td>
                            <td>
                                <span class="table-badge table-badge-info">
                                    <i class="bi bi-truck"></i>
                                    {{ $cost->trip->vehicle->vehicle_number ?? 'N/A' }}
                                </span>
                            </td>
                            <td>
                                <div class="table-cell-user">
                                    <div class="table-cell-user-avatar">
                                        <i class="bi bi-person"></i>
                                    </div>
                                    <span>{{ $cost->trip->driver->name ?? 'N/A' }}</span>
                                </div>
                            </td>
                            <td class="text-end">
                                <span class="cost-value">
                                    <span class="cost-currency">$</span>{{ number_format($cost->base_cost, 2) }}
                                </span>
                            </td>
                            <td class="text-end">
                                <span class="cost-value">
                                    <span class="cost-currency">$</span>{{ number_format($cost->toll_cost, 2) }}
                                </span>
                            </td>
                            <td class="text-end">
                                <span class="cost-value">
                                    <span class="cost-currency">$</span>{{ number_format($cost->fuel_cost, 2) }}
                                </span>
                            </td>
                            <td class="text-end">
                                <span class="cost-value">
                                    <span class="cost-currency">$</span>{{ number_format($cost->other_costs, 2) }}
                                </span>
                            </td>
                            <td class="text-end">
                                <span class="cost-total">
                                    <span class="cost-currency">$</span>{{ number_format($cost->total_cost, 2) }}
                                </span>
                            </td>
                            <td>
                                <div class="table-actions">
                                    <a href="{{ route('admin.trips.show', $cost->trip) }}" 
                                       class="btn-table-action btn-table-view" 
                                       title="{{ __('view') }} {{ __('trip') }}">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    @if(auth()->user()->hasPermission('trips.edit'))
                                    <a href="{{ route('admin.costs.edit', $cost) }}" 
                                       class="btn-table-action btn-table-edit" 
                                       title="{{ __('edit') }}">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="table-totals-row">
                            <td colspan="4" class="text-end fw-bold">{{ __('total') }}:</td>
                            <td class="text-end">
                                <span class="cost-total-footer">
                                    <span class="cost-currency">$</span>{{ number_format($costs->sum('base_cost'), 2) }}
                                </span>
                            </td>
                            <td class="text-end">
                                <span class="cost-total-footer">
                                    <span class="cost-currency">$</span>{{ number_format($costs->sum('toll_cost'), 2) }}
                                </span>
                            </td>
                            <td class="text-end">
                                <span class="cost-total-footer">
                                    <span class="cost-currency">$</span>{{ number_format($costs->sum('fuel_cost'), 2) }}
                                </span>
                            </td>
                            <td class="text-end">
                                <span class="cost-total-footer">
                                    <span class="cost-currency">$</span>{{ number_format($costs->sum('other_costs'), 2) }}
                                </span>
                            </td>
                            <td class="text-end">
                                <span class="cost-grand-total">
                                    <span class="cost-currency">$</span>{{ number_format($costs->sum('total_cost'), 2) }}
                                </span>
                            </td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>

            {{-- Pagination --}}
            @if($costs->hasPages())
            <div class="list-pagination">
                <div class="pagination-info">
                    {{ __('Showing') }} {{ $costs->firstItem() }} {{ __('to') }} {{ $costs->lastItem() }} {{ __('of') }} {{ $costs->total() }} {{ __('entries') }}
                </div>
                <div class="pagination-links">
                    {{ $costs->links() }}
                </div>
            </div>
            @endif
        @endif
    </div>

    {{-- Summary Cards --}}
    @if(!$costs->isEmpty())
    <div class="cost-summary-grid">
        <div class="cost-summary-card">
            <div class="cost-summary-icon" style="background: linear-gradient(135deg, #7c3aed 0%, #a78bfa 100%);">
                <i class="bi bi-currency-dollar"></i>
            </div>
            <div class="cost-summary-content">
                <span class="cost-summary-label">{{ __('total') }} {{ __('base_cost') }}</span>
                <span class="cost-summary-value">${{ number_format($costs->sum('base_cost'), 2) }}</span>
            </div>
        </div>
        <div class="cost-summary-card">
            <div class="cost-summary-icon" style="background: linear-gradient(135deg, #d97706 0%, #fbbf24 100%);">
                <i class="bi bi-signpost-split"></i>
            </div>
            <div class="cost-summary-content">
                <span class="cost-summary-label">{{ __('total') }} {{ __('toll_cost') }}</span>
                <span class="cost-summary-value">${{ number_format($costs->sum('toll_cost'), 2) }}</span>
            </div>
        </div>
        <div class="cost-summary-card">
            <div class="cost-summary-icon" style="background: linear-gradient(135deg, #dc2626 0%, #f87171 100%);">
                <i class="bi bi-fuel-pump"></i>
            </div>
            <div class="cost-summary-content">
                <span class="cost-summary-label">{{ __('total') }} {{ __('fuel_cost') }}</span>
                <span class="cost-summary-value">${{ number_format($costs->sum('fuel_cost'), 2) }}</span>
            </div>
        </div>
        <div class="cost-summary-card">
            <div class="cost-summary-icon" style="background: linear-gradient(135deg, #059669 0%, #34d399 100%);">
                <i class="bi bi-calculator"></i>
            </div>
            <div class="cost-summary-content">
                <span class="cost-summary-label">{{ __('total') }} {{ __('costs') }}</span>
                <span class="cost-summary-value">${{ number_format($costs->sum('total_cost'), 2) }}</span>
            </div>
        </div>
    </div>
    @endif
</div>

<style>
/* Cost Value Styles */
.cost-value {
    font-weight: 500;
    color: var(--text-primary);
}

.cost-currency {
    color: var(--text-muted);
    font-size: 0.85em;
}

.cost-total {
    font-weight: 700;
    color: var(--success-color);
    font-size: 1rem;
}

.cost-total-footer {
    font-weight: 600;
    color: var(--text-primary);
}

.cost-grand-total {
    font-weight: 700;
    color: var(--success-color);
    font-size: 1.1rem;
}

/* Table Totals Row */
.table-totals-row {
    background: var(--body-bg);
}

.table-totals-row td {
    border-top: 2px solid var(--border-color);
    padding-top: 1rem !important;
    padding-bottom: 1rem !important;
}

/* Cost Summary Grid */
.cost-summary-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.25rem;
    margin-top: 1.5rem;
}

.cost-summary-card {
    display: flex;
    align-items: center;
    gap: 1rem;
    background: var(--card-bg);
    border: 1px solid var(--border-color);
    border-radius: 14px;
    padding: 1.25rem 1.5rem;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
    transition: all 0.3s ease;
}

.cost-summary-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.cost-summary-icon {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.cost-summary-icon i {
    font-size: 1.25rem;
    color: #ffffff;
}

.cost-summary-content {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.cost-summary-label {
    font-size: 0.8rem;
    color: var(--text-muted);
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.3px;
}

.cost-summary-value {
    font-size: 1.35rem;
    font-weight: 700;
    color: var(--text-primary);
}

[data-theme="dark"] .cost-summary-card {
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
}

[data-theme="dark"] .cost-summary-card:hover {
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
}

@media (max-width: 767.98px) {
    .cost-summary-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .cost-summary-card {
        padding: 1rem;
    }
    
    .cost-summary-icon {
        width: 42px;
        height: 42px;
    }
    
    .cost-summary-value {
        font-size: 1.1rem;
    }
}

@media (max-width: 480px) {
    .cost-summary-grid {
        grid-template-columns: 1fr;
    }
}
</style>
@endsection