@extends('layouts.app')

@section('title', __('add_delivery') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admincreatepage.css') }}">
@endpush

@section('content')
<div class="create-page-container">
    {{-- Page Header --}}
    <div class="create-page-header">
        <div class="create-page-header-content">
            <div class="create-page-breadcrumb">
                <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.deliveries.index') }}">{{ __('deliveries') }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ __('Create') }}</span>
            </div>
            <h1 class="create-page-title">
                <div class="create-page-title-icon">
                    <i class="bi bi-plus-lg"></i>
                </div>
                {{ __('add_delivery') }}
            </h1>
            <p class="create-page-subtitle">{{ __('Fill in the details below to create a new delivery record') }}</p>
        </div>
        <div class="create-page-actions">
            <a href="{{ route('admin.deliveries.index') }}" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('Back to List') }}
            </a>
        </div>
    </div>

    {{-- Validation Errors --}}
    @if($errors->any())
        <div class="create-alert danger">
            <div class="create-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="create-alert-content">
                <div class="create-alert-title">{{ __('Validation Error') }}</div>
                <div class="create-alert-text">{{ __('Please check the form and fix the errors below.') }}</div>
            </div>
        </div>
    @endif

    {{-- No Trips Warning --}}
    @if($trips->isEmpty())
        <div class="create-alert warning">
            <div class="create-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="create-alert-content">
                <div class="create-alert-title">{{ __('no_trips_available') }}</div>
                <div class="create-alert-text">
                    {{ __('To create a delivery, you need a completed trip without an existing delivery record. Please ensure you have trips with "delivered" status.') }}
                </div>
            </div>
        </div>
    @endif

    <form action="{{ route('admin.deliveries.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="create-form-layout">
            {{-- Main Form --}}
            <div class="create-form-main">
                {{-- Trip Selection Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-icon primary">
                            <i class="bi bi-geo-alt"></i>
                        </div>
                        <div>
                            <h5 class="create-card-title">{{ __('trip') }}</h5>
                            <p class="create-card-subtitle">{{ __('Select the completed trip for this delivery') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-group">
                            <label for="trip_id" class="create-label required">{{ __('select_trip') }}</label>
                            <select class="create-select @error('trip_id') is-invalid @enderror" 
                                    id="trip_id" 
                                    name="trip_id" 
                                    required 
                                    {{ $trips->isEmpty() ? 'disabled' : '' }}>
                                <option value="">{{ __('select_option') }}</option>
                                @foreach($trips as $trip)
                                <option value="{{ $trip->id }}" {{ old('trip_id') == $trip->id ? 'selected' : '' }}>
                                    {{ $trip->trip_number }} - 
                                    {{ $trip->vehicle->vehicle_number ?? 'N/A' }} - 
                                    {{ $trip->driver->name ?? 'N/A' }}
                                </option>
                                @endforeach
                            </select>
                            @error('trip_id')
                                <div class="create-error">{{ $message }}</div>
                            @enderror
                            <small class="create-help">{{ __('Only trips with "delivered" status are available') }}</small>
                        </div>
                    </div>
                </div>

                {{-- Customer Information Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-icon info">
                            <i class="bi bi-person"></i>
                        </div>
                        <div>
                            <h5 class="create-card-title">{{ __('customer_details') }}</h5>
                            <p class="create-card-subtitle">{{ __('Enter the customer information') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="customer_name" class="create-label required">{{ __('customer_name') }}</label>
                                <input type="text" 
                                       class="create-input @error('customer_name') is-invalid @enderror" 
                                       id="customer_name" 
                                       name="customer_name" 
                                       value="{{ old('customer_name') }}"
                                       placeholder="{{ __('Enter customer name') }}"
                                       required>
                                @error('customer_name')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="create-form-group">
                                <label for="customer_phone" class="create-label">{{ __('customer_phone') }}</label>
                                <input type="tel" 
                                       class="create-input @error('customer_phone') is-invalid @enderror" 
                                       id="customer_phone" 
                                       name="customer_phone" 
                                       value="{{ old('customer_phone') }}"
                                       placeholder="+91 98765 43210">
                                @error('customer_phone')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-group">
                            <label for="customer_email" class="create-label">{{ __('customer_email') }}</label>
                            <input type="email" 
                                   class="create-input @error('customer_email') is-invalid @enderror" 
                                   id="customer_email" 
                                   name="customer_email" 
                                   value="{{ old('customer_email') }}"
                                   placeholder="customer@example.com">
                            @error('customer_email')
                                <div class="create-error">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="create-form-group">
                            <label for="delivery_address" class="create-label required">{{ __('delivery_address') }}</label>
                            <textarea class="create-textarea @error('delivery_address') is-invalid @enderror" 
                                      id="delivery_address" 
                                      name="delivery_address" 
                                      rows="3"
                                      placeholder="{{ __('Enter complete delivery address') }}"
                                      required>{{ old('delivery_address') }}</textarea>
                            @error('delivery_address')
                                <div class="create-error">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Delivery Details Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-icon success">
                            <i class="bi bi-clipboard-check"></i>
                        </div>
                        <div>
                            <h5 class="create-card-title">{{ __('delivery_information') }}</h5>
                            <p class="create-card-subtitle">{{ __('Enter delivery details and status') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="delivered_at" class="create-label required">{{ __('delivered_at') }}</label>
                                <input type="datetime-local" 
                                       class="create-input @error('delivered_at') is-invalid @enderror" 
                                       id="delivered_at" 
                                       name="delivered_at" 
                                       value="{{ old('delivered_at') }}"
                                       required>
                                @error('delivered_at')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="create-form-group">
                                <label for="delivery_status" class="create-label required">{{ __('delivery_status') }}</label>
                                <select class="create-select @error('delivery_status') is-invalid @enderror" 
                                        id="delivery_status" 
                                        name="delivery_status" 
                                        required>
                                    <option value="">{{ __('select_option') }}</option>
                                    <option value="pending" {{ old('delivery_status') === 'pending' ? 'selected' : '' }}>
                                        {{ __('pending') }}
                                    </option>
                                    <option value="partial" {{ old('delivery_status') === 'partial' ? 'selected' : '' }}>
                                        {{ __('partial') }}
                                    </option>
                                    <option value="completed" {{ old('delivery_status') === 'completed' ? 'selected' : '' }}>
                                        {{ __('completed') }}
                                    </option>
                                    <option value="failed" {{ old('delivery_status') === 'failed' ? 'selected' : '' }}>
                                        {{ __('failed') }}
                                    </option>
                                </select>
                                @error('delivery_status')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-group">
                            <label for="delivery_remarks" class="create-label">{{ __('delivery_remarks') }}</label>
                            <textarea class="create-textarea @error('delivery_remarks') is-invalid @enderror" 
                                      id="delivery_remarks" 
                                      name="delivery_remarks" 
                                      rows="3"
                                      placeholder="{{ __('Any additional remarks or notes...') }}">{{ old('delivery_remarks') }}</textarea>
                            @error('delivery_remarks')
                                <div class="create-error">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Documents Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-icon warning">
                            <i class="bi bi-file-earmark-image"></i>
                        </div>
                        <div>
                            <h5 class="create-card-title">{{ __('proof_of_delivery') }}</h5>
                            <p class="create-card-subtitle">{{ __('Upload signature and POD documents') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="signature" class="create-label">{{ __('signature') }}</label>
                                <div class="create-file-upload">
                                    <input type="file" 
                                           class="create-file-input @error('signature') is-invalid @enderror" 
                                           id="signature" 
                                           name="signature" 
                                           accept="image/jpeg,image/jpg,image/png">
                                    <label for="signature" class="create-file-label">
                                        <i class="bi bi-cloud-upload"></i>
                                        <span>{{ __('Choose signature file') }}</span>
                                    </label>
                                </div>
                                @error('signature')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                                <small class="create-help">{{ __('Max 2MB. Formats: JPG, PNG') }}</small>
                            </div>

                            <div class="create-form-group">
                                <label for="pod_file" class="create-label">{{ __('pod_file') }}</label>
                                <div class="create-file-upload">
                                    <input type="file" 
                                           class="create-file-input @error('pod_file') is-invalid @enderror" 
                                           id="pod_file" 
                                           name="pod_file" 
                                           accept="image/jpeg,image/jpg,image/png,application/pdf">
                                    <label for="pod_file" class="create-file-label">
                                        <i class="bi bi-cloud-upload"></i>
                                        <span>{{ __('Choose POD file') }}</span>
                                    </label>
                                </div>
                                @error('pod_file')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                                <small class="create-help">{{ __('Max 5MB. Formats: JPG, PNG, PDF') }}</small>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Form Actions --}}
                <div class="create-card">
                    <div class="create-card-body">
                        <div class="create-form-actions">
                            <a href="{{ route('admin.deliveries.index') }}" class="create-btn create-btn-secondary">
                                <i class="bi bi-x-lg"></i>
                                {{ __('cancel') }}
                            </a>
                            <button type="submit" class="create-btn create-btn-primary" {{ $trips->isEmpty() ? 'disabled' : '' }}>
                                <i class="bi bi-save"></i>
                                {{ __('Create Delivery') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Sidebar --}}
            <div class="create-form-sidebar">
                {{-- Tips Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon info">
                            <i class="bi bi-lightbulb"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Quick Tips') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Only trips with "delivered" status can have delivery records') }}</span>
                            </li>
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Customer name and address are required fields') }}</span>
                            </li>
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Upload POD and signature for complete records') }}</span>
                            </li>
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Setting status to "completed" will finalize the trip') }}</span>
                            </li>
                        </ul>
                    </div>
                </div>

                {{-- Status Info Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon warning">
                            <i class="bi bi-info-circle"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Status Guide') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-status-guide">
                            <div class="create-status-item">
                                <span class="create-status-badge pending">
                                    <i class="bi bi-clock"></i>
                                    {{ __('pending') }}
                                </span>
                                <p>{{ __('Delivery awaiting completion') }}</p>
                            </div>
                            <div class="create-status-item">
                                <span class="create-status-badge warning">
                                    <i class="bi bi-exclamation-circle"></i>
                                    {{ __('partial') }}
                                </span>
                                <p>{{ __('Partial delivery completed') }}</p>
                            </div>
                            <div class="create-status-item">
                                <span class="create-status-badge success">
                                    <i class="bi bi-check-circle"></i>
                                    {{ __('completed') }}
                                </span>
                                <p>{{ __('Delivery successfully completed') }}</p>
                            </div>
                            <div class="create-status-item">
                                <span class="create-status-badge danger">
                                    <i class="bi bi-x-circle"></i>
                                    {{ __('failed') }}
                                </span>
                                <p>{{ __('Delivery failed or cancelled') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Quick Actions Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon success">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Quick Actions') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="{{ route('admin.deliveries.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                {{ __('View All Deliveries') }}
                            </a>
                            <a href="{{ route('admin.trips.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-geo-alt"></i>
                                {{ __('Manage Trips') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // File upload preview
    const fileInputs = document.querySelectorAll('.create-file-input');
    fileInputs.forEach(input => {
        input.addEventListener('change', function() {
            const label = this.nextElementSibling;
            const fileName = this.files[0]?.name || 'Choose file';
            label.querySelector('span').textContent = fileName;
        });
    });
});
</script>
@endpush