@extends('layouts.app')

@section('title', __('Edit Fuel Log') . ' - ' . $fuelLog->fuel_number)

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admincreatepage.css') }}">
@endpush

@section('content')
<div class="create-page-container">
    {{-- Page Header --}}
    <div class="create-page-header">
        <div class="create-page-header-content">
            <div class="create-page-breadcrumb">
                <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.fuel-logs.index') }}">{{ __('Fuel Logs') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.fuel-logs.show', $fuelLog) }}">{{ $fuelLog->fuel_number }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ __('Edit') }}</span>
            </div>
            <h1 class="create-page-title">
                <div class="create-page-title-icon">
                    <i class="bi bi-pencil"></i>
                </div>
                {{ __('Edit Fuel Log') }}
            </h1>
            <p class="create-page-subtitle">{{ __('Update the fuel log details below') }}</p>
        </div>
        <div class="create-page-actions">
            <a href="{{ route('admin.fuel-logs.show', $fuelLog) }}" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('Back to Details') }}
            </a>
        </div>
    </div>

    {{-- Validation Errors --}}
    @if($errors->any())
        <div class="create-alert danger">
            <div class="create-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="create-alert-content">
                <div class="create-alert-title">{{ __('Please fix the following errors') }}</div>
                <div class="create-alert-text">
                    <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    @endif

    <form action="{{ route('admin.fuel-logs.update', $fuelLog) }}" method="POST" id="fuelLogForm">
        @csrf
        @method('PUT')

        <div class="create-form-layout">
            {{-- Main Form --}}
            <div class="create-form-main">
                {{-- Basic Information Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon primary">
                            <i class="bi bi-fuel-pump"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Basic Information') }}</h5>
                            <p class="create-card-subtitle">{{ __('Fuel log identification and vehicle assignment') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-hash"></i>
                                    {{ __('Fuel Log Number') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" 
                                           name="fuel_number" 
                                           id="fuel_number"
                                           class="create-input @error('fuel_number') is-invalid @enderror" 
                                           value="{{ old('fuel_number', $fuelLog->fuel_number) }}"
                                           placeholder="FUEL-2025-0001"
                                           required>
                                    <i class="bi bi-upc-scan create-input-icon"></i>
                                </div>
                                @error('fuel_number')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-truck"></i>
                                    {{ __('Vehicle') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select name="vehicle_id" 
                                        id="vehicle_id"
                                        class="create-select @error('vehicle_id') is-invalid @enderror"
                                        required>
                                    <option value="">{{ __('Select Vehicle') }}</option>
                                    @foreach($vehicles as $vehicle)
                                        <option value="{{ $vehicle->id }}" {{ old('vehicle_id', $fuelLog->vehicle_id) == $vehicle->id ? 'selected' : '' }}>
                                            {{ $vehicle->vehicle_number }} - {{ $vehicle->vehicleType->name ?? '' }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('vehicle_id')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-person"></i>
                                    {{ __('Driver') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <select name="driver_id" 
                                        id="driver_id"
                                        class="create-select @error('driver_id') is-invalid @enderror">
                                    <option value="">{{ __('Select Driver') }}</option>
                                    @foreach($drivers as $driver)
                                        <option value="{{ $driver->id }}" {{ old('driver_id', $fuelLog->driver_id) == $driver->id ? 'selected' : '' }}>
                                            {{ $driver->name }} - {{ $driver->mobile }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('driver_id')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-signpost"></i>
                                    {{ __('Link to Trip') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <select name="trip_id" 
                                        id="trip_id"
                                        class="create-select @error('trip_id') is-invalid @enderror">
                                    <option value="">{{ __('No Trip') }}</option>
                                    @foreach($trips as $trip)
                                        <option value="{{ $trip->id }}" {{ old('trip_id', $fuelLog->trip_id) == $trip->id ? 'selected' : '' }}>
                                            {{ $trip->trip_number }} - {{ $trip->vehicle->vehicle_number ?? '' }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('trip_id')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Fuel Details Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon info">
                            <i class="bi bi-droplet"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Fuel Details') }}</h5>
                            <p class="create-card-subtitle">{{ __('Fuel type, quantity and pricing information') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-droplet-fill"></i>
                                    {{ __('Fuel Type') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select name="fuel_type" 
                                        id="fuel_type"
                                        class="create-select @error('fuel_type') is-invalid @enderror"
                                        required>
                                    <option value="diesel" {{ old('fuel_type', $fuelLog->fuel_type) == 'diesel' ? 'selected' : '' }}>{{ __('Diesel') }}</option>
                                    <option value="petrol" {{ old('fuel_type', $fuelLog->fuel_type) == 'petrol' ? 'selected' : '' }}>{{ __('Petrol') }}</option>
                                    <option value="cng" {{ old('fuel_type', $fuelLog->fuel_type) == 'cng' ? 'selected' : '' }}>{{ __('CNG') }}</option>
                                    <option value="electric" {{ old('fuel_type', $fuelLog->fuel_type) == 'electric' ? 'selected' : '' }}>{{ __('Electric') }}</option>
                                </select>
                                @error('fuel_type')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-water"></i>
                                    {{ __('Quantity') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-group">
                                    <input type="number" 
                                           name="quantity" 
                                           id="quantity"
                                           class="create-input @error('quantity') is-invalid @enderror" 
                                           value="{{ old('quantity', $fuelLog->quantity) }}"
                                           placeholder="0.00"
                                           step="0.01"
                                           min="0.01"
                                           required>
                                    <span class="create-input-addon">L</span>
                                </div>
                                @error('quantity')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-currency-dollar"></i>
                                    {{ __('Price Per Unit') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-group">
                                    <span class="create-input-addon">$</span>
                                    <input type="number" 
                                           name="price_per_unit" 
                                           id="price_per_unit"
                                           class="create-input @error('price_per_unit') is-invalid @enderror" 
                                           value="{{ old('price_per_unit', $fuelLog->price_per_unit) }}"
                                           placeholder="0.00"
                                           step="0.01"
                                           min="0.01"
                                           required>
                                </div>
                                @error('price_per_unit')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-calculator"></i>
                                    {{ __('Total Cost') }}
                                </label>
                                <div class="create-input-group">
                                    <span class="create-input-addon">$</span>
                                    <input type="text" 
                                           id="total_cost_display"
                                           class="create-input" 
                                           value="{{ number_format($fuelLog->total_cost, 2) }}"
                                           readonly
                                           disabled>
                                </div>
                                <p class="create-form-hint">
                                    <i class="bi bi-info-circle"></i>
                                    {{ __('Auto-calculated from quantity × price') }}
                                </p>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-check2-square"></i>
                                    {{ __('Full Tank Fill') }}
                                </label>
                                <div class="create-checkbox-wrapper">
                                    <input type="checkbox" 
                                           name="is_full_tank" 
                                           id="is_full_tank"
                                           class="create-checkbox"
                                           value="1"
                                           {{ old('is_full_tank', $fuelLog->is_full_tank) ? 'checked' : '' }}>
                                    <label for="is_full_tank" class="create-checkbox-label">
                                        {{ __('This was a full tank fill-up') }}
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Odometer & Date Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon warning">
                            <i class="bi bi-speedometer2"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Odometer & Date') }}</h5>
                            <p class="create-card-subtitle">{{ __('Mileage reading and fill-up date/time') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-speedometer"></i>
                                    {{ __('Odometer Reading') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-group">
                                    <input type="number" 
                                           name="odometer_reading" 
                                           id="odometer_reading"
                                           class="create-input @error('odometer_reading') is-invalid @enderror" 
                                           value="{{ old('odometer_reading', $fuelLog->odometer_reading) }}"
                                           placeholder="0"
                                           min="0">
                                    <span class="create-input-addon">km</span>
                                </div>
                                @error('odometer_reading')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                                @if($fuelLog->previous_odometer)
                                    <p class="create-form-hint">
                                        <i class="bi bi-info-circle"></i>
                                        {{ __('Previous reading') }}: {{ number_format($fuelLog->previous_odometer) }} km
                                    </p>
                                @endif
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-credit-card"></i>
                                    {{ __('Payment Method') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select name="payment_method" 
                                        id="payment_method"
                                        class="create-select @error('payment_method') is-invalid @enderror"
                                        required>
                                    <option value="cash" {{ old('payment_method', $fuelLog->payment_method) == 'cash' ? 'selected' : '' }}>{{ __('Cash') }}</option>
                                    <option value="card" {{ old('payment_method', $fuelLog->payment_method) == 'card' ? 'selected' : '' }}>{{ __('Card') }}</option>
                                    <option value="company_account" {{ old('payment_method', $fuelLog->payment_method) == 'company_account' ? 'selected' : '' }}>{{ __('Company Account') }}</option>
                                    <option value="fuel_card" {{ old('payment_method', $fuelLog->payment_method) == 'fuel_card' ? 'selected' : '' }}>{{ __('Fuel Card') }}</option>
                                </select>
                                @error('payment_method')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-calendar"></i>
                                    {{ __('Fill Date') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="date" 
                                           name="fill_date" 
                                           id="fill_date"
                                           class="create-input @error('fill_date') is-invalid @enderror" 
                                           value="{{ old('fill_date', $fuelLog->fill_date->format('Y-m-d')) }}"
                                           required>
                                    <i class="bi bi-calendar-event create-input-icon"></i>
                                </div>
                                @error('fill_date')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-clock"></i>
                                    {{ __('Fill Time') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="time" 
                                           name="fill_time" 
                                           id="fill_time"
                                           class="create-input @error('fill_time') is-invalid @enderror" 
                                           value="{{ old('fill_time', $fuelLog->fill_time) }}">
                                    <i class="bi bi-clock create-input-icon"></i>
                                </div>
                                @error('fill_time')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Station & Receipt Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon success">
                            <i class="bi bi-geo-alt"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Station & Receipt') }}</h5>
                            <p class="create-card-subtitle">{{ __('Fuel station details and receipt information') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-building"></i>
                                    {{ __('Fuel Station') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" 
                                           name="fuel_station" 
                                           id="fuel_station"
                                           class="create-input @error('fuel_station') is-invalid @enderror" 
                                           value="{{ old('fuel_station', $fuelLog->fuel_station) }}"
                                           placeholder="{{ __('e.g., Shell, BP, Petron') }}">
                                    <i class="bi bi-building create-input-icon"></i>
                                </div>
                                @error('fuel_station')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-receipt"></i>
                                    {{ __('Receipt Number') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" 
                                           name="receipt_number" 
                                           id="receipt_number"
                                           class="create-input @error('receipt_number') is-invalid @enderror" 
                                           value="{{ old('receipt_number', $fuelLog->receipt_number) }}"
                                           placeholder="{{ __('Receipt/Invoice number') }}">
                                    <i class="bi bi-receipt create-input-icon"></i>
                                </div>
                                @error('receipt_number')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group full-width">
                                <label class="create-form-label">
                                    <i class="bi bi-pin-map"></i>
                                    {{ __('Station Location') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" 
                                           name="station_location" 
                                           id="station_location"
                                           class="create-input @error('station_location') is-invalid @enderror" 
                                           value="{{ old('station_location', $fuelLog->station_location) }}"
                                           placeholder="{{ __('Address or location of the fuel station') }}">
                                    <i class="bi bi-geo-alt create-input-icon"></i>
                                </div>
                                @error('station_location')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group full-width">
                                <label class="create-form-label">
                                    <i class="bi bi-journal-text"></i>
                                    {{ __('Notes') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <textarea name="notes" 
                                          id="notes"
                                          class="create-textarea @error('notes') is-invalid @enderror"
                                          rows="3"
                                          placeholder="{{ __('Any additional notes or remarks...') }}">{{ old('notes', $fuelLog->notes) }}</textarea>
                                @error('notes')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Form Actions --}}
                <div class="create-form-actions">
                    <a href="{{ route('admin.fuel-logs.show', $fuelLog) }}" class="create-btn create-btn-secondary">
                        <i class="bi bi-x-lg"></i>
                        {{ __('Cancel') }}
                    </a>
                    <button type="submit" class="create-btn create-btn-primary">
                        <i class="bi bi-check-lg"></i>
                        {{ __('Update Fuel Log') }}
                    </button>
                </div>
            </div>

            {{-- Sidebar --}}
            <div class="create-form-sidebar">
                {{-- Current Record --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon info">
                            <i class="bi bi-info-circle"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Current Record') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-status-preview">
                            <div class="status-preview-item">
                                <span class="status-preview-label">{{ __('Fuel #') }}</span>
                                <span class="status-preview-value">{{ $fuelLog->fuel_number }}</span>
                            </div>
                            <div class="status-preview-item">
                                <span class="status-preview-label">{{ __('Vehicle') }}</span>
                                <span class="status-preview-value">{{ $fuelLog->vehicle->vehicle_number }}</span>
                            </div>
                            <div class="status-preview-item">
                                <span class="status-preview-label">{{ __('Created') }}</span>
                                <span class="status-preview-value">{{ $fuelLog->created_at->format('M d, Y') }}</span>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Cost Summary --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon primary">
                            <i class="bi bi-calculator"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Cost Summary') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-status-preview">
                            <div class="status-preview-item">
                                <span class="status-preview-label">{{ __('Quantity') }}</span>
                                <span class="status-preview-value" id="summary_quantity">{{ number_format($fuelLog->quantity, 2) }} L</span>
                            </div>
                            <div class="status-preview-item">
                                <span class="status-preview-label">{{ __('Price/Unit') }}</span>
                                <span class="status-preview-value" id="summary_price">${{ number_format($fuelLog->price_per_unit, 2) }}</span>
                            </div>
                            <div class="status-preview-divider"></div>
                            <div class="status-preview-item highlight">
                                <span class="status-preview-label">{{ __('Total Cost') }}</span>
                                <span class="status-preview-value text-success fw-bold" id="summary_total">${{ number_format($fuelLog->total_cost, 2) }}</span>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Quick Actions --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon primary">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Quick Actions') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="{{ route('admin.fuel-logs.show', $fuelLog) }}" class="create-quick-action-btn">
                                <i class="bi bi-eye"></i>
                                {{ __('View Details') }}
                            </a>
                            <a href="{{ route('admin.fuel-logs.vehicle-history', $fuelLog->vehicle) }}" class="create-quick-action-btn">
                                <i class="bi bi-clock-history"></i>
                                {{ __('Vehicle History') }}
                            </a>
                            <a href="{{ route('admin.fuel-logs.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                {{ __('View All Fuel Logs') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const quantityInput = document.getElementById('quantity');
    const priceInput = document.getElementById('price_per_unit');
    const totalDisplay = document.getElementById('total_cost_display');
    const summaryQuantity = document.getElementById('summary_quantity');
    const summaryPrice = document.getElementById('summary_price');
    const summaryTotal = document.getElementById('summary_total');

    // Calculate total cost
    function calculateTotal() {
        const quantity = parseFloat(quantityInput.value) || 0;
        const price = parseFloat(priceInput.value) || 0;
        const total = quantity * price;

        totalDisplay.value = total.toFixed(2);
        summaryQuantity.textContent = quantity.toFixed(2) + ' L';
        summaryPrice.textContent = '$' + price.toFixed(2);
        summaryTotal.textContent = '$' + total.toFixed(2);
    }

    quantityInput.addEventListener('input', calculateTotal);
    priceInput.addEventListener('input', calculateTotal);
});
</script>
@endpush