@extends('layouts.app')

@section('title', $fuelLog->fuel_number . ' - ' . __('Fuel Log Details'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admindetailpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header with Breadcrumb --}}
    <div class="page-header">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('admin.fuel-logs.index') }}">{{ __('Fuel Logs') }}</a></li>
                    <li class="breadcrumb-item active">{{ $fuelLog->fuel_number }}</li>
                </ol>
            </nav>
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <div class="detail-alert detail-alert-info">
            <div class="detail-alert-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title">{{ __('Success') }}</div>
                <div class="detail-alert-text">{{ session('success') }}</div>
            </div>
        </div>
    @endif

    @if(session('error'))
        <div class="detail-alert detail-alert-warning">
            <div class="detail-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title">{{ __('Error') }}</div>
                <div class="detail-alert-text">{{ session('error') }}</div>
            </div>
        </div>
    @endif

    @php
        $fuelTypeClasses = [
            'diesel' => 'warning',
            'petrol' => 'info',
            'cng' => 'success',
            'electric' => 'primary'
        ];
        $paymentClasses = [
            'cash' => 'success',
            'card' => 'info',
            'company_account' => 'primary',
            'fuel_card' => 'warning'
        ];
    @endphp

    {{-- Hero Section --}}
    <div class="detail-hero">
        <div class="detail-hero-header">
            <div class="detail-hero-content">
                <div class="detail-hero-icon">
                    <i class="bi bi-fuel-pump"></i>
                </div>
                <div class="detail-hero-info">
                    <h1 class="detail-hero-title">{{ $fuelLog->fuel_number }}</h1>
                    <p class="detail-hero-subtitle">{{ $fuelLog->vehicle->vehicle_number }} · {{ __('Filled') }} {{ $fuelLog->fill_date->format('M d, Y') }}</p>
                    <div class="detail-hero-badges">
                        <span class="status-badge status-badge-{{ $fuelTypeClasses[$fuelLog->fuel_type] ?? 'secondary' }}">
                            <i class="bi bi-droplet"></i>
                            {{ __(ucfirst($fuelLog->fuel_type)) }}
                        </span>
                        <span class="status-badge status-badge-{{ $paymentClasses[$fuelLog->payment_method] ?? 'secondary' }}">
                            <i class="bi bi-credit-card"></i>
                            {{ __(ucfirst(str_replace('_', ' ', $fuelLog->payment_method))) }}
                        </span>
                        @if($fuelLog->is_full_tank)
                        <span class="status-badge status-badge-delivered">
                            <i class="bi bi-check-circle"></i>
                            {{ __('Full Tank') }}
                        </span>
                        @endif
                    </div>
                </div>
            </div>
            <div class="detail-actions">
                @if(auth()->user()->hasPermission('fuel.edit'))
                <a href="{{ route('admin.fuel-logs.edit', $fuelLog) }}" class="btn-detail btn-detail-warning">
                    <i class="bi bi-pencil"></i>
                    {{ __('Edit') }}
                </a>
                @endif
                <a href="{{ route('admin.fuel-logs.index') }}" class="btn-detail btn-detail-outline">
                    <i class="bi bi-arrow-left"></i>
                    {{ __('Back to List') }}
                </a>
            </div>
        </div>
        <div class="detail-hero-body">
            <div class="hero-stat">
                <div class="hero-stat-value">{{ number_format($fuelLog->quantity, 2) }}</div>
                <div class="hero-stat-label">{{ __('Liters') }}</div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value">${{ number_format($fuelLog->price_per_unit, 2) }}</div>
                <div class="hero-stat-label">{{ __('Price/Unit') }}</div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value text-success">${{ number_format($fuelLog->total_cost, 2) }}</div>
                <div class="hero-stat-label">{{ __('Total Cost') }}</div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value">{{ $fuelLog->fuel_efficiency ? number_format($fuelLog->fuel_efficiency, 2) : '-' }}</div>
                <div class="hero-stat-label">{{ __('km/L Efficiency') }}</div>
            </div>
        </div>
    </div>

    <div class="row">
        {{-- Main Content --}}
        <div class="col-lg-8">
            {{-- Vehicle Information Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon primary">
                        <i class="bi bi-truck"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Vehicle Information') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="entity-card">
                        <div class="entity-card-avatar primary">
                            <i class="bi bi-truck"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-name">{{ $fuelLog->vehicle->vehicle_number }}</h6>
                            <p class="entity-card-subtitle">{{ $fuelLog->vehicle->vehicleType->name ?? '-' }}</p>
                            <div class="entity-card-meta">
                                @if($fuelLog->vehicle->brand)
                                <span><i class="bi bi-tag"></i> {{ $fuelLog->vehicle->brand }} {{ $fuelLog->vehicle->model ?? '' }}</span>
                                @endif
                                <span><i class="bi bi-palette"></i> {{ $fuelLog->vehicle->color ?? '-' }}</span>
                            </div>
                        </div>
                        <div class="entity-card-action">
                            <a href="{{ route('admin.fuel-logs.vehicle-history', $fuelLog->vehicle) }}" class="btn-detail btn-detail-outline btn-sm">
                                <i class="bi bi-clock-history"></i>
                                {{ __('View Fuel History') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Fuel Details Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon info">
                        <i class="bi bi-droplet"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Fuel Details') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Fuel Type') }}</span>
                            <span class="info-item-value">
                                <span class="badge bg-{{ $fuelTypeClasses[$fuelLog->fuel_type] ?? 'secondary' }}">
                                    {{ __(ucfirst($fuelLog->fuel_type)) }}
                                </span>
                            </span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Quantity') }}</span>
                            <span class="info-item-value highlight">{{ number_format($fuelLog->quantity, 2) }} {{ $fuelLog->fuel_type === 'electric' ? 'kWh' : 'L' }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Price Per Unit') }}</span>
                            <span class="info-item-value">${{ number_format($fuelLog->price_per_unit, 2) }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Total Cost') }}</span>
                            <span class="info-item-value highlight text-success">${{ number_format($fuelLog->total_cost, 2) }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Full Tank') }}</span>
                            <span class="info-item-value">
                                @if($fuelLog->is_full_tank)
                                    <span class="badge bg-success"><i class="bi bi-check"></i> {{ __('Yes') }}</span>
                                @else
                                    <span class="badge bg-secondary">{{ __('No') }}</span>
                                @endif
                            </span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Payment Method') }}</span>
                            <span class="info-item-value">
                                <span class="badge bg-{{ $paymentClasses[$fuelLog->payment_method] ?? 'secondary' }}">
                                    {{ __(ucfirst(str_replace('_', ' ', $fuelLog->payment_method))) }}
                                </span>
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Odometer & Efficiency Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon warning">
                        <i class="bi bi-speedometer2"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Odometer & Efficiency') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Odometer Reading') }}</span>
                            <span class="info-item-value highlight">{{ $fuelLog->odometer_reading ? number_format($fuelLog->odometer_reading) . ' km' : '-' }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Previous Reading') }}</span>
                            <span class="info-item-value">{{ $fuelLog->previous_odometer ? number_format($fuelLog->previous_odometer) . ' km' : '-' }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Distance Traveled') }}</span>
                            <span class="info-item-value">{{ $fuelLog->distance_traveled ? number_format($fuelLog->distance_traveled) . ' km' : '-' }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Fuel Efficiency') }}</span>
                            <span class="info-item-value">
                                @if($fuelLog->fuel_efficiency)
                                    <span class="badge bg-success fs-6">
                                        <i class="bi bi-speedometer2 me-1"></i>
                                        {{ number_format($fuelLog->fuel_efficiency, 2) }} km/L
                                    </span>
                                @else
                                    <span class="text-muted">{{ __('Not calculated') }}</span>
                                @endif
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Station Details Card --}}
            @if($fuelLog->fuel_station || $fuelLog->station_location || $fuelLog->receipt_number)
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon success">
                        <i class="bi bi-geo-alt"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Station Details') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        @if($fuelLog->fuel_station)
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Fuel Station') }}</span>
                            <span class="info-item-value">{{ $fuelLog->fuel_station }}</span>
                        </div>
                        @endif
                        @if($fuelLog->station_location)
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Station Location') }}</span>
                            <span class="info-item-value">{{ $fuelLog->station_location }}</span>
                        </div>
                        @endif
                        @if($fuelLog->receipt_number)
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Receipt Number') }}</span>
                            <span class="info-item-value highlight">{{ $fuelLog->receipt_number }}</span>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
            @endif

            {{-- Notes Card --}}
            @if($fuelLog->notes)
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon secondary">
                        <i class="bi bi-journal-text"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Notes') }}</h5>
                </div>
                <div class="detail-card-body">
                    <p class="mb-0">{{ $fuelLog->notes }}</p>
                </div>
            </div>
            @endif
        </div>

        {{-- Sidebar --}}
        <div class="col-lg-4">
            {{-- Driver Card --}}
            @if($fuelLog->driver)
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon info">
                        <i class="bi bi-person"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Driver') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="entity-card">
                        <div class="entity-card-avatar info">
                            <i class="bi bi-person"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-name">{{ $fuelLog->driver->name }}</h6>
                            <div class="entity-card-meta">
                                <span><i class="bi bi-telephone"></i> {{ $fuelLog->driver->mobile }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            {{-- Linked Trip Card --}}
            @if($fuelLog->trip)
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon warning">
                        <i class="bi bi-signpost"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Linked Trip') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="data-list">
                        <div class="data-list-item">
                            <span class="data-list-item-label">{{ __('Trip Number') }}</span>
                            <span class="data-list-item-value">
                                <a href="{{ route('admin.trips.show', $fuelLog->trip) }}">{{ $fuelLog->trip->trip_number }}</a>
                            </span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">{{ __('Status') }}</span>
                            <span class="data-list-item-value">
                                <span class="badge bg-{{ $fuelLog->trip->status === 'delivered' ? 'success' : 'warning' }}">
                                    {{ __(ucfirst($fuelLog->trip->status)) }}
                                </span>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            {{-- Vehicle Fuel Stats Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon success">
                        <i class="bi bi-graph-up"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Vehicle Fuel Stats') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="data-list">
                        <div class="data-list-item">
                            <span class="data-list-item-label">{{ __('Total Cost') }}</span>
                            <span class="data-list-item-value text-success fw-bold">${{ number_format($vehicleStats['total_cost'] ?? 0, 2) }}</span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">{{ __('Total Fuel') }}</span>
                            <span class="data-list-item-value">{{ number_format($vehicleStats['total_quantity'] ?? 0, 2) }} L</span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">{{ __('Avg Efficiency') }}</span>
                            <span class="data-list-item-value">{{ ($vehicleStats['avg_efficiency'] ?? false) ? number_format($vehicleStats['avg_efficiency'], 2) . ' km/L' : '-' }}</span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">{{ __('Fill Count') }}</span>
                            <span class="data-list-item-value">{{ $vehicleStats['fill_count'] ?? 0 }}</span>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Activity Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon secondary">
                        <i class="bi bi-clock-history"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Activity') }}</h5>
                </div>
                <div class="detail-card-body">
                    @if($fuelLog->creator)
                    <div class="entity-card mb-3">
                        <div class="entity-card-avatar secondary">
                            <i class="bi bi-person-badge"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-name">{{ $fuelLog->creator->name }}</h6>
                            <p class="entity-card-subtitle">{{ __('Created by') }}</p>
                        </div>
                    </div>
                    @endif
                    <div class="detail-timeline">
                        <div class="timeline-item">
                            <div class="timeline-marker info"></div>
                            <div class="timeline-content">
                                <div class="timeline-title">{{ __('Fill Date') }}</div>
                                <div class="timeline-date">
                                    {{ $fuelLog->fill_date->format('M d, Y') }}
                                    @if($fuelLog->fill_time)
                                        · {{ \Carbon\Carbon::parse($fuelLog->fill_time)->format('h:i A') }}
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="timeline-item">
                            <div class="timeline-marker success"></div>
                            <div class="timeline-content">
                                <div class="timeline-title">{{ __('Record Created') }}</div>
                                <div class="timeline-date">{{ $fuelLog->created_at->format('M d, Y h:i A') }}</div>
                            </div>
                        </div>
                        @if($fuelLog->updated_at != $fuelLog->created_at)
                        <div class="timeline-item">
                            <div class="timeline-marker warning"></div>
                            <div class="timeline-content">
                                <div class="timeline-title">{{ __('Last Updated') }}</div>
                                <div class="timeline-date">{{ $fuelLog->updated_at->format('M d, Y h:i A') }}</div>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            {{-- Danger Zone --}}
            @if(auth()->user()->hasPermission('fuel.delete'))
            <div class="detail-card border-danger">
                <div class="detail-card-header bg-danger bg-opacity-10">
                    <div class="detail-card-header-icon" style="background: rgba(220, 53, 69, 0.1); color: #dc3545;">
                        <i class="bi bi-exclamation-triangle"></i>
                    </div>
                    <h5 class="detail-card-title text-danger">{{ __('Danger Zone') }}</h5>
                </div>
                <div class="detail-card-body">
                    <p class="text-muted small mb-3">{{ __('Once you delete this fuel log, there is no going back. Please be certain.') }}</p>
                    <form action="{{ route('admin.fuel-logs.destroy', $fuelLog) }}" method="POST"
                          onsubmit="return confirm('{{ __('Are you sure you want to delete this fuel log?') }}')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="bi bi-trash me-1"></i>
                            {{ __('Delete Fuel Log') }}
                        </button>
                    </form>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection