@extends('layouts.app')

@section('title', __('Fuel History') . ' - ' . $vehicle->vehicle_number)

@push('styles')
<link rel="stylesheet" href="{{ asset('css/adminlistpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header --}}
    <div class="list-page-header">
        <div class="list-page-header-left">
            <div class="list-page-breadcrumb mb-2">
                <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.fuel-logs.index') }}">{{ __('Fuel Logs') }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ $vehicle->vehicle_number }}</span>
            </div>
            <h1 class="list-page-title">
                <i class="bi bi-clock-history"></i>
                {{ __('Fuel History') }}
            </h1>
            <p class="list-page-subtitle">{{ __('Fuel consumption history for') }} {{ $vehicle->vehicle_number }} · {{ $vehicle->vehicleType->name ?? '' }}</p>
        </div>
        <div class="list-page-header-actions">
            <a href="{{ route('admin.fuel-logs.index') }}" class="btn-secondary-action">
                <i class="bi bi-arrow-left"></i>
                {{ __('Back to List') }}
            </a>
            @if(auth()->user()->hasPermission('fuel.create'))
            <a href="{{ route('admin.fuel-logs.create', ['vehicle_id' => $vehicle->id]) }}" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                {{ __('Add Fuel Log') }}
            </a>
            @endif
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- Vehicle Info & Stats --}}
    <div class="row mb-4">
        <div class="col-lg-4">
            <div class="list-card h-100">
                <div class="list-card-header">
                    <h5 class="list-card-title">
                        <i class="bi bi-truck me-2"></i>
                        {{ __('Vehicle Details') }}
                    </h5>
                </div>
                <div class="list-card-body">
                    <div class="vehicle-info-grid">
                        <div class="vehicle-info-item">
                            <span class="vehicle-info-label">{{ __('Vehicle Number') }}</span>
                            <span class="vehicle-info-value">{{ $vehicle->vehicle_number }}</span>
                        </div>
                        <div class="vehicle-info-item">
                            <span class="vehicle-info-label">{{ __('Vehicle Type') }}</span>
                            <span class="vehicle-info-value">{{ $vehicle->vehicleType->name ?? '-' }}</span>
                        </div>
                        @if($vehicle->brand)
                        <div class="vehicle-info-item">
                            <span class="vehicle-info-label">{{ __('Brand/Model') }}</span>
                            <span class="vehicle-info-value">{{ $vehicle->brand }} {{ $vehicle->model ?? '' }}</span>
                        </div>
                        @endif
                        <div class="vehicle-info-item">
                            <span class="vehicle-info-label">{{ __('Status') }}</span>
                            <span class="vehicle-info-value">
                                <span class="badge bg-{{ $vehicle->status === 'active' ? 'success' : 'secondary' }}">
                                    {{ __(ucfirst($vehicle->status)) }}
                                </span>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-8">
            <div class="list-stats-bar mb-0">
                <div class="list-stat-card gradient-violet">
                    <div class="list-stat-icon">
                        <i class="bi bi-fuel-pump"></i>
                    </div>
                    <div class="list-stat-content">
                        <div class="list-stat-value">{{ $fuelLogs->total() }}</div>
                        <div class="list-stat-label">{{ __('Fill Records') }}</div>
                    </div>
                    <div class="list-stat-footer">
                        <i class="bi bi-list-check"></i>
                        {{ __('Total') }}
                    </div>
                </div>
                <div class="list-stat-card gradient-rose">
                    <div class="list-stat-icon">
                        <i class="bi bi-droplet"></i>
                    </div>
                    <div class="list-stat-content">
                        <div class="list-stat-value">{{ number_format($stats['total_quantity'] ?? 0, 0) }}</div>
                        <div class="list-stat-label">{{ __('Total Liters') }}</div>
                    </div>
                    <div class="list-stat-footer">
                        <i class="bi bi-water"></i>
                        {{ __('Consumed') }}
                    </div>
                </div>
                <div class="list-stat-card gradient-cyan">
                    <div class="list-stat-icon">
                        <i class="bi bi-currency-dollar"></i>
                    </div>
                    <div class="list-stat-content">
                        <div class="list-stat-value">${{ number_format($stats['total_cost'] ?? 0, 0) }}</div>
                        <div class="list-stat-label">{{ __('Total Cost') }}</div>
                    </div>
                    <div class="list-stat-footer">
                        <i class="bi bi-cash-stack"></i>
                        {{ __('Spent') }}
                    </div>
                </div>
                <div class="list-stat-card gradient-amber">
                    <div class="list-stat-icon">
                        <i class="bi bi-speedometer2"></i>
                    </div>
                    <div class="list-stat-content">
                        <div class="list-stat-value">{{ $stats['avg_efficiency'] ? number_format($stats['avg_efficiency'], 1) : '-' }}</div>
                        <div class="list-stat-label">{{ __('Avg km/L') }}</div>
                    </div>
                    <div class="list-stat-footer">
                        <i class="bi bi-lightning"></i>
                        {{ __('Efficiency') }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Filter Bar --}}
    <div class="list-filter-bar">
        <div class="list-filter-header">
            <div class="list-filter-title">
                <i class="bi bi-funnel"></i>
                {{ __('Filters') }}
            </div>
            @if(request()->hasAny(['fuel_type', 'payment_method', 'date_from', 'date_to']))
                <a href="{{ route('admin.fuel-logs.vehicle-history', $vehicle) }}" class="list-filter-clear">
                    <i class="bi bi-x-circle"></i>
                    {{ __('Clear Filters') }}
                </a>
            @endif
        </div>
        <form action="{{ route('admin.fuel-logs.vehicle-history', $vehicle) }}" method="GET">
            <div class="list-filter-row">
                <div class="list-filter-group">
                    <label>{{ __('Fuel Type') }}</label>
                    <select name="fuel_type" class="form-select">
                        <option value="">{{ __('All Types') }}</option>
                        <option value="diesel" {{ request('fuel_type') === 'diesel' ? 'selected' : '' }}>{{ __('Diesel') }}</option>
                        <option value="petrol" {{ request('fuel_type') === 'petrol' ? 'selected' : '' }}>{{ __('Petrol') }}</option>
                        <option value="cng" {{ request('fuel_type') === 'cng' ? 'selected' : '' }}>{{ __('CNG') }}</option>
                        <option value="electric" {{ request('fuel_type') === 'electric' ? 'selected' : '' }}>{{ __('Electric') }}</option>
                    </select>
                </div>
                <div class="list-filter-group">
                    <label>{{ __('Payment') }}</label>
                    <select name="payment_method" class="form-select">
                        <option value="">{{ __('All Methods') }}</option>
                        <option value="cash" {{ request('payment_method') === 'cash' ? 'selected' : '' }}>{{ __('Cash') }}</option>
                        <option value="card" {{ request('payment_method') === 'card' ? 'selected' : '' }}>{{ __('Card') }}</option>
                        <option value="company_account" {{ request('payment_method') === 'company_account' ? 'selected' : '' }}>{{ __('Company Account') }}</option>
                        <option value="fuel_card" {{ request('payment_method') === 'fuel_card' ? 'selected' : '' }}>{{ __('Fuel Card') }}</option>
                    </select>
                </div>
                <div class="list-filter-group">
                    <label>{{ __('Date From') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                </div>
                <div class="list-filter-group">
                    <label>{{ __('Date To') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                </div>
                <div class="list-filter-buttons">
                    <button type="submit" class="btn-filter btn-filter-primary">
                        <i class="bi bi-search"></i>
                        {{ __('Apply') }}
                    </button>
                </div>
            </div>
        </form>
    </div>

    {{-- Data Table --}}
    <div class="list-card">
        @if($fuelLogs->count() > 0)
            <div class="list-table-responsive">
                <table class="list-table">
                    <thead>
                        <tr>
                            <th>{{ __('Fuel #') }}</th>
                            <th>{{ __('Fill Date') }}</th>
                            <th>{{ __('Fuel Type') }}</th>
                            <th>{{ __('Quantity') }}</th>
                            <th>{{ __('Price/Unit') }}</th>
                            <th>{{ __('Total Cost') }}</th>
                            <th>{{ __('Odometer') }}</th>
                            <th>{{ __('Efficiency') }}</th>
                            <th>{{ __('Payment') }}</th>
                            <th class="text-center">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($fuelLogs as $fuelLog)
                            @php
                                $fuelTypeClasses = [
                                    'diesel' => 'warning',
                                    'petrol' => 'info',
                                    'cng' => 'success',
                                    'electric' => 'primary'
                                ];
                                $paymentClasses = [
                                    'cash' => 'success',
                                    'card' => 'info',
                                    'company_account' => 'primary',
                                    'fuel_card' => 'warning'
                                ];
                            @endphp
                            <tr>
                                <td>
                                    <div class="table-primary-text">
                                        <a href="{{ route('admin.fuel-logs.show', $fuelLog) }}">
                                            {{ $fuelLog->fuel_number }}
                                        </a>
                                    </div>
                                    @if($fuelLog->is_full_tank)
                                        <span class="badge bg-success badge-sm">{{ __('Full Tank') }}</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="table-primary-text">{{ $fuelLog->fill_date->format('M d, Y') }}</div>
                                    @if($fuelLog->fill_time)
                                        <div class="table-secondary-text">{{ \Carbon\Carbon::parse($fuelLog->fill_time)->format('h:i A') }}</div>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge bg-{{ $fuelTypeClasses[$fuelLog->fuel_type] ?? 'secondary' }}">
                                        {{ __(ucfirst($fuelLog->fuel_type)) }}
                                    </span>
                                </td>
                                <td>
                                    <div class="table-primary-text">{{ number_format($fuelLog->quantity, 2) }} L</div>
                                </td>
                                <td>
                                    <div class="table-primary-text">${{ number_format($fuelLog->price_per_unit, 2) }}</div>
                                </td>
                                <td>
                                    <div class="table-primary-text text-success fw-semibold">${{ number_format($fuelLog->total_cost, 2) }}</div>
                                </td>
                                <td>
                                    @if($fuelLog->odometer_reading)
                                        <div class="table-primary-text">{{ number_format($fuelLog->odometer_reading) }} km</div>
                                        @if($fuelLog->distance_traveled)
                                            <div class="table-secondary-text">+{{ number_format($fuelLog->distance_traveled) }} km</div>
                                        @endif
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    @if($fuelLog->fuel_efficiency)
                                        <span class="badge bg-success">{{ number_format($fuelLog->fuel_efficiency, 2) }} km/L</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge bg-{{ $paymentClasses[$fuelLog->payment_method] ?? 'secondary' }}">
                                        {{ __(ucfirst(str_replace('_', ' ', $fuelLog->payment_method))) }}
                                    </span>
                                </td>
                                <td>
                                    <div class="table-actions">
                                        @if(auth()->user()->hasPermission('fuel.view'))
                                            <a href="{{ route('admin.fuel-logs.show', $fuelLog) }}" 
                                               class="btn-table-action btn-table-view" 
                                               title="{{ __('View') }}">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                        @endif
                                        @if(auth()->user()->hasPermission('fuel.edit'))
                                            <a href="{{ route('admin.fuel-logs.edit', $fuelLog) }}" 
                                               class="btn-table-action btn-table-edit" 
                                               title="{{ __('Edit') }}">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                        @endif
                                        @if(auth()->user()->hasPermission('fuel.delete'))
                                            <form action="{{ route('admin.fuel-logs.destroy', $fuelLog) }}" method="POST" class="d-inline"
                                                  onsubmit="return confirm('{{ __('Are you sure you want to delete this fuel log?') }}')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" 
                                                        class="btn-table-action btn-table-delete" 
                                                        title="{{ __('Delete') }}">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Pagination --}}
            @if($fuelLogs->hasPages())
            <div class="list-pagination">
                <div class="list-pagination-info">
                    {{ __('Showing') }} {{ $fuelLogs->firstItem() }} {{ __('to') }} {{ $fuelLogs->lastItem() }} {{ __('of') }} {{ $fuelLogs->total() }} {{ __('results') }}
                </div>
                <nav class="list-pagination-nav">
                    {{ $fuelLogs->links() }}
                </nav>
            </div>
            @endif
        @else
            {{-- Empty State --}}
            <div class="list-empty-state">
                <div class="list-empty-state-icon">
                    <i class="bi bi-fuel-pump"></i>
                </div>
                <h4 class="list-empty-state-title">{{ __('No Fuel Records') }}</h4>
                <p class="list-empty-state-text">
                    {{ __('No fuel logs found for this vehicle. Add a fuel log to start tracking consumption.') }}
                </p>
                @if(auth()->user()->hasPermission('fuel.create'))
                <a href="{{ route('admin.fuel-logs.create', ['vehicle_id' => $vehicle->id]) }}" class="btn-create">
                    <i class="bi bi-plus-lg"></i>
                    {{ __('Add Fuel Log') }}
                </a>
                @endif
            </div>
        @endif
    </div>
</div>

@push('styles')
<style>
.list-page-breadcrumb {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 0.875rem;
    color: var(--text-secondary);
}

.list-page-breadcrumb a {
    color: var(--text-secondary);
    text-decoration: none;
}

.list-page-breadcrumb a:hover {
    color: var(--primary-color);
}

.list-page-breadcrumb i {
    font-size: 0.75rem;
}

.btn-secondary-action {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.625rem 1.25rem;
    background: var(--card-bg);
    border: 1px solid var(--border-color);
    border-radius: 10px;
    color: var(--text-primary);
    font-size: 0.875rem;
    font-weight: 500;
    text-decoration: none;
    transition: all 0.2s ease;
}

.btn-secondary-action:hover {
    background: var(--body-bg);
    border-color: var(--primary-color);
    color: var(--primary-color);
}

.list-card-header {
    padding: 1rem 1.5rem;
    border-bottom: 1px solid var(--border-color);
}

.list-card-title {
    margin: 0;
    font-size: 1rem;
    font-weight: 600;
    color: var(--text-primary);
}

.list-card-body {
    padding: 1.5rem;
}

.vehicle-info-grid {
    display: grid;
    gap: 1rem;
}

.vehicle-info-item {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.vehicle-info-label {
    font-size: 0.75rem;
    color: var(--text-secondary);
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.vehicle-info-value {
    font-size: 0.9375rem;
    font-weight: 500;
    color: var(--text-primary);
}
</style>
@endpush
@endsection