@extends('layouts.app')

@section('title', __('Add Maintenance Type') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admincreatepage.css') }}">
@endpush

@section('content')
<div class="create-page-container">
    {{-- Page Header --}}
    <div class="create-page-header">
        <div class="create-page-header-content">
            <nav class="create-page-breadcrumb">
                <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.maintenances.index') }}">{{ __('Maintenances') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.maintenance-types.index') }}">{{ __('Maintenance Types') }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ __('Add Maintenance Type') }}</span>
            </nav>
            <h1 class="create-page-title">
                <div class="create-page-title-icon">
                    <i class="bi bi-plus-lg"></i>
                </div>
                {{ __('Add Maintenance Type') }}
            </h1>
            <p class="create-page-subtitle">{{ __('Create a new maintenance type for scheduling') }}</p>
        </div>
        <div class="create-page-actions">
            <a href="{{ route('admin.maintenance-types.index') }}" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('Back to List') }}
            </a>
        </div>
    </div>

    {{-- Validation Errors --}}
    @if($errors->any())
        <div class="create-alert danger">
            <div class="create-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="create-alert-content">
                <div class="create-alert-title">{{ __('Please fix the following errors') }}</div>
                <div class="create-alert-text">
                    <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    @endif

    <form action="{{ route('admin.maintenance-types.store') }}" method="POST">
        @csrf

        <div class="create-form-layout">
            {{-- Main Form --}}
            <div class="create-form-main">
                {{-- Basic Information Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon primary">
                            <i class="bi bi-gear"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Basic Information') }}</h5>
                            <p class="create-card-subtitle">{{ __('Enter maintenance type details') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-type"></i>
                                    {{ __('Name') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" name="name" class="create-input @error('name') is-invalid @enderror" 
                                           value="{{ old('name') }}" placeholder="{{ __('e.g., Oil Change, Tire Rotation') }}" required>
                                    <i class="bi bi-type create-input-icon"></i>
                                </div>
                                @error('name')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-toggle-on"></i>
                                    {{ __('Status') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select name="status" class="create-select @error('status') is-invalid @enderror" required>
                                    <option value="active" {{ old('status', 'active') === 'active' ? 'selected' : '' }}>{{ __('Active') }}</option>
                                    <option value="inactive" {{ old('status') === 'inactive' ? 'selected' : '' }}>{{ __('Inactive') }}</option>
                                </select>
                                @error('status')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-group">
                            <label class="create-form-label">
                                <i class="bi bi-text-paragraph"></i>
                                {{ __('Description') }}
                                <span class="create-form-optional">({{ __('Optional') }})</span>
                            </label>
                            <textarea name="description" class="create-textarea @error('description') is-invalid @enderror" 
                                      rows="3" placeholder="{{ __('Describe this maintenance type...') }}">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Interval Settings Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon warning">
                            <i class="bi bi-clock"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Interval Settings') }}</h5>
                            <p class="create-card-subtitle">{{ __('Default intervals for scheduling') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-speedometer2"></i>
                                    {{ __('Default Interval (KM)') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="number" name="default_interval_km" class="create-input @error('default_interval_km') is-invalid @enderror" 
                                           value="{{ old('default_interval_km') }}" placeholder="5000" min="0">
                                    <i class="bi bi-speedometer2 create-input-icon"></i>
                                </div>
                                @error('default_interval_km')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                                <p class="create-form-hint">
                                    <i class="bi bi-info-circle"></i>
                                    {{ __('Distance interval for next maintenance') }}
                                </p>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-calendar"></i>
                                    {{ __('Default Interval (Days)') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="number" name="default_interval_days" class="create-input @error('default_interval_days') is-invalid @enderror" 
                                           value="{{ old('default_interval_days') }}" placeholder="90" min="0">
                                    <i class="bi bi-calendar create-input-icon"></i>
                                </div>
                                @error('default_interval_days')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                                <p class="create-form-hint">
                                    <i class="bi bi-info-circle"></i>
                                    {{ __('Time interval for next maintenance') }}
                                </p>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-currency-dollar"></i>
                                    {{ __('Estimated Cost') }} ($)
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="number" name="estimated_cost" class="create-input @error('estimated_cost') is-invalid @enderror" 
                                           value="{{ old('estimated_cost') }}" placeholder="0.00" step="0.01" min="0">
                                    <i class="bi bi-currency-dollar create-input-icon"></i>
                                </div>
                                @error('estimated_cost')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                                <p class="create-form-hint">
                                    <i class="bi bi-info-circle"></i>
                                    {{ __('Default cost estimate for this type') }}
                                </p>
                            </div>
                            <div class="create-form-group"></div>
                        </div>
                    </div>
                </div>

                {{-- Form Actions --}}
                <div class="create-card-actions">
                    <div class="create-card-actions-left">
                        <a href="{{ route('admin.maintenance-types.index') }}" class="create-btn create-btn-secondary">
                            <i class="bi bi-x-lg"></i>
                            {{ __('Cancel') }}
                        </a>
                    </div>
                    <div class="create-card-actions-right">
                        <button type="submit" class="create-btn create-btn-primary">
                            <i class="bi bi-check-circle"></i>
                            {{ __('Save Maintenance Type') }}
                        </button>
                    </div>
                </div>
            </div>

            {{-- Sidebar --}}
            <div class="create-form-sidebar">
                {{-- Tips Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon info">
                            <i class="bi bi-lightbulb"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Quick Tips') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Set either KM or Days interval, or both') }}</span>
                            </li>
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Estimated cost helps with budget planning') }}</span>
                            </li>
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Use descriptive names for easy identification') }}</span>
                            </li>
                        </ul>
                    </div>
                </div>

                {{-- Examples Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon primary">
                            <i class="bi bi-list-check"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Common Types') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li><i class="bi bi-droplet"></i> <span>{{ __('Oil Change') }}</span></li>
                            <li><i class="bi bi-circle"></i> <span>{{ __('Tire Rotation') }}</span></li>
                            <li><i class="bi bi-funnel"></i> <span>{{ __('Air Filter') }}</span></li>
                            <li><i class="bi bi-disc"></i> <span>{{ __('Brake Inspection') }}</span></li>
                            <li><i class="bi bi-gear"></i> <span>{{ __('Transmission Service') }}</span></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection