@extends('layouts.app')

@section('title', __('Edit Maintenance Type') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admincreatepage.css') }}">
@endpush

@section('content')
<div class="create-page-container">
    {{-- Page Header --}}
    <div class="create-page-header">
        <div class="create-page-header-content">
            <nav class="create-page-breadcrumb">
                <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.maintenances.index') }}">{{ __('Maintenances') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.maintenance-types.index') }}">{{ __('Maintenance Types') }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ __('Edit') }}</span>
            </nav>
            <h1 class="create-page-title">
                <div class="create-page-title-icon">
                    <i class="bi bi-pencil"></i>
                </div>
                {{ __('Edit Maintenance Type') }}
            </h1>
            <p class="create-page-subtitle">{{ __('Update maintenance type details') }}</p>
        </div>
        <div class="create-page-actions">
            <a href="{{ route('admin.maintenance-types.index') }}" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('Back to List') }}
            </a>
        </div>
    </div>

    {{-- Validation Errors --}}
    @if($errors->any())
        <div class="create-alert danger">
            <div class="create-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="create-alert-content">
                <div class="create-alert-title">{{ __('Please fix the following errors') }}</div>
                <div class="create-alert-text">
                    <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    @endif

    <form action="{{ route('admin.maintenance-types.update', $maintenanceType) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="create-form-layout">
            {{-- Main Form --}}
            <div class="create-form-main">
                {{-- Basic Information Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon primary">
                            <i class="bi bi-gear"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Basic Information') }}</h5>
                            <p class="create-card-subtitle">{{ __('Update maintenance type details') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-type"></i>
                                    {{ __('Name') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" name="name" class="create-input @error('name') is-invalid @enderror" 
                                           value="{{ old('name', $maintenanceType->name) }}" 
                                           placeholder="{{ __('e.g., Oil Change, Tire Rotation') }}" required>
                                    <i class="bi bi-type create-input-icon"></i>
                                </div>
                                @error('name')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-toggle-on"></i>
                                    {{ __('Status') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select name="status" class="create-select @error('status') is-invalid @enderror" required>
                                    <option value="active" {{ old('status', $maintenanceType->status) === 'active' ? 'selected' : '' }}>{{ __('Active') }}</option>
                                    <option value="inactive" {{ old('status', $maintenanceType->status) === 'inactive' ? 'selected' : '' }}>{{ __('Inactive') }}</option>
                                </select>
                                @error('status')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-group">
                            <label class="create-form-label">
                                <i class="bi bi-text-paragraph"></i>
                                {{ __('Description') }}
                                <span class="create-form-optional">({{ __('Optional') }})</span>
                            </label>
                            <textarea name="description" class="create-textarea @error('description') is-invalid @enderror" 
                                      rows="3" placeholder="{{ __('Describe this maintenance type...') }}">{{ old('description', $maintenanceType->description) }}</textarea>
                            @error('description')
                                <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Interval Settings Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon warning">
                            <i class="bi bi-clock"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Interval Settings') }}</h5>
                            <p class="create-card-subtitle">{{ __('Default intervals for scheduling') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-speedometer2"></i>
                                    {{ __('Default Interval (KM)') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="number" name="default_interval_km" class="create-input @error('default_interval_km') is-invalid @enderror" 
                                           value="{{ old('default_interval_km', $maintenanceType->default_interval_km) }}" placeholder="5000" min="0">
                                    <i class="bi bi-speedometer2 create-input-icon"></i>
                                </div>
                                @error('default_interval_km')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                                <p class="create-form-hint">
                                    <i class="bi bi-info-circle"></i>
                                    {{ __('Distance interval for next maintenance') }}
                                </p>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-calendar"></i>
                                    {{ __('Default Interval (Days)') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="number" name="default_interval_days" class="create-input @error('default_interval_days') is-invalid @enderror" 
                                           value="{{ old('default_interval_days', $maintenanceType->default_interval_days) }}" placeholder="90" min="0">
                                    <i class="bi bi-calendar create-input-icon"></i>
                                </div>
                                @error('default_interval_days')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                                <p class="create-form-hint">
                                    <i class="bi bi-info-circle"></i>
                                    {{ __('Time interval for next maintenance') }}
                                </p>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-currency-dollar"></i>
                                    {{ __('Estimated Cost') }} ($)
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="number" name="estimated_cost" class="create-input @error('estimated_cost') is-invalid @enderror" 
                                           value="{{ old('estimated_cost', $maintenanceType->estimated_cost) }}" placeholder="0.00" step="0.01" min="0">
                                    <i class="bi bi-currency-dollar create-input-icon"></i>
                                </div>
                                @error('estimated_cost')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                                <p class="create-form-hint">
                                    <i class="bi bi-info-circle"></i>
                                    {{ __('Default cost estimate for this type') }}
                                </p>
                            </div>
                            <div class="create-form-group"></div>
                        </div>
                    </div>
                </div>

                {{-- Form Actions --}}
                <div class="create-card-actions">
                    <div class="create-card-actions-left">
                        <a href="{{ route('admin.maintenance-types.index') }}" class="create-btn create-btn-secondary">
                            <i class="bi bi-x-lg"></i>
                            {{ __('Cancel') }}
                        </a>
                    </div>
                    <div class="create-card-actions-right">
                        <button type="submit" class="create-btn create-btn-primary">
                            <i class="bi bi-save"></i>
                            {{ __('Update Maintenance Type') }}
                        </button>
                    </div>
                </div>
            </div>

            {{-- Sidebar --}}
            <div class="create-form-sidebar">
                {{-- Current Status Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon {{ $maintenanceType->status === 'active' ? 'success' : 'warning' }}">
                            <i class="bi bi-{{ $maintenanceType->status === 'active' ? 'check-circle' : 'x-circle' }}"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Current Status') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-status-preview">
                            <span class="create-status-badge {{ $maintenanceType->status === 'active' ? 'active' : 'pending' }}">
                                <i class="bi bi-{{ $maintenanceType->status === 'active' ? 'check-circle' : 'x-circle' }}"></i>
                                {{ __(ucfirst($maintenanceType->status)) }}
                            </span>
                            <p class="create-status-description">
                                {{ __('Created') }}: {{ $maintenanceType->created_at->format('d M Y, h:i A') }}
                            </p>
                        </div>
                    </div>
                </div>

                {{-- Type Details Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon primary">
                            <i class="bi bi-gear"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Type Details') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-hash"></i>
                                <span><strong>{{ __('ID') }}:</strong> #{{ $maintenanceType->id }}</span>
                            </li>
                            <li>
                                <i class="bi bi-list-ol"></i>
                                <span><strong>{{ __('Records') }}:</strong> {{ $maintenanceType->maintenances->count() }}</span>
                            </li>
                            @if($maintenanceType->updated_at)
                            <li>
                                <i class="bi bi-clock-history"></i>
                                <span><strong>{{ __('Last Updated') }}:</strong> {{ $maintenanceType->updated_at->diffForHumans() }}</span>
                            </li>
                            @endif
                        </ul>
                    </div>
                </div>

                {{-- Warning Card --}}
                @if($maintenanceType->maintenances->count() > 0)
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon warning">
                            <i class="bi bi-exclamation-triangle"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Warning') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <p class="text-muted small mb-0">
                            {{ __('This type has') }} {{ $maintenanceType->maintenances->count() }} {{ __('associated maintenance records. Changes may affect existing records.') }}
                        </p>
                    </div>
                </div>
                @endif

                {{-- Quick Actions Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon success">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Quick Actions') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="{{ route('admin.maintenance-types.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                {{ __('View All Types') }}
                            </a>
                            <a href="{{ route('admin.maintenances.index') }}?maintenance_type_id={{ $maintenanceType->id }}" class="create-quick-action-btn">
                                <i class="bi bi-funnel"></i>
                                {{ __('View Records') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection