@extends('layouts.app')

@section('title', __('Maintenance Types') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/adminlistpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header --}}
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-gear-wide-connected"></i>
                {{ __('Maintenance Types') }}
            </h1>
            <p class="list-page-subtitle">{{ __('Manage maintenance types and service intervals') }}</p>
        </div>
        <div class="list-page-header-actions">
            <a href="{{ route('admin.maintenances.index') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('Back to Maintenances') }}
            </a>
            @if(auth()->user()->hasPermission('maintenance_types.create'))
            <a href="{{ route('admin.maintenance-types.create') }}" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                {{ __('Add Maintenance Type') }}
            </a>
            @endif
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- Stats Bar --}}
    <div class="list-stats-bar">
        <div class="list-stat-card gradient-violet">
            <div class="list-stat-icon">
                <i class="bi bi-gear-wide-connected"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $maintenanceTypes->count() }}</div>
                <div class="list-stat-label">{{ __('Total Types') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-list-ul"></i>
                {{ __('All Types') }}
            </div>
        </div>
        <div class="list-stat-card gradient-green">
            <div class="list-stat-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $maintenanceTypes->where('status', 'active')->count() }}</div>
                <div class="list-stat-label">{{ __('Active') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-toggle-on"></i>
                {{ __('Enabled') }}
            </div>
        </div>
        <div class="list-stat-card gradient-amber">
            <div class="list-stat-icon">
                <i class="bi bi-x-circle"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $maintenanceTypes->where('status', 'inactive')->count() }}</div>
                <div class="list-stat-label">{{ __('Inactive') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-toggle-off"></i>
                {{ __('Disabled') }}
            </div>
        </div>
    </div>

    {{-- Data Table --}}
    <div class="list-table-container">
        <div class="list-table-header">
            <h5 class="list-table-title">
                {{ __('Maintenance Types List') }}
                <span class="list-table-count">({{ $maintenanceTypes->count() }} {{ __('records') }})</span>
            </h5>
        </div>

        @if($maintenanceTypes->count() > 0)
            <div class="table-responsive">
                <table class="list-table">
                    <thead>
                        <tr>
                            <th>{{ __('Name') }}</th>
                            <th>{{ __('Description') }}</th>
                            <th>{{ __('Interval (KM)') }}</th>
                            <th>{{ __('Interval (Days)') }}</th>
                            <th>{{ __('Est. Cost') }}</th>
                            <th>{{ __('Records') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th class="text-center">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($maintenanceTypes as $type)
                        <tr>
                            <td>
                                <div class="table-cell-with-icon">
                                    <div class="table-cell-icon primary">
                                        <i class="bi bi-gear"></i>
                                    </div>
                                    <div class="table-cell-content">
                                        <span class="table-cell-title">{{ $type->name }}</span>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="text-muted">{{ Str::limit($type->description, 50) ?: '-' }}</span>
                            </td>
                            <td>
                                @if($type->default_interval_km)
                                    <span class="badge bg-info-subtle text-info">
                                        <i class="bi bi-speedometer2 me-1"></i>{{ number_format($type->default_interval_km) }} km
                                    </span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                @if($type->default_interval_days)
                                    <span class="badge bg-warning-subtle text-warning">
                                        <i class="bi bi-calendar me-1"></i>{{ $type->default_interval_days }} {{ __('days') }}
                                    </span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                @if($type->estimated_cost)
                                    <span class="fw-semibold">${{ number_format($type->estimated_cost, 2) }}</span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                <span class="badge bg-secondary">{{ $type->maintenances_count ?? $type->maintenances->count() }}</span>
                            </td>
                            <td>
                                @if($type->status == 'active')
                                    <span class="table-badge table-badge-delivered">
                                        <i class="bi bi-check-circle"></i>
                                        {{ __('Active') }}
                                    </span>
                                @else
                                    <span class="table-badge table-badge-cancelled">
                                        <i class="bi bi-x-circle"></i>
                                        {{ __('Inactive') }}
                                    </span>
                                @endif
                            </td>
                            <td>
                                <div class="table-actions">
                                    @if(auth()->user()->hasPermission('maintenance_types.edit'))
                                    <a href="{{ route('admin.maintenance-types.edit', $type) }}" class="btn-table-action btn-table-edit" title="{{ __('Edit') }}">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    @endif
                                    @if(auth()->user()->hasPermission('maintenance_types.delete'))
                                        @if(($type->maintenances_count ?? $type->maintenances->count()) == 0)
                                        <form action="{{ route('admin.maintenance-types.destroy', $type) }}" method="POST" class="d-inline"
                                              onsubmit="return confirm('{{ __('Are you sure you want to delete this maintenance type?') }}')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn-table-action btn-table-delete" title="{{ __('Delete') }}">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                        @else
                                        <button type="button" class="btn-table-action btn-table-delete" disabled title="{{ __('Cannot delete - maintenance type is in use') }}">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                        @endif
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="list-empty-state">
                <div class="list-empty-state-icon">
                    <i class="bi bi-gear-wide-connected"></i>
                </div>
                <h4 class="list-empty-state-title">{{ __('No Maintenance Types Found') }}</h4>
                <p class="list-empty-state-text">{{ __('Add your first maintenance type to get started.') }}</p>
                @if(auth()->user()->hasPermission('maintenance_types.create'))
                <a href="{{ route('admin.maintenance-types.create') }}" class="btn-create">
                    <i class="bi bi-plus-lg"></i>
                    {{ __('Add Maintenance Type') }}
                </a>
                @endif
            </div>
        @endif
    </div>
</div>
@endsection