@extends('layouts.app')

@section('title', __('Add Maintenance') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admincreatepage.css') }}">
<style>
    .parts-table { width: 100%; border-collapse: collapse; }
    .parts-table th { background: var(--body-bg); padding: 0.75rem; text-align: left; font-size: 0.8rem; font-weight: 600; color: var(--text-secondary); text-transform: uppercase; border-bottom: 1px solid var(--border-color); }
    .parts-table td { padding: 0.75rem; border-bottom: 1px solid var(--border-color); vertical-align: middle; }
    .parts-table input { width: 100%; }
    .btn-remove-part { width: 36px; height: 36px; border-radius: 8px; border: 1px solid var(--border-color); background: var(--card-bg); color: #dc3545; cursor: pointer; display: flex; align-items: center; justify-content: center; transition: all 0.2s ease; }
    .btn-remove-part:hover { background: #dc3545; color: #fff; border-color: #dc3545; }
    .no-parts-message { text-align: center; padding: 2rem; color: var(--text-muted); }
</style>
@endpush

@section('content')
<div class="create-page-container">
    {{-- Page Header --}}
    <div class="create-page-header">
        <div class="create-page-header-content">
            <nav class="create-page-breadcrumb">
                <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.maintenances.index') }}">{{ __('Maintenances') }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ __('Add Maintenance') }}</span>
            </nav>
            <h1 class="create-page-title">
                <div class="create-page-title-icon">
                    <i class="bi bi-plus-lg"></i>
                </div>
                {{ __('Add Maintenance') }}
            </h1>
            <p class="create-page-subtitle">{{ __('Schedule new vehicle maintenance') }}</p>
        </div>
        <div class="create-page-actions">
            <a href="{{ route('admin.maintenances.index') }}" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('Back to List') }}
            </a>
        </div>
    </div>

    {{-- Validation Errors --}}
    @if($errors->any())
        <div class="create-alert danger">
            <div class="create-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="create-alert-content">
                <div class="create-alert-title">{{ __('Please fix the following errors') }}</div>
                <div class="create-alert-text">
                    <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    @endif

    <form action="{{ route('admin.maintenances.store') }}" method="POST" id="maintenanceForm">
        @csrf

        <div class="create-form-layout">
            {{-- Main Form --}}
            <div class="create-form-main">
                {{-- Vehicle & Type Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon primary">
                            <i class="bi bi-truck"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Vehicle & Type') }}</h5>
                            <p class="create-card-subtitle">{{ __('Select vehicle and maintenance type') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-truck"></i>
                                    {{ __('Vehicle') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select name="vehicle_id" id="vehicle_id" class="create-select @error('vehicle_id') is-invalid @enderror" required>
                                    <option value="">{{ __('Select Vehicle') }}</option>
                                    @foreach($vehicles as $vehicle)
                                        <option value="{{ $vehicle->id }}" {{ old('vehicle_id') == $vehicle->id ? 'selected' : '' }}>
                                            {{ $vehicle->vehicle_number }} - {{ $vehicle->brand }} {{ $vehicle->model }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('vehicle_id')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                                <p class="create-form-hint">
                                    <i class="bi bi-info-circle"></i>
                                    {{ __('Select a vehicle for maintenance') }}
                                </p>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-gear"></i>
                                    {{ __('Maintenance Type') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select name="maintenance_type_id" id="maintenance_type_id" class="create-select @error('maintenance_type_id') is-invalid @enderror" required>
                                    <option value="">{{ __('Select Type') }}</option>
                                    @foreach($maintenanceTypes as $type)
                                        <option value="{{ $type->id }}" 
                                                data-interval-km="{{ $type->default_interval_km }}"
                                                data-interval-days="{{ $type->default_interval_days }}"
                                                data-estimated-cost="{{ $type->estimated_cost }}"
                                                {{ old('maintenance_type_id') == $type->id ? 'selected' : '' }}>
                                            {{ $type->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('maintenance_type_id')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                                <p class="create-form-hint">
                                    <i class="bi bi-lightbulb"></i>
                                    {{ __('Selecting a type will auto-fill estimated cost') }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Schedule & Priority Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon warning">
                            <i class="bi bi-calendar-check"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Schedule & Priority') }}</h5>
                            <p class="create-card-subtitle">{{ __('Set maintenance schedule and priority') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-calendar"></i>
                                    {{ __('Scheduled Date') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="date" name="scheduled_date" class="create-input @error('scheduled_date') is-invalid @enderror" 
                                           value="{{ old('scheduled_date', date('Y-m-d')) }}" required>
                                    <i class="bi bi-calendar create-input-icon"></i>
                                </div>
                                @error('scheduled_date')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-flag"></i>
                                    {{ __('Priority') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select name="priority" class="create-select @error('priority') is-invalid @enderror" required>
                                    <option value="low" {{ old('priority') === 'low' ? 'selected' : '' }}>{{ __('Low') }}</option>
                                    <option value="medium" {{ old('priority', 'medium') === 'medium' ? 'selected' : '' }}>{{ __('Medium') }}</option>
                                    <option value="high" {{ old('priority') === 'high' ? 'selected' : '' }}>{{ __('High') }}</option>
                                    <option value="urgent" {{ old('priority') === 'urgent' ? 'selected' : '' }}>{{ __('Urgent') }}</option>
                                </select>
                                @error('priority')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-speedometer2"></i>
                                    {{ __('Odometer Reading') }} (km)
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="number" name="odometer_reading" class="create-input @error('odometer_reading') is-invalid @enderror" 
                                           value="{{ old('odometer_reading') }}" placeholder="0" min="0">
                                    <i class="bi bi-speedometer2 create-input-icon"></i>
                                </div>
                                @error('odometer_reading')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-activity"></i>
                                    {{ __('Status') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select name="status" class="create-select @error('status') is-invalid @enderror" required>
                                    <option value="scheduled" {{ old('status', 'scheduled') === 'scheduled' ? 'selected' : '' }}>{{ __('Scheduled') }}</option>
                                    <option value="in_progress" {{ old('status') === 'in_progress' ? 'selected' : '' }}>{{ __('In Progress') }}</option>
                                    <option value="completed" {{ old('status') === 'completed' ? 'selected' : '' }}>{{ __('Completed') }}</option>
                                    <option value="cancelled" {{ old('status') === 'cancelled' ? 'selected' : '' }}>{{ __('Cancelled') }}</option>
                                </select>
                                @error('status')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Cost Information Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon success">
                            <i class="bi bi-currency-dollar"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Cost Information') }}</h5>
                            <p class="create-card-subtitle">{{ __('Maintenance cost and vendor details') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-wrench"></i>
                                    {{ __('Labor Cost') }} ($)
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="number" name="labor_cost" id="labor_cost" class="create-input @error('labor_cost') is-invalid @enderror" 
                                           value="{{ old('labor_cost', 0) }}" step="0.01" min="0">
                                    <i class="bi bi-currency-dollar create-input-icon"></i>
                                </div>
                                @error('labor_cost')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-box-seam"></i>
                                    {{ __('Parts Cost') }} ($)
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="number" name="parts_cost" id="parts_cost" class="create-input" 
                                           value="{{ old('parts_cost', 0) }}" step="0.01" min="0" readonly>
                                    <i class="bi bi-currency-dollar create-input-icon"></i>
                                </div>
                                <p class="create-form-hint">
                                    <i class="bi bi-info-circle"></i>
                                    {{ __('Auto-calculated from parts') }}
                                </p>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-building"></i>
                                    {{ __('Vendor Name') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" name="vendor_name" class="create-input @error('vendor_name') is-invalid @enderror" 
                                           value="{{ old('vendor_name') }}" placeholder="{{ __('Service center name') }}">
                                    <i class="bi bi-building create-input-icon"></i>
                                </div>
                                @error('vendor_name')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-telephone"></i>
                                    {{ __('Vendor Contact') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" name="vendor_contact" class="create-input @error('vendor_contact') is-invalid @enderror" 
                                           value="{{ old('vendor_contact') }}" placeholder="{{ __('Contact number') }}">
                                    <i class="bi bi-telephone create-input-icon"></i>
                                </div>
                                @error('vendor_contact')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-receipt"></i>
                                    {{ __('Invoice Number') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" name="invoice_number" class="create-input @error('invoice_number') is-invalid @enderror" 
                                           value="{{ old('invoice_number') }}" placeholder="{{ __('Invoice reference') }}">
                                    <i class="bi bi-receipt create-input-icon"></i>
                                </div>
                                @error('invoice_number')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-person-badge"></i>
                                    {{ __('Performed By') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" name="performed_by" class="create-input @error('performed_by') is-invalid @enderror" 
                                           value="{{ old('performed_by') }}" placeholder="{{ __('Mechanic name') }}">
                                    <i class="bi bi-person-badge create-input-icon"></i>
                                </div>
                                @error('performed_by')
                                    <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Parts Replaced Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon info">
                            <i class="bi bi-tools"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Parts Replaced') }}</h5>
                            <p class="create-card-subtitle">{{ __('Add parts used in this maintenance') }}</p>
                        </div>
                        <button type="button" class="create-btn create-btn-sm create-btn-primary" id="addPartBtn">
                            <i class="bi bi-plus-lg"></i>
                            {{ __('Add Part') }}
                        </button>
                    </div>
                    <div class="create-card-body" style="padding: 0;">
                        <table class="parts-table" id="partsTable">
                            <thead>
                                <tr>
                                    <th>{{ __('Part Name') }}</th>
                                    <th>{{ __('Part Number') }}</th>
                                    <th style="width: 100px;">{{ __('Qty') }}</th>
                                    <th style="width: 120px;">{{ __('Unit Price') }}</th>
                                    <th style="width: 120px;">{{ __('Total') }}</th>
                                    <th style="width: 50px;"></th>
                                </tr>
                            </thead>
                            <tbody id="partsTableBody">
                                <tr class="no-parts-row">
                                    <td colspan="6" class="no-parts-message">
                                        <i class="bi bi-inbox"></i><br>
                                        {{ __('No parts added yet. Click "Add Part" to add parts.') }}
                                    </td>
                                </tr>
                            </tbody>
                            <tfoot id="partsTableFoot" style="display: none;">
                                <tr>
                                    <td colspan="4" class="text-end fw-bold">{{ __('Total Parts Cost') }}:</td>
                                    <td class="fw-bold" id="totalPartsCost">$0.00</td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>

                {{-- Notes Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon secondary">
                            <i class="bi bi-journal-text"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Notes & Description') }}</h5>
                            <p class="create-card-subtitle">{{ __('Additional information') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-group">
                            <label class="create-form-label">
                                <i class="bi bi-text-paragraph"></i>
                                {{ __('Description') }}
                            </label>
                            <textarea name="description" class="create-textarea @error('description') is-invalid @enderror" 
                                      rows="3" placeholder="{{ __('Describe the maintenance work...') }}">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                            @enderror
                        </div>

                        <div class="create-form-group">
                            <label class="create-form-label">
                                <i class="bi bi-sticky"></i>
                                {{ __('Notes') }}
                            </label>
                            <textarea name="notes" class="create-textarea @error('notes') is-invalid @enderror" 
                                      rows="2" placeholder="{{ __('Additional notes...') }}">{{ old('notes') }}</textarea>
                            @error('notes')
                                <div class="create-form-error"><i class="bi bi-exclamation-circle"></i> {{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Form Actions --}}
                <div class="create-card-actions">
                    <div class="create-card-actions-left">
                        <a href="{{ route('admin.maintenances.index') }}" class="create-btn create-btn-secondary">
                            <i class="bi bi-x-lg"></i>
                            {{ __('Cancel') }}
                        </a>
                    </div>
                    <div class="create-card-actions-right">
                        <button type="submit" class="create-btn create-btn-primary">
                            <i class="bi bi-check-circle"></i>
                            {{ __('Save Maintenance') }}
                        </button>
                    </div>
                </div>
            </div>

            {{-- Sidebar --}}
            <div class="create-form-sidebar">
                {{-- Tips Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon info">
                            <i class="bi bi-lightbulb"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Quick Tips') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Select a vehicle first to schedule maintenance') }}</span>
                            </li>
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Maintenance type will auto-fill estimated cost') }}</span>
                            </li>
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Add parts to track replacement costs separately') }}</span>
                            </li>
                            <li>
                                <i class="bi bi-exclamation-circle-fill text-warning"></i>
                                <span>{{ __('Setting status to "In Progress" will change vehicle status to "Maintenance"') }}</span>
                            </li>
                        </ul>
                    </div>
                </div>

                {{-- Cost Summary Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon success">
                            <i class="bi bi-calculator"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Cost Summary') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">{{ __('Labor Cost') }}:</span>
                            <span id="summaryLaborCost">$0.00</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">{{ __('Parts Cost') }}:</span>
                            <span id="summaryPartsCost">$0.00</span>
                        </div>
                        <hr>
                        <div class="d-flex justify-content-between">
                            <span class="fw-bold">{{ __('Total Cost') }}:</span>
                            <span class="fw-bold text-primary" id="summaryTotalCost">$0.00</span>
                        </div>
                    </div>
                </div>

                {{-- Quick Links Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon primary">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Quick Actions') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <a href="{{ route('admin.maintenances.index') }}" class="create-sidebar-link">
                            <i class="bi bi-list-ul"></i>
                            {{ __('View All Maintenances') }}
                        </a>
                        <a href="{{ route('admin.maintenance-types.index') }}" class="create-sidebar-link">
                            <i class="bi bi-gear"></i>
                            {{ __('Manage Types') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

{{-- Part Row Template --}}
<template id="partRowTemplate">
    <tr class="part-row">
        <td><input type="text" name="parts[INDEX][part_name]" class="create-input" placeholder="{{ __('Part name') }}" required></td>
        <td><input type="text" name="parts[INDEX][part_number]" class="create-input" placeholder="{{ __('Part #') }}"></td>
        <td><input type="number" name="parts[INDEX][quantity]" class="create-input part-qty" value="1" min="1" required></td>
        <td><input type="number" name="parts[INDEX][unit_price]" class="create-input part-price" value="0" step="0.01" min="0" required></td>
        <td><span class="part-total fw-semibold">$0.00</span></td>
        <td><button type="button" class="btn-remove-part" title="{{ __('Remove') }}"><i class="bi bi-trash"></i></button></td>
    </tr>
</template>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    let partIndex = 0;
    const partsTableBody = document.getElementById('partsTableBody');
    const partsTableFoot = document.getElementById('partsTableFoot');
    const partTemplate = document.getElementById('partRowTemplate');
    const addPartBtn = document.getElementById('addPartBtn');
    const noPartsRow = document.querySelector('.no-parts-row');

    addPartBtn.addEventListener('click', function() {
        if (noPartsRow) noPartsRow.style.display = 'none';
        partsTableFoot.style.display = 'table-footer-group';
        const template = partTemplate.content.cloneNode(true);
        const row = template.querySelector('tr');
        row.innerHTML = row.innerHTML.replace(/INDEX/g, partIndex);
        const qtyInput = row.querySelector('.part-qty');
        const priceInput = row.querySelector('.part-price');
        const removeBtn = row.querySelector('.btn-remove-part');
        qtyInput.addEventListener('input', calculatePartTotal);
        priceInput.addEventListener('input', calculatePartTotal);
        removeBtn.addEventListener('click', function() { row.remove(); calculateTotalPartsCost(); checkEmptyParts(); });
        partsTableBody.appendChild(row);
        partIndex++;
        calculateTotalPartsCost();
    });

    function calculatePartTotal(e) {
        const row = e.target.closest('tr');
        const qty = parseFloat(row.querySelector('.part-qty').value) || 0;
        const price = parseFloat(row.querySelector('.part-price').value) || 0;
        row.querySelector('.part-total').textContent = '$' + (qty * price).toFixed(2);
        calculateTotalPartsCost();
    }

    function calculateTotalPartsCost() {
        let total = 0;
        document.querySelectorAll('.part-row').forEach(row => {
            const qty = parseFloat(row.querySelector('.part-qty').value) || 0;
            const price = parseFloat(row.querySelector('.part-price').value) || 0;
            total += qty * price;
        });
        document.getElementById('totalPartsCost').textContent = '$' + total.toFixed(2);
        document.getElementById('parts_cost').value = total.toFixed(2);
        document.getElementById('summaryPartsCost').textContent = '$' + total.toFixed(2);
        updateTotalCost();
    }

    function checkEmptyParts() {
        if (document.querySelectorAll('.part-row').length === 0) {
            noPartsRow.style.display = 'table-row';
            partsTableFoot.style.display = 'none';
        }
    }

    document.getElementById('labor_cost').addEventListener('input', function() {
        document.getElementById('summaryLaborCost').textContent = '$' + (parseFloat(this.value) || 0).toFixed(2);
        updateTotalCost();
    });

    function updateTotalCost() {
        const labor = parseFloat(document.getElementById('labor_cost').value) || 0;
        const parts = parseFloat(document.getElementById('parts_cost').value) || 0;
        document.getElementById('summaryTotalCost').textContent = '$' + (labor + parts).toFixed(2);
    }

    document.getElementById('maintenance_type_id').addEventListener('change', function() {
        const selected = this.options[this.selectedIndex];
        const estimatedCost = selected.dataset.estimatedCost || 0;
        if (estimatedCost > 0) {
            document.getElementById('labor_cost').value = estimatedCost;
            document.getElementById('summaryLaborCost').textContent = '$' + parseFloat(estimatedCost).toFixed(2);
            updateTotalCost();
        }
    });
});
</script>
@endpush