@extends('layouts.app')

@section('title', __('Maintenances') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/adminlistpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header --}}
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-tools"></i>
                {{ __('Maintenances') }}
            </h1>
            <p class="list-page-subtitle">{{ __('Manage vehicle maintenance and service records') }}</p>
        </div>
        <div class="list-page-header-actions">
            @if(auth()->user()->hasPermission('maintenance.create'))
            <a href="{{ route('admin.maintenances.create') }}" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                {{ __('Add Maintenance') }}
            </a>
            @endif
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- Stats Bar --}}
    <div class="list-stats-bar">
        <div class="list-stat-card gradient-violet">
            <div class="list-stat-icon">
                <i class="bi bi-tools"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $stats['total'] ?? 0 }}</div>
                <div class="list-stat-label">{{ __('Total Maintenances') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-list-ul"></i>
                {{ __('All Records') }}
            </div>
        </div>
        <div class="list-stat-card gradient-blue">
            <div class="list-stat-icon">
                <i class="bi bi-calendar-check"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $stats['scheduled'] ?? 0 }}</div>
                <div class="list-stat-label">{{ __('Scheduled') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-clock"></i>
                {{ __('Upcoming') }}
            </div>
        </div>
        <div class="list-stat-card gradient-amber">
            <div class="list-stat-icon">
                <i class="bi bi-gear-wide-connected"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $stats['in_progress'] ?? 0 }}</div>
                <div class="list-stat-label">{{ __('In Progress') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-wrench"></i>
                {{ __('Being Serviced') }}
            </div>
        </div>
        <div class="list-stat-card gradient-red">
            <div class="list-stat-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $stats['overdue'] ?? 0 }}</div>
                <div class="list-stat-label">{{ __('Overdue') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-clock-history"></i>
                {{ __('Needs Attention') }}
            </div>
        </div>
        <div class="list-stat-card gradient-green">
            <div class="list-stat-icon">
                <i class="bi bi-currency-dollar"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">${{ number_format($stats['cost_this_month'] ?? 0, 2) }}</div>
                <div class="list-stat-label">{{ __('Cost This Month') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-graph-up"></i>
                {{ __('Expenses') }}
            </div>
        </div>
    </div>

    {{-- Quick Links --}}
    <div class="d-flex gap-2 mb-3">
        <a href="{{ route('admin.maintenances.due-soon') }}" class="btn btn-outline-warning btn-sm">
            <i class="bi bi-clock me-1"></i>
            {{ __('Due Soon') }}
        </a>
        <a href="{{ route('admin.maintenances.overdue') }}" class="btn btn-outline-danger btn-sm">
            <i class="bi bi-exclamation-circle me-1"></i>
            {{ __('Overdue') }}
        </a>
        @if(auth()->user()->hasPermission('maintenance_types.view'))
        <a href="{{ route('admin.maintenance-types.index') }}" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-gear me-1"></i>
            {{ __('Manage Types') }}
        </a>
        @endif
    </div>

    {{-- Filter Bar --}}
    <div class="list-filter-bar">
        <div class="list-filter-header">
            <div class="list-filter-title">
                <i class="bi bi-funnel"></i>
                {{ __('Filters') }}
            </div>
            @if(request()->hasAny(['search', 'status', 'priority', 'vehicle_id', 'maintenance_type_id']))
                <a href="{{ route('admin.maintenances.index') }}" class="list-filter-clear">
                    <i class="bi bi-x-circle"></i>
                    {{ __('Clear Filters') }}
                </a>
            @endif
        </div>
        <form action="{{ route('admin.maintenances.index') }}" method="GET">
            <div class="list-filter-row">
                <div class="list-filter-group search-group">
                    <label>{{ __('Search') }}</label>
                    <div class="list-search-box">
                        <i class="bi bi-search"></i>
                        <input type="text" name="search" class="form-control" 
                               placeholder="{{ __('Search by maintenance number...') }}"
                               value="{{ request('search') }}">
                    </div>
                </div>
                <div class="list-filter-group">
                    <label>{{ __('Status') }}</label>
                    <select name="status" class="form-select">
                        <option value="">{{ __('All Statuses') }}</option>
                        <option value="scheduled" {{ request('status') === 'scheduled' ? 'selected' : '' }}>{{ __('Scheduled') }}</option>
                        <option value="in_progress" {{ request('status') === 'in_progress' ? 'selected' : '' }}>{{ __('In Progress') }}</option>
                        <option value="completed" {{ request('status') === 'completed' ? 'selected' : '' }}>{{ __('Completed') }}</option>
                        <option value="cancelled" {{ request('status') === 'cancelled' ? 'selected' : '' }}>{{ __('Cancelled') }}</option>
                    </select>
                </div>
                <div class="list-filter-group">
                    <label>{{ __('Priority') }}</label>
                    <select name="priority" class="form-select">
                        <option value="">{{ __('All Priorities') }}</option>
                        <option value="low" {{ request('priority') === 'low' ? 'selected' : '' }}>{{ __('Low') }}</option>
                        <option value="medium" {{ request('priority') === 'medium' ? 'selected' : '' }}>{{ __('Medium') }}</option>
                        <option value="high" {{ request('priority') === 'high' ? 'selected' : '' }}>{{ __('High') }}</option>
                        <option value="urgent" {{ request('priority') === 'urgent' ? 'selected' : '' }}>{{ __('Urgent') }}</option>
                    </select>
                </div>
                <div class="list-filter-group">
                    <label>{{ __('Vehicle') }}</label>
                    <select name="vehicle_id" class="form-select">
                        <option value="">{{ __('All Vehicles') }}</option>
                        @foreach($vehicles as $vehicle)
                            <option value="{{ $vehicle->id }}" {{ request('vehicle_id') == $vehicle->id ? 'selected' : '' }}>
                                {{ $vehicle->vehicle_number }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="list-filter-group">
                    <label>{{ __('Type') }}</label>
                    <select name="maintenance_type_id" class="form-select">
                        <option value="">{{ __('All Types') }}</option>
                        @foreach($maintenanceTypes as $type)
                            <option value="{{ $type->id }}" {{ request('maintenance_type_id') == $type->id ? 'selected' : '' }}>
                                {{ $type->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="list-filter-buttons">
                    <button type="submit" class="btn-filter btn-filter-primary">
                        <i class="bi bi-search"></i>
                        {{ __('Apply') }}
                    </button>
                </div>
            </div>
        </form>
    </div>

    {{-- Data Table --}}
    <div class="list-table-container">
        <div class="list-table-header">
            <h5 class="list-table-title">
                {{ __('Maintenances List') }}
                <span class="list-table-count">({{ $maintenances->total() }} {{ __('records') }})</span>
            </h5>
        </div>

        @php
            $statusClasses = [
                'scheduled' => 'pending',
                'in_progress' => 'assigned',
                'completed' => 'delivered',
                'cancelled' => 'cancelled'
            ];
            $statusIcons = [
                'scheduled' => 'calendar',
                'in_progress' => 'gear-wide-connected',
                'completed' => 'check-circle',
                'cancelled' => 'x-circle'
            ];
            $priorityClasses = [
                'low' => 'secondary',
                'medium' => 'info',
                'high' => 'warning',
                'urgent' => 'danger'
            ];
        @endphp

        @if($maintenances->count() > 0)
            <div class="table-responsive">
                <table class="list-table">
                    <thead>
                        <tr>
                            <th>{{ __('Maintenance #') }}</th>
                            <th>{{ __('Vehicle') }}</th>
                            <th>{{ __('Type') }}</th>
                            <th>{{ __('Scheduled Date') }}</th>
                            <th>{{ __('Priority') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th>{{ __('Total Cost') }}</th>
                            <th class="text-center">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($maintenances as $maintenance)
                        <tr class="{{ $maintenance->isOverdue ? 'table-danger' : '' }}">
                            <td>
                                <a href="{{ route('admin.maintenances.show', $maintenance) }}" class="table-item-link">
                                    {{ $maintenance->maintenance_number }}
                                </a>
                                @if($maintenance->isOverdue)
                                    <span class="badge bg-danger ms-1">{{ __('Overdue') }}</span>
                                @elseif($maintenance->isDueSoon)
                                    <span class="badge bg-warning ms-1">{{ __('Due Soon') }}</span>
                                @endif
                            </td>
                            <td>
                                <div class="table-cell-with-icon">
                                    <div class="table-cell-icon primary">
                                        <i class="bi bi-truck"></i>
                                    </div>
                                    <div class="table-cell-content">
                                        <span class="table-cell-title">{{ $maintenance->vehicle->vehicle_number }}</span>
                                        <span class="table-cell-subtitle">{{ $maintenance->vehicle->brand }} {{ $maintenance->vehicle->model }}</span>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-secondary-subtle text-secondary">
                                    {{ $maintenance->maintenanceType->name }}
                                </span>
                            </td>
                            <td>
                                <div class="table-cell-date">
                                    <i class="bi bi-calendar"></i>
                                    {{ $maintenance->scheduled_date->format('M d, Y') }}
                                </div>
                                <small class="text-muted">{{ $maintenance->scheduled_date->diffForHumans() }}</small>
                            </td>
                            <td>
                                <span class="badge bg-{{ $priorityClasses[$maintenance->priority] ?? 'secondary' }}">
                                    {{ __(ucfirst($maintenance->priority)) }}
                                </span>
                            </td>
                            <td>
                                <span class="table-badge table-badge-{{ $statusClasses[$maintenance->status] ?? 'pending' }}">
                                    <i class="bi bi-{{ $statusIcons[$maintenance->status] ?? 'circle' }}"></i>
                                    {{ __(ucfirst(str_replace('_', ' ', $maintenance->status))) }}
                                </span>
                            </td>
                            <td>
                                <span class="fw-semibold">${{ number_format($maintenance->totalCost, 2) }}</span>
                            </td>
                            <td>
                                <div class="table-actions">
                                    <a href="{{ route('admin.maintenances.show', $maintenance) }}" 
                                       class="btn-table-action btn-table-view" 
                                       title="{{ __('View') }}">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    @if(auth()->user()->hasPermission('maintenance.edit'))
                                    <a href="{{ route('admin.maintenances.edit', $maintenance) }}" 
                                       class="btn-table-action btn-table-edit" 
                                       title="{{ __('Edit') }}">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    @endif
                                    @if(auth()->user()->hasPermission('maintenance.delete'))
                                    <form action="{{ route('admin.maintenances.destroy', $maintenance) }}" 
                                          method="POST" 
                                          class="d-inline"
                                          onsubmit="return confirm('{{ __('Are you sure you want to delete this maintenance record?') }}')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn-table-action btn-table-delete" title="{{ __('Delete') }}">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Pagination --}}
            @if($maintenances->hasPages())
            <div class="list-pagination">
                <div class="list-pagination-info">
                    {{ __('Showing') }} {{ $maintenances->firstItem() }} {{ __('to') }} {{ $maintenances->lastItem() }} {{ __('of') }} {{ $maintenances->total() }} {{ __('entries') }}
                </div>
                <div class="list-pagination-links">
                    {{ $maintenances->withQueryString()->links() }}
                </div>
            </div>
            @endif
        @else
            {{-- Empty State --}}
            <div class="list-empty-state">
                <div class="list-empty-state-icon">
                    <i class="bi bi-tools"></i>
                </div>
                <h4 class="list-empty-state-title">{{ __('No Maintenances Found') }}</h4>
                <p class="list-empty-state-text">{{ __('No maintenance records found. Add your first maintenance to get started.') }}</p>
                @if(auth()->user()->hasPermission('maintenance.create'))
                <a href="{{ route('admin.maintenances.create') }}" class="btn-create">
                    <i class="bi bi-plus-lg"></i>
                    {{ __('Add Maintenance') }}
                </a>
                @endif
            </div>
        @endif
    </div>
</div>
@endsection