@extends('layouts.app')

@section('title', __('Overdue Maintenances') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/adminlistpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header --}}
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-exclamation-triangle text-danger"></i>
                {{ __('Overdue Maintenances') }}
            </h1>
            <p class="list-page-subtitle">{{ __('Maintenances that are past their scheduled date') }}</p>
        </div>
        <div class="list-page-header-actions">
            <a href="{{ route('admin.maintenances.index') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('Back to Maintenances') }}
            </a>
            @if(auth()->user()->hasPermission('maintenance.create'))
            <a href="{{ route('admin.maintenances.create') }}" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                {{ __('Add Maintenance') }}
            </a>
            @endif
        </div>
    </div>

    {{-- Alert Banner --}}
    @if($maintenances->count() > 0)
    <div class="alert alert-danger d-flex align-items-center mb-4" role="alert">
        <i class="bi bi-exclamation-triangle-fill me-3" style="font-size: 1.5rem;"></i>
        <div>
            <strong>{{ $maintenances->count() }} {{ __('overdue maintenances') }}</strong>
            <p class="mb-0">{{ __('These maintenances need immediate attention') }}</p>
        </div>
    </div>
    @endif

    @php
        $priorityClasses = [
            'low' => 'secondary',
            'medium' => 'info',
            'high' => 'warning',
            'urgent' => 'danger'
        ];
    @endphp

    {{-- Data Table --}}
    <div class="list-table-container">
        <div class="list-table-header">
            <h5 class="list-table-title">
                {{ __('Overdue List') }}
                <span class="list-table-count">({{ $maintenances->count() }} {{ __('records') }})</span>
            </h5>
        </div>

        @if($maintenances->count() > 0)
            <div class="table-responsive">
                <table class="list-table">
                    <thead>
                        <tr>
                            <th>{{ __('Maintenance #') }}</th>
                            <th>{{ __('Vehicle') }}</th>
                            <th>{{ __('Type') }}</th>
                            <th>{{ __('Scheduled Date') }}</th>
                            <th>{{ __('Days Overdue') }}</th>
                            <th>{{ __('Priority') }}</th>
                            <th class="text-center">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($maintenances as $maintenance)
                        @php
                            $daysOverdue = now()->diffInDays($maintenance->scheduled_date);
                        @endphp
                        <tr class="table-danger">
                            <td>
                                <a href="{{ route('admin.maintenances.show', $maintenance) }}" class="table-item-link">
                                    {{ $maintenance->maintenance_number }}
                                </a>
                                <span class="badge bg-danger ms-1">{{ __('Overdue') }}</span>
                            </td>
                            <td>
                                <div class="table-cell-with-icon">
                                    <div class="table-cell-icon danger">
                                        <i class="bi bi-truck"></i>
                                    </div>
                                    <div class="table-cell-content">
                                        <span class="table-cell-title">{{ $maintenance->vehicle->vehicle_number }}</span>
                                        <span class="table-cell-subtitle">{{ $maintenance->vehicle->brand }} {{ $maintenance->vehicle->model }}</span>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-secondary-subtle text-secondary">
                                    {{ $maintenance->maintenanceType->name }}
                                </span>
                            </td>
                            <td>
                                <div class="table-cell-date text-danger">
                                    <i class="bi bi-calendar-x"></i>
                                    {{ $maintenance->scheduled_date->format('M d, Y') }}
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-danger">{{ $daysOverdue }} {{ __('days overdue') }}</span>
                            </td>
                            <td>
                                <span class="badge bg-{{ $priorityClasses[$maintenance->priority] ?? 'secondary' }}">
                                    {{ __(ucfirst($maintenance->priority)) }}
                                </span>
                            </td>
                            <td>
                                <div class="table-actions">
                                    <a href="{{ route('admin.maintenances.show', $maintenance) }}" class="btn-table-action btn-table-view" title="{{ __('View') }}">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    @if(auth()->user()->hasPermission('maintenance.edit'))
                                    <a href="{{ route('admin.maintenances.edit', $maintenance) }}" class="btn-table-action btn-table-edit" title="{{ __('Edit') }}">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="list-empty-state">
                <div class="list-empty-state-icon">
                    <i class="bi bi-check-circle text-success"></i>
                </div>
                <h4 class="list-empty-state-title">{{ __('No Overdue Maintenances') }}</h4>
                <p class="list-empty-state-text">{{ __('Great! All maintenances are on schedule') }}</p>
                <a href="{{ route('admin.maintenances.index') }}" class="btn btn-outline-primary">
                    <i class="bi bi-arrow-left me-2"></i>
                    {{ __('Back to Maintenances') }}
                </a>
            </div>
        @endif
    </div>
</div>
@endsection