@extends('layouts.app')

@section('title', $maintenance->maintenance_number . ' - ' . __('Maintenance Details'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admindetailpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header with Breadcrumb --}}
    <div class="page-header">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('admin.maintenances.index') }}">{{ __('Maintenances') }}</a></li>
                    <li class="breadcrumb-item active">{{ $maintenance->maintenance_number }}</li>
                </ol>
            </nav>
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <div class="detail-alert detail-alert-info">
            <div class="detail-alert-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title">{{ __('Success') }}</div>
                <div class="detail-alert-text">{{ session('success') }}</div>
            </div>
        </div>
    @endif

    @if(session('error'))
        <div class="detail-alert detail-alert-warning">
            <div class="detail-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title">{{ __('Error') }}</div>
                <div class="detail-alert-text">{{ session('error') }}</div>
            </div>
        </div>
    @endif

    @php
        $statusClasses = [
            'scheduled' => 'pending',
            'in_progress' => 'assigned',
            'completed' => 'delivered',
            'cancelled' => 'cancelled'
        ];
        $statusIcons = [
            'scheduled' => 'calendar',
            'in_progress' => 'gear-wide-connected',
            'completed' => 'check-circle',
            'cancelled' => 'x-circle'
        ];
        $priorityClasses = [
            'low' => 'normal',
            'medium' => 'normal',
            'high' => 'high',
            'urgent' => 'urgent'
        ];
        $priorityIcons = [
            'low' => 'flag',
            'medium' => 'flag',
            'high' => 'flag-fill',
            'urgent' => 'exclamation-triangle-fill'
        ];
    @endphp

    {{-- Hero Section --}}
    <div class="detail-hero">
        <div class="detail-hero-header">
            <div class="detail-hero-content">
                <div class="detail-hero-icon">
                    <i class="bi bi-tools"></i>
                </div>
                <div class="detail-hero-info">
                    <h1 class="detail-hero-title">{{ $maintenance->maintenance_number }}</h1>
                    <p class="detail-hero-subtitle">{{ $maintenance->maintenanceType->name }} · {{ $maintenance->vehicle->vehicle_number }}</p>
                    <div class="detail-hero-badges">
                        <span class="status-badge status-badge-{{ $statusClasses[$maintenance->status] ?? 'pending' }}">
                            <i class="bi bi-{{ $statusIcons[$maintenance->status] ?? 'circle' }}"></i>
                            {{ __(ucfirst(str_replace('_', ' ', $maintenance->status))) }}
                        </span>
                        <span class="priority-badge priority-badge-{{ $priorityClasses[$maintenance->priority] ?? 'normal' }}">
                            <i class="bi bi-{{ $priorityIcons[$maintenance->priority] ?? 'flag' }}"></i>
                            {{ __(ucfirst($maintenance->priority)) }}
                        </span>
                        @if($maintenance->isOverdue)
                            <span class="status-badge status-badge-cancelled">
                                <i class="bi bi-exclamation-triangle"></i>
                                {{ __('Overdue') }}
                            </span>
                        @elseif($maintenance->isDueSoon)
                            <span class="status-badge status-badge-pending">
                                <i class="bi bi-clock"></i>
                                {{ __('Due Soon') }}
                            </span>
                        @endif
                    </div>
                </div>
            </div>
            <div class="detail-actions">
                @if(auth()->user()->hasPermission('maintenance.edit'))
                <a href="{{ route('admin.maintenances.edit', $maintenance) }}" class="btn-detail btn-detail-warning">
                    <i class="bi bi-pencil"></i>
                    {{ __('Edit') }}
                </a>
                @endif
                <a href="{{ route('admin.maintenances.index') }}" class="btn-detail btn-detail-outline">
                    <i class="bi bi-arrow-left"></i>
                    {{ __('Back to List') }}
                </a>
            </div>
        </div>
        <div class="detail-hero-body">
            <div class="hero-stat">
                <div class="hero-stat-value">
                    <i class="bi bi-calendar text-primary"></i>
                </div>
                <div class="hero-stat-label">{{ $maintenance->scheduled_date->format('M d, Y') }}</div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value">{{ $maintenance->completed_date ? $maintenance->completed_date->format('M d') : '-' }}</div>
                <div class="hero-stat-label">{{ __('Completed Date') }}</div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value">{{ $maintenance->odometer_reading ? number_format($maintenance->odometer_reading) : '-' }}</div>
                <div class="hero-stat-label">{{ __('Odometer (km)') }}</div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value">${{ number_format($maintenance->totalCost, 2) }}</div>
                <div class="hero-stat-label">{{ __('Total Cost') }}</div>
            </div>
        </div>
    </div>

    {{-- Main Content Row --}}
    <div class="row">
        {{-- Left Column --}}
        <div class="col-lg-8">
            {{-- Vehicle Information --}}
            <div class="detail-card mb-4">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon primary">
                        <i class="bi bi-truck"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Vehicle Information') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="entity-card mb-3">
                        <div class="entity-card-avatar primary">
                            <i class="bi bi-truck-front"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-title">{{ $maintenance->vehicle->vehicle_number }}</h6>
                            <p class="entity-card-subtitle">{{ $maintenance->vehicle->brand }} {{ $maintenance->vehicle->model }}</p>
                            <div class="entity-card-meta">
                                <span class="entity-card-meta-item">
                                    <i class="bi bi-truck"></i>
                                    {{ $maintenance->vehicle->vehicleType->name ?? '-' }}
                                </span>
                                <span class="entity-card-meta-item">
                                    <span class="badge bg-{{ $maintenance->vehicle->status === 'active' ? 'success' : ($maintenance->vehicle->status === 'maintenance' ? 'warning' : 'secondary') }}">
                                        {{ __(ucfirst($maintenance->vehicle->status)) }}
                                    </span>
                                </span>
                            </div>
                        </div>
                    </div>
                    <a href="{{ route('admin.maintenances.vehicle-history', $maintenance->vehicle) }}" class="btn-detail btn-detail-outline w-100 justify-content-center">
                        <i class="bi bi-clock-history"></i>
                        {{ __('View Maintenance History') }}
                    </a>
                </div>
            </div>

            {{-- Cost Breakdown --}}
            <div class="detail-card mb-4">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon success">
                        <i class="bi bi-currency-dollar"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Cost Breakdown') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Labor Cost') }}</span>
                            <span class="info-item-value">${{ number_format($maintenance->labor_cost, 2) }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Parts Cost') }}</span>
                            <span class="info-item-value">${{ number_format($maintenance->parts_cost, 2) }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Total Cost') }}</span>
                            <span class="info-item-value highlight">${{ number_format($maintenance->totalCost, 2) }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Invoice Number') }}</span>
                            <span class="info-item-value">{{ $maintenance->invoice_number ?: '-' }}</span>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Parts Replaced --}}
            <div class="detail-card mb-4">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon info">
                        <i class="bi bi-tools"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Parts Replaced') }} ({{ $maintenance->parts->count() }})</h5>
                </div>
                <div class="detail-card-body-compact">
                    @if($maintenance->parts->count() > 0)
                    <div class="table-responsive">
                        <table class="related-items-table">
                            <thead>
                                <tr>
                                    <th>{{ __('Part Name') }}</th>
                                    <th>{{ __('Part Number') }}</th>
                                    <th>{{ __('Quantity') }}</th>
                                    <th>{{ __('Unit Price') }}</th>
                                    <th>{{ __('Total') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($maintenance->parts as $part)
                                <tr>
                                    <td>{{ $part->part_name }}</td>
                                    <td>{{ $part->part_number ?: '-' }}</td>
                                    <td>{{ $part->quantity }}</td>
                                    <td>${{ number_format($part->unit_price, 2) }}</td>
                                    <td class="fw-semibold">${{ number_format($part->total_price, 2) }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="4" class="text-end fw-bold">{{ __('Total Parts Cost') }}:</td>
                                    <td class="fw-bold">${{ number_format($maintenance->parts_cost, 2) }}</td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    @else
                    <div class="detail-empty-state">
                        <div class="detail-empty-state-icon">
                            <i class="bi bi-inbox"></i>
                        </div>
                        <h6 class="detail-empty-state-title">{{ __('No Parts Replaced') }}</h6>
                        <p class="detail-empty-state-text">{{ __('No parts were replaced in this maintenance.') }}</p>
                    </div>
                    @endif
                </div>
            </div>

            {{-- Notes & Description --}}
            @if($maintenance->description || $maintenance->notes)
            <div class="detail-card mb-4">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon secondary">
                        <i class="bi bi-journal-text"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Notes & Description') }}</h5>
                </div>
                <div class="detail-card-body">
                    @if($maintenance->description)
                    <div class="mb-3">
                        <label class="info-item-label">{{ __('Description') }}</label>
                        <p class="mb-0">{{ $maintenance->description }}</p>
                    </div>
                    @endif
                    @if($maintenance->notes)
                    <div>
                        <label class="info-item-label">{{ __('Notes') }}</label>
                        <p class="mb-0">{{ $maintenance->notes }}</p>
                    </div>
                    @endif
                </div>
            </div>
            @endif
        </div>

        {{-- Right Column (Sidebar) --}}
        <div class="col-lg-4">
            {{-- Maintenance Type Card --}}
            <div class="detail-card mb-4">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon warning">
                        <i class="bi bi-gear"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Maintenance Type') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="entity-card">
                        <div class="entity-card-avatar warning">
                            <i class="bi bi-wrench"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-title">{{ $maintenance->maintenanceType->name }}</h6>
                            <p class="entity-card-subtitle">{{ $maintenance->maintenanceType->description ?: __('Standard maintenance type') }}</p>
                        </div>
                    </div>
                    <div class="data-list mt-3">
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-speedometer2"></i>
                                {{ __('Interval (KM)') }}
                            </span>
                            <span class="data-list-item-value">{{ $maintenance->maintenanceType->default_interval_km ? number_format($maintenance->maintenanceType->default_interval_km) : '-' }}</span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-calendar-week"></i>
                                {{ __('Interval (Days)') }}
                            </span>
                            <span class="data-list-item-value">{{ $maintenance->maintenanceType->default_interval_days ?: '-' }}</span>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Service Info Card --}}
            <div class="detail-card mb-4">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon info">
                        <i class="bi bi-person-badge"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Service Info') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="data-list">
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-person"></i>
                                {{ __('Performed By') }}
                            </span>
                            <span class="data-list-item-value">{{ $maintenance->performed_by ?: '-' }}</span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-building"></i>
                                {{ __('Vendor') }}
                            </span>
                            <span class="data-list-item-value">{{ $maintenance->vendor_name ?: '-' }}</span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-telephone"></i>
                                {{ __('Contact') }}
                            </span>
                            <span class="data-list-item-value">{{ $maintenance->vendor_contact ?: '-' }}</span>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Next Due Card --}}
            <div class="detail-card mb-4">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon danger">
                        <i class="bi bi-calendar-event"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Next Due') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="data-list">
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-speedometer2"></i>
                                {{ __('Next Due KM') }}
                            </span>
                            <span class="data-list-item-value">{{ $maintenance->next_due_km ? number_format($maintenance->next_due_km) . ' km' : '-' }}</span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-calendar"></i>
                                {{ __('Next Due Date') }}
                            </span>
                            <span class="data-list-item-value">{{ $maintenance->next_due_date ? $maintenance->next_due_date->format('M d, Y') : '-' }}</span>
                        </div>
                    </div>
                    @if($maintenance->status === 'scheduled' || $maintenance->status === 'in_progress')
                    <div class="alert alert-info mt-3 mb-0">
                        <i class="bi bi-info-circle me-2"></i>
                        <small>{{ __('Auto-calculated when maintenance is completed') }}</small>
                    </div>
                    @endif
                </div>
            </div>

            {{-- Activity Card --}}
            <div class="detail-card mb-4">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon secondary">
                        <i class="bi bi-clock-history"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Activity') }}</h5>
                </div>
                <div class="detail-card-body">
                    @if($maintenance->createdBy)
                    <div class="entity-card mb-3">
                        <div class="entity-card-avatar info">
                            <i class="bi bi-person"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-title">{{ $maintenance->createdBy->name }}</h6>
                            <p class="entity-card-subtitle">{{ __('Created By') }}</p>
                        </div>
                    </div>
                    @endif

                    <div class="detail-timeline">
                        <div class="timeline-item">
                            <div class="timeline-marker primary">
                                <i class="bi bi-plus"></i>
                            </div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">{{ __('Maintenance Created') }}</h6>
                                <p class="timeline-time">{{ $maintenance->created_at->format('M d, Y \a\t h:i A') }}</p>
                            </div>
                        </div>
                        
                        @if($maintenance->status !== 'scheduled')
                        <div class="timeline-item">
                            <div class="timeline-marker info">
                                <i class="bi bi-check"></i>
                            </div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">{{ __('Status Updated') }}</h6>
                                <p class="timeline-time">{{ __('Changed to') }} {{ __(ucfirst(str_replace('_', ' ', $maintenance->status))) }}</p>
                            </div>
                        </div>
                        @endif

                        <div class="timeline-item">
                            <div class="timeline-marker secondary">
                                <i class="bi bi-pencil"></i>
                            </div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">{{ __('Last Updated') }}</h6>
                                <p class="timeline-time">{{ $maintenance->updated_at->format('M d, Y \a\t h:i A') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Delete Card --}}
            @if(auth()->user()->hasPermission('maintenance.delete'))
            <div class="detail-card mb-4">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon danger">
                        <i class="bi bi-trash"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Danger Zone') }}</h5>
                </div>
                <div class="detail-card-body">
                    <p class="text-muted small mb-3">{{ __('Deleting a maintenance record is permanent and cannot be undone.') }}</p>
                    <form action="{{ route('admin.maintenances.destroy', $maintenance) }}" method="POST" 
                          onsubmit="return confirm('{{ __('Are you sure you want to delete this maintenance record?') }}')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn-detail btn-detail-danger w-100 justify-content-center">
                            <i class="bi bi-trash"></i>
                            {{ __('Delete Maintenance') }}
                        </button>
                    </form>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection