@extends('layouts.app')

@section('title', __('Vehicle Maintenance History') . ' - ' . $vehicle->vehicle_number)

@push('styles')
<link rel="stylesheet" href="{{ asset('css/adminlistpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header --}}
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-clock-history"></i>
                {{ __('Vehicle Maintenance History') }}
            </h1>
            <p class="list-page-subtitle">{{ $vehicle->vehicle_number }} - {{ $vehicle->brand }} {{ $vehicle->model }}</p>
        </div>
        <div class="list-page-header-actions">
            <a href="{{ route('admin.maintenances.index') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('Back to Maintenances') }}
            </a>
            @if(auth()->user()->hasPermission('maintenance.create'))
            <a href="{{ route('admin.maintenances.create') }}?vehicle_id={{ $vehicle->id }}" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                {{ __('Add Maintenance') }}
            </a>
            @endif
        </div>
    </div>

    {{-- Vehicle Info Card --}}
    <div class="row mb-4">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center gap-3">
                        <div class="rounded-3 bg-primary-subtle p-3">
                            <i class="bi bi-truck text-primary" style="font-size: 2rem;"></i>
                        </div>
                        <div>
                            <h4 class="mb-1">{{ $vehicle->vehicle_number }}</h4>
                            <p class="mb-0 text-muted">{{ $vehicle->brand }} {{ $vehicle->model }} · {{ $vehicle->vehicleType->name ?? '-' }}</p>
                        </div>
                        <div class="ms-auto">
                            <span class="badge bg-{{ $vehicle->status === 'active' ? 'success' : ($vehicle->status === 'maintenance' ? 'warning' : 'secondary') }} fs-6">
                                {{ ucfirst($vehicle->status) }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-primary text-white">
                <div class="card-body text-center">
                    <h2 class="mb-0">${{ number_format($totalCost ?? 0, 2) }}</h2>
                    <p class="mb-0">{{ __('Total Maintenance Cost') }}</p>
                </div>
            </div>
        </div>
    </div>

    @php
        $statusClasses = [
            'scheduled' => 'pending',
            'in_progress' => 'assigned',
            'completed' => 'delivered',
            'cancelled' => 'cancelled'
        ];
        $statusIcons = [
            'scheduled' => 'calendar',
            'in_progress' => 'gear-wide-connected',
            'completed' => 'check-circle',
            'cancelled' => 'x-circle'
        ];
    @endphp

    {{-- Data Table --}}
    <div class="list-table-container">
        <div class="list-table-header">
            <h5 class="list-table-title">
                {{ __('Maintenance History') }}
                <span class="list-table-count">({{ $maintenances->total() }} {{ __('records') }})</span>
            </h5>
        </div>

        @if($maintenances->count() > 0)
            <div class="table-responsive">
                <table class="list-table">
                    <thead>
                        <tr>
                            <th>{{ __('Maintenance #') }}</th>
                            <th>{{ __('Type') }}</th>
                            <th>{{ __('Scheduled Date') }}</th>
                            <th>{{ __('Completed Date') }}</th>
                            <th>{{ __('Odometer') }}</th>
                            <th>{{ __('Cost') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th class="text-center">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($maintenances as $maintenance)
                        <tr>
                            <td>
                                <a href="{{ route('admin.maintenances.show', $maintenance) }}" class="table-item-link">
                                    {{ $maintenance->maintenance_number }}
                                </a>
                            </td>
                            <td>
                                <span class="badge bg-secondary-subtle text-secondary">
                                    {{ $maintenance->maintenanceType->name }}
                                </span>
                            </td>
                            <td>
                                <div class="table-cell-date">
                                    <i class="bi bi-calendar"></i>
                                    {{ $maintenance->scheduled_date->format('M d, Y') }}
                                </div>
                            </td>
                            <td>
                                @if($maintenance->completed_date)
                                <div class="table-cell-date text-success">
                                    <i class="bi bi-calendar-check"></i>
                                    {{ $maintenance->completed_date->format('M d, Y') }}
                                </div>
                                @else
                                <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                {{ $maintenance->odometer_reading ? number_format($maintenance->odometer_reading) . ' km' : '-' }}
                            </td>
                            <td>
                                <span class="fw-semibold">${{ number_format($maintenance->totalCost, 2) }}</span>
                            </td>
                            <td>
                                <span class="table-badge table-badge-{{ $statusClasses[$maintenance->status] ?? 'pending' }}">
                                    <i class="bi bi-{{ $statusIcons[$maintenance->status] ?? 'circle' }}"></i>
                                    {{ __(ucfirst(str_replace('_', ' ', $maintenance->status))) }}
                                </span>
                            </td>
                            <td>
                                <div class="table-actions">
                                    <a href="{{ route('admin.maintenances.show', $maintenance) }}" class="btn-table-action btn-table-view" title="{{ __('View') }}">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    @if(auth()->user()->hasPermission('maintenance.edit'))
                                    <a href="{{ route('admin.maintenances.edit', $maintenance) }}" class="btn-table-action btn-table-edit" title="{{ __('Edit') }}">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Pagination --}}
            @if($maintenances->hasPages())
            <div class="list-pagination">
                <div class="list-pagination-info">
                    {{ __('Showing') }} {{ $maintenances->firstItem() }} {{ __('to') }} {{ $maintenances->lastItem() }} {{ __('of') }} {{ $maintenances->total() }} {{ __('entries') }}
                </div>
                <div class="list-pagination-links">
                    {{ $maintenances->withQueryString()->links() }}
                </div>
            </div>
            @endif
        @else
            <div class="list-empty-state">
                <div class="list-empty-state-icon">
                    <i class="bi bi-inbox"></i>
                </div>
                <h4 class="list-empty-state-title">{{ __('No Maintenance History') }}</h4>
                <p class="list-empty-state-text">{{ __('No maintenance records found for this vehicle') }}</p>
                @if(auth()->user()->hasPermission('maintenance.create'))
                <a href="{{ route('admin.maintenances.create') }}?vehicle_id={{ $vehicle->id }}" class="btn-create">
                    <i class="bi bi-plus-lg"></i>
                    {{ __('Schedule Maintenance') }}
                </a>
                @endif
            </div>
        @endif
    </div>
</div>
@endsection