<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ __('Privacy Policy & Terms') }} - LogiFleet</title>
    
    <!-- Bootstrap 5.3 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    
    <!-- Google Fonts - Poppins -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        * {
            font-family: 'Poppins', sans-serif;
        }
        
        body {
            background-color: #F9FAFB;
        }
        
        .bg-gradient-primary {
            background: linear-gradient(135deg, #2563EB 0%, #1E40AF 100%);
        }
        
        .btn-floating {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            box-shadow: 0 4px 15px rgba(37, 99, 235, 0.4);
            display: none;
        }
        
        .card {
            border: none;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }
        
        .border-5 {
            border-width: 5px !important;
        }
        
        a {
            color: #2563EB;
            text-decoration: none;
        }
        
        a:hover {
            color: #1E40AF;
        }
        
        .list-unstyled a {
            transition: all 0.3s ease;
        }
        
        .list-unstyled a:hover {
            padding-left: 5px;
        }
        
        h2, h3, h4, h5, h6 {
            color: #111827;
        }
        
        .text-primary {
            color: #2563EB !important;
        }
        
        .bg-primary {
            background-color: #2563EB !important;
        }
        
        .btn-primary {
            background-color: #2563EB;
            border-color: #2563EB;
        }
        
        .btn-primary:hover {
            background-color: #1E40AF;
            border-color: #1E40AF;
        }
        
        .alert-info {
            background-color: #EFF6FF;
            border-color: #BFDBFE;
            color: #1E40AF;
        }
        
        .alert-warning {
            background-color: #FEF3C7;
            border-color: #FDE68A;
            color: #92400E;
        }
        
        .alert-success {
            background-color: #D1FAE5;
            border-color: #A7F3D0;
            color: #065F46;
        }
        
        .bg-light {
            background-color: #F3F4F6 !important;
        }
        
        .section-divider {
            height: 3px;
            background: linear-gradient(90deg, #2563EB 0%, #10B981 100%);
            margin: 3rem 0;
            border: none;
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card border-0 shadow-sm bg-gradient-primary text-white">
                    <div class="card-body py-4">
                        <h1 class="display-5 fw-bold mb-2">
                            <i class="bi bi-shield-check me-2"></i>{{ __('Privacy Policy & Terms') }}
                        </h1>
                        <p class="lead mb-0">{{ __('LogiFleet Management System') }}</p>
                        
                    </div>
                </div>
            </div>
        </div>

      

        <!-- PRIVACY POLICY SECTION -->
        <div class="row mb-5" id="privacy-policy">
            <div class="col-12">
                <div class="card shadow-sm border-start border-primary border-5">
                    <div class="card-body">
                        <h2 class="card-title fw-bold text-primary mb-4">
                            <i class="bi bi-shield-check me-2"></i>{{ __('Privacy Policy') }}
                        </h2>

                        <!-- Introduction -->
                        <div class="mb-4">
                            <h4 class="fw-bold">{{ __('Introduction') }}</h4>
                            <p>{{ __('Welcome to LogiFleet, a comprehensive fleet management system. We are committed to protecting your privacy and ensuring the security of your personal information.') }}</p>
                            <p>{{ __('This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you use our web application and mobile driver application.') }}</p>
                            <div class="alert alert-info">
                                <i class="bi bi-info-circle me-2"></i>
                                {{ __('By using LogiFleet, you agree to the collection and use of information in accordance with this policy.') }}
                            </div>
                        </div>

                        <!-- Information We Collect -->
                        <div class="mb-4" id="information-collect">
                            <h4 class="fw-bold">{{ __('Information We Collect') }}</h4>
                            
                            <h6 class="fw-bold mt-3">{{ __('Personal Information') }}</h6>
                            <ul>
                                <li>{{ __('Name, email address, and phone number') }}</li>
                                <li>{{ __('Username and password') }}</li>
                                <li>{{ __('Driver license information (for drivers)') }}</li>
                                <li>{{ __('Profile information and preferences') }}</li>
                            </ul>

                            <h6 class="fw-bold mt-3">{{ __('Location Information') }}</h6>
                            <ul>
                                <li>{{ __('Real-time GPS location data during active trips') }}</li>
                                <li>{{ __('Delivery location coordinates') }}</li>
                                <li>{{ __('Route history and travel patterns') }}</li>
                            </ul>
                            <div class="alert alert-warning">
                                <i class="bi bi-exclamation-triangle me-2"></i>
                                {{ __('GPS tracking is only active when you are logged into the driver app and have an active trip. You can disable location services at any time through your device settings.') }}
                            </div>

                            <h6 class="fw-bold mt-3">{{ __('Delivery & Vehicle Information') }}</h6>
                            <ul>
                                <li>{{ __('Proof of delivery photos and digital signatures') }}</li>
                                <li>{{ __('Vehicle type, make, model, and license plate') }}</li>
                                <li>{{ __('Trip records and delivery timestamps') }}</li>
                                <li>{{ __('Shipment details and costs') }}</li>
                            </ul>

                            <h6 class="fw-bold mt-3">{{ __('Usage Information') }}</h6>
                            <ul>
                                <li>{{ __('Login timestamps and IP addresses') }}</li>
                                <li>{{ __('Device information and app usage patterns') }}</li>
                                <li>{{ __('Error logs and crash reports') }}</li>
                            </ul>
                        </div>

                        <!-- How We Use Information -->
                        <div class="mb-4" id="data-use">
                            <h4 class="fw-bold">{{ __('How We Use Your Information') }}</h4>
                            <p>{{ __('We use the collected information for the following purposes:') }}</p>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <div class="card bg-light h-100">
                                        <div class="card-body">
                                            <h6 class="fw-bold text-primary">
                                                <i class="bi bi-truck me-2"></i>{{ __('Fleet Operations') }}
                                            </h6>
                                            <ul class="small mb-0">
                                                <li>{{ __('Trip planning and route optimization') }}</li>
                                                <li>{{ __('Real-time vehicle tracking') }}</li>
                                                <li>{{ __('Delivery management and confirmation') }}</li>
                                                <li>{{ __('Driver assignment and scheduling') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="card bg-light h-100">
                                        <div class="card-body">
                                            <h6 class="fw-bold text-primary">
                                                <i class="bi bi-shield-check me-2"></i>{{ __('Security & Safety') }}
                                            </h6>
                                            <ul class="small mb-0">
                                                <li>{{ __('User authentication and access control') }}</li>
                                                <li>{{ __('Fraud detection and prevention') }}</li>
                                                <li>{{ __('Security monitoring') }}</li>
                                                <li>{{ __('Legal compliance') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="card bg-light h-100">
                                        <div class="card-body">
                                            <h6 class="fw-bold text-primary">
                                                <i class="bi bi-graph-up me-2"></i>{{ __('Analytics & Improvement') }}
                                            </h6>
                                            <ul class="small mb-0">
                                                <li>{{ __('Performance analysis and reporting') }}</li>
                                                <li>{{ __('Service improvement and optimization') }}</li>
                                                <li>{{ __('Feature development and testing') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="card bg-light h-100">
                                        <div class="card-body">
                                            <h6 class="fw-bold text-primary">
                                                <i class="bi bi-chat-dots me-2"></i>{{ __('Communication') }}
                                            </h6>
                                            <ul class="small mb-0">
                                                <li>{{ __('Service notifications and updates') }}</li>
                                                <li>{{ __('Customer support and assistance') }}</li>
                                                <li>{{ __('System alerts and maintenance') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Information Sharing -->
                        <div class="mb-4">
                            <h4 class="fw-bold">{{ __('Information Sharing') }}</h4>
                            <p>{{ __('We do not sell your personal information. We may share your information in the following circumstances:') }}</p>
                            <ul>
                                <li><strong>{{ __('Within Your Organization') }}:</strong> {{ __('Information is shared with authorized users based on their role and permissions.') }}</li>
                                <li><strong>{{ __('Service Providers') }}:</strong> {{ __('Cloud hosting providers (Firebase for GPS tracking), database services, and analytics tools.') }}</li>
                                <li><strong>{{ __('Legal Requirements') }}:</strong> {{ __('When required by law or to protect rights, property, or safety.') }}</li>
                                <li><strong>{{ __('Business Transfers') }}:</strong> {{ __('In the event of a merger, acquisition, or sale of assets.') }}</li>
                            </ul>
                        </div>

                        <!-- Data Security -->
                        <div class="mb-4" id="data-security">
                            <h4 class="fw-bold">{{ __('Data Security') }}</h4>
                            <p>{{ __('We implement appropriate technical and organizational measures to protect your information:') }}</p>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <div class="d-flex">
                                        <div class="flex-shrink-0">
                                            <i class="bi bi-lock-fill text-primary fs-3 me-3"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="fw-bold">{{ __('Encryption') }}</h6>
                                            <p class="small text-muted">{{ __('Data in transit is encrypted using SSL/TLS. Passwords are hashed using bcrypt.') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="d-flex">
                                        <div class="flex-shrink-0">
                                            <i class="bi bi-person-check-fill text-primary fs-3 me-3"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="fw-bold">{{ __('Access Control') }}</h6>
                                            <p class="small text-muted">{{ __('Role-based access control (RBAC) ensures users only access data they need.') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="d-flex">
                                        <div class="flex-shrink-0">
                                            <i class="bi bi-eye-fill text-primary fs-3 me-3"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="fw-bold">{{ __('Monitoring') }}</h6>
                                            <p class="small text-muted">{{ __('Continuous security monitoring and regular security audits.') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="d-flex">
                                        <div class="flex-shrink-0">
                                            <i class="bi bi-arrow-repeat text-primary fs-3 me-3"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="fw-bold">{{ __('Backups') }}</h6>
                                            <p class="small text-muted">{{ __('Regular data backups with secure storage and recovery procedures.') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="alert alert-warning">
                                <i class="bi bi-exclamation-triangle me-2"></i>
                                {{ __('While we strive to protect your information, no method of transmission over the internet is 100% secure. Please use strong passwords and keep your login credentials confidential.') }}
                            </div>
                        </div>

                        <!-- Data Retention -->
                        <div class="mb-4">
                            <h4 class="fw-bold">{{ __('Data Retention') }}</h4>
                            <p>{{ __('We retain your information for as long as necessary to fulfill the purposes outlined in this policy:') }}</p>
                            <ul>
                                <li><strong>{{ __('Account Information') }}:</strong> {{ __('Retained while your account is active and for 2 years after account closure.') }}</li>
                                <li><strong>{{ __('Trip Records') }}:</strong> {{ __('Retained for 5 years for legal and compliance purposes.') }}</li>
                                <li><strong>{{ __('GPS Tracking Data') }}:</strong> {{ __('Retained for 90 days, then automatically deleted.') }}</li>
                                <li><strong>{{ __('Delivery Photos') }}:</strong> {{ __('Retained for 3 years for proof of delivery.') }}</li>
                                <li><strong>{{ __('System Logs') }}:</strong> {{ __('Retained for 1 year for security and troubleshooting.') }}</li>
                            </ul>
                            <p>{{ __('You may request earlier deletion of your data by contacting us.') }}</p>
                        </div>

                        <!-- GPS Tracking -->
                        <div class="mb-4" id="gps-tracking">
                            <h4 class="fw-bold">{{ __('GPS Tracking and Location Services') }}</h4>
                            <div class="alert alert-info">
                                <i class="bi bi-geo-alt-fill me-2"></i>
                                <strong>{{ __('Important Information for Drivers') }}</strong>
                            </div>
                            
                            <h6 class="fw-bold mt-3">{{ __('When Location is Collected') }}</h6>
                            <p>{{ __('GPS location data is collected only when:') }}</p>
                            <ul>
                                <li>{{ __('You are logged into the LogiFleet Driver mobile app') }}</li>
                                <li>{{ __('You have an active trip assigned') }}</li>
                                <li>{{ __('Location services are enabled on your device') }}</li>
                            </ul>

                            <h6 class="fw-bold mt-3">{{ __('Purpose of GPS Tracking') }}</h6>
                            <ul>
                                <li>{{ __('Real-time trip monitoring and route optimization') }}</li>
                                <li>{{ __('Accurate delivery time estimates') }}</li>
                                <li>{{ __('Safety and security of drivers and cargo') }}</li>
                                <li>{{ __('Compliance verification and record-keeping') }}</li>
                            </ul>

                            <h6 class="fw-bold mt-3">{{ __('Controlling Location Tracking') }}</h6>
                            <ul>
                                <li>{{ __('Disable location services in your device settings') }}</li>
                                <li>{{ __('Log out of the driver app when off-duty') }}</li>
                                <li>{{ __('Location is NOT tracked when app is closed or you\'re logged out') }}</li>
                            </ul>

                            <h6 class="fw-bold mt-3">{{ __('Location Data Storage') }}</h6>
                            <ul>
                                <li>{{ __('Stored in Firebase Realtime Database') }}</li>
                                <li>{{ __('Automatically deleted after 90 days') }}</li>
                                <li>{{ __('Encrypted during transmission and storage') }}</li>
                                <li>{{ __('Accessible only to authorized personnel') }}</li>
                            </ul>
                        </div>

                        <!-- Your Rights -->
                        <div class="mb-4" id="your-rights">
                            <h4 class="fw-bold">{{ __('Your Rights and Choices') }}</h4>
                            <p>{{ __('You have the following rights regarding your personal information:') }}</p>
                            <ul>
                                <li><strong>{{ __('Right to Access') }}:</strong> {{ __('Request a copy of your personal data from your profile settings.') }}</li>
                                <li><strong>{{ __('Right to Correction') }}:</strong> {{ __('Update your personal information at any time through your profile.') }}</li>
                                <li><strong>{{ __('Right to Deletion') }}:</strong> {{ __('Request deletion of your account and personal data (some data may be retained for legal compliance).') }}</li>
                                <li><strong>{{ __('Right to Object') }}:</strong> {{ __('Object to certain data processing activities.') }}</li>
                                <li><strong>{{ __('Right to Data Portability') }}:</strong> {{ __('Export your data in JSON/CSV format.') }}</li>
                            </ul>
                        </div>

                        <!-- Changes to Policy -->
                        <div class="mb-4">
                            <h4 class="fw-bold">{{ __('Changes to This Privacy Policy') }}</h4>
                            <p>{{ __('We may update this Privacy Policy from time to time. When we make changes:') }}</p>
                            <ul>
                                <li>{{ __('The "Last Updated" date at the top will be revised') }}</li>
                                <li>{{ __('Registered users will be notified via email') }}</li>
                                <li>{{ __('A notification will appear in the application') }}</li>
                            </ul>
                            <p>{{ __('Your continued use of LogiFleet after changes are posted constitutes acceptance of the updated policy.') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <hr class="section-divider">

        <!-- TERMS OF SERVICE SECTION -->
        <div class="row mb-5" id="terms-service">
            <div class="col-12">
                <div class="card shadow-sm border-start border-success border-5">
                    <div class="card-body">
                        <h2 class="card-title fw-bold text-success mb-4">
                            <i class="bi bi-file-earmark-text me-2"></i>{{ __('Terms of Service') }}
                        </h2>

                        <div class="mb-4">
                            <h4 class="fw-bold">{{ __('Acceptance of Terms') }}</h4>
                            <p>{{ __('By accessing and using LogiFleet, you accept and agree to be bound by the terms and provision of this agreement.') }}</p>
                        </div>

                        <div class="mb-4">
                            <h4 class="fw-bold">{{ __('User Accounts') }}</h4>
                            <p>{{ __('You are responsible for:') }}</p>
                            <ul>
                                <li>{{ __('Maintaining the confidentiality of your account and password') }}</li>
                                <li>{{ __('All activities that occur under your account') }}</li>
                                <li>{{ __('Notifying us immediately of any unauthorized use') }}</li>
                                <li>{{ __('Ensuring your account information is accurate and up-to-date') }}</li>
                            </ul>
                        </div>

                        <div class="mb-4">
                            <h4 class="fw-bold">{{ __('Acceptable Use') }}</h4>
                            <p>{{ __('You agree NOT to:') }}</p>
                            <ul>
                                <li>{{ __('Use the service for any illegal purpose') }}</li>
                                <li>{{ __('Attempt to gain unauthorized access to the system') }}</li>
                                <li>{{ __('Upload malicious code or viruses') }}</li>
                                <li>{{ __('Interfere with or disrupt the service') }}</li>
                                <li>{{ __('Misuse or abuse the GPS tracking features') }}</li>
                                <li>{{ __('Share your account credentials with unauthorized persons') }}</li>
                            </ul>
                        </div>

                        <div class="mb-4">
                            <h4 class="fw-bold">{{ __('Intellectual Property') }}</h4>
                            <p>{{ __('The service and its original content, features, and functionality are owned by LogiFleet and are protected by international copyright, trademark, and other intellectual property laws.') }}</p>
                        </div>

                        <div class="mb-4">
                            <h4 class="fw-bold">{{ __('Limitation of Liability') }}</h4>
                            <p>{{ __('LogiFleet shall not be liable for any indirect, incidental, special, consequential, or punitive damages resulting from:') }}</p>
                            <ul>
                                <li>{{ __('Your use or inability to use the service') }}</li>
                                <li>{{ __('Any unauthorized access to or use of our servers') }}</li>
                                <li>{{ __('Any interruption or cessation of transmission to or from the service') }}</li>
                                <li>{{ __('Any bugs, viruses, or the like that may be transmitted through the service') }}</li>
                            </ul>
                        </div>

                        <div class="mb-4">
                            <h4 class="fw-bold">{{ __('Termination') }}</h4>
                            <p>{{ __('We may terminate or suspend your account and access to the service immediately, without prior notice or liability, for any reason, including breach of these Terms.') }}</p>
                        </div>

                        <div class="mb-4">
                            <h4 class="fw-bold">{{ __('Governing Law') }}</h4>
                            <p>{{ __('These Terms shall be governed by and construed in accordance with the laws of India, without regard to its conflict of law provisions.') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <hr class="section-divider">

        

        <!-- Footer -->
        <div class="row">
            <div class="col-12">
                <div class="text-center text-muted py-4">
                    <p class="mb-0">&copy; {{ date('Y') }} LogiFleet Management System. {{ __('All rights reserved.') }}</p>
                    <p class="small mb-0">{{ __('Last Updated') }}: {{ \Carbon\Carbon::parse($lastUpdated)->format('F d, Y') }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Back to Top Button -->
    <button type="button" class="btn btn-primary btn-floating position-fixed bottom-0 end-0 m-4" id="backToTop">
        <i class="bi bi-arrow-up"></i>
    </button>

    <!-- Bootstrap 5.3 JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Back to top button
        const backToTopBtn = document.getElementById('backToTop');
        
        window.addEventListener('scroll', function() {
            if (window.pageYOffset > 300) {
                backToTopBtn.style.display = 'block';
            } else {
                backToTopBtn.style.display = 'none';
            }
        });
        
        backToTopBtn.addEventListener('click', function() {
            window.scrollTo({ top: 0, behavior: 'smooth' });
        });

        // Smooth scroll for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({ behavior: 'smooth', block: 'start' });
                }
            });
        });
    </script>
</body>
</html>