@extends('layouts.app')

@section('title', __('Cost Report'))
@section('page-title', __('Cost Report'))
@section('page-subtitle', __('Analyze expenses and cost breakdown'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/adminlistpage.css') }}">
<style>
    .report-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 1.5rem;
    }
    .export-dropdown .dropdown-menu {
        min-width: 150px;
    }
    .summary-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
        gap: 1rem;
        margin-bottom: 1.5rem;
    }
    .summary-card {
        background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
        border-radius: 12px;
        padding: 1.25rem;
        border: 1px solid #fca5a5;
    }
    .summary-card.primary {
        background: linear-gradient(135deg, #fef2f2 0%, #fee2e2 100%);
        border-color: #fca5a5;
    }
    .summary-card-value {
        font-size: 1.75rem;
        font-weight: 700;
        color: #dc2626;
    }
    .summary-card-label {
        font-size: 0.75rem;
        color: #991b1b;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    .filter-section {
        background: white;
        border-radius: 12px;
        padding: 1.25rem;
        margin-bottom: 1.5rem;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .chart-section {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
        gap: 1.5rem;
        margin-bottom: 1.5rem;
    }
    .chart-card {
        background: white;
        border-radius: 12px;
        padding: 1.25rem;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .chart-card-title {
        font-weight: 600;
        color: #374151;
        margin-bottom: 1rem;
        padding-bottom: 0.5rem;
        border-bottom: 1px solid #e5e7eb;
    }
    .data-table-card {
        background: white;
        border-radius: 12px;
        padding: 1.25rem;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .mini-table {
        width: 100%;
    }
    .mini-table th {
        font-size: 0.7rem;
        text-transform: uppercase;
        color: #6b7280;
        font-weight: 600;
        padding: 0.5rem;
        border-bottom: 2px solid #e5e7eb;
    }
    .mini-table td {
        padding: 0.5rem;
        font-size: 0.85rem;
        border-bottom: 1px solid #f3f4f6;
    }
    .cost-type-badge {
        padding: 0.25rem 0.5rem;
        border-radius: 4px;
        font-size: 0.7rem;
        font-weight: 600;
        background: #fef2f2;
        color: #dc2626;
    }
    .cost-type-badge.fuel { background: #fef3c7; color: #92400e; }
    .cost-type-badge.toll { background: #dbeafe; color: #1e40af; }
    .cost-type-badge.maintenance { background: #d1fae5; color: #065f46; }
    .cost-type-badge.loading { background: #ede9fe; color: #5b21b6; }
    .cost-type-badge.parking { background: #fce7f3; color: #be185d; }
    .cost-type-badge.other { background: #f3f4f6; color: #374151; }
    .percentage-bar {
        height: 8px;
        background: #e5e7eb;
        border-radius: 4px;
        overflow: hidden;
    }
    .percentage-bar-fill {
        height: 100%;
        background: linear-gradient(90deg, #dc2626, #f87171);
        border-radius: 4px;
    }
    .trend-up { color: #dc2626; }
    .trend-down { color: #16a34a; }
</style>
@endpush

@section('content')
<div class="container-fluid">
    {{-- Report Header --}}
    <div class="report-header">
        <div>
            <h4 class="mb-1"><i class="bi bi-currency-dollar text-danger me-2"></i>{{ __('Cost Analysis Report') }}</h4>
            <p class="text-muted mb-0">{{ __('Detailed breakdown of all trip-related expenses') }}</p>
        </div>
        <div class="d-flex gap-2">
            <div class="dropdown export-dropdown">
                <button class="btn btn-success dropdown-toggle" type="button" data-bs-toggle="dropdown">
                    <i class="bi bi-download me-1"></i> {{ __('Export') }}
                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                        <a class="dropdown-item" href="{{ route('admin.reports.cost.export', array_merge(request()->query(), ['format' => 'pdf'])) }}">
                            <i class="bi bi-file-pdf text-danger me-2"></i> {{ __('Export as PDF') }}
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item" href="{{ route('admin.reports.cost.export', array_merge(request()->query(), ['format' => 'csv'])) }}">
                            <i class="bi bi-filetype-csv text-success me-2"></i> {{ __('Export as CSV') }}
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item" href="{{ route('admin.reports.cost.export', array_merge(request()->query(), ['format' => 'html'])) }}">
                            <i class="bi bi-filetype-html text-primary me-2"></i> {{ __('Export as HTML') }}
                        </a>
                    </li>
                </ul>
            </div>
            <a href="{{ route('admin.costs.index') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-1"></i> {{ __('Back to Costs') }}
            </a>
        </div>
    </div>

    {{-- Summary Cards --}}
    <div class="summary-cards">
        <div class="summary-card primary">
            <div class="summary-card-value">${{ number_format($summary['total_cost'], 2) }}</div>
            <div class="summary-card-label">{{ __('Total Cost') }}</div>
        </div>
        <div class="summary-card">
            <div class="summary-card-value">${{ number_format($summary['avg_cost'], 2) }}</div>
            <div class="summary-card-label">{{ __('Average Cost') }}</div>
        </div>
        <div class="summary-card">
            <div class="summary-card-value">{{ $summary['total_records'] }}</div>
            <div class="summary-card-label">{{ __('Total Entries') }}</div>
        </div>
    </div>

    {{-- Filters --}}
    <div class="filter-section">
        <form action="{{ route('admin.reports.cost.index') }}" method="GET">
            <div class="row g-3">
                <div class="col-md-2">
                    <label class="form-label">{{ __('Date From') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Date To') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                </div>
                <div class="col-md-3">
                    <label class="form-label">{{ __('Trip') }}</label>
                    <select name="trip_id" class="form-select">
                        <option value="">{{ __('All Trips') }}</option>
                        @foreach($trips as $trip)
                            <option value="{{ $trip->id }}" {{ request('trip_id') == $trip->id ? 'selected' : '' }}>
                                {{ $trip->trip_number }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Cost Type') }}</label>
                    <select name="cost_type" class="form-select">
                        <option value="">{{ __('All Types') }}</option>
                        @foreach($costTypes as $type)
                            <option value="{{ $type }}" {{ request('cost_type') == $type ? 'selected' : '' }}>
                                {{ ucfirst($type) }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 d-flex align-items-end gap-2">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-funnel me-1"></i> {{ __('Filter') }}
                    </button>
                    <a href="{{ route('admin.reports.cost.index') }}" class="btn btn-outline-secondary">
                        <i class="bi bi-x-lg"></i>
                    </a>
                </div>
            </div>
        </form>
    </div>

    {{-- Charts Section --}}
    <div class="chart-section">
        {{-- By Cost Type --}}
        <div class="chart-card">
            <h6 class="chart-card-title"><i class="bi bi-pie-chart me-2"></i>{{ __('Cost Breakdown by Type') }}</h6>
            @if($byCostType->count() > 0)
                <table class="mini-table">
                    <thead>
                        <tr>
                            <th>{{ __('Cost Type') }}</th>
                            <th class="text-end">{{ __('Total') }}</th>
                            <th class="text-end">{{ __('Count') }}</th>
                            <th style="width: 120px;">{{ __('Share') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($byCostType as $item)
                        @php
                            $percentage = $summary['total_cost'] > 0 ? round(($item->total_amount / $summary['total_cost']) * 100, 1) : 0;
                            $typeClass = strtolower($item->cost_type ?? 'other');
                        @endphp
                        <tr>
                            <td><span class="cost-type-badge {{ $typeClass }}">{{ ucfirst($item->cost_type ?? 'Other') }}</span></td>
                            <td class="text-end"><strong>${{ number_format($item->total_amount, 2) }}</strong></td>
                            <td class="text-end">{{ $item->count }}</td>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <div class="percentage-bar flex-grow-1">
                                        <div class="percentage-bar-fill" style="width: {{ $percentage }}%"></div>
                                    </div>
                                    <span class="text-muted" style="font-size: 0.75rem; min-width: 35px;">{{ $percentage }}%</span>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <p class="text-muted text-center py-3">{{ __('No data available') }}</p>
            @endif
        </div>

        {{-- By Trip (Top 10) --}}
        <div class="chart-card">
            <h6 class="chart-card-title"><i class="bi bi-signpost-split me-2"></i>{{ __('Top Trips by Cost') }}</h6>
            @if($byTrip->count() > 0)
                <table class="mini-table">
                    <thead>
                        <tr>
                            <th>{{ __('Trip') }}</th>
                            <th class="text-end">{{ __('Total Cost') }}</th>
                            <th class="text-end">{{ __('Entries') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($byTrip as $item)
                        <tr>
                            <td>{{ $item->trip->trip_number ?? '-' }}</td>
                            <td class="text-end"><strong>${{ number_format($item->total_amount, 2) }}</strong></td>
                            <td class="text-end">{{ $item->count }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <p class="text-muted text-center py-3">{{ __('No data available') }}</p>
            @endif
        </div>

        {{-- Monthly Trend --}}
        <div class="chart-card">
            <h6 class="chart-card-title"><i class="bi bi-graph-up me-2"></i>{{ __('Monthly Trend (Last 6 Months)') }}</h6>
            @if($monthlyTrend->count() > 0)
                <table class="mini-table">
                    <thead>
                        <tr>
                            <th>{{ __('Month') }}</th>
                            <th class="text-end">{{ __('Total Cost') }}</th>
                            <th class="text-end">{{ __('Entries') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($monthlyTrend as $item)
                        <tr>
                            <td>{{ \Carbon\Carbon::parse($item->month . '-01')->format('M Y') }}</td>
                            <td class="text-end"><strong>${{ number_format($item->total_amount, 2) }}</strong></td>
                            <td class="text-end">{{ $item->count }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <p class="text-muted text-center py-3">{{ __('No data available') }}</p>
            @endif
        </div>
    </div>

    {{-- Data Table --}}
    <div class="data-table-card">
        <h6 class="chart-card-title"><i class="bi bi-table me-2"></i>{{ __('Cost Details') }}</h6>
        
        @if($costs->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead>
                        <tr>
                            <th>{{ __('Date') }}</th>
                            <th>{{ __('Trip') }}</th>
                            <th>{{ __('Vehicle') }}</th>
                            <th>{{ __('Driver') }}</th>
                            <th>{{ __('Cost Type') }}</th>
                            <th>{{ __('Description') }}</th>
                            <th class="text-end">{{ __('Amount') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($costs as $cost)
                        @php
                            $typeClass = strtolower($cost->cost_type ?? 'other');
                        @endphp
                        <tr>
                            <td>{{ $cost->created_at->format('Y-m-d') }}</td>
                            <td>{{ $cost->trip->trip_number ?? '-' }}</td>
                            <td>{{ $cost->trip->vehicle->vehicle_number ?? '-' }}</td>
                            <td>{{ $cost->trip->driver->name ?? '-' }}</td>
                            <td><span class="cost-type-badge {{ $typeClass }}">{{ ucfirst($cost->cost_type ?? 'Other') }}</span></td>
                            <td>{{ $cost->description ?? '-' }}</td>
                            <td class="text-end"><strong>${{ number_format($cost->amount, 2) }}</strong></td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                {{ $costs->links() }}
            </div>
        @else
            <div class="text-center py-5">
                <i class="bi bi-currency-dollar display-4 text-muted"></i>
                <p class="text-muted mt-2">{{ __('No cost entries found for the selected filters') }}</p>
            </div>
        @endif
    </div>
</div>
@endsection