@extends('layouts.app')

@section('title', __('Create Report') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admincreatepage.css') }}">
@endpush

@section('content')
<div class="create-page-container">
    {{-- Page Header --}}
    <div class="create-page-header">
        <div class="create-page-header-content">
            <div class="create-page-breadcrumb">
                <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.reports.index') }}">{{ __('Reports') }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ __('Create') }}</span>
            </div>
            <h1 class="create-page-title">
                <div class="create-page-title-icon">
                    <i class="bi bi-plus-lg"></i>
                </div>
                {{ __('Create Report') }}
            </h1>
            <p class="create-page-subtitle">{{ __('Generate a new analytics report for your fleet') }}</p>
        </div>
        <div class="create-page-actions">
            <a href="{{ route('admin.reports.index') }}" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('Back to List') }}
            </a>
        </div>
    </div>

    {{-- Validation Errors --}}
    @if($errors->any())
        <div class="create-alert danger">
            <div class="create-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="create-alert-content">
                <div class="create-alert-title">{{ __('Please fix the following errors') }}</div>
                <div class="create-alert-text">
                    <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    @endif

    <form action="{{ route('admin.reports.store') }}" method="POST" id="reportForm">
        @csrf

        <div class="create-form-layout">
            {{-- Main Form --}}
            <div class="create-form-main">
                {{-- Basic Information Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon primary">
                            <i class="bi bi-file-earmark-bar-graph"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Basic Information') }}</h5>
                            <p class="create-card-subtitle">{{ __('Report identification and type selection') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-hash"></i>
                                    {{ __('Report Number') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" 
                                           name="report_number" 
                                           id="report_number"
                                           class="create-input @error('report_number') is-invalid @enderror" 
                                           value="{{ old('report_number', $suggestedNumber) }}"
                                           placeholder="RPT-202512-0001"
                                           required>
                                    <i class="bi bi-upc-scan create-input-icon"></i>
                                </div>
                                @error('report_number')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                                <p class="create-form-hint">
                                    <i class="bi bi-lightbulb"></i>
                                    {{ __('Auto-generated. You can modify if needed.') }}
                                </p>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-tag"></i>
                                    {{ __('Report Title') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" 
                                           name="title" 
                                           id="title"
                                           class="create-input @error('title') is-invalid @enderror" 
                                           value="{{ old('title') }}"
                                           placeholder="{{ __('e.g., Monthly Fuel Report - December 2025') }}"
                                           required>
                                    <i class="bi bi-pencil create-input-icon"></i>
                                </div>
                                @error('title')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group full-width">
                                <label class="create-form-label">
                                    <i class="bi bi-list-check"></i>
                                    {{ __('Report Type') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-radio-cards">
                                    <div class="create-radio-card">
                                        <input type="radio" name="report_type" id="type_fuel" value="fuel_consumption" 
                                               {{ old('report_type', $selectedType) == 'fuel_consumption' ? 'checked' : '' }}>
                                        <label for="type_fuel" class="create-radio-card-label">
                                            <i class="bi bi-fuel-pump text-warning"></i>
                                            {{ __('Fuel Consumption') }}
                                        </label>
                                    </div>
                                    <div class="create-radio-card">
                                        <input type="radio" name="report_type" id="type_trip" value="trip_summary"
                                               {{ old('report_type', $selectedType) == 'trip_summary' ? 'checked' : '' }}>
                                        <label for="type_trip" class="create-radio-card-label">
                                            <i class="bi bi-geo-alt text-primary"></i>
                                            {{ __('Trip Summary') }}
                                        </label>
                                    </div>
                                    <div class="create-radio-card">
                                        <input type="radio" name="report_type" id="type_vehicle" value="vehicle_utilization"
                                               {{ old('report_type', $selectedType) == 'vehicle_utilization' ? 'checked' : '' }}>
                                        <label for="type_vehicle" class="create-radio-card-label">
                                            <i class="bi bi-truck text-info"></i>
                                            {{ __('Vehicle Utilization') }}
                                        </label>
                                    </div>
                                    <div class="create-radio-card">
                                        <input type="radio" name="report_type" id="type_driver" value="driver_performance"
                                               {{ old('report_type', $selectedType) == 'driver_performance' ? 'checked' : '' }}>
                                        <label for="type_driver" class="create-radio-card-label">
                                            <i class="bi bi-person-badge text-success"></i>
                                            {{ __('Driver Performance') }}
                                        </label>
                                    </div>
                                    <div class="create-radio-card">
                                        <input type="radio" name="report_type" id="type_cost" value="cost_analysis"
                                               {{ old('report_type', $selectedType) == 'cost_analysis' ? 'checked' : '' }}>
                                        <label for="type_cost" class="create-radio-card-label">
                                            <i class="bi bi-currency-dollar text-danger"></i>
                                            {{ __('Cost Analysis') }}
                                        </label>
                                    </div>
                                    <div class="create-radio-card">
                                        <input type="radio" name="report_type" id="type_delivery" value="delivery_performance"
                                               {{ old('report_type', $selectedType) == 'delivery_performance' ? 'checked' : '' }}>
                                        <label for="type_delivery" class="create-radio-card-label">
                                            <i class="bi bi-box-seam text-secondary"></i>
                                            {{ __('Delivery Performance') }}
                                        </label>
                                    </div>
                                </div>
                                @error('report_type')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group full-width">
                                <label class="create-form-label">
                                    <i class="bi bi-journal-text"></i>
                                    {{ __('Description') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <textarea name="description" 
                                          id="description"
                                          class="create-textarea @error('description') is-invalid @enderror"
                                          rows="3"
                                          placeholder="{{ __('Brief description of what this report covers...') }}">{{ old('description') }}</textarea>
                                @error('description')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Date Range & Filters Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon info">
                            <i class="bi bi-calendar-range"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Date Range & Filters') }}</h5>
                            <p class="create-card-subtitle">{{ __('Define the time period and scope of the report') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-calendar-plus"></i>
                                    {{ __('Start Date') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="date" 
                                           name="date_from" 
                                           id="date_from"
                                           class="create-input @error('date_from') is-invalid @enderror" 
                                           value="{{ old('date_from') }}">
                                    <i class="bi bi-calendar-event create-input-icon"></i>
                                </div>
                                @error('date_from')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-calendar-minus"></i>
                                    {{ __('End Date') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="date" 
                                           name="date_to" 
                                           id="date_to"
                                           class="create-input @error('date_to') is-invalid @enderror" 
                                           value="{{ old('date_to') }}">
                                    <i class="bi bi-calendar-event create-input-icon"></i>
                                </div>
                                @error('date_to')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                                <p class="create-form-hint">
                                    <i class="bi bi-info-circle"></i>
                                    {{ __('Leave empty for all-time report') }}
                                </p>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-truck"></i>
                                    {{ __('Filter by Vehicle') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <select name="vehicle_id" 
                                        id="vehicle_id"
                                        class="create-select @error('vehicle_id') is-invalid @enderror">
                                    <option value="">{{ __('All Vehicles') }}</option>
                                    @foreach($vehicles as $vehicle)
                                        <option value="{{ $vehicle->id }}" {{ old('vehicle_id') == $vehicle->id ? 'selected' : '' }}>
                                            {{ $vehicle->vehicle_number }} - {{ $vehicle->vehicleType->name ?? '' }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('vehicle_id')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-person"></i>
                                    {{ __('Filter by Driver') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <select name="driver_id" 
                                        id="driver_id"
                                        class="create-select @error('driver_id') is-invalid @enderror">
                                    <option value="">{{ __('All Drivers') }}</option>
                                    @foreach($drivers as $driver)
                                        <option value="{{ $driver->id }}" {{ old('driver_id') == $driver->id ? 'selected' : '' }}>
                                            {{ $driver->name }} - {{ $driver->mobile }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('driver_id')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-truck-front"></i>
                                    {{ __('Filter by Vehicle Type') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <select name="vehicle_type_id" 
                                        id="vehicle_type_id"
                                        class="create-select @error('vehicle_type_id') is-invalid @enderror">
                                    <option value="">{{ __('All Vehicle Types') }}</option>
                                    @foreach($vehicleTypes as $type)
                                        <option value="{{ $type->id }}" {{ old('vehicle_type_id') == $type->id ? 'selected' : '' }}>
                                            {{ $type->name }} ({{ $type->capacity }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('vehicle_type_id')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Output Settings Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon warning">
                            <i class="bi bi-gear"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Output Settings') }}</h5>
                            <p class="create-card-subtitle">{{ __('Choose export format and scheduling options') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-file-earmark"></i>
                                    {{ __('Output Format') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-radio-cards small">
                                    <div class="create-radio-card">
                                        <input type="radio" name="format" id="format_pdf" value="pdf" 
                                               {{ old('format', 'pdf') == 'pdf' ? 'checked' : '' }}>
                                        <label for="format_pdf" class="create-radio-card-label">
                                            <i class="bi bi-file-pdf text-danger"></i>
                                            {{ __('PDF') }}
                                        </label>
                                    </div>
                                    <div class="create-radio-card">
                                        <input type="radio" name="format" id="format_excel" value="excel"
                                               {{ old('format') == 'excel' ? 'checked' : '' }}>
                                        <label for="format_excel" class="create-radio-card-label">
                                            <i class="bi bi-file-earmark-excel text-success"></i>
                                            {{ __('Excel') }}
                                        </label>
                                    </div>
                                    <div class="create-radio-card">
                                        <input type="radio" name="format" id="format_csv" value="csv"
                                               {{ old('format') == 'csv' ? 'checked' : '' }}>
                                        <label for="format_csv" class="create-radio-card-label">
                                            <i class="bi bi-filetype-csv text-info"></i>
                                            {{ __('CSV') }}
                                        </label>
                                    </div>
                                    <div class="create-radio-card">
                                        <input type="radio" name="format" id="format_html" value="html"
                                               {{ old('format') == 'html' ? 'checked' : '' }}>
                                        <label for="format_html" class="create-radio-card-label">
                                            <i class="bi bi-filetype-html text-primary"></i>
                                            {{ __('HTML') }}
                                        </label>
                                    </div>
                                </div>
                                @error('format')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-arrow-repeat"></i>
                                    {{ __('Schedule Report') }}
                                </label>
                                <div class="create-checkbox-wrapper">
                                    <input type="checkbox" 
                                           name="is_scheduled" 
                                           id="is_scheduled"
                                           class="create-checkbox"
                                           value="1"
                                           {{ old('is_scheduled') ? 'checked' : '' }}>
                                    <label for="is_scheduled" class="create-checkbox-label">
                                        {{ __('Enable recurring generation') }}
                                    </label>
                                </div>
                            </div>

                            <div class="create-form-group" id="frequency_group" style="{{ old('is_scheduled') ? '' : 'display: none;' }}">
                                <label class="create-form-label">
                                    <i class="bi bi-calendar-week"></i>
                                    {{ __('Frequency') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select name="schedule_frequency" 
                                        id="schedule_frequency"
                                        class="create-select @error('schedule_frequency') is-invalid @enderror">
                                    <option value="">{{ __('Select Frequency') }}</option>
                                    <option value="daily" {{ old('schedule_frequency') == 'daily' ? 'selected' : '' }}>{{ __('Daily') }}</option>
                                    <option value="weekly" {{ old('schedule_frequency') == 'weekly' ? 'selected' : '' }}>{{ __('Weekly') }}</option>
                                    <option value="monthly" {{ old('schedule_frequency') == 'monthly' ? 'selected' : '' }}>{{ __('Monthly') }}</option>
                                    <option value="quarterly" {{ old('schedule_frequency') == 'quarterly' ? 'selected' : '' }}>{{ __('Quarterly') }}</option>
                                </select>
                                @error('schedule_frequency')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Form Actions --}}
                <div class="create-form-actions">
                    <a href="{{ route('admin.reports.index') }}" class="create-btn create-btn-secondary">
                        <i class="bi bi-x-lg"></i>
                        {{ __('Cancel') }}
                    </a>
                    <button type="submit" class="create-btn create-btn-primary">
                        <i class="bi bi-check-lg"></i>
                        {{ __('Save as Draft') }}
                    </button>
                    <button type="submit" name="generate_now" value="1" class="create-btn create-btn-success">
                        <i class="bi bi-play-fill"></i>
                        {{ __('Save & Generate') }}
                    </button>
                </div>
            </div>

            {{-- Sidebar --}}
            <div class="create-form-sidebar">
                {{-- Report Types Info --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon info">
                            <i class="bi bi-info-circle"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Report Types') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-tips-list">
                            <div class="tip-item">
                                <i class="bi bi-fuel-pump text-warning"></i>
                                <div>
                                    <strong>{{ __('Fuel Consumption') }}</strong>
                                    <small>{{ __('Analyze fuel usage and costs') }}</small>
                                </div>
                            </div>
                            <div class="tip-item">
                                <i class="bi bi-geo-alt text-primary"></i>
                                <div>
                                    <strong>{{ __('Trip Summary') }}</strong>
                                    <small>{{ __('Overview of all trips') }}</small>
                                </div>
                            </div>
                            <div class="tip-item">
                                <i class="bi bi-truck text-info"></i>
                                <div>
                                    <strong>{{ __('Vehicle Utilization') }}</strong>
                                    <small>{{ __('Track vehicle efficiency') }}</small>
                                </div>
                            </div>
                            <div class="tip-item">
                                <i class="bi bi-person-badge text-success"></i>
                                <div>
                                    <strong>{{ __('Driver Performance') }}</strong>
                                    <small>{{ __('Evaluate driver metrics') }}</small>
                                </div>
                            </div>
                            <div class="tip-item">
                                <i class="bi bi-currency-dollar text-danger"></i>
                                <div>
                                    <strong>{{ __('Cost Analysis') }}</strong>
                                    <small>{{ __('Breakdown of expenses') }}</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Quick Tips --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon warning">
                            <i class="bi bi-lightbulb"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Quick Tips') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                {{ __('Use date filters for specific periods') }}
                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                {{ __('Schedule recurring reports for automation') }}
                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                {{ __('PDF is best for printing') }}
                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                {{ __('Excel allows further analysis') }}
                            </li>
                        </ul>
                    </div>
                </div>

                {{-- Quick Actions --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon primary">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Quick Actions') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="{{ route('admin.reports.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                {{ __('View All Reports') }}
                            </a>
                            <a href="{{ route('admin.trips.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-geo-alt"></i>
                                {{ __('Manage Trips') }}
                            </a>
                            <a href="{{ route('admin.fuel-logs.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-fuel-pump"></i>
                                {{ __('Fuel Logs') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

@push('styles')
<style>
.create-radio-cards.small .create-radio-card-label {
    padding: 0.75rem 1rem;
    font-size: 0.875rem;
}

.create-radio-cards.small .create-radio-card-label i {
    font-size: 1.25rem;
}

.tip-item {
    display: flex;
    align-items: flex-start;
    gap: 0.75rem;
    padding: 0.75rem 0;
    border-bottom: 1px solid var(--border-color);
}

.tip-item:last-child {
    border-bottom: none;
    padding-bottom: 0;
}

.tip-item i {
    font-size: 1.25rem;
    flex-shrink: 0;
    margin-top: 0.125rem;
}

.tip-item div {
    display: flex;
    flex-direction: column;
    gap: 0.125rem;
}

.tip-item strong {
    font-size: 0.875rem;
    font-weight: 600;
    color: var(--text-primary);
}

.tip-item small {
    font-size: 0.75rem;
    color: var(--text-secondary);
}

.create-btn-success {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: #ffffff;
    border: none;
}

.create-btn-success:hover {
    background: linear-gradient(135deg, #059669 0%, #047857 100%);
    color: #ffffff;
    transform: translateY(-1px);
}
</style>
@endpush
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const isScheduled = document.getElementById('is_scheduled');
    const frequencyGroup = document.getElementById('frequency_group');
    const frequencySelect = document.getElementById('schedule_frequency');

    isScheduled.addEventListener('change', function() {
        if (this.checked) {
            frequencyGroup.style.display = 'block';
            frequencySelect.required = true;
        } else {
            frequencyGroup.style.display = 'none';
            frequencySelect.required = false;
            frequencySelect.value = '';
        }
    });
});
</script>
@endpush
