@extends('layouts.app')

@section('title', __('Fuel Report'))
@section('page-title', __('Fuel Report'))
@section('page-subtitle', __('Analyze fuel consumption across your fleet'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/adminlistpage.css') }}">
<style>
    .report-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 1.5rem;
    }
    .export-dropdown .dropdown-menu {
        min-width: 150px;
    }
    .summary-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
        margin-bottom: 1.5rem;
    }
    .summary-card {
        background: linear-gradient(135deg, #fff7ed 0%, #ffedd5 100%);
        border-radius: 12px;
        padding: 1.25rem;
        border: 1px solid #fed7aa;
    }
    .summary-card.primary {
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
        border-color: #fcd34d;
    }
    .summary-card-value {
        font-size: 1.75rem;
        font-weight: 700;
        color: #ea580c;
    }
    .summary-card-label {
        font-size: 0.75rem;
        color: #9a3412;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    .filter-section {
        background: white;
        border-radius: 12px;
        padding: 1.25rem;
        margin-bottom: 1.5rem;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .chart-section {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
        gap: 1.5rem;
        margin-bottom: 1.5rem;
    }
    .chart-card {
        background: white;
        border-radius: 12px;
        padding: 1.25rem;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .chart-card-title {
        font-weight: 600;
        color: #374151;
        margin-bottom: 1rem;
        padding-bottom: 0.5rem;
        border-bottom: 1px solid #e5e7eb;
    }
    .data-table-card {
        background: white;
        border-radius: 12px;
        padding: 1.25rem;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .mini-table {
        width: 100%;
    }
    .mini-table th {
        font-size: 0.7rem;
        text-transform: uppercase;
        color: #6b7280;
        font-weight: 600;
        padding: 0.5rem;
        border-bottom: 2px solid #e5e7eb;
    }
    .mini-table td {
        padding: 0.5rem;
        font-size: 0.85rem;
        border-bottom: 1px solid #f3f4f6;
    }
    .fuel-badge {
        padding: 0.25rem 0.5rem;
        border-radius: 4px;
        font-size: 0.7rem;
        font-weight: 600;
    }
    .fuel-badge.diesel { background: #fef3c7; color: #92400e; }
    .fuel-badge.petrol { background: #dbeafe; color: #1e40af; }
    .fuel-badge.cng { background: #d1fae5; color: #065f46; }
    .fuel-badge.electric { background: #ede9fe; color: #5b21b6; }
</style>
@endpush

@section('content')
<div class="container-fluid">
    {{-- Report Header --}}
    <div class="report-header">
        <div>
            <h4 class="mb-1"><i class="bi bi-fuel-pump text-warning me-2"></i>{{ __('Fuel Consumption Report') }}</h4>
            <p class="text-muted mb-0">{{ __('Detailed analysis of fuel usage and costs') }}</p>
        </div>
        <div class="d-flex gap-2">
            <div class="dropdown export-dropdown">
                <button class="btn btn-success dropdown-toggle" type="button" data-bs-toggle="dropdown">
                    <i class="bi bi-download me-1"></i> {{ __('Export') }}
                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                        <a class="dropdown-item" href="{{ route('admin.reports.fuel.export', array_merge(request()->query(), ['format' => 'pdf'])) }}">
                            <i class="bi bi-file-pdf text-danger me-2"></i> {{ __('Export as PDF') }}
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item" href="{{ route('admin.reports.fuel.export', array_merge(request()->query(), ['format' => 'csv'])) }}">
                            <i class="bi bi-filetype-csv text-success me-2"></i> {{ __('Export as CSV') }}
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item" href="{{ route('admin.reports.fuel.export', array_merge(request()->query(), ['format' => 'html'])) }}">
                            <i class="bi bi-filetype-html text-primary me-2"></i> {{ __('Export as HTML') }}
                        </a>
                    </li>
                </ul>
            </div>
            <a href="{{ route('admin.fuel-logs.index') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-1"></i> {{ __('Back to Fuel Logs') }}
            </a>
        </div>
    </div>

    {{-- Summary Cards --}}
    <div class="summary-cards">
        <div class="summary-card primary">
            <div class="summary-card-value">{{ number_format($summary['total_quantity'], 2) }} L</div>
            <div class="summary-card-label">{{ __('Total Quantity') }}</div>
        </div>
        <div class="summary-card">
            <div class="summary-card-value">${{ number_format($summary['total_cost'], 2) }}</div>
            <div class="summary-card-label">{{ __('Total Cost') }}</div>
        </div>
        <div class="summary-card">
            <div class="summary-card-value">${{ number_format($summary['avg_price'], 2) }}</div>
            <div class="summary-card-label">{{ __('Avg Price/Unit') }}</div>
        </div>
        <div class="summary-card">
            <div class="summary-card-value">{{ $summary['total_records'] }}</div>
            <div class="summary-card-label">{{ __('Total Records') }}</div>
        </div>
    </div>

    {{-- Filters --}}
    <div class="filter-section">
        <form action="{{ route('admin.reports.fuel.index') }}" method="GET">
            <div class="row g-3">
                <div class="col-md-2">
                    <label class="form-label">{{ __('Date From') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Date To') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Vehicle') }}</label>
                    <select name="vehicle_id" class="form-select">
                        <option value="">{{ __('All Vehicles') }}</option>
                        @foreach($vehicles as $vehicle)
                            <option value="{{ $vehicle->id }}" {{ request('vehicle_id') == $vehicle->id ? 'selected' : '' }}>
                                {{ $vehicle->vehicle_number }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Driver') }}</label>
                    <select name="driver_id" class="form-select">
                        <option value="">{{ __('All Drivers') }}</option>
                        @foreach($drivers as $driver)
                            <option value="{{ $driver->id }}" {{ request('driver_id') == $driver->id ? 'selected' : '' }}>
                                {{ $driver->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Fuel Type') }}</label>
                    <select name="fuel_type" class="form-select">
                        <option value="">{{ __('All Types') }}</option>
                        <option value="diesel" {{ request('fuel_type') == 'diesel' ? 'selected' : '' }}>{{ __('Diesel') }}</option>
                        <option value="petrol" {{ request('fuel_type') == 'petrol' ? 'selected' : '' }}>{{ __('Petrol') }}</option>
                        <option value="cng" {{ request('fuel_type') == 'cng' ? 'selected' : '' }}>{{ __('CNG') }}</option>
                        <option value="electric" {{ request('fuel_type') == 'electric' ? 'selected' : '' }}>{{ __('Electric') }}</option>
                    </select>
                </div>
                <div class="col-md-2 d-flex align-items-end gap-2">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-funnel me-1"></i> {{ __('Filter') }}
                    </button>
                    <a href="{{ route('admin.reports.fuel.index') }}" class="btn btn-outline-secondary">
                        <i class="bi bi-x-lg"></i>
                    </a>
                </div>
            </div>
        </form>
    </div>

    {{-- Charts Section --}}
    <div class="chart-section">
        {{-- By Vehicle --}}
        <div class="chart-card">
            <h6 class="chart-card-title"><i class="bi bi-truck me-2"></i>{{ __('By Vehicle') }}</h6>
            @if($byVehicle->count() > 0)
                <table class="mini-table">
                    <thead>
                        <tr>
                            <th>{{ __('Vehicle') }}</th>
                            <th class="text-end">{{ __('Quantity') }}</th>
                            <th class="text-end">{{ __('Cost') }}</th>
                            <th class="text-end">{{ __('Fills') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($byVehicle as $item)
                        <tr>
                            <td>{{ $item->vehicle->vehicle_number ?? '-' }}</td>
                            <td class="text-end">{{ number_format($item->total_quantity, 2) }} L</td>
                            <td class="text-end">${{ number_format($item->total_cost, 2) }}</td>
                            <td class="text-end">{{ $item->fill_count }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <p class="text-muted text-center py-3">{{ __('No data available') }}</p>
            @endif
        </div>

        {{-- By Fuel Type --}}
        <div class="chart-card">
            <h6 class="chart-card-title"><i class="bi bi-fuel-pump me-2"></i>{{ __('By Fuel Type') }}</h6>
            @if($byFuelType->count() > 0)
                <table class="mini-table">
                    <thead>
                        <tr>
                            <th>{{ __('Fuel Type') }}</th>
                            <th class="text-end">{{ __('Quantity') }}</th>
                            <th class="text-end">{{ __('Cost') }}</th>
                            <th class="text-end">{{ __('Fills') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($byFuelType as $item)
                        <tr>
                            <td><span class="fuel-badge {{ $item->fuel_type }}">{{ ucfirst($item->fuel_type) }}</span></td>
                            <td class="text-end">{{ number_format($item->total_quantity, 2) }} L</td>
                            <td class="text-end">${{ number_format($item->total_cost, 2) }}</td>
                            <td class="text-end">{{ $item->fill_count }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <p class="text-muted text-center py-3">{{ __('No data available') }}</p>
            @endif
        </div>
    </div>

    {{-- Data Table --}}
    <div class="data-table-card">
        <h6 class="chart-card-title"><i class="bi bi-table me-2"></i>{{ __('Fuel Log Details') }}</h6>
        
        @if($fuelLogs->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead>
                        <tr>
                            <th>{{ __('Date') }}</th>
                            <th>{{ __('Vehicle') }}</th>
                            <th>{{ __('Driver') }}</th>
                            <th>{{ __('Fuel Type') }}</th>
                            <th class="text-end">{{ __('Quantity') }}</th>
                            <th class="text-end">{{ __('Price/Unit') }}</th>
                            <th class="text-end">{{ __('Total Cost') }}</th>
                            <th>{{ __('Odometer') }}</th>
                            <th>{{ __('Station') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($fuelLogs as $log)
                        <tr>
                            <td>{{ $log->fill_date }}</td>
                            <td>{{ $log->vehicle->vehicle_number ?? '-' }}</td>
                            <td>{{ $log->driver->name ?? '-' }}</td>
                            <td><span class="fuel-badge {{ $log->fuel_type }}">{{ ucfirst($log->fuel_type) }}</span></td>
                            <td class="text-end">{{ number_format($log->quantity, 2) }} L</td>
                            <td class="text-end">${{ number_format($log->price_per_unit, 2) }}</td>
                            <td class="text-end"><strong>${{ number_format($log->total_cost, 2) }}</strong></td>
                            <td>{{ $log->odometer_reading ?? '-' }}</td>
                            <td>{{ $log->fuel_station ?? '-' }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                {{ $fuelLogs->links() }}
            </div>
        @else
            <div class="text-center py-5">
                <i class="bi bi-fuel-pump display-4 text-muted"></i>
                <p class="text-muted mt-2">{{ __('No fuel logs found for the selected filters') }}</p>
            </div>
        @endif
    </div>
</div>
@endsection