@extends('layouts.app')

@section('title', __('Reports') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/adminlistpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header --}}
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-file-earmark-bar-graph"></i>
                {{ __('Reports') }}
            </h1>
            <p class="list-page-subtitle">{{ __('Generate and manage fleet analytics reports') }}</p>
        </div>
        <div class="list-page-header-actions">
            @if(auth()->user()->hasPermission('reports.create'))
            <a href="{{ route('admin.reports.create') }}" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                {{ __('New Report') }}
            </a>
            @endif
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- Stats Bar --}}
    <div class="list-stats-bar">
        <div class="list-stat-card gradient-violet">
            <div class="list-stat-icon">
                <i class="bi bi-file-earmark-bar-graph"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $stats['total'] }}</div>
                <div class="list-stat-label">{{ __('Total Reports') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-graph-up-arrow"></i>
                {{ __('All time') }}
            </div>
        </div>
        <div class="list-stat-card gradient-cyan">
            <div class="list-stat-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $stats['completed'] }}</div>
                <div class="list-stat-label">{{ __('Completed') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-check2-all"></i>
                {{ __('Generated') }}
            </div>
        </div>
        <div class="list-stat-card gradient-rose">
            <div class="list-stat-icon">
                <i class="bi bi-hourglass-split"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $stats['pending'] }}</div>
                <div class="list-stat-label">{{ __('Pending') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-clock"></i>
                {{ __('Awaiting') }}
            </div>
        </div>
        <div class="list-stat-card gradient-amber">
            <div class="list-stat-icon">
                <i class="bi bi-calendar-check"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $stats['scheduled'] }}</div>
                <div class="list-stat-label">{{ __('Scheduled') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-arrow-repeat"></i>
                {{ __('Recurring') }}
            </div>
        </div>
    </div>

    {{-- Quick Report Types --}}
    <div class="list-card mb-4">
        <div class="list-card-header">
            <h5 class="list-card-title">
                <i class="bi bi-lightning me-2"></i>
                {{ __('Quick Reports') }}
            </h5>
        </div>
        <div class="list-card-body">
            <div class="row g-3">
                <div class="col-md-4 col-lg-2">
                    <a href="{{ route('admin.reports.create', ['type' => 'fuel_consumption']) }}" class="quick-report-card">
                        <div class="quick-report-icon bg-warning bg-opacity-10 text-warning">
                            <i class="bi bi-fuel-pump"></i>
                        </div>
                        <span class="quick-report-label">{{ __('Fuel Consumption') }}</span>
                    </a>
                </div>
                <div class="col-md-4 col-lg-2">
                    <a href="{{ route('admin.reports.create', ['type' => 'trip_summary']) }}" class="quick-report-card">
                        <div class="quick-report-icon bg-primary bg-opacity-10 text-primary">
                            <i class="bi bi-geo-alt"></i>
                        </div>
                        <span class="quick-report-label">{{ __('Trip Summary') }}</span>
                    </a>
                </div>
                <div class="col-md-4 col-lg-2">
                    <a href="{{ route('admin.reports.create', ['type' => 'vehicle_utilization']) }}" class="quick-report-card">
                        <div class="quick-report-icon bg-info bg-opacity-10 text-info">
                            <i class="bi bi-truck"></i>
                        </div>
                        <span class="quick-report-label">{{ __('Vehicle Utilization') }}</span>
                    </a>
                </div>
                <div class="col-md-4 col-lg-2">
                    <a href="{{ route('admin.reports.create', ['type' => 'driver_performance']) }}" class="quick-report-card">
                        <div class="quick-report-icon bg-success bg-opacity-10 text-success">
                            <i class="bi bi-person-badge"></i>
                        </div>
                        <span class="quick-report-label">{{ __('Driver Performance') }}</span>
                    </a>
                </div>
                <div class="col-md-4 col-lg-2">
                    <a href="{{ route('admin.reports.create', ['type' => 'cost_analysis']) }}" class="quick-report-card">
                        <div class="quick-report-icon bg-danger bg-opacity-10 text-danger">
                            <i class="bi bi-currency-dollar"></i>
                        </div>
                        <span class="quick-report-label">{{ __('Cost Analysis') }}</span>
                    </a>
                </div>
                <div class="col-md-4 col-lg-2">
                    <a href="{{ route('admin.reports.create', ['type' => 'delivery_performance']) }}" class="quick-report-card">
                        <div class="quick-report-icon bg-secondary bg-opacity-10 text-secondary">
                            <i class="bi bi-box-seam"></i>
                        </div>
                        <span class="quick-report-label">{{ __('Delivery Performance') }}</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    {{-- Filter Bar --}}
    <div class="list-filter-bar">
        <div class="list-filter-header">
            <div class="list-filter-title">
                <i class="bi bi-funnel"></i>
                {{ __('Filters') }}
            </div>
            @if(request()->hasAny(['search', 'report_type', 'status', 'format', 'date_from', 'date_to']))
                <a href="{{ route('admin.reports.index') }}" class="list-filter-clear">
                    <i class="bi bi-x-circle"></i>
                    {{ __('Clear Filters') }}
                </a>
            @endif
        </div>
        <form action="{{ route('admin.reports.index') }}" method="GET">
            <div class="list-filter-row">
                <div class="list-filter-group search-group">
                    <label>{{ __('Search') }}</label>
                    <div class="list-search-box">
                        <i class="bi bi-search"></i>
                        <input type="text" name="search" class="form-control" 
                               placeholder="{{ __('Search by report number or title...') }}"
                               value="{{ request('search') }}">
                    </div>
                </div>
                <div class="list-filter-group">
                    <label>{{ __('Report Type') }}</label>
                    <select name="report_type" class="form-select">
                        <option value="">{{ __('All Types') }}</option>
                        <option value="fuel_consumption" {{ request('report_type') === 'fuel_consumption' ? 'selected' : '' }}>{{ __('Fuel Consumption') }}</option>
                        <option value="trip_summary" {{ request('report_type') === 'trip_summary' ? 'selected' : '' }}>{{ __('Trip Summary') }}</option>
                        <option value="vehicle_utilization" {{ request('report_type') === 'vehicle_utilization' ? 'selected' : '' }}>{{ __('Vehicle Utilization') }}</option>
                        <option value="driver_performance" {{ request('report_type') === 'driver_performance' ? 'selected' : '' }}>{{ __('Driver Performance') }}</option>
                        <option value="cost_analysis" {{ request('report_type') === 'cost_analysis' ? 'selected' : '' }}>{{ __('Cost Analysis') }}</option>
                        <option value="delivery_performance" {{ request('report_type') === 'delivery_performance' ? 'selected' : '' }}>{{ __('Delivery Performance') }}</option>
                    </select>
                </div>
                <div class="list-filter-group">
                    <label>{{ __('Status') }}</label>
                    <select name="status" class="form-select">
                        <option value="">{{ __('All Statuses') }}</option>
                        <option value="draft" {{ request('status') === 'draft' ? 'selected' : '' }}>{{ __('Draft') }}</option>
                        <option value="generating" {{ request('status') === 'generating' ? 'selected' : '' }}>{{ __('Generating') }}</option>
                        <option value="completed" {{ request('status') === 'completed' ? 'selected' : '' }}>{{ __('Completed') }}</option>
                        <option value="failed" {{ request('status') === 'failed' ? 'selected' : '' }}>{{ __('Failed') }}</option>
                        <option value="scheduled" {{ request('status') === 'scheduled' ? 'selected' : '' }}>{{ __('Scheduled') }}</option>
                    </select>
                </div>
                <div class="list-filter-group">
                    <label>{{ __('Format') }}</label>
                    <select name="format" class="form-select">
                        <option value="">{{ __('All Formats') }}</option>
                        <option value="pdf" {{ request('format') === 'pdf' ? 'selected' : '' }}>{{ __('PDF') }}</option>
                        <option value="excel" {{ request('format') === 'excel' ? 'selected' : '' }}>{{ __('Excel') }}</option>
                        <option value="csv" {{ request('format') === 'csv' ? 'selected' : '' }}>{{ __('CSV') }}</option>
                    </select>
                </div>
                <div class="list-filter-buttons">
                    <button type="submit" class="btn-filter btn-filter-primary">
                        <i class="bi bi-search"></i>
                        {{ __('Apply') }}
                    </button>
                </div>
            </div>
        </form>
    </div>

    {{-- Data Table --}}
    <div class="list-card">
        @if($reports->count() > 0)
            <div class="list-table-responsive">
                <table class="list-table">
                    <thead>
                        <tr>
                            <th>{{ __('Report #') }}</th>
                            <th>{{ __('Title') }}</th>
                            <th>{{ __('Type') }}</th>
                            <th>{{ __('Date Range') }}</th>
                            <th>{{ __('Format') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th>{{ __('Generated') }}</th>
                            <th class="text-center">{{ __('Actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($reports as $report)
                            @php
                                $statusClasses = [
                                    'draft' => 'secondary',
                                    'generating' => 'info',
                                    'completed' => 'success',
                                    'failed' => 'danger',
                                    'scheduled' => 'warning',
                                ];
                                $typeClasses = [
                                    'fuel_consumption' => 'warning',
                                    'trip_summary' => 'primary',
                                    'vehicle_utilization' => 'info',
                                    'driver_performance' => 'success',
                                    'cost_analysis' => 'danger',
                                    'delivery_performance' => 'secondary',
                                    'custom' => 'dark',
                                ];
                                $typeIcons = [
                                    'fuel_consumption' => 'fuel-pump',
                                    'trip_summary' => 'geo-alt',
                                    'vehicle_utilization' => 'truck',
                                    'driver_performance' => 'person-badge',
                                    'cost_analysis' => 'currency-dollar',
                                    'delivery_performance' => 'box-seam',
                                    'custom' => 'file-earmark',
                                ];
                            @endphp
                            <tr>
                                <td>
                                    <div class="table-primary-text">
                                        <a href="{{ route('admin.reports.show', $report) }}">
                                            {{ $report->report_number }}
                                        </a>
                                    </div>
                                    @if($report->is_scheduled)
                                        <span class="badge bg-warning badge-sm">
                                            <i class="bi bi-arrow-repeat"></i> {{ __('Scheduled') }}
                                        </span>
                                    @endif
                                </td>
                                <td>
                                    <div class="table-primary-text">{{ Str::limit($report->title, 40) }}</div>
                                    <div class="table-secondary-text">{{ $report->creator->name ?? '-' }}</div>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $typeClasses[$report->report_type] ?? 'secondary' }}">
                                        <i class="bi bi-{{ $typeIcons[$report->report_type] ?? 'file-earmark' }} me-1"></i>
                                        {{ __(ucwords(str_replace('_', ' ', $report->report_type))) }}
                                    </span>
                                </td>
                                <td>
                                    <div class="table-primary-text">{{ $report->date_range }}</div>
                                </td>
                                <td>
                                    <span class="badge bg-light text-dark">
                                        <i class="bi bi-file-earmark me-1"></i>
                                        {{ strtoupper($report->format) }}
                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $statusClasses[$report->status] ?? 'secondary' }}">
                                        {{ __(ucfirst($report->status)) }}
                                    </span>
                                </td>
                                <td>
                                    @if($report->generated_at)
                                        <div class="table-primary-text">{{ $report->generated_at->format('M d, Y') }}</div>
                                        <div class="table-secondary-text">{{ $report->generated_at->format('h:i A') }}</div>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="table-actions">
                                        @if(auth()->user()->hasPermission('reports.view'))
                                            <a href="{{ route('admin.reports.show', $report) }}" 
                                               class="btn-table-action btn-table-view" 
                                               title="{{ __('View') }}">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                        @endif
                                        @if($report->isDownloadable() && auth()->user()->hasPermission('reports.export'))
                                            <a href="{{ route('admin.reports.download', $report) }}" 
                                               class="btn-table-action btn-table-edit" 
                                               title="{{ __('Download') }}">
                                                <i class="bi bi-download"></i>
                                            </a>
                                        @endif
                                        @if(in_array($report->status, ['draft', 'failed']) && auth()->user()->hasPermission('reports.edit'))
                                            <a href="{{ route('admin.reports.edit', $report) }}" 
                                               class="btn-table-action btn-table-edit" 
                                               title="{{ __('Edit') }}">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                        @endif
                                        @if(auth()->user()->hasPermission('reports.delete'))
                                            <form action="{{ route('admin.reports.destroy', $report) }}" method="POST" class="d-inline"
                                                  onsubmit="return confirm('{{ __('Are you sure you want to delete this report?') }}')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" 
                                                        class="btn-table-action btn-table-delete" 
                                                        title="{{ __('Delete') }}">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Pagination --}}
            @if($reports->hasPages())
            <div class="list-pagination">
                <div class="list-pagination-info">
                    {{ __('Showing') }} {{ $reports->firstItem() }} {{ __('to') }} {{ $reports->lastItem() }} {{ __('of') }} {{ $reports->total() }} {{ __('results') }}
                </div>
                <nav class="list-pagination-nav">
                    {{ $reports->links() }}
                </nav>
            </div>
            @endif
        @else
            {{-- Empty State --}}
            <div class="list-empty-state">
                <div class="list-empty-state-icon">
                    <i class="bi bi-file-earmark-bar-graph"></i>
                </div>
                <h4 class="list-empty-state-title">{{ __('No Reports Found') }}</h4>
                <p class="list-empty-state-text">
                    {{ __('There are no reports matching your criteria. Create a new report to get started.') }}
                </p>
                @if(auth()->user()->hasPermission('reports.create'))
                <a href="{{ route('admin.reports.create') }}" class="btn-create">
                    <i class="bi bi-plus-lg"></i>
                    {{ __('Create First Report') }}
                </a>
                @endif
            </div>
        @endif
    </div>
</div>

@push('styles')
<style>
.list-card-header {
    padding: 1rem 1.5rem;
    border-bottom: 1px solid var(--border-color);
}

.list-card-title {
    margin: 0;
    font-size: 1rem;
    font-weight: 600;
    color: var(--text-primary);
}

.list-card-body {
    padding: 1.5rem;
}

.quick-report-card {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.75rem;
    padding: 1.25rem 1rem;
    background: var(--card-bg);
    border: 1px solid var(--border-color);
    border-radius: 12px;
    text-decoration: none;
    transition: all 0.2s ease;
}

.quick-report-card:hover {
    border-color: var(--primary-color);
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.quick-report-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.quick-report-icon i {
    font-size: 1.5rem;
}

.quick-report-label {
    font-size: 0.8125rem;
    font-weight: 500;
    color: var(--text-primary);
    text-align: center;
}
</style>
@endpush
@endsection
