@extends('layouts.app')

@section('title', $report->report_number . ' - ' . __('Report Details'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admindetailpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header with Breadcrumb --}}
    <div class="page-header">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('admin.reports.index') }}">{{ __('Reports') }}</a></li>
                    <li class="breadcrumb-item active">{{ $report->report_number }}</li>
                </ol>
            </nav>
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <div class="detail-alert detail-alert-info">
            <div class="detail-alert-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title">{{ __('Success') }}</div>
                <div class="detail-alert-text">{{ session('success') }}</div>
            </div>
        </div>
    @endif

    @if(session('error'))
        <div class="detail-alert detail-alert-warning">
            <div class="detail-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title">{{ __('Error') }}</div>
                <div class="detail-alert-text">{{ session('error') }}</div>
            </div>
        </div>
    @endif

    @if(session('info'))
        <div class="detail-alert detail-alert-info">
            <div class="detail-alert-icon">
                <i class="bi bi-info-circle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title">{{ __('Info') }}</div>
                <div class="detail-alert-text">{{ session('info') }}</div>
            </div>
        </div>
    @endif

    @php
        $statusClasses = [
            'draft' => 'pending',
            'generating' => 'assigned',
            'completed' => 'delivered',
            'failed' => 'cancelled',
            'scheduled' => 'in-transit',
        ];
        $typeClasses = [
            'fuel_consumption' => 'warning',
            'trip_summary' => 'primary',
            'vehicle_utilization' => 'info',
            'driver_performance' => 'success',
            'cost_analysis' => 'danger',
            'delivery_performance' => 'secondary',
            'custom' => 'dark',
        ];
        $typeIcons = [
            'fuel_consumption' => 'fuel-pump',
            'trip_summary' => 'geo-alt',
            'vehicle_utilization' => 'truck',
            'driver_performance' => 'person-badge',
            'cost_analysis' => 'currency-dollar',
            'delivery_performance' => 'box-seam',
            'custom' => 'file-earmark',
        ];
    @endphp

    {{-- Hero Section --}}
    <div class="detail-hero">
        <div class="detail-hero-header">
            <div class="detail-hero-content">
                <div class="detail-hero-icon">
                    <i class="bi bi-file-earmark-bar-graph"></i>
                </div>
                <div class="detail-hero-info">
                    <h1 class="detail-hero-title">{{ $report->report_number }}</h1>
                    <p class="detail-hero-subtitle">{{ $report->title }} · {{ __('Created') }} {{ $report->created_at->format('M d, Y') }}</p>
                    <div class="detail-hero-badges">
                        <span class="status-badge status-badge-{{ $statusClasses[$report->status] ?? 'pending' }}">
                            <i class="bi bi-{{ $report->status === 'completed' ? 'check-circle' : ($report->status === 'failed' ? 'x-circle' : 'clock') }}"></i>
                            {{ __(ucfirst($report->status)) }}
                        </span>
                        <span class="status-badge status-badge-{{ $typeClasses[$report->report_type] ?? 'secondary' }}">
                            <i class="bi bi-{{ $typeIcons[$report->report_type] ?? 'file-earmark' }}"></i>
                            {{ __(ucwords(str_replace('_', ' ', $report->report_type))) }}
                        </span>
                        @if($report->is_scheduled)
                        <span class="status-badge status-badge-in-transit">
                            <i class="bi bi-arrow-repeat"></i>
                            {{ __(ucfirst($report->schedule_frequency)) }}
                        </span>
                        @endif
                    </div>
                </div>
            </div>
            <div class="detail-actions">
                @if($report->status === 'completed' && auth()->user()->hasPermission('reports.export'))
                <a href="{{ route('admin.reports.download', $report) }}" class="btn-detail btn-detail-success">
                    <i class="bi bi-download"></i>
                    {{ __('Download') }}
                </a>
                @endif
                @if(in_array($report->status, ['draft', 'completed', 'failed']) && auth()->user()->hasPermission('reports.edit'))
                <form action="{{ route('admin.reports.generate', $report) }}" method="POST" class="d-inline">
                    @csrf
                    <button type="submit" class="btn-detail btn-detail-primary">
                        <i class="bi bi-play-fill"></i>
                        {{ $report->status === 'completed' ? __('Regenerate') : __('Generate') }}
                    </button>
                </form>
                @endif
                @if(in_array($report->status, ['draft', 'failed']) && auth()->user()->hasPermission('reports.edit'))
                <a href="{{ route('admin.reports.edit', $report) }}" class="btn-detail btn-detail-warning">
                    <i class="bi bi-pencil"></i>
                    {{ __('Edit') }}
                </a>
                @endif
                <a href="{{ route('admin.reports.index') }}" class="btn-detail btn-detail-outline">
                    <i class="bi bi-arrow-left"></i>
                    {{ __('Back to List') }}
                </a>
            </div>
        </div>
        <div class="detail-hero-body">
            <div class="hero-stat">
                <div class="hero-stat-value">{{ strtoupper($report->format) }}</div>
                <div class="hero-stat-label">{{ __('Format') }}</div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value">{{ $report->date_range }}</div>
                <div class="hero-stat-label">{{ __('Date Range') }}</div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value">{{ $report->generated_at ? $report->generated_at->format('M d') : '-' }}</div>
                <div class="hero-stat-label">{{ __('Generated') }}</div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value">{{ $report->formatted_file_size }}</div>
                <div class="hero-stat-label">{{ __('File Size') }}</div>
            </div>
        </div>
    </div>

    {{-- Failed Report Alert --}}
    @if($report->status === 'failed' && $report->error_message)
    <div class="detail-alert detail-alert-warning mb-4">
        <div class="detail-alert-icon">
            <i class="bi bi-exclamation-triangle"></i>
        </div>
        <div class="detail-alert-content">
            <div class="detail-alert-title">{{ __('Report Generation Failed') }}</div>
            <div class="detail-alert-text">{{ $report->error_message }}</div>
        </div>
    </div>
    @endif

    <div class="row">
        {{-- Main Content --}}
        <div class="col-lg-8">
            {{-- Report Configuration Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon primary">
                        <i class="bi bi-gear"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Report Configuration') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Report Number') }}</span>
                            <span class="info-item-value highlight">{{ $report->report_number }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Title') }}</span>
                            <span class="info-item-value">{{ $report->title }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Report Type') }}</span>
                            <span class="info-item-value">
                                <span class="badge bg-{{ $typeClasses[$report->report_type] ?? 'secondary' }}">
                                    <i class="bi bi-{{ $typeIcons[$report->report_type] ?? 'file-earmark' }} me-1"></i>
                                    {{ __(ucwords(str_replace('_', ' ', $report->report_type))) }}
                                </span>
                            </span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Output Format') }}</span>
                            <span class="info-item-value">{{ strtoupper($report->format) }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Date From') }}</span>
                            <span class="info-item-value">{{ $report->date_from ? $report->date_from->format('M d, Y') : __('All Time') }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Date To') }}</span>
                            <span class="info-item-value">{{ $report->date_to ? $report->date_to->format('M d, Y') : __('Present') }}</span>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Filters Applied Card --}}
            @if($report->vehicle || $report->driver || $report->vehicleType)
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon info">
                        <i class="bi bi-funnel"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Filters Applied') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        @if($report->vehicle)
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Vehicle') }}</span>
                            <span class="info-item-value">{{ $report->vehicle->vehicle_number }}</span>
                        </div>
                        @endif
                        @if($report->driver)
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Driver') }}</span>
                            <span class="info-item-value">{{ $report->driver->name }}</span>
                        </div>
                        @endif
                        @if($report->vehicleType)
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Vehicle Type') }}</span>
                            <span class="info-item-value">{{ $report->vehicleType->name }}</span>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
            @endif

            {{-- Report Data Card (if completed) --}}
            @if($report->status === 'completed' && $reportData)
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon success">
                        <i class="bi bi-bar-chart"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Report Summary') }}</h5>
                </div>
                <div class="detail-card-body">
                    @if(isset($reportData['summary']))
                    <div class="row g-3 mb-4">
                        @foreach($reportData['summary'] as $key => $value)
                        <div class="col-md-4 col-lg-3">
                            <div class="summary-stat-card">
                                <div class="summary-stat-value">
                                    @if(is_numeric($value))
                                        @if(str_contains($key, 'cost') || str_contains($key, 'total'))
                                            ${{ number_format($value, 2) }}
                                        @elseif(str_contains($key, 'rate') || str_contains($key, 'efficiency'))
                                            {{ number_format($value, 1) }}%
                                        @else
                                            {{ number_format($value, is_float($value) ? 2 : 0) }}
                                        @endif
                                    @else
                                        {{ $value }}
                                    @endif
                                </div>
                                <div class="summary-stat-label">{{ __(ucwords(str_replace('_', ' ', $key))) }}</div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @endif

                    {{-- Data Tables --}}
                    @if(isset($reportData['by_vehicle']) && count($reportData['by_vehicle']) > 0)
                    <h6 class="mb-3"><i class="bi bi-truck me-2"></i>{{ __('By Vehicle') }}</h6>
                    <div class="table-responsive mb-4">
                        <table class="table table-sm table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>{{ __('Vehicle') }}</th>
                                    @if(isset($reportData['by_vehicle'][0]['total_quantity']))
                                    <th class="text-end">{{ __('Quantity') }}</th>
                                    @endif
                                    @if(isset($reportData['by_vehicle'][0]['total_cost']))
                                    <th class="text-end">{{ __('Cost') }}</th>
                                    @endif
                                    @if(isset($reportData['by_vehicle'][0]['trip_count']))
                                    <th class="text-end">{{ __('Trips') }}</th>
                                    @endif
                                    @if(isset($reportData['by_vehicle'][0]['avg_efficiency']))
                                    <th class="text-end">{{ __('Avg km/L') }}</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($reportData['by_vehicle'] as $item)
                                <tr>
                                    <td>{{ $item['vehicle'] ?? '-' }}</td>
                                    @if(isset($item['total_quantity']))
                                    <td class="text-end">{{ number_format($item['total_quantity'], 2) }} L</td>
                                    @endif
                                    @if(isset($item['total_cost']))
                                    <td class="text-end text-success">${{ number_format($item['total_cost'], 2) }}</td>
                                    @endif
                                    @if(isset($item['trip_count']))
                                    <td class="text-end">{{ $item['trip_count'] }}</td>
                                    @endif
                                    @if(isset($item['avg_efficiency']))
                                    <td class="text-end">{{ $item['avg_efficiency'] ? number_format($item['avg_efficiency'], 2) : '-' }}</td>
                                    @endif
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @endif

                    @if(isset($reportData['by_status']) && count($reportData['by_status']) > 0)
                    <h6 class="mb-3"><i class="bi bi-pie-chart me-2"></i>{{ __('By Status') }}</h6>
                    <div class="table-responsive mb-4">
                        <table class="table table-sm table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>{{ __('Status') }}</th>
                                    <th class="text-end">{{ __('Count') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($reportData['by_status'] as $item)
                                <tr>
                                    <td>{{ $item['status'] ?? '-' }}</td>
                                    <td class="text-end">{{ $item['count'] ?? 0 }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @endif

                    @if(isset($reportData['drivers']) && count($reportData['drivers']) > 0)
                    <h6 class="mb-3"><i class="bi bi-people me-2"></i>{{ __('Driver Performance') }}</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>{{ __('Driver') }}</th>
                                    <th class="text-end">{{ __('Trips') }}</th>
                                    <th class="text-end">{{ __('Completed') }}</th>
                                    <th class="text-end">{{ __('Rate') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($reportData['drivers'] as $driver)
                                <tr>
                                    <td>{{ $driver['name'] ?? '-' }}</td>
                                    <td class="text-end">{{ $driver['total_trips'] ?? 0 }}</td>
                                    <td class="text-end">{{ $driver['completed_trips'] ?? 0 }}</td>
                                    <td class="text-end">
                                        <span class="badge bg-{{ ($driver['completion_rate'] ?? 0) >= 80 ? 'success' : (($driver['completion_rate'] ?? 0) >= 50 ? 'warning' : 'danger') }}">
                                            {{ $driver['completion_rate'] ?? 0 }}%
                                        </span>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @endif
                </div>
            </div>
            @endif

            {{-- Description Card --}}
            @if($report->description)
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon secondary">
                        <i class="bi bi-journal-text"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Description') }}</h5>
                </div>
                <div class="detail-card-body">
                    <p class="mb-0">{{ $report->description }}</p>
                </div>
            </div>
            @endif
        </div>

        {{-- Sidebar --}}
        <div class="col-lg-4">
            {{-- Schedule Info Card --}}
            @if($report->is_scheduled)
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon warning">
                        <i class="bi bi-calendar-check"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Schedule') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="data-list">
                        <div class="data-list-item">
                            <span class="data-list-item-label">{{ __('Frequency') }}</span>
                            <span class="data-list-item-value">{{ __(ucfirst($report->schedule_frequency)) }}</span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">{{ __('Next Run') }}</span>
                            <span class="data-list-item-value">
                                {{ $report->next_run_at ? $report->next_run_at->format('M d, Y h:i A') : '-' }}
                            </span>
                        </div>
                        @if($report->last_run_at)
                        <div class="data-list-item">
                            <span class="data-list-item-label">{{ __('Last Run') }}</span>
                            <span class="data-list-item-value">{{ $report->last_run_at->format('M d, Y h:i A') }}</span>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
            @endif

            {{-- Activity Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon secondary">
                        <i class="bi bi-clock-history"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Activity') }}</h5>
                </div>
                <div class="detail-card-body">
                    @if($report->creator)
                    <div class="entity-card mb-3">
                        <div class="entity-card-avatar secondary">
                            <i class="bi bi-person-badge"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-name">{{ $report->creator->name }}</h6>
                            <p class="entity-card-subtitle">{{ __('Created by') }}</p>
                        </div>
                    </div>
                    @endif
                    <div class="detail-timeline">
                        <div class="timeline-item">
                            <div class="timeline-marker success"></div>
                            <div class="timeline-content">
                                <div class="timeline-title">{{ __('Created') }}</div>
                                <div class="timeline-date">{{ $report->created_at->format('M d, Y h:i A') }}</div>
                            </div>
                        </div>
                        @if($report->generated_at)
                        <div class="timeline-item">
                            <div class="timeline-marker info"></div>
                            <div class="timeline-content">
                                <div class="timeline-title">{{ __('Generated') }}</div>
                                <div class="timeline-date">{{ $report->generated_at->format('M d, Y h:i A') }}</div>
                            </div>
                        </div>
                        @endif
                        @if($report->updated_at != $report->created_at)
                        <div class="timeline-item">
                            <div class="timeline-marker warning"></div>
                            <div class="timeline-content">
                                <div class="timeline-title">{{ __('Last Updated') }}</div>
                                <div class="timeline-date">{{ $report->updated_at->format('M d, Y h:i A') }}</div>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            {{-- Danger Zone --}}
            @if(auth()->user()->hasPermission('reports.delete'))
            <div class="detail-card border-danger">
                <div class="detail-card-header bg-danger bg-opacity-10">
                    <div class="detail-card-header-icon" style="background: rgba(220, 53, 69, 0.1); color: #dc3545;">
                        <i class="bi bi-exclamation-triangle"></i>
                    </div>
                    <h5 class="detail-card-title text-danger">{{ __('Danger Zone') }}</h5>
                </div>
                <div class="detail-card-body">
                    <p class="text-muted small mb-3">{{ __('Once you delete this report, there is no going back. Please be certain.') }}</p>
                    <form action="{{ route('admin.reports.destroy', $report) }}" method="POST"
                          onsubmit="return confirm('{{ __('Are you sure you want to delete this report?') }}')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="bi bi-trash me-1"></i>
                            {{ __('Delete Report') }}
                        </button>
                    </form>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>

@push('styles')
<style>
.summary-stat-card {
    background: var(--body-bg);
    border: 1px solid var(--border-color);
    border-radius: 12px;
    padding: 1rem;
    text-align: center;
}

.summary-stat-value {
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--text-primary);
    line-height: 1.2;
}

.summary-stat-label {
    font-size: 0.75rem;
    color: var(--text-secondary);
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-top: 0.25rem;
}
</style>
@endpush
@endsection
