@extends('layouts.app')

@section('title', __('Trip Report'))
@section('page-title', __('Trip Report'))
@section('page-subtitle', __('Analyze trip performance and status'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/adminlistpage.css') }}">
<style>
    .report-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 1.5rem;
    }
    .export-dropdown .dropdown-menu {
        min-width: 150px;
    }
    .summary-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
        gap: 1rem;
        margin-bottom: 1.5rem;
    }
    .summary-card {
        background: linear-gradient(135deg, #eff6ff 0%, #dbeafe 100%);
        border-radius: 12px;
        padding: 1.25rem;
        border: 1px solid #bfdbfe;
    }
    .summary-card.success { background: linear-gradient(135deg, #dcfce7 0%, #bbf7d0 100%); border-color: #86efac; }
    .summary-card.warning { background: linear-gradient(135deg, #fef9c3 0%, #fef08a 100%); border-color: #fde047; }
    .summary-card.danger { background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%); border-color: #fca5a5; }
    .summary-card.info { background: linear-gradient(135deg, #e0e7ff 0%, #c7d2fe 100%); border-color: #a5b4fc; }
    .summary-card-value {
        font-size: 1.75rem;
        font-weight: 700;
        color: #1e40af;
    }
    .summary-card.success .summary-card-value { color: #16a34a; }
    .summary-card.warning .summary-card-value { color: #ca8a04; }
    .summary-card.danger .summary-card-value { color: #dc2626; }
    .summary-card.info .summary-card-value { color: #4f46e5; }
    .summary-card-label {
        font-size: 0.75rem;
        color: #1e40af;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    .summary-card.success .summary-card-label { color: #166534; }
    .summary-card.warning .summary-card-label { color: #854d0e; }
    .summary-card.danger .summary-card-label { color: #991b1b; }
    .summary-card.info .summary-card-label { color: #3730a3; }
    .filter-section {
        background: white;
        border-radius: 12px;
        padding: 1.25rem;
        margin-bottom: 1.5rem;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .chart-section {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
        gap: 1.5rem;
        margin-bottom: 1.5rem;
    }
    .chart-card {
        background: white;
        border-radius: 12px;
        padding: 1.25rem;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .chart-card-title {
        font-weight: 600;
        color: #374151;
        margin-bottom: 1rem;
        padding-bottom: 0.5rem;
        border-bottom: 1px solid #e5e7eb;
    }
    .data-table-card {
        background: white;
        border-radius: 12px;
        padding: 1.25rem;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .mini-table {
        width: 100%;
    }
    .mini-table th {
        font-size: 0.7rem;
        text-transform: uppercase;
        color: #6b7280;
        font-weight: 600;
        padding: 0.5rem;
        border-bottom: 2px solid #e5e7eb;
    }
    .mini-table td {
        padding: 0.5rem;
        font-size: 0.85rem;
        border-bottom: 1px solid #f3f4f6;
    }
    .status-badge {
        padding: 0.25rem 0.5rem;
        border-radius: 4px;
        font-size: 0.7rem;
        font-weight: 600;
    }
    .status-badge.completed { background: #dcfce7; color: #16a34a; }
    .status-badge.in_transit { background: #dbeafe; color: #2563eb; }
    .status-badge.pending { background: #fef9c3; color: #ca8a04; }
    .status-badge.cancelled { background: #fee2e2; color: #dc2626; }
    .status-badge.scheduled { background: #e0e7ff; color: #4f46e5; }
    .completion-rate {
        font-size: 0.8rem;
        padding: 0.25rem 0.5rem;
        border-radius: 4px;
    }
    .completion-rate.high { background: #dcfce7; color: #16a34a; }
    .completion-rate.medium { background: #fef9c3; color: #ca8a04; }
    .completion-rate.low { background: #fee2e2; color: #dc2626; }
</style>
@endpush

@section('content')
<div class="container-fluid">
    {{-- Report Header --}}
    <div class="report-header">
        <div>
            <h4 class="mb-1"><i class="bi bi-signpost-split text-primary me-2"></i>{{ __('Trip Summary Report') }}</h4>
            <p class="text-muted mb-0">{{ __('Overview of trip performance and completion rates') }}</p>
        </div>
        <div class="d-flex gap-2">
            <div class="dropdown export-dropdown">
                <button class="btn btn-success dropdown-toggle" type="button" data-bs-toggle="dropdown">
                    <i class="bi bi-download me-1"></i> {{ __('Export') }}
                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                        <a class="dropdown-item" href="{{ route('admin.reports.trip.export', array_merge(request()->query(), ['format' => 'pdf'])) }}">
                            <i class="bi bi-file-pdf text-danger me-2"></i> {{ __('Export as PDF') }}
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item" href="{{ route('admin.reports.trip.export', array_merge(request()->query(), ['format' => 'csv'])) }}">
                            <i class="bi bi-filetype-csv text-success me-2"></i> {{ __('Export as CSV') }}
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item" href="{{ route('admin.reports.trip.export', array_merge(request()->query(), ['format' => 'html'])) }}">
                            <i class="bi bi-filetype-html text-primary me-2"></i> {{ __('Export as HTML') }}
                        </a>
                    </li>
                </ul>
            </div>
            <a href="{{ route('admin.trips.index') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-1"></i> {{ __('Back to Trips') }}
            </a>
        </div>
    </div>

    {{-- Summary Cards --}}
    <div class="summary-cards">
        <div class="summary-card">
            <div class="summary-card-value">{{ $summary['total_trips'] }}</div>
            <div class="summary-card-label">{{ __('Total Trips') }}</div>
        </div>
        <div class="summary-card success">
            <div class="summary-card-value">{{ $summary['completed'] }}</div>
            <div class="summary-card-label">{{ __('Completed') }}</div>
        </div>
        <div class="summary-card info">
            <div class="summary-card-value">{{ $summary['in_transit'] }}</div>
            <div class="summary-card-label">{{ __('In Transit') }}</div>
        </div>
        <div class="summary-card warning">
            <div class="summary-card-value">{{ $summary['pending'] }}</div>
            <div class="summary-card-label">{{ __('Pending') }}</div>
        </div>
        <div class="summary-card danger">
            <div class="summary-card-value">{{ $summary['cancelled'] }}</div>
            <div class="summary-card-label">{{ __('Cancelled') }}</div>
        </div>
    </div>

    {{-- Filters --}}
    <div class="filter-section">
        <form action="{{ route('admin.reports.trip.index') }}" method="GET">
            <div class="row g-3">
                <div class="col-md-2">
                    <label class="form-label">{{ __('Date From') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Date To') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Vehicle') }}</label>
                    <select name="vehicle_id" class="form-select">
                        <option value="">{{ __('All Vehicles') }}</option>
                        @foreach($vehicles as $vehicle)
                            <option value="{{ $vehicle->id }}" {{ request('vehicle_id') == $vehicle->id ? 'selected' : '' }}>
                                {{ $vehicle->vehicle_number }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Driver') }}</label>
                    <select name="driver_id" class="form-select">
                        <option value="">{{ __('All Drivers') }}</option>
                        @foreach($drivers as $driver)
                            <option value="{{ $driver->id }}" {{ request('driver_id') == $driver->id ? 'selected' : '' }}>
                                {{ $driver->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Status') }}</label>
                    <select name="status" class="form-select">
                        <option value="">{{ __('All Status') }}</option>
                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>{{ __('Pending') }}</option>
                        <option value="scheduled" {{ request('status') == 'scheduled' ? 'selected' : '' }}>{{ __('Scheduled') }}</option>
                        <option value="in_transit" {{ request('status') == 'in_transit' ? 'selected' : '' }}>{{ __('In Transit') }}</option>
                        <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>{{ __('Completed') }}</option>
                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>{{ __('Cancelled') }}</option>
                    </select>
                </div>
                <div class="col-md-2 d-flex align-items-end gap-2">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-funnel me-1"></i> {{ __('Filter') }}
                    </button>
                    <a href="{{ route('admin.reports.trip.index') }}" class="btn btn-outline-secondary">
                        <i class="bi bi-x-lg"></i>
                    </a>
                </div>
            </div>
        </form>
    </div>

    {{-- Charts Section --}}
    <div class="chart-section">
        {{-- By Status --}}
        <div class="chart-card">
            <h6 class="chart-card-title"><i class="bi bi-pie-chart me-2"></i>{{ __('By Status') }}</h6>
            @if($byStatus->count() > 0)
                <table class="mini-table">
                    <thead>
                        <tr>
                            <th>{{ __('Status') }}</th>
                            <th class="text-end">{{ __('Count') }}</th>
                            <th class="text-end">{{ __('Percentage') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($byStatus as $item)
                        @php
                            $percentage = $summary['total_trips'] > 0 ? round(($item->count / $summary['total_trips']) * 100, 1) : 0;
                        @endphp
                        <tr>
                            <td><span class="status-badge {{ $item->status }}">{{ ucfirst(str_replace('_', ' ', $item->status)) }}</span></td>
                            <td class="text-end">{{ $item->count }}</td>
                            <td class="text-end">{{ $percentage }}%</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <p class="text-muted text-center py-3">{{ __('No data available') }}</p>
            @endif
        </div>

        {{-- By Vehicle --}}
        <div class="chart-card">
            <h6 class="chart-card-title"><i class="bi bi-truck me-2"></i>{{ __('By Vehicle') }}</h6>
            @if($byVehicle->count() > 0)
                <table class="mini-table">
                    <thead>
                        <tr>
                            <th>{{ __('Vehicle') }}</th>
                            <th class="text-end">{{ __('Total') }}</th>
                            <th class="text-end">{{ __('Completed') }}</th>
                            <th class="text-end">{{ __('Rate') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($byVehicle as $item)
                        @php
                            $rate = $item->total_trips > 0 ? round(($item->completed / $item->total_trips) * 100, 1) : 0;
                            $rateClass = $rate >= 80 ? 'high' : ($rate >= 50 ? 'medium' : 'low');
                        @endphp
                        <tr>
                            <td>{{ $item->vehicle->vehicle_number ?? '-' }}</td>
                            <td class="text-end">{{ $item->total_trips }}</td>
                            <td class="text-end">{{ $item->completed }}</td>
                            <td class="text-end"><span class="completion-rate {{ $rateClass }}">{{ $rate }}%</span></td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <p class="text-muted text-center py-3">{{ __('No data available') }}</p>
            @endif
        </div>

        {{-- By Driver --}}
        <div class="chart-card">
            <h6 class="chart-card-title"><i class="bi bi-person-badge me-2"></i>{{ __('By Driver') }}</h6>
            @if($byDriver->count() > 0)
                <table class="mini-table">
                    <thead>
                        <tr>
                            <th>{{ __('Driver') }}</th>
                            <th class="text-end">{{ __('Total') }}</th>
                            <th class="text-end">{{ __('Completed') }}</th>
                            <th class="text-end">{{ __('Rate') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($byDriver as $item)
                        @php
                            $rate = $item->total_trips > 0 ? round(($item->completed / $item->total_trips) * 100, 1) : 0;
                            $rateClass = $rate >= 80 ? 'high' : ($rate >= 50 ? 'medium' : 'low');
                        @endphp
                        <tr>
                            <td>{{ $item->driver->name ?? '-' }}</td>
                            <td class="text-end">{{ $item->total_trips }}</td>
                            <td class="text-end">{{ $item->completed }}</td>
                            <td class="text-end"><span class="completion-rate {{ $rateClass }}">{{ $rate }}%</span></td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <p class="text-muted text-center py-3">{{ __('No data available') }}</p>
            @endif
        </div>
    </div>

    {{-- Data Table --}}
    <div class="data-table-card">
        <h6 class="chart-card-title"><i class="bi bi-table me-2"></i>{{ __('Trip Details') }}</h6>
        
        @if($trips->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead>
                        <tr>
                            <th>{{ __('Trip Number') }}</th>
                            <th>{{ __('Scheduled Date') }}</th>
                            <th>{{ __('Vehicle') }}</th>
                            <th>{{ __('Driver') }}</th>
                            <th>{{ __('Origin') }}</th>
                            <th>{{ __('Destination') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th>{{ __('Start Time') }}</th>
                            <th>{{ __('End Time') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($trips as $trip)
                        <tr>
                            <td><strong>{{ $trip->trip_number }}</strong></td>
                            <td>{{ $trip->scheduled_date }}</td>
                            <td>{{ $trip->vehicle->vehicle_number ?? '-' }}</td>
                            <td>{{ $trip->driver->name ?? '-' }}</td>
                            <td>{{ $trip->origin ?? '-' }}</td>
                            <td>{{ $trip->destination ?? '-' }}</td>
                            <td><span class="status-badge {{ $trip->status }}">{{ ucfirst(str_replace('_', ' ', $trip->status)) }}</span></td>
                            <td>{{ $trip->actual_start_time ?? '-' }}</td>
                            <td>{{ $trip->actual_end_time ?? '-' }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                {{ $trips->links() }}
            </div>
        @else
            <div class="text-center py-5">
                <i class="bi bi-signpost-split display-4 text-muted"></i>
                <p class="text-muted mt-2">{{ __('No trips found for the selected filters') }}</p>
            </div>
        @endif
    </div>
</div>
@endsection