@extends('layouts.app')

@section('title', __('add_role') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admincreatepage.css') }}">
<style>
    /* Permission Module Card Styles */
    .permission-module-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
        gap: 1.25rem;
    }

    .permission-module-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 12px;
        overflow: hidden;
        transition: all 0.2s ease;
    }

    .permission-module-card:hover {
        border-color: var(--primary-color);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    }

    .permission-module-header {
        background: var(--body-bg);
        padding: 1rem 1.25rem;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .permission-module-header .form-check {
        margin: 0;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .permission-module-header .form-check-input {
        width: 1.25rem;
        height: 1.25rem;
        cursor: pointer;
    }

    .permission-module-header .form-check-label {
        font-weight: 600;
        color: var(--text-primary);
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .permission-module-icon {
        width: 32px;
        height: 32px;
        border-radius: 8px;
        background: var(--primary-light);
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--primary-color);
    }

    .permission-module-body {
        padding: 1rem 1.25rem;
    }

    .permission-item {
        display: flex;
        align-items: center;
        padding: 0.5rem 0;
        border-bottom: 1px solid var(--border-color);
    }

    .permission-item:last-child {
        border-bottom: none;
    }

    .permission-item .form-check {
        margin: 0;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .permission-item .form-check-input {
        cursor: pointer;
    }

    .permission-item .form-check-label {
        cursor: pointer;
        color: var(--text-secondary);
        font-size: 0.9rem;
    }

    .permission-item .form-check-input:checked + .form-check-label {
        color: var(--text-primary);
    }
</style>
@endpush

@section('content')
<div class="create-page-container">
    {{-- Page Header --}}
    <div class="create-page-header">
        <div class="create-page-header-content">
            <nav class="create-page-breadcrumb">
                <a href="{{ route('admin.dashboard') }}">{{ __('dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.roles.index') }}">{{ __('roles') }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ __('add_role') }}</span>
            </nav>
            <h1 class="create-page-title">
                <span class="create-page-title-icon">
                    <i class="bi bi-shield-plus"></i>
                </span>
                {{ __('add_role') }}
            </h1>
            <p class="create-page-subtitle">{{ __('Create a new role with permissions') }}</p>
        </div>
        <div class="create-page-actions">
            <a href="{{ route('admin.roles.index') }}" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('back') }}
            </a>
        </div>
    </div>

    <form action="{{ route('admin.roles.store') }}" method="POST">
        @csrf

        <div class="create-form-layout">
            {{-- Main Form --}}
            <div class="create-form-main">
                {{-- Basic Information --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon primary">
                            <i class="bi bi-info-circle"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title">{{ __('Basic Information') }}</h3>
                            <p class="create-card-subtitle">{{ __('Role name and description') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="name" class="create-form-label">
                                    {{ __('role_name') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="text" 
                                       class="create-input @error('name') is-invalid @enderror" 
                                       id="name" 
                                       name="name" 
                                       value="{{ old('name') }}"
                                       placeholder="e.g., fleet_manager"
                                       required>
                                @error('name')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                                <span class="create-form-hint">{{ __('role_name_hint') }}</span>
                            </div>
                            <div class="create-form-group">
                                <label for="display_name" class="create-form-label">
                                    {{ __('display_name') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="text" 
                                       class="create-input @error('display_name') is-invalid @enderror" 
                                       id="display_name" 
                                       name="display_name" 
                                       value="{{ old('display_name') }}"
                                       placeholder="e.g., Fleet Manager"
                                       required>
                                @error('display_name')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="create-form-group">
                            <label for="description" class="create-form-label">
                                {{ __('description') }}
                                <span class="create-form-optional">({{ __('Optional') }})</span>
                            </label>
                            <textarea class="create-textarea @error('description') is-invalid @enderror" 
                                      id="description" 
                                      name="description" 
                                      rows="3"
                                      placeholder="{{ __('description_placeholder') }}">{{ old('description') }}</textarea>
                            @error('description')
                                <span class="create-form-error">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Permissions Section --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon success">
                            <i class="bi bi-key"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title">
                                {{ __('assign_permissions') }}
                                <span class="create-form-required">*</span>
                            </h3>
                            <p class="create-card-subtitle">{{ __('Select permissions for this role') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        @error('permissions')
                            <div class="alert alert-danger mb-4">
                                <i class="bi bi-exclamation-triangle me-2"></i>{{ $message }}
                            </div>
                        @enderror

                        <div class="permission-module-grid">
                            @foreach($permissions as $module => $modulePermissions)
                            <div class="permission-module-card">
                                <div class="permission-module-header">
                                    <div class="permission-module-icon">
                                        <i class="bi bi-folder"></i>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input module-checkbox" 
                                               type="checkbox" 
                                               id="module_{{ $module }}"
                                               data-module="{{ $module }}">
                                        <label class="form-check-label" for="module_{{ $module }}">
                                            {{ __(ucfirst($module)) }}
                                        </label>
                                    </div>
                                </div>
                                <div class="permission-module-body">
                                    @foreach($modulePermissions as $permission)
                                    <div class="permission-item">
                                        <div class="form-check">
                                            <input class="form-check-input permission-checkbox" 
                                                   type="checkbox" 
                                                   name="permissions[]" 
                                                   value="{{ $permission->id }}" 
                                                   id="permission_{{ $permission->id }}"
                                                   data-module="{{ $module }}"
                                                   {{ in_array($permission->id, old('permissions', [])) ? 'checked' : '' }}>
                                            <label class="form-check-label" for="permission_{{ $permission->id }}">
                                                {{ $permission->display_name }}
                                            </label>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>

                    {{-- Form Actions --}}
                    <div class="create-card-actions">
                        <div class="create-card-actions-left">
                            <a href="{{ route('admin.roles.index') }}" class="create-btn create-btn-secondary">
                                <i class="bi bi-x-lg"></i>
                                {{ __('cancel') }}
                            </a>
                        </div>
                        <div class="create-card-actions-right">
                            <button type="submit" class="create-btn create-btn-primary">
                                <i class="bi bi-check-circle"></i>
                                {{ __('save') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Sidebar --}}
            <div class="create-form-sidebar">
                {{-- Quick Tips --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-lightbulb"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Quick Tips') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                {{ __('Use lowercase with underscores for role name') }}
                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                {{ __('Display name is shown to users') }}
                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                {{ __('Select at least one permission') }}
                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                {{ __('Click module header to select all') }}
                            </li>
                        </ul>
                    </div>
                </div>

                {{-- Permission Info --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-info-circle"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Permission Info') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-status-preview">
                            <span class="create-status-badge" style="background-color: rgba(13, 110, 253, 0.1); color: #0d6efd;">
                                <i class="bi bi-eye"></i>
                                {{ __('View') }}
                            </span>
                            <p class="create-status-description">{{ __('Read-only access') }}</p>
                        </div>
                        <div class="create-status-preview">
                            <span class="create-status-badge" style="background-color: rgba(25, 135, 84, 0.1); color: #198754;">
                                <i class="bi bi-plus-circle"></i>
                                {{ __('Create') }}
                            </span>
                            <p class="create-status-description">{{ __('Add new records') }}</p>
                        </div>
                        <div class="create-status-preview">
                            <span class="create-status-badge" style="background-color: rgba(255, 193, 7, 0.1); color: #ffc107;">
                                <i class="bi bi-pencil"></i>
                                {{ __('Edit') }}
                            </span>
                            <p class="create-status-description">{{ __('Modify existing records') }}</p>
                        </div>
                        <div class="create-status-preview">
                            <span class="create-status-badge" style="background-color: rgba(220, 53, 69, 0.1); color: #dc3545;">
                                <i class="bi bi-trash"></i>
                                {{ __('Delete') }}
                            </span>
                            <p class="create-status-description">{{ __('Remove records') }}</p>
                        </div>
                    </div>
                </div>

                {{-- Quick Actions --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Quick Actions') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="{{ route('admin.roles.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                {{ __('View All Roles') }}
                            </a>
                            <a href="{{ route('admin.users.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-people"></i>
                                {{ __('Manage Users') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script>
// Select all permissions in a module when module checkbox is clicked
document.querySelectorAll('.module-checkbox').forEach(function(moduleCheckbox) {
    moduleCheckbox.addEventListener('change', function() {
        const module = this.dataset.module;
        const isChecked = this.checked;
        
        document.querySelectorAll(`.permission-checkbox[data-module="${module}"]`).forEach(function(permCheckbox) {
            permCheckbox.checked = isChecked;
        });
    });
});

// Update module checkbox state based on individual permissions
document.querySelectorAll('.permission-checkbox').forEach(function(permCheckbox) {
    permCheckbox.addEventListener('change', function() {
        const module = this.dataset.module;
        const moduleCheckbox = document.querySelector(`.module-checkbox[data-module="${module}"]`);
        const modulePermissions = document.querySelectorAll(`.permission-checkbox[data-module="${module}"]`);
        const checkedPermissions = document.querySelectorAll(`.permission-checkbox[data-module="${module}"]:checked`);
        
        moduleCheckbox.checked = modulePermissions.length === checkedPermissions.length;
    });
});
</script>
@endpush