@extends('layouts.app')

@section('title', __('edit_role') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admincreatepage.css') }}">
<style>
    /* Permission Module Card Styles */
    .permission-module-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
        gap: 1.25rem;
    }

    .permission-module-card {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 12px;
        overflow: hidden;
        transition: all 0.2s ease;
    }

    .permission-module-card:hover {
        border-color: var(--primary-color);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    }

    .permission-module-card.disabled {
        opacity: 0.7;
    }

    .permission-module-header {
        background: var(--body-bg);
        padding: 1rem 1.25rem;
        border-bottom: 1px solid var(--border-color);
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .permission-module-header .form-check {
        margin: 0;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .permission-module-header .form-check-input {
        width: 1.25rem;
        height: 1.25rem;
        cursor: pointer;
    }

    .permission-module-header .form-check-input:disabled {
        cursor: not-allowed;
        opacity: 0.6;
    }

    .permission-module-header .form-check-label {
        font-weight: 600;
        color: var(--text-primary);
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .permission-module-icon {
        width: 32px;
        height: 32px;
        border-radius: 8px;
        background: var(--primary-light);
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--primary-color);
    }

    .permission-module-body {
        padding: 1rem 1.25rem;
    }

    .permission-item {
        display: flex;
        align-items: center;
        padding: 0.5rem 0;
        border-bottom: 1px solid var(--border-color);
    }

    .permission-item:last-child {
        border-bottom: none;
    }

    .permission-item .form-check {
        margin: 0;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .permission-item .form-check-input {
        cursor: pointer;
    }

    .permission-item .form-check-input:disabled {
        cursor: not-allowed;
    }

    .permission-item .form-check-label {
        cursor: pointer;
        color: var(--text-secondary);
        font-size: 0.9rem;
    }

    .permission-item .form-check-input:checked + .form-check-label {
        color: var(--text-primary);
    }
</style>
@endpush

@section('content')
<div class="create-page-container">
    {{-- Page Header --}}
    <div class="create-page-header">
        <div class="create-page-header-content">
            <nav class="create-page-breadcrumb">
                <a href="{{ route('admin.dashboard') }}">{{ __('dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.roles.index') }}">{{ __('roles') }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ __('edit_role') }}</span>
            </nav>
            <h1 class="create-page-title">
                <span class="create-page-title-icon">
                    <i class="bi bi-shield-lock"></i>
                </span>
                {{ __('edit_role') }}: {{ $role->display_name }}
            </h1>
            <p class="create-page-subtitle">{{ __('Update role information and permissions') }}</p>
        </div>
        <div class="create-page-actions">
            <a href="{{ route('admin.roles.index') }}" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('back') }}
            </a>
        </div>
    </div>

    <form action="{{ route('admin.roles.update', $role) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="create-form-layout">
            {{-- Main Form --}}
            <div class="create-form-main">
                {{-- Basic Information --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon primary">
                            <i class="bi bi-info-circle"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title">{{ __('Basic Information') }}</h3>
                            <p class="create-card-subtitle">{{ __('Role name and description') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="name" class="create-form-label">
                                    {{ __('role_name') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="text" 
                                       class="create-input @error('name') is-invalid @enderror" 
                                       id="name" 
                                       name="name" 
                                       value="{{ old('name', $role->name) }}"
                                       placeholder="e.g., fleet_manager"
                                       {{ $role->name === 'super_admin' ? 'readonly' : '' }}
                                       required>
                                @error('name')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                                @if($role->name === 'super_admin')
                                    <span class="create-form-hint" style="color: var(--warning-color);">
                                        <i class="bi bi-exclamation-triangle"></i> {{ __('super_admin_cannot_be_renamed') }}
                                    </span>
                                @else
                                    <span class="create-form-hint">{{ __('role_name_hint') }}</span>
                                @endif
                            </div>
                            <div class="create-form-group">
                                <label for="display_name" class="create-form-label">
                                    {{ __('display_name') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="text" 
                                       class="create-input @error('display_name') is-invalid @enderror" 
                                       id="display_name" 
                                       name="display_name" 
                                       value="{{ old('display_name', $role->display_name) }}"
                                       placeholder="e.g., Fleet Manager"
                                       required>
                                @error('display_name')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="create-form-group">
                            <label for="description" class="create-form-label">
                                {{ __('description') }}
                                <span class="create-form-optional">({{ __('Optional') }})</span>
                            </label>
                            <textarea class="create-textarea @error('description') is-invalid @enderror" 
                                      id="description" 
                                      name="description" 
                                      rows="3"
                                      placeholder="{{ __('description_placeholder') }}">{{ old('description', $role->description) }}</textarea>
                            @error('description')
                                <span class="create-form-error">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Permissions Section --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon success">
                            <i class="bi bi-key"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title">
                                {{ __('assign_permissions') }}
                                <span class="create-form-required">*</span>
                            </h3>
                            <p class="create-card-subtitle">{{ __('Select permissions for this role') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        @if($role->name === 'super_admin')
                            <div class="create-alert create-alert-info mb-4">
                                <div class="create-alert-icon">
                                    <i class="bi bi-info-circle"></i>
                                </div>
                                <div class="create-alert-content">
                                    <p class="create-alert-text mb-0">{{ __('super_admin_has_all_permissions') }}</p>
                                </div>
                            </div>
                        @endif

                        @error('permissions')
                            <div class="alert alert-danger mb-4">
                                <i class="bi bi-exclamation-triangle me-2"></i>{{ $message }}
                            </div>
                        @enderror

                        @php
                            $selectedPermissions = old('permissions', $role->permissions->pluck('id')->toArray());
                        @endphp

                        <div class="permission-module-grid">
                            @foreach($permissions as $module => $modulePermissions)
                            <div class="permission-module-card {{ $role->name === 'super_admin' ? 'disabled' : '' }}">
                                <div class="permission-module-header">
                                    <div class="permission-module-icon">
                                        <i class="bi bi-folder"></i>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input module-checkbox" 
                                               type="checkbox" 
                                               id="module_{{ $module }}"
                                               data-module="{{ $module }}"
                                               {{ $role->name === 'super_admin' ? 'checked disabled' : '' }}>
                                        <label class="form-check-label" for="module_{{ $module }}">
                                            {{ __(ucfirst($module)) }}
                                        </label>
                                    </div>
                                </div>
                                <div class="permission-module-body">
                                    @foreach($modulePermissions as $permission)
                                    <div class="permission-item">
                                        <div class="form-check">
                                            <input class="form-check-input permission-checkbox" 
                                                   type="checkbox" 
                                                   name="permissions[]" 
                                                   value="{{ $permission->id }}" 
                                                   id="permission_{{ $permission->id }}"
                                                   data-module="{{ $module }}"
                                                   {{ in_array($permission->id, $selectedPermissions) ? 'checked' : '' }}
                                                   {{ $role->name === 'super_admin' ? 'disabled' : '' }}>
                                            <label class="form-check-label" for="permission_{{ $permission->id }}">
                                                {{ $permission->display_name }}
                                            </label>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                            @endforeach
                        </div>

                        {{-- Hidden inputs for super_admin to keep all permissions --}}
                        @if($role->name === 'super_admin')
                            @foreach($permissions as $module => $modulePermissions)
                                @foreach($modulePermissions as $permission)
                                    <input type="hidden" name="permissions[]" value="{{ $permission->id }}">
                                @endforeach
                            @endforeach
                        @endif
                    </div>

                    {{-- Form Actions --}}
                    <div class="create-card-actions">
                        <div class="create-card-actions-left">
                            <a href="{{ route('admin.roles.index') }}" class="create-btn create-btn-secondary">
                                <i class="bi bi-x-lg"></i>
                                {{ __('cancel') }}
                            </a>
                        </div>
                        <div class="create-card-actions-right">
                            <button type="submit" class="create-btn create-btn-primary">
                                <i class="bi bi-check-circle"></i>
                                {{ __('update') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Sidebar --}}
            <div class="create-form-sidebar">
                {{-- Role Info --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-shield-check"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Role Info') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="d-flex align-items-center mb-3">
                            <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                <i class="bi bi-shield-lock fs-4"></i>
                            </div>
                            <div>
                                <h6 class="mb-0">{{ $role->display_name }}</h6>
                                <small class="text-muted">{{ $role->name }}</small>
                            </div>
                        </div>
                        @if($role->name === 'super_admin')
                            <div class="create-status-preview">
                                <span class="create-status-badge" style="background-color: rgba(255, 193, 7, 0.1); color: #ffc107;">
                                    <i class="bi bi-star"></i>
                                    {{ __('System Role') }}
                                </span>
                                <p class="create-status-description">{{ __('Cannot be deleted') }}</p>
                            </div>
                        @endif
                    </div>
                </div>

                {{-- Statistics --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-bar-chart"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Statistics') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="list-unstyled mb-0">
                            <li class="d-flex justify-content-between mb-2 pb-2 border-bottom">
                                <span class="text-muted">{{ __('users') }}</span>
                                <span class="badge bg-primary">{{ $role->users_count ?? 0 }}</span>
                            </li>
                            <li class="d-flex justify-content-between mb-2 pb-2 border-bottom">
                                <span class="text-muted">{{ __('permissions') }}</span>
                                <span class="badge bg-success">{{ $role->permissions->count() }}</span>
                            </li>
                            <li class="d-flex justify-content-between">
                                <span class="text-muted">{{ __('modules') }}</span>
                                <span class="badge bg-info">{{ count($permissions) }}</span>
                            </li>
                        </ul>
                    </div>
                </div>

                {{-- Record Info --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-clock-history"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Record Info') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="list-unstyled mb-0">
                            <li class="d-flex justify-content-between mb-2 pb-2 border-bottom">
                                <span class="text-muted">{{ __('ID') }}</span>
                                <span>#{{ $role->id }}</span>
                            </li>
                            <li class="d-flex justify-content-between mb-2 pb-2 border-bottom">
                                <span class="text-muted">{{ __('Created') }}</span>
                                <span>{{ $role->created_at->format('M d, Y') }}</span>
                            </li>
                            <li class="d-flex justify-content-between">
                                <span class="text-muted">{{ __('Updated') }}</span>
                                <span>{{ $role->updated_at->format('M d, Y') }}</span>
                            </li>
                        </ul>
                    </div>
                </div>

                {{-- Quick Actions --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Quick Actions') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="{{ route('admin.roles.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                {{ __('View All Roles') }}
                            </a>
                            <a href="{{ route('admin.roles.create') }}" class="create-quick-action-btn">
                                <i class="bi bi-plus-circle"></i>
                                {{ __('Add New Role') }}
                            </a>
                            <a href="{{ route('admin.users.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-people"></i>
                                {{ __('Manage Users') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script>
// Select all permissions in a module when module checkbox is clicked
document.querySelectorAll('.module-checkbox:not([disabled])').forEach(function(moduleCheckbox) {
    moduleCheckbox.addEventListener('change', function() {
        const module = this.dataset.module;
        const isChecked = this.checked;
        
        document.querySelectorAll(`.permission-checkbox[data-module="${module}"]:not([disabled])`).forEach(function(permCheckbox) {
            permCheckbox.checked = isChecked;
        });
    });
});

// Update module checkbox state based on individual permissions
document.querySelectorAll('.permission-checkbox:not([disabled])').forEach(function(permCheckbox) {
    permCheckbox.addEventListener('change', function() {
        const module = this.dataset.module;
        const moduleCheckbox = document.querySelector(`.module-checkbox[data-module="${module}"]:not([disabled])`);
        
        if (moduleCheckbox) {
            const modulePermissions = document.querySelectorAll(`.permission-checkbox[data-module="${module}"]:not([disabled])`);
            const checkedPermissions = document.querySelectorAll(`.permission-checkbox[data-module="${module}"]:not([disabled]):checked`);
            
            moduleCheckbox.checked = modulePermissions.length === checkedPermissions.length;
        }
    });
});

// Set initial state of module checkboxes on page load
document.querySelectorAll('.module-checkbox:not([disabled])').forEach(function(moduleCheckbox) {
    const module = moduleCheckbox.dataset.module;
    const modulePermissions = document.querySelectorAll(`.permission-checkbox[data-module="${module}"]:not([disabled])`);
    const checkedPermissions = document.querySelectorAll(`.permission-checkbox[data-module="${module}"]:not([disabled]):checked`);
    
    moduleCheckbox.checked = modulePermissions.length === checkedPermissions.length && modulePermissions.length > 0;
});
</script>
@endpush