@extends('layouts.app')

@section('title', __('users') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/adminlistpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header --}}
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-people"></i>
                {{ __('users') }}
            </h1>
            <p class="list-page-subtitle">{{ __('Manage system users and their roles') }}</p>
        </div>
        <div class="list-page-header-actions">
            <a href="{{ route('admin.users.create') }}" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                {{ __('add_user') }}
            </a>
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- Stats Bar --}}
    <div class="list-stats-bar">
        <div class="list-stat-card gradient-violet">
            <div class="list-stat-icon">
                <i class="bi bi-people"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $users->total() }}</div>
                <div class="list-stat-label">{{ __('Total Users') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-database"></i>
                {{ __('All records') }}
            </div>
        </div>
        <div class="list-stat-card gradient-green">
            <div class="list-stat-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $users->where('status', 'active')->count() }}</div>
                <div class="list-stat-label">{{ __('active') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-person-check"></i>
                {{ __('Enabled') }}
            </div>
        </div>
        <div class="list-stat-card gradient-amber">
            <div class="list-stat-icon">
                <i class="bi bi-x-circle"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $users->where('status', 'inactive')->count() }}</div>
                <div class="list-stat-label">{{ __('inactive') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-person-x"></i>
                {{ __('Disabled') }}
            </div>
        </div>
        <div class="list-stat-card gradient-blue">
            <div class="list-stat-icon">
                <i class="bi bi-shield-check"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $users->filter(fn($u) => $u->roles->count() > 0)->count() }}</div>
                <div class="list-stat-label">{{ __('With Roles') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-key"></i>
                {{ __('Assigned') }}
            </div>
        </div>
    </div>

    {{-- Filter Bar --}}
    <div class="list-filter-bar">
        <form action="{{ route('admin.users.index') }}" method="GET">
            <div class="list-filter-row">
                <div class="list-filter-group search-group">
                    <div class="list-search-box">
                        <input type="text" 
                               name="search" 
                               placeholder="{{ __('search_users') }}..." 
                               value="{{ request('search') }}">
                        <i class="bi bi-search"></i>
                    </div>
                </div>
                <div class="list-filter-buttons">
                    <button type="submit" class="btn-filter btn-filter-primary">
                        <i class="bi bi-search"></i>
                        {{ __('search') }}
                    </button>
                    <a href="{{ route('admin.users.index') }}" class="btn-filter btn-filter-outline">
                        <i class="bi bi-x-circle"></i>
                        {{ __('clear') }}
                    </a>
                </div>
            </div>
        </form>
    </div>

    {{-- Users Table --}}
    <div class="list-table-container">
        <div class="list-table-header">
            <h5 class="list-table-title">
                <i class="bi bi-table me-2"></i>
                {{ __('users') }}
                <span class="list-table-count">({{ $users->total() }} {{ __('records') }})</span>
            </h5>
        </div>

        @if($users->count() > 0)
            <div class="table-responsive">
                <table class="list-table">
                    <thead>
                        <tr>
                            <th>{{ __('name') }}</th>
                            <th>{{ __('email') }}</th>
                            <th>{{ __('mobile') }}</th>
                            <th>{{ __('roles') }}</th>
                            <th>{{ __('status') }}</th>
                            <th>{{ __('created_at') }}</th>
                            <th class="text-center">{{ __('actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($users as $user)
                        <tr>
                            <td>
                                <div class="table-cell-user">
                                    <div class="table-cell-user-avatar">
                                        <i class="bi bi-person"></i>
                                    </div>
                                    <div>
                                        <strong>{{ $user->name }}</strong>
                                        @if($user->id === auth()->id())
                                            <span class="badge bg-info ms-1">{{ __('You') }}</span>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="table-cell-date">
                                    <i class="bi bi-envelope"></i>
                                    {{ $user->email }}
                                </span>
                            </td>
                            <td>
                                @if($user->mobile)
                                    <span class="table-cell-date">
                                        <i class="bi bi-phone"></i>
                                        {{ $user->mobile }}
                                    </span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                @forelse($user->roles as $role)
                                    <span class="table-badge table-badge-assigned">
                                        <i class="bi bi-shield-check"></i>
                                        {{ $role->display_name }}
                                    </span>
                                @empty
                                    <span class="table-badge table-badge-cancelled">
                                        <i class="bi bi-x-circle"></i>
                                        {{ __('no_role') }}
                                    </span>
                                @endforelse
                            </td>
                            <td>
                                @if($user->status === 'active')
                                    <span class="table-badge table-badge-delivered">
                                        <i class="bi bi-check-circle"></i>
                                        {{ __('active') }}
                                    </span>
                                @else
                                    <span class="table-badge table-badge-cancelled">
                                        <i class="bi bi-x-circle"></i>
                                        {{ __('inactive') }}
                                    </span>
                                @endif
                            </td>
                            <td>
                                <span class="table-cell-date">
                                    <i class="bi bi-calendar"></i>
                                    {{ $user->created_at->format('d M Y') }}
                                </span>
                            </td>
                            <td>
                                <div class="table-actions">
                                    <a href="{{ route('admin.users.edit', $user) }}" 
                                       class="btn-table-action btn-table-edit" 
                                       title="{{ __('edit') }}">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    @if($user->id !== auth()->id())
                                        <form action="{{ route('admin.users.destroy', $user) }}" 
                                              method="POST" 
                                              class="d-inline"
                                              onsubmit="return confirm('{{ __('are_you_sure') }}');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" 
                                                    class="btn-table-action btn-table-delete" 
                                                    title="{{ __('delete') }}">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Pagination --}}
            @if($users->hasPages())
            <div class="list-pagination">
                <div class="pagination-info">
                    {{ __('Showing') }} {{ $users->firstItem() }} {{ __('to') }} {{ $users->lastItem() }} {{ __('of') }} {{ $users->total() }} {{ __('entries') }}
                </div>
                <div class="pagination-links">
                    {{ $users->links() }}
                </div>
            </div>
            @endif
        @else
            <div class="list-empty-state">
                <div class="list-empty-icon">
                    <i class="bi bi-people"></i>
                </div>
                <h4>{{ __('no_users_found') }}</h4>
                <p>{{ __('No users found. Add your first user to get started.') }}</p>
                <a href="{{ route('admin.users.create') }}" class="btn-create">
                    <i class="bi bi-plus-lg"></i>
                    {{ __('add_user') }}
                </a>
            </div>
        @endif
    </div>
</div>
@endsection