@extends('layouts.app')

@section('title', __('vehicle_types') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/adminlistpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header --}}
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-tags"></i>
                {{ __('vehicle_types') }}
            </h1>
            <p class="list-page-subtitle">{{ __('Manage vehicle categories and their configurations') }}</p>
        </div>
        <div class="list-page-header-actions">
            <a href="{{ route('admin.vehicle-types.create') }}" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                {{ __('add_vehicle_type') }}
            </a>
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- Stats Bar --}}
    <div class="list-stats-bar">
        <div class="list-stat-card gradient-violet">
            <div class="list-stat-icon">
                <i class="bi bi-tags"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $vehicleTypes->total() }}</div>
                <div class="list-stat-label">{{ __('Total Types') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-collection"></i>
                {{ __('All Categories') }}
            </div>
        </div>

        <div class="list-stat-card gradient-green">
            <div class="list-stat-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $vehicleTypes->where('status', 'active')->count() }}</div>
                <div class="list-stat-label">{{ __('active') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-play-circle"></i>
                {{ __('Available') }}
            </div>
        </div>

        <div class="list-stat-card gradient-rose">
            <div class="list-stat-icon">
                <i class="bi bi-x-circle"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $vehicleTypes->where('status', 'inactive')->count() }}</div>
                <div class="list-stat-label">{{ __('inactive') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-pause-circle"></i>
                {{ __('Disabled') }}
            </div>
        </div>

        <div class="list-stat-card gradient-cyan">
            <div class="list-stat-icon">
                <i class="bi bi-currency-dollar"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">${{ number_format($vehicleTypes->avg('base_price') ?? 0, 0) }}</div>
                <div class="list-stat-label">{{ __('Avg. Price') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-graph-up"></i>
                {{ __('Base Rate') }}
            </div>
        </div>
    </div>

    {{-- Filter Bar --}}
    <div class="list-filter-bar">
        <div class="list-filter-header">
            <div class="list-filter-title">
                <i class="bi bi-funnel"></i>
                {{ __('Filters') }}
            </div>
            @if(request()->hasAny(['search']))
                <a href="{{ route('admin.vehicle-types.index') }}" class="list-filter-clear">
                    <i class="bi bi-x-circle"></i>
                    {{ __('Clear Filters') }}
                </a>
            @endif
        </div>
        <form action="{{ route('admin.vehicle-types.index') }}" method="GET">
            <div class="list-filter-row">
                <div class="list-filter-group search-group">
                    <label>{{ __('search') }}</label>
                    <div class="list-search-box">
                        <i class="bi bi-search"></i>
                        <input type="text" name="search" class="form-control" 
                               placeholder="{{ __('search') }}..." 
                               value="{{ request('search') }}">
                    </div>
                </div>
                <div class="list-filter-group">
                    <label>&nbsp;</label>
                    <button type="submit" class="btn-filter">
                        <i class="bi bi-funnel"></i>
                        {{ __('Filter') }}
                    </button>
                </div>
            </div>
        </form>
    </div>

    {{-- Data Table --}}
    <div class="list-table-container">
        <div class="list-table-header">
            <h5 class="list-table-title">
                <i class="bi bi-table"></i>
                {{ __('vehicle_types') }}
                <span class="list-table-count">({{ $vehicleTypes->total() }} {{ __('records') }})</span>
            </h5>
        </div>

        <table class="list-table">
            <thead>
                <tr>
                    <th>{{ __('name') }}</th>
                    <th>{{ __('capacity') }}</th>
                    <th>{{ __('base_price') }}</th>
                    <th>{{ __('description') }}</th>
                    <th>{{ __('status') }}</th>
                    <th>{{ __('actions') }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse($vehicleTypes as $vehicleType)
                <tr>
                    <td>
                        <div class="table-cell-main">
                            <i class="bi bi-truck text-primary me-2"></i>
                            <strong>{{ $vehicleType->name }}</strong>
                        </div>
                    </td>
                    <td>
                        <span class="table-cell-text">
                            <i class="bi bi-box text-muted me-1"></i>
                            {{ $vehicleType->capacity }}
                        </span>
                    </td>
                    <td>
                        <span class="table-badge table-badge-info">
                            <i class="bi bi-currency-dollar"></i>
                            {{ number_format($vehicleType->base_price, 2) }}
                        </span>
                    </td>
                    <td>
                        <span class="table-cell-text text-muted">
                            {{ $vehicleType->description ?? '-' }}
                        </span>
                    </td>
                    <td>
                        @if($vehicleType->status === 'active')
                            <span class="table-badge table-badge-success">
                                <i class="bi bi-check-circle"></i>
                                {{ __('active') }}
                            </span>
                        @else
                            <span class="table-badge table-badge-danger">
                                <i class="bi bi-x-circle"></i>
                                {{ __('inactive') }}
                            </span>
                        @endif
                    </td>
                    <td>
                        <div class="table-actions">
                            <a href="{{ route('admin.vehicle-types.edit', $vehicleType) }}" 
                               class="btn-table-action btn-table-edit" 
                               title="{{ __('edit') }}">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <form action="{{ route('admin.vehicle-types.destroy', $vehicleType) }}" 
                                  method="POST" 
                                  class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" 
                                        class="btn-table-action btn-table-delete delete-confirm" 
                                        title="{{ __('delete') }}">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6">
                        <div class="list-empty-state">
                            <div class="list-empty-state-icon">
                                <i class="bi bi-tags"></i>
                            </div>
                            <h5 class="list-empty-state-title">{{ __('no_records') }}</h5>
                            <p class="list-empty-state-text">{{ __('No vehicle types found. Add a new type to get started.') }}</p>
                            <a href="{{ route('admin.vehicle-types.create') }}" class="btn-create">
                                <i class="bi bi-plus-lg"></i>
                                {{ __('add_vehicle_type') }}
                            </a>
                        </div>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>

        {{-- Pagination --}}
        @if($vehicleTypes->hasPages())
        <div class="list-pagination">
            <div class="list-pagination-info">
                {{ __('Showing') }} {{ $vehicleTypes->firstItem() }} {{ __('to') }} {{ $vehicleTypes->lastItem() }} {{ __('of') }} {{ $vehicleTypes->total() }} {{ __('entries') }}
            </div>
            <div class="list-pagination-nav">
                {{ $vehicleTypes->links() }}
            </div>
        </div>
        @endif
    </div>
</div>
@endsection