@extends('layouts.app')

@section('title', __('add_vehicle') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admincreatepage.css') }}">
@endpush

@section('content')
<div class="create-page-container">
    {{-- Page Header --}}
    <div class="create-page-header">
        <div class="create-page-header-content">
            <div class="create-page-breadcrumb">
                <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.vehicles.index') }}">{{ __('vehicles') }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ __('Create') }}</span>
            </div>
            <h1 class="create-page-title">
                <div class="create-page-title-icon">
                    <i class="bi bi-plus-lg"></i>
                </div>
                {{ __('add_vehicle') }}
            </h1>
            <p class="create-page-subtitle">{{ __('Fill in the details below to add a new vehicle to your fleet') }}</p>
        </div>
        <div class="create-page-actions">
            <a href="{{ route('admin.vehicles.index') }}" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('cancel') }}
            </a>
        </div>
    </div>

    {{-- Validation Errors --}}
    @if($errors->any())
        <div class="create-alert danger">
            <div class="create-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="create-alert-content">
                <div class="create-alert-title">{{ __('Validation Error') }}</div>
                <div class="create-alert-text">{{ __('Please check the form and fix the errors below.') }}</div>
            </div>
        </div>
    @endif

    <form action="{{ route('admin.vehicles.store') }}" method="POST">
        @csrf
        <div class="create-form-layout">
            {{-- Main Form --}}
            <div class="create-form-main">
                {{-- Vehicle Information Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-icon primary">
                            <i class="bi bi-truck"></i>
                        </div>
                        <div>
                            <h5 class="create-card-title">{{ __('Vehicle Information') }}</h5>
                            <p class="create-card-subtitle">{{ __('Enter the basic vehicle details') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="vehicle_type_id" class="create-label required">{{ __('vehicle_type') }}</label>
                                <select class="create-select @error('vehicle_type_id') is-invalid @enderror" 
                                        id="vehicle_type_id" name="vehicle_type_id" required>
                                    <option value="">{{ __('select_option') }}</option>
                                    @foreach($vehicleTypes as $type)
                                        <option value="{{ $type->id }}" 
                                                {{ old('vehicle_type_id') == $type->id ? 'selected' : '' }}>
                                            {{ $type->name }} ({{ $type->capacity }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('vehicle_type_id')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="create-form-group">
                                <label for="vehicle_number" class="create-label required">{{ __('vehicle_number') }}</label>
                                <input type="text" 
                                       class="create-input @error('vehicle_number') is-invalid @enderror" 
                                       id="vehicle_number" 
                                       name="vehicle_number" 
                                       value="{{ old('vehicle_number') }}"
                                       placeholder="e.g., MH-01-AB-1234"
                                       required>
                                @error('vehicle_number')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-group">
                            <label for="status" class="create-label required">{{ __('status') }}</label>
                            <select class="create-select @error('status') is-invalid @enderror" 
                                    id="status" name="status" required>
                                <option value="active" {{ old('status') === 'active' ? 'selected' : '' }}>
                                    {{ __('active') }}
                                </option>
                                <option value="inactive" {{ old('status') === 'inactive' ? 'selected' : '' }}>
                                    {{ __('inactive') }}
                                </option>
                                <option value="maintenance" {{ old('status') === 'maintenance' ? 'selected' : '' }}>
                                    {{ __('maintenance') }}
                                </option>
                            </select>
                            @error('status')
                                <div class="create-error">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Registration & Insurance Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-icon info">
                            <i class="bi bi-calendar-check"></i>
                        </div>
                        <div>
                            <h5 class="create-card-title">{{ __('Registration & Insurance') }}</h5>
                            <p class="create-card-subtitle">{{ __('Important dates for vehicle compliance') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="registration_date" class="create-label">{{ __('registration_date') }}</label>
                                <input type="date" 
                                       class="create-input @error('registration_date') is-invalid @enderror" 
                                       id="registration_date" 
                                       name="registration_date" 
                                       value="{{ old('registration_date') }}">
                                @error('registration_date')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="create-form-group">
                                <label for="insurance_expiry" class="create-label">{{ __('insurance_expiry') }}</label>
                                <input type="date" 
                                       class="create-input @error('insurance_expiry') is-invalid @enderror" 
                                       id="insurance_expiry" 
                                       name="insurance_expiry" 
                                       value="{{ old('insurance_expiry') }}">
                                @error('insurance_expiry')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                                <small class="create-help">{{ __('Keep track of insurance renewal dates') }}</small>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Additional Information Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-icon warning">
                            <i class="bi bi-sticky"></i>
                        </div>
                        <div>
                            <h5 class="create-card-title">{{ __('Additional Information') }}</h5>
                            <p class="create-card-subtitle">{{ __('Any extra notes about this vehicle') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-group">
                            <label for="notes" class="create-label">{{ __('notes') }}</label>
                            <textarea class="create-textarea @error('notes') is-invalid @enderror" 
                                      id="notes" 
                                      name="notes" 
                                      rows="3"
                                      placeholder="{{ __('Any additional information about the vehicle...') }}">{{ old('notes') }}</textarea>
                            @error('notes')
                                <div class="create-error">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Form Actions --}}
                <div class="create-card">
                    <div class="create-card-body">
                        <div class="create-form-actions">
                            <a href="{{ route('admin.vehicles.index') }}" class="create-btn create-btn-secondary">
                                <i class="bi bi-x-lg"></i>
                                {{ __('cancel') }}
                            </a>
                            <button type="submit" class="create-btn create-btn-primary">
                                <i class="bi bi-check-circle"></i>
                                {{ __('save') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Sidebar --}}
            <div class="create-form-sidebar">
                {{-- Tips Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon info">
                            <i class="bi bi-lightbulb"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Quick Tips') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Use a unique vehicle number for easy identification') }}</span>
                            </li>
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Select the appropriate vehicle type to match cargo requirements') }}</span>
                            </li>
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Keep insurance dates updated for compliance tracking') }}</span>
                            </li>
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Set status to maintenance if the vehicle is under service') }}</span>
                            </li>
                        </ul>
                    </div>
                </div>

                {{-- Status Guide Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon warning">
                            <i class="bi bi-info-circle"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Status Guide') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-status-guide">
                            <div class="create-status-item">
                                <span class="create-status-badge active">
                                    <i class="bi bi-check-circle"></i>
                                    {{ __('active') }}
                                </span>
                                <p>{{ __('Vehicle is ready for trips') }}</p>
                            </div>
                            <div class="create-status-item">
                                <span class="create-status-badge pending">
                                    <i class="bi bi-tools"></i>
                                    {{ __('maintenance') }}
                                </span>
                                <p>{{ __('Vehicle under service') }}</p>
                            </div>
                            <div class="create-status-item">
                                <span class="create-status-badge danger">
                                    <i class="bi bi-x-circle"></i>
                                    {{ __('inactive') }}
                                </span>
                                <p>{{ __('Vehicle not available') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Quick Actions Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon success">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Quick Actions') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="{{ route('admin.vehicles.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                {{ __('View All Vehicles') }}
                            </a>
                            <a href="{{ route('admin.vehicle-types.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-tags"></i>
                                {{ __('Manage Vehicle Types') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection