<?php


use App\Http\Controllers\Api\DriverApiController;
use Illuminate\Support\Facades\Route;


/*
|--------------------------------------------------------------------------
| Driver Mobile App API Routes
|--------------------------------------------------------------------------
|
| These routes are for the Flutter driver mobile application.
| All routes use Sanctum authentication except login.
|
*/


Route::get('/test', function () {
    return response()->json(['message' => 'API is working!']);
});
// Public routes (no authentication required)
Route::prefix('driver')->group(function () {
    Route::post('/login', [DriverApiController::class, 'login']);
});

// Protected routes (require Sanctum authentication)
Route::middleware('auth:sanctum')->prefix('driver')->group(function () {
    // Authentication
    Route::post('/logout', [DriverApiController::class, 'logout']);
    Route::get('/profile', [DriverApiController::class, 'profile']);

    // Dashboard
    Route::get('/dashboard', [DriverApiController::class, 'dashboard']);

    // Trips
    Route::get('/trips', [DriverApiController::class, 'trips']);
    Route::get('/trips/{id}', [DriverApiController::class, 'tripDetails']);
    Route::post('/trips/{id}/update-status', [DriverApiController::class, 'updateTripStatus']);

    // Deliveries
    Route::post('/trips/{id}/delivery', [DriverApiController::class, 'createDelivery']);
    Route::get('/trips/{id}/deliveries', [DriverApiController::class, 'tripDeliveries']);
});
