<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\VehicleTypeController;
use App\Http\Controllers\Admin\VehicleController;
use App\Http\Controllers\Admin\DriverController;
use App\Http\Controllers\Admin\TripController;
use App\Http\Controllers\Admin\DeliveryController;
use App\Http\Controllers\Admin\CostController;
use App\Http\Controllers\Admin\CostReportController;
use App\Http\Controllers\Admin\MaintenanceController;
use App\Http\Controllers\Admin\MaintenanceTypeController;
use App\Http\Controllers\Admin\FuelLogController;
use App\Http\Controllers\Admin\FuelReportController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\ShipmentController;
use App\Http\Controllers\Admin\TripReportController;
use App\Http\Controllers\RouteOptimizerController;
use App\Http\Controllers\TrackingController;

// Language switcher (no authentication required)
Route::get('/lang/{locale}', function ($locale) {
    if (in_array($locale, ['en', 'es', 'hi', 'ta'])) {
        session(['locale' => $locale]);
    }
    return redirect()->back();
})->name('lang.switch');

// Guest routes (only accessible when NOT logged in)
Route::middleware('guest')->group(function () {
    Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [LoginController::class, 'login']);
    Route::get('/privacy', [LoginController::class, 'privacy'])->name('privacy');
});


Route::middleware(['auth'])->group(function () {
    Route::get('/route-optimizer', [RouteOptimizerController::class, 'index'])
        ->name('route-optimizer.index');
    Route::post('/route-optimizer/optimize', [RouteOptimizerController::class, 'optimize'])
        ->name('route-optimizer.optimize');
    Route::post('/route-optimizer/apply', [RouteOptimizerController::class, 'applyRoute'])
        ->name('route-optimizer.apply');

    Route::post('trips/{trip}/update-location-sequence', [TripController::class, 'updateLocationSequence'])
        ->name('admin.trips.update-location-sequence');

    // Route optimizer preview
    Route::get('route-optimizer/preview', [RouteOptimizerController::class, 'getRoutePreview'])
        ->name('route-optimizer.preview');
});

// Authenticated routes (all admin routes)
Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {



    // Logout
    Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

    // Dashboard - accessible to all authenticated users
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // ============================================
    // VEHICLE TYPES - Requires vehicle_types permissions
    // ============================================
    Route::middleware(['permission:vehicle_types.view'])->group(function () {
        Route::get('/vehicle-types', [VehicleTypeController::class, 'index'])->name('vehicle-types.index');
    });

    Route::middleware(['permission:vehicle_types.create'])->group(function () {
        Route::get('/vehicle-types/create', [VehicleTypeController::class, 'create'])->name('vehicle-types.create');
        Route::post('/vehicle-types', [VehicleTypeController::class, 'store'])->name('vehicle-types.store');
    });

    Route::middleware(['permission:vehicle_types.edit'])->group(function () {
        Route::get('/vehicle-types/{vehicleType}/edit', [VehicleTypeController::class, 'edit'])->name('vehicle-types.edit');
        Route::put('/vehicle-types/{vehicleType}', [VehicleTypeController::class, 'update'])->name('vehicle-types.update');
    });

    Route::middleware(['permission:vehicle_types.delete'])->group(function () {
        Route::delete('/vehicle-types/{vehicleType}', [VehicleTypeController::class, 'destroy'])->name('vehicle-types.destroy');
    });

    // ============================================
    // VEHICLES - Requires vehicles permissions
    // ============================================
    Route::middleware(['permission:vehicles.view'])->group(function () {
        Route::get('/vehicles', [VehicleController::class, 'index'])->name('vehicles.index');
    });

    Route::middleware(['permission:vehicles.create'])->group(function () {
        Route::get('/vehicles/create', [VehicleController::class, 'create'])->name('vehicles.create');
        Route::post('/vehicles', [VehicleController::class, 'store'])->name('vehicles.store');
    });

    Route::middleware(['permission:vehicles.edit'])->group(function () {
        Route::get('/vehicles/{vehicle}/edit', [VehicleController::class, 'edit'])->name('vehicles.edit');
        Route::put('/vehicles/{vehicle}', [VehicleController::class, 'update'])->name('vehicles.update');
    });

    Route::middleware(['permission:vehicles.delete'])->group(function () {
        Route::delete('/vehicles/{vehicle}', [VehicleController::class, 'destroy'])->name('vehicles.destroy');
    });

    // ============================================
    // DRIVERS - Requires drivers permissions
    // ============================================
    Route::middleware(['permission:drivers.view'])->group(function () {
        Route::get('/drivers', [DriverController::class, 'index'])->name('drivers.index');
        Route::get('/drivers/check-availability/{driver}', [DriverController::class, 'checkAvailability'])->name('drivers.check-availability');
    });

    Route::middleware(['permission:drivers.create'])->group(function () {
        Route::get('/drivers/create', [DriverController::class, 'create'])->name('drivers.create');
        Route::post('/drivers', [DriverController::class, 'store'])->name('drivers.store');
    });

    Route::middleware(['permission:drivers.edit'])->group(function () {
        Route::get('/drivers/{driver}/edit', [DriverController::class, 'edit'])->name('drivers.edit');
        Route::put('/drivers/{driver}', [DriverController::class, 'update'])->name('drivers.update');
    });

    Route::middleware(['permission:drivers.delete'])->group(function () {
        Route::delete('/drivers/{driver}', [DriverController::class, 'destroy'])->name('drivers.destroy');
    });

    // ============================================
    // TRIPS - Requires trips permissions
    // FIXED: Specific routes BEFORE parameterized routes
    // ============================================
    Route::middleware(['permission:trips.create'])->group(function () {
        Route::get('/trips/create', [TripController::class, 'create'])->name('trips.create');
        Route::post('/trips', [TripController::class, 'store'])->name('trips.store');
        Route::post('/trips/{trip}/upload-file', [TripController::class, 'uploadFile'])->name('trips.upload-file');
    });

    Route::middleware(['permission:trips.edit'])->group(function () {
        Route::get('/trips/{trip}/edit', [TripController::class, 'edit'])->name('trips.edit');
        Route::put('/trips/{trip}', [TripController::class, 'update'])->name('trips.update');
    });

    Route::middleware(['permission:trips.view'])->group(function () {
        Route::get('/trips', [TripController::class, 'index'])->name('trips.index');
        Route::get('/trips/{trip}', [TripController::class, 'show'])->name('trips.show');
    });

    Route::middleware(['permission:trips.delete'])->group(function () {
        Route::delete('/trips/{trip}', [TripController::class, 'destroy'])->name('trips.destroy');
    });

    // ============================================
    // DELIVERIES - Requires deliveries permissions
    // FIXED: Specific routes BEFORE parameterized routes
    // ============================================
    Route::middleware(['permission:deliveries.create'])->group(function () {
        Route::get('/deliveries/create', [DeliveryController::class, 'create'])->name('deliveries.create');
        Route::post('/deliveries', [DeliveryController::class, 'store'])->name('deliveries.store');
    });

    Route::middleware(['permission:deliveries.edit'])->group(function () {
        Route::get('/deliveries/{delivery}/edit', [DeliveryController::class, 'edit'])->name('deliveries.edit');
        Route::put('/deliveries/{delivery}', [DeliveryController::class, 'update'])->name('deliveries.update');
    });

    Route::middleware(['permission:deliveries.view'])->group(function () {
        Route::get('/deliveries', [DeliveryController::class, 'index'])->name('deliveries.index');
        Route::get('/deliveries/{delivery}', [DeliveryController::class, 'show'])->name('deliveries.show');
        Route::get('/deliveries/{delivery}/download-pod', [DeliveryController::class, 'downloadPod'])->name('deliveries.download-pod');
        Route::get('/deliveries/{delivery}/download-signature', [DeliveryController::class, 'downloadSignature'])->name('deliveries.download-signature');
    });

    Route::middleware(['permission:deliveries.delete'])->group(function () {
        Route::delete('/deliveries/{delivery}', [DeliveryController::class, 'destroy'])->name('deliveries.destroy');
    });

    // ============================================
    // SHIPMENTS - Requires shipments permissions
    // FIXED: Specific routes BEFORE parameterized routes
    // ============================================
    Route::middleware(['permission:shipments.create'])->group(function () {
        Route::get('/shipments/create', [ShipmentController::class, 'create'])->name('shipments.create');
        Route::post('/shipments', [ShipmentController::class, 'store'])->name('shipments.store');
    });

    Route::middleware(['permission:shipments.edit'])->group(function () {
        Route::get('/shipments/{shipment}/edit', [ShipmentController::class, 'edit'])->name('shipments.edit');
        Route::put('/shipments/{shipment}', [ShipmentController::class, 'update'])->name('shipments.update');
        Route::patch('/shipments/{shipment}/cancel', [ShipmentController::class, 'cancel'])->name('shipments.cancel');
    });

    Route::middleware(['permission:shipments.assign'])->group(function () {
        Route::get('/shipments/{shipment}/assign-vehicle', [ShipmentController::class, 'assignVehicle'])->name('shipments.assign-vehicle');
        Route::post('/shipments/{shipment}/store-assignment', [ShipmentController::class, 'storeAssignment'])->name('shipments.store-assignment');
    });

    Route::middleware(['permission:shipments.view'])->group(function () {
        Route::get('/shipments', [ShipmentController::class, 'index'])->name('shipments.index');
        Route::get('/shipments/{shipment}', [ShipmentController::class, 'show'])->name('shipments.show');
    });

    Route::middleware(['permission:shipments.delete'])->group(function () {
        Route::delete('/shipments/{shipment}', [ShipmentController::class, 'destroy'])->name('shipments.destroy');
    });

    // ============================================
    // COSTS - Uses trips permissions (costs are part of trips)
    // FIXED: Specific routes BEFORE parameterized routes
    // ============================================
    Route::middleware(['permission:trips.create'])->group(function () {
        Route::get('/costs/create', [CostController::class, 'create'])->name('costs.create');
        Route::post('/costs', [CostController::class, 'store'])->name('costs.store');
    });

    Route::middleware(['permission:trips.edit'])->group(function () {
        Route::get('/costs/{cost}/edit', [CostController::class, 'edit'])->name('costs.edit');
        Route::put('/costs/{cost}', [CostController::class, 'update'])->name('costs.update');
    });

    Route::middleware(['permission:trips.view'])->group(function () {
        Route::get('/costs', [CostController::class, 'index'])->name('costs.index');
    });

    // ============================================
    // USERS - Requires users permissions
    // ============================================
    Route::middleware(['permission:users.view'])->group(function () {
        Route::get('/users', [UserController::class, 'index'])->name('users.index');
    });

    Route::middleware(['permission:users.create'])->group(function () {
        Route::get('/users/create', [UserController::class, 'create'])->name('users.create');
        Route::post('/users', [UserController::class, 'store'])->name('users.store');
    });

    Route::middleware(['permission:users.edit'])->group(function () {
        Route::get('/users/{user}/edit', [UserController::class, 'edit'])->name('users.edit');
        Route::put('/users/{user}', [UserController::class, 'update'])->name('users.update');
    });

    Route::middleware(['permission:users.delete'])->group(function () {
        Route::delete('/users/{user}', [UserController::class, 'destroy'])->name('users.destroy');
    });

    // ============================================
    // ROLES & PERMISSIONS - Requires roles permissions
    // ============================================
    Route::middleware(['permission:roles.view'])->group(function () {
        Route::get('/roles', [RoleController::class, 'index'])->name('roles.index');
    });

    Route::middleware(['permission:roles.create'])->group(function () {
        Route::get('/roles/create', [RoleController::class, 'create'])->name('roles.create');
        Route::post('/roles', [RoleController::class, 'store'])->name('roles.store');
    });

    Route::middleware(['permission:roles.edit'])->group(function () {
        Route::get('/roles/{role}/edit', [RoleController::class, 'edit'])->name('roles.edit');
        Route::put('/roles/{role}', [RoleController::class, 'update'])->name('roles.update');
    });

    Route::middleware(['permission:roles.delete'])->group(function () {
        Route::delete('/roles/{role}', [RoleController::class, 'destroy'])->name('roles.destroy');
    });

    // ============================================
    // TRACKING
    // ============================================
    Route::get('/tracking', [TrackingController::class, 'index'])->name('tracking.index');
    Route::get('/tracking/locations', [TrackingController::class, 'getDriverLocations'])->name('tracking.locations');
    Route::get('/tracking/driver/{driverId}', [TrackingController::class, 'getDriverLocation'])->name('tracking.driver');

    // ============================================
    // MAINTENANCE TYPES - Requires maintenance_types permissions
    // ============================================
    Route::middleware(['permission:maintenance_types.view'])->group(function () {
        Route::get('/maintenance-types', [MaintenanceTypeController::class, 'index'])->name('maintenance-types.index');
    });

    Route::middleware(['permission:maintenance_types.create'])->group(function () {
        Route::get('/maintenance-types/create', [MaintenanceTypeController::class, 'create'])->name('maintenance-types.create');
        Route::post('/maintenance-types', [MaintenanceTypeController::class, 'store'])->name('maintenance-types.store');
    });

    Route::middleware(['permission:maintenance_types.edit'])->group(function () {
        Route::get('/maintenance-types/{maintenanceType}/edit', [MaintenanceTypeController::class, 'edit'])->name('maintenance-types.edit');
        Route::put('/maintenance-types/{maintenanceType}', [MaintenanceTypeController::class, 'update'])->name('maintenance-types.update');
    });

    Route::middleware(['permission:maintenance_types.delete'])->group(function () {
        Route::delete('/maintenance-types/{maintenanceType}', [MaintenanceTypeController::class, 'destroy'])->name('maintenance-types.destroy');
    });

    // ============================================
    // MAINTENANCES - Requires maintenance permissions
    // IMPORTANT: Static routes MUST come before dynamic {maintenance} routes
    // ============================================
    Route::middleware(['permission:maintenance.create'])->group(function () {
        Route::get('/maintenances/create', [MaintenanceController::class, 'create'])->name('maintenances.create');
        Route::post('/maintenances', [MaintenanceController::class, 'store'])->name('maintenances.store');
    });

    Route::middleware(['permission:maintenance.view'])->group(function () {
        Route::get('/maintenances', [MaintenanceController::class, 'index'])->name('maintenances.index');
        Route::get('/maintenances/due-soon', [MaintenanceController::class, 'dueSoon'])->name('maintenances.due-soon');
        Route::get('/maintenances/overdue', [MaintenanceController::class, 'overdue'])->name('maintenances.overdue');
        Route::get('/maintenances/vehicle/{vehicle}/history', [MaintenanceController::class, 'vehicleHistory'])->name('maintenances.vehicle-history');
        Route::get('/maintenances/{maintenance}', [MaintenanceController::class, 'show'])->name('maintenances.show');
    });

    Route::middleware(['permission:maintenance.edit'])->group(function () {
        Route::get('/maintenances/{maintenance}/edit', [MaintenanceController::class, 'edit'])->name('maintenances.edit');
        Route::put('/maintenances/{maintenance}', [MaintenanceController::class, 'update'])->name('maintenances.update');
    });

    Route::middleware(['permission:maintenance.delete'])->group(function () {
        Route::delete('/maintenances/{maintenance}', [MaintenanceController::class, 'destroy'])->name('maintenances.destroy');
    });

    // ============================================
    // FUEL LOGS - Requires fuel permissions
    // IMPORTANT: Static routes MUST come before dynamic {fuelLog} routes
    // ============================================
    Route::middleware(['permission:fuel.create'])->group(function () {
        Route::get('/fuel-logs/create', [FuelLogController::class, 'create'])->name('fuel-logs.create');
        Route::post('/fuel-logs', [FuelLogController::class, 'store'])->name('fuel-logs.store');
        Route::post('/fuel-logs/get-previous-odometer', [FuelLogController::class, 'getPreviousOdometer'])->name('fuel-logs.get-previous-odometer');
    });

    Route::middleware(['permission:fuel.view'])->group(function () {
        Route::get('/fuel-logs', [FuelLogController::class, 'index'])->name('fuel-logs.index');
        Route::get('/fuel-logs/vehicle/{vehicle}/history', [FuelLogController::class, 'vehicleHistory'])->name('fuel-logs.vehicle-history');
        Route::get('/fuel-logs/{fuelLog}', [FuelLogController::class, 'show'])->name('fuel-logs.show');
    });

    Route::middleware(['permission:fuel.edit'])->group(function () {
        Route::get('/fuel-logs/{fuelLog}/edit', [FuelLogController::class, 'edit'])->name('fuel-logs.edit');
        Route::put('/fuel-logs/{fuelLog}', [FuelLogController::class, 'update'])->name('fuel-logs.update');
    });

    Route::middleware(['permission:fuel.delete'])->group(function () {
        Route::delete('/fuel-logs/{fuelLog}', [FuelLogController::class, 'destroy'])->name('fuel-logs.destroy');
    });

    // ============================================
    // REPORTS - Requires reports permissions
    // IMPORTANT: Specific routes (fuel, trip, cost) MUST come BEFORE {report} routes
    // ============================================

    // ------------------------------------------
    // SEPARATE REPORT PAGES (MUST BE FIRST!)
    // ------------------------------------------
    Route::middleware(['permission:reports.view'])->group(function () {
        // Fuel Reports (Separate Page)
        Route::get('/reports/fuel', [FuelReportController::class, 'index'])->name('reports.fuel.index');
        Route::get('/reports/fuel/export', [FuelReportController::class, 'export'])->name('reports.fuel.export');

        // Trip Reports (Separate Page)
        Route::get('/reports/trip', [TripReportController::class, 'index'])->name('reports.trip.index');
        Route::get('/reports/trip/export', [TripReportController::class, 'export'])->name('reports.trip.export');

        // Cost Reports (Separate Page)
        Route::get('/reports/cost', [CostReportController::class, 'index'])->name('reports.cost.index');
        Route::get('/reports/cost/export', [CostReportController::class, 'export'])->name('reports.cost.export');
    });

    // ------------------------------------------
    // MAIN REPORT CRUD (After specific routes)
    // ------------------------------------------
    Route::middleware(['permission:reports.create'])->group(function () {
        Route::get('/reports/create', [ReportController::class, 'create'])->name('reports.create');
        Route::post('/reports', [ReportController::class, 'store'])->name('reports.store');
    });

    Route::middleware(['permission:reports.edit'])->group(function () {
        Route::get('/reports/{report}/edit', [ReportController::class, 'edit'])->name('reports.edit');
        Route::put('/reports/{report}', [ReportController::class, 'update'])->name('reports.update');
        Route::post('/reports/{report}/generate', [ReportController::class, 'generate'])->name('reports.generate');
    });

    Route::middleware(['permission:reports.view'])->group(function () {
        Route::get('/reports', [ReportController::class, 'index'])->name('reports.index');
        Route::get('/reports/{report}', [ReportController::class, 'show'])->name('reports.show');
    });

    Route::middleware(['permission:reports.export'])->group(function () {
        Route::get('/reports/{report}/download', [ReportController::class, 'download'])->name('reports.download');
    });

    Route::middleware(['permission:reports.delete'])->group(function () {
        Route::delete('/reports/{report}', [ReportController::class, 'destroy'])->name('reports.destroy');
    });
});

// Redirect root to login
Route::get('/', function () {
    return redirect()->route('login');
});

Route::get('/test-firebase', function () {
    try {
        $factory = (new \Kreait\Firebase\Factory)
            ->withServiceAccount(storage_path('app/firebase/credentials.json'))
            ->withDatabaseUri(config('firebase.database_url'));

        $database = $factory->createDatabase();
        $database->getReference('test')->set(['connected' => true, 'time' => time()]);

        return '✅ Firebase Connected Successfully!';
    } catch (\Exception $e) {
        return '❌ Error: ' . $e->getMessage();
    }
});

// TEMPORARY TEST ROUTE
Route::get('/test-firebase-driver/{id}', function ($id) {
    try {
        $factory = (new \Kreait\Firebase\Factory)
            ->withServiceAccount(storage_path('app/firebase/credentials.json'))
            ->withDatabaseUri(config('firebase.database_url'));

        $database = $factory->createDatabase();

        // Try both formats
        $ref1 = 'driver_locations/driver_' . $id;
        $ref2 = 'driver_locations/' . $id;

        $data1 = $database->getReference($ref1)->getValue();
        $data2 = $database->getReference($ref2)->getValue();

        return response()->json([
            'driver_id' => $id,
            'reference_1' => $ref1,
            'data_1' => $data1,
            'reference_2' => $ref2,
            'data_2' => $data2,
            'all_drivers' => $database->getReference('driver_locations')->getValue()
        ]);
    } catch (\Exception $e) {
        return response()->json(['error' => $e->getMessage()]);
    }
});
