<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" data-theme="light">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', __('app_name')); ?></title>

    <!-- Bootstrap 5.3 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">

    <!-- Poppins Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap"
        rel="stylesheet">

    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('css/custom.css')); ?>">

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body>
    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar">
        <!-- Sidebar Header / Brand -->
        <div class="sidebar-header">
            <div class="sidebar-brand">
                <div class="brand-icon">
                    <i class="bi bi-truck"></i>
                </div>
                <div class="brand-text">
                    <span class="brand-name">LogiFleet</span>
                    <span class="brand-subtitle">Admin Dashboard</span>
                  
                </div>
            </div>
        </div>

        <!-- Sidebar Menu -->
        <nav class="sidebar-nav">
            <!-- Main Navigation Section -->
            <div class="nav-section">
                <span class="nav-section-title"><?php echo e(__('Main Navigation')); ?></span>
                <ul class="nav-menu">
                    <li class="nav-item">
                        <a href="<?php echo e(route('admin.dashboard')); ?>"
                            class="nav-link <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>">
                            <i class="bi bi-grid-1x2-fill"></i>
                            <span><?php echo e(__('dashboard')); ?></span>
                        </a>
                    </li>

                    <?php if(auth()->check() && auth()->user()->hasPermission('shipments.view')): ?>
                        <li class="nav-item has-submenu">
                            <a href="#shipmentSubmenu"
                                class="nav-link <?php echo e(request()->routeIs('admin.shipments.*') ? 'active' : ''); ?>"
                                data-bs-toggle="collapse"
                                aria-expanded="<?php echo e(request()->routeIs('admin.shipments.*') ? 'true' : 'false'); ?>">
                                <i class="bi bi-box-seam-fill"></i>
                                <span><?php echo e(__('shipments')); ?></span>
                                <i class="bi bi-chevron-down submenu-arrow"></i>
                            </a>
                            <ul class="submenu collapse <?php echo e(request()->routeIs('admin.shipments.*') ? 'show' : ''); ?>"
                                id="shipmentSubmenu">
                                <li>
                                    <a href="<?php echo e(route('admin.shipments.index')); ?>"
                                        class="<?php echo e(request()->routeIs('admin.shipments.index') ? 'active' : ''); ?>">
                                        <span><?php echo e(__('All Shipments')); ?></span>
                                    </a>
                                </li>
                                <?php if(auth()->user()->hasPermission('shipments.create')): ?>
                                    <li>
                                        <a href="<?php echo e(route('admin.shipments.create')); ?>"
                                            class="<?php echo e(request()->routeIs('admin.shipments.create') ? 'active' : ''); ?>">
                                            <span><?php echo e(__('New Shipment')); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </li>
                    <?php endif; ?>

                    <?php if(auth()->check() && auth()->user()->hasPermission('trips.view')): ?>
                        <li class="nav-item has-submenu">
                            <a href="#tripSubmenu"
                                class="nav-link <?php echo e(request()->routeIs('admin.trips.*') ? 'active' : ''); ?>"
                                data-bs-toggle="collapse"
                                aria-expanded="<?php echo e(request()->routeIs('admin.trips.*') ? 'true' : 'false'); ?>">
                                <i class="bi bi-signpost-split-fill"></i>
                                <span><?php echo e(__('trips')); ?></span>
                                <i class="bi bi-chevron-down submenu-arrow"></i>
                            </a>
                            <ul class="submenu collapse <?php echo e(request()->routeIs('admin.trips.*') ? 'show' : ''); ?>"
                                id="tripSubmenu">
                                <li>
                                    <a href="<?php echo e(route('admin.trips.index')); ?>"
                                        class="<?php echo e(request()->routeIs('admin.trips.index') ? 'active' : ''); ?>">
                                        <span><?php echo e(__('All Trips')); ?></span>
                                    </a>
                                </li>
                                <?php if(auth()->user()->hasPermission('trips.create')): ?>
                                    <li>
                                        <a href="<?php echo e(route('admin.trips.create')); ?>"
                                            class="<?php echo e(request()->routeIs('admin.trips.create') ? 'active' : ''); ?>">
                                            <span><?php echo e(__('New Trip')); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </li>
                    <?php endif; ?>

                    <?php if(auth()->check() && auth()->user()->hasPermission('deliveries.view')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.deliveries.index')); ?>"
                                class="nav-link <?php echo e(request()->routeIs('admin.deliveries.*') ? 'active' : ''); ?>">
                                <i class="bi bi-clipboard-check-fill"></i>
                                <span><?php echo e(__('deliveries')); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>

            <!-- Management Section -->
            <div class="nav-section">
                <span class="nav-section-title"><?php echo e(__('Management')); ?></span>
                <ul class="nav-menu">
                    <?php if(auth()->check() && auth()->user()->hasPermission('vehicles.view')): ?>
                        <li class="nav-item has-submenu">
                            <a href="#vehicleSubmenu"
                                class="nav-link <?php echo e(request()->routeIs('admin.vehicles.*') || request()->routeIs('admin.vehicle-types.*') ? 'active' : ''); ?>"
                                data-bs-toggle="collapse"
                                aria-expanded="<?php echo e(request()->routeIs('admin.vehicles.*') || request()->routeIs('admin.vehicle-types.*') ? 'true' : 'false'); ?>">
                                <i class="bi bi-truck-front-fill"></i>
                                <span><?php echo e(__('vehicles')); ?></span>
                                <i class="bi bi-chevron-down submenu-arrow"></i>
                            </a>
                            <ul class="submenu collapse <?php echo e(request()->routeIs('admin.vehicles.*') || request()->routeIs('admin.vehicle-types.*') || request()->routeIs('admin.maintenances.*') || request()->routeIs('admin.maintenance-types.*') || request()->routeIs('admin.fuel-logs.*') ? 'show' : ''); ?>"
                                id="vehicleSubmenu">
                                
                                
                                <?php if(auth()->check() && auth()->user()->hasPermission('vehicles.view')): ?>
                                    <li>
                                        <a href="<?php echo e(route('admin.vehicles.index')); ?>"
                                            class="<?php echo e(request()->routeIs('admin.vehicles.*') ? 'active' : ''); ?>">
                                            <span><?php echo e(__('All Vehicles')); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                
                                <?php if(auth()->check() && auth()->user()->hasPermission('vehicle_types.view')): ?>
                                    <li>
                                        <a href="<?php echo e(route('admin.vehicle-types.index')); ?>"
                                            class="<?php echo e(request()->routeIs('admin.vehicle-types.*') ? 'active' : ''); ?>">
                                            <span><?php echo e(__('Vehicle Types')); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                
                                <?php if(auth()->check() && auth()->user()->hasPermission('maintenance.view')): ?>
                                    <li>
                                        <a href="<?php echo e(route('admin.maintenances.index')); ?>"
                                            class="<?php echo e(request()->routeIs('admin.maintenances.*') ? 'active' : ''); ?>">
                                            <span><?php echo e(__('Maintenances')); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                
                                <?php if(auth()->check() && auth()->user()->hasPermission('maintenance_types.view')): ?>
                                    <li>
                                        <a href="<?php echo e(route('admin.maintenance-types.index')); ?>"
                                            class="<?php echo e(request()->routeIs('admin.maintenance-types.*') ? 'active' : ''); ?>">
                                            <span><?php echo e(__('Maintenance Types')); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                
                                <?php if(auth()->check() && auth()->user()->hasPermission('fuel.view')): ?>
                                    <li>
                                        <a href="<?php echo e(route('admin.fuel-logs.index')); ?>"
                                            class="<?php echo e(request()->routeIs('admin.fuel-logs.*') ? 'active' : ''); ?>">
                                            <span><?php echo e(__('Fuel Logs')); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </li>
                    <?php endif; ?>

                    <?php if(auth()->check() && auth()->user()->hasPermission('drivers.view')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.drivers.index')); ?>"
                                class="nav-link <?php echo e(request()->routeIs('admin.drivers.*') ? 'active' : ''); ?>">
                                <i class="bi bi-person-badge-fill"></i>
                                <span><?php echo e(__('drivers')); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <?php if(auth()->check() && auth()->user()->hasAnyPermission(['trips.view', 'trips.create', 'trips.edit'])): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.costs.index')); ?>"
                                class="nav-link <?php echo e(request()->routeIs('admin.costs.*') ? 'active' : ''); ?>">
                                <i class="bi bi-currency-dollar"></i>
                                <span><?php echo e(__('costs')); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <li class="nav-item">
                        <a href="<?php echo e(route('admin.tracking.index')); ?>"
                            class="nav-link <?php echo e(request()->routeIs('admin.tracking.*') ? 'active' : ''); ?>">
                            <i class="bi bi-geo-alt-fill"></i>
                            <span><?php echo e(__('Live Tracking')); ?></span>
                        </a>
                    </li>
                </ul>
            </div>
<div class="nav-section">
    <span class="nav-section-title"><?php echo e(__('AI Route Optimizer')); ?></span>
    <ul class="nav-menu">
        <li class="nav-item">
            <a href="<?php echo e(route('route-optimizer.index')); ?>" class="nav-link <?php echo e(request()->routeIs('route-optimizer.*') ? 'active' : ''); ?>">
                <i class="bi bi-magic"></i>
                <?php echo e(__('Route Optimizer')); ?>

            </a>
        </li>
    </ul>
</div>
            <!-- Analytics & Settings Section -->
            <div class="nav-section">
                <span class="nav-section-title"><?php echo e(__('Analytics & Settings')); ?></span>
                <ul class="nav-menu">
                    
                    <?php if(auth()->check() && auth()->user()->hasPermission('reports.view')): ?>
                        <li class="nav-item has-submenu">
                            <a href="#reportsSubmenu"
                                class="nav-link <?php echo e(request()->routeIs('admin.reports.*') ? 'active' : ''); ?>"
                                data-bs-toggle="collapse"
                                aria-expanded="<?php echo e(request()->routeIs('admin.reports.*') ? 'true' : 'false'); ?>">
                                <i class="bi bi-file-earmark-bar-graph-fill"></i>
                                <span><?php echo e(__('Reports')); ?></span>
                                <i class="bi bi-chevron-down submenu-arrow"></i>
                            </a>
                            <ul class="submenu collapse <?php echo e(request()->routeIs('admin.reports.*') ? 'show' : ''); ?>"
                                id="reportsSubmenu">
                                
                                <li>
                                    <a href="<?php echo e(route('admin.reports.index')); ?>"
                                        class="<?php echo e(request()->routeIs('admin.reports.index') && !request()->routeIs('admin.reports.fuel.*') && !request()->routeIs('admin.reports.trip.*') && !request()->routeIs('admin.reports.cost.*') ? 'active' : ''); ?>">
                                        <span><?php echo e(__('All Reports')); ?></span>
                                    </a>
                                </li>
                                
                                <?php if(auth()->user()->hasPermission('reports.create')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.reports.create')); ?>"
                                        class="<?php echo e(request()->routeIs('admin.reports.create') ? 'active' : ''); ?>">
                                        <span><?php echo e(__('New Report')); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                
                                <li>
                                    <a href="<?php echo e(route('admin.reports.fuel.index')); ?>"
                                        class="<?php echo e(request()->routeIs('admin.reports.fuel.*') ? 'active' : ''); ?>">
                                        <span><?php echo e(__('Fuel Report')); ?></span>
                                    </a>
                                </li>
                                
                                <li>
                                    <a href="<?php echo e(route('admin.reports.trip.index')); ?>"
                                        class="<?php echo e(request()->routeIs('admin.reports.trip.*') ? 'active' : ''); ?>">
                                        <span><?php echo e(__('Trip Report')); ?></span>
                                    </a>
                                </li>
                                
                                <li>
                                    <a href="<?php echo e(route('admin.reports.cost.index')); ?>"
                                        class="<?php echo e(request()->routeIs('admin.reports.cost.*') ? 'active' : ''); ?>">
                                        <span><?php echo e(__('Cost Report')); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </li>
                    <?php endif; ?>

                    <?php if(auth()->check() && auth()->user()->hasPermission('users.view')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.users.index')); ?>"
                                class="nav-link <?php echo e(request()->routeIs('admin.users.*') ? 'active' : ''); ?>">
                                <i class="bi bi-people-fill"></i>
                                <span><?php echo e(__('users')); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <?php if(auth()->check() && auth()->user()->hasPermission('roles.view')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.roles.index')); ?>"
                                class="nav-link <?php echo e(request()->routeIs('admin.roles.*') ? 'active' : ''); ?>">
                                <i class="bi bi-shield-lock-fill"></i>
                                <span><?php echo e(__('roles')); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
          

        </nav>

        <!-- Sidebar Footer - Theme Toggle -->
        <div class="sidebar-footer">
            <div class="theme-toggle" id="themeToggle">
                <i class="bi bi-sun-fill theme-icon-light"></i>
                <span class="theme-text"><?php echo e(__('Light Mode')); ?></span>
                <i class="bi bi-moon-fill theme-icon-dark"></i>
            </div>
        </div>
    </aside>

    <!-- Main Content -->
    <div class="main-content" id="mainContent">
        <!-- Top Header -->
        <header class="top-header">
            <div class="header-left">
                <button class="sidebar-toggle d-lg-none" id="sidebarToggle" aria-label="Toggle sidebar">
                    <i class="bi bi-list"></i>
                </button>
                <div class="page-info">
                    <h1 class="page-title"><?php echo $__env->yieldContent('page-title', __('dashboard')); ?></h1>
                    <p class="page-subtitle"><?php echo $__env->yieldContent('page-subtitle', __('Welcome back! Here\'s your logistics overview.')); ?></p>
                </div>
            </div>
            <div class="header-right">
                <!-- Language Switcher -->
                <div class="language-dropdown dropdown">
                    <button class="btn btn-lang dropdown-toggle" type="button" data-bs-toggle="dropdown"
                        aria-expanded="false">
                        <i class="bi bi-globe2"></i>
                        <span><?php echo e(strtoupper(app()->getLocale()) == 'EN' ? 'English' : (strtoupper(app()->getLocale()) == 'HI' ? 'हिंदी' : (strtoupper(app()->getLocale()) == 'ES' ? 'Español' : 'தமிழ்'))); ?></span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item <?php echo e(app()->getLocale() == 'en' ? 'active' : ''); ?>"
                                href="/lang/en"><span class="flag-icon">🇺🇸</span> English</a></li>
                        <li><a class="dropdown-item <?php echo e(app()->getLocale() == 'hi' ? 'active' : ''); ?>"
                                href="/lang/hi"><span class="flag-icon">🇮🇳</span> हिंदी</a></li>
                        <li><a class="dropdown-item <?php echo e(app()->getLocale() == 'es' ? 'active' : ''); ?>"
                                href="/lang/es"><span class="flag-icon">🇪🇸</span> Español</a></li>
                    </ul>
                </div>

                <!-- User Menu -->
                <div class="user-dropdown dropdown">
                    <?php if(auth()->check()): ?>
                        <button class="btn btn-user dropdown-toggle" type="button" data-bs-toggle="dropdown"
                            aria-expanded="false">
                            <div class="user-avatar">
                                <?php echo e(strtoupper(substr(auth()->user()->name, 0, 1))); ?>

                            </div>
                            <span class="user-name d-none d-md-inline"><?php echo e(auth()->user()->name); ?></span>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end user-menu-dropdown">
                            <li class="dropdown-header">
                                <strong><?php echo e(auth()->user()->name); ?></strong>
                                <?php if(auth()->user()->roles->isNotEmpty()): ?>
                                    <span class="badge bg-primary-subtle text-primary"><?php echo e(auth()->user()->roles->first()->display_name); ?></span>
                                <?php endif; ?>
                            </li>
                            <li>
                                <hr class="dropdown-divider">
                            </li>
                            <li>
                                <form action="<?php echo e(route('admin.logout')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="dropdown-item text-danger">
                                        <i class="bi bi-box-arrow-right"></i> <?php echo e(__('logout')); ?>

                                    </button>
                                </form>
                            </li>
                        </ul>
                    <?php endif; ?>
                </div>
            </div>
        </header>

        <!-- Page Content -->
        <main class="content-wrapper">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>

    <!-- Sidebar Overlay for Mobile -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <!-- Bootstrap 5.3 JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Theme & Sidebar Script -->
    <script>
        // Theme Toggle
        const themeToggle = document.getElementById('themeToggle');
        const html = document.documentElement;
        const themeText = themeToggle.querySelector('.theme-text');

        // Check for saved theme preference
        const savedTheme = localStorage.getItem('theme') || 'light';
        html.setAttribute('data-theme', savedTheme);
        updateThemeText(savedTheme);

        themeToggle.addEventListener('click', () => {
            const currentTheme = html.getAttribute('data-theme');
            const newTheme = currentTheme === 'light' ? 'dark' : 'light';

            html.setAttribute('data-theme', newTheme);
            localStorage.setItem('theme', newTheme);
            updateThemeText(newTheme);
        });

        function updateThemeText(theme) {
            themeText.textContent = theme === 'light' ? '<?php echo e(__('Light Mode')); ?>' : '<?php echo e(__('Dark Mode')); ?>';
        }

        // Mobile Sidebar Toggle
        const sidebar = document.getElementById('sidebar');
        const sidebarToggle = document.getElementById('sidebarToggle');
        const sidebarOverlay = document.getElementById('sidebarOverlay');

        if (sidebarToggle) {
            sidebarToggle.addEventListener('click', () => {
                sidebar.classList.toggle('show');
                sidebarOverlay.classList.toggle('show');
            });
        }

        if (sidebarOverlay) {
            sidebarOverlay.addEventListener('click', () => {
                sidebar.classList.remove('show');
                sidebarOverlay.classList.remove('show');
            });
        }

        // Submenu Arrow Rotation
        document.querySelectorAll('.has-submenu > .nav-link').forEach(link => {
            link.addEventListener('click', function() {
                const arrow = this.querySelector('.submenu-arrow');
                const isExpanded = this.getAttribute('aria-expanded') === 'true';
            });
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var activeItem = document.querySelector('.sidebar-nav .active');
            if (activeItem) {
                var sidebarMenu = document.querySelector('.sidebar-nav');
                if (sidebarMenu) {
                    setTimeout(function() {
                        var activeItemTop = activeItem.offsetTop;
                        var sidebarMenuHeight = sidebarMenu.clientHeight;
                        var activeItemHeight = activeItem.offsetHeight;
                        var scrollPosition = activeItemTop - (sidebarMenuHeight / 2) + (activeItemHeight / 2);
                        scrollPosition = Math.max(0, scrollPosition);
                        sidebarMenu.scrollTo({
                            top: scrollPosition,
                            behavior: 'smooth'
                        });
                    }, 100);
                }
            }
        });
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html><?php /**PATH D:\Laravel\fleet-management\resources\views/layouts/app.blade.php ENDPATH**/ ?>