<?php $__env->startSection('title', __('Create Report') . ' - ' . __('app_name')); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/admincreatepage.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="create-page-container">
    
    <div class="create-page-header">
        <div class="create-page-header-content">
            <div class="create-page-breadcrumb">
                <a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                <i class="bi bi-chevron-right"></i>
                <a href="<?php echo e(route('admin.reports.index')); ?>"><?php echo e(__('Reports')); ?></a>
                <i class="bi bi-chevron-right"></i>
                <span><?php echo e(__('Create')); ?></span>
            </div>
            <h1 class="create-page-title">
                <div class="create-page-title-icon">
                    <i class="bi bi-plus-lg"></i>
                </div>
                <?php echo e(__('Create Report')); ?>

            </h1>
            <p class="create-page-subtitle"><?php echo e(__('Generate a new analytics report for your fleet')); ?></p>
        </div>
        <div class="create-page-actions">
            <a href="<?php echo e(route('admin.reports.index')); ?>" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                <?php echo e(__('Back to List')); ?>

            </a>
        </div>
    </div>

    
    <?php if($errors->any()): ?>
        <div class="create-alert danger">
            <div class="create-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="create-alert-content">
                <div class="create-alert-title"><?php echo e(__('Please fix the following errors')); ?></div>
                <div class="create-alert-text">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('admin.reports.store')); ?>" method="POST" id="reportForm">
        <?php echo csrf_field(); ?>

        <div class="create-form-layout">
            
            <div class="create-form-main">
                
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon primary">
                            <i class="bi bi-file-earmark-bar-graph"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title"><?php echo e(__('Basic Information')); ?></h5>
                            <p class="create-card-subtitle"><?php echo e(__('Report identification and type selection')); ?></p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-hash"></i>
                                    <?php echo e(__('Report Number')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" 
                                           name="report_number" 
                                           id="report_number"
                                           class="create-input <?php $__errorArgs = ['report_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('report_number', $suggestedNumber)); ?>"
                                           placeholder="RPT-202512-0001"
                                           required>
                                    <i class="bi bi-upc-scan create-input-icon"></i>
                                </div>
                                <?php $__errorArgs = ['report_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <p class="create-form-hint">
                                    <i class="bi bi-lightbulb"></i>
                                    <?php echo e(__('Auto-generated. You can modify if needed.')); ?>

                                </p>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-tag"></i>
                                    <?php echo e(__('Report Title')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" 
                                           name="title" 
                                           id="title"
                                           class="create-input <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('title')); ?>"
                                           placeholder="<?php echo e(__('e.g., Monthly Fuel Report - December 2025')); ?>"
                                           required>
                                    <i class="bi bi-pencil create-input-icon"></i>
                                </div>
                                <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group full-width">
                                <label class="create-form-label">
                                    <i class="bi bi-list-check"></i>
                                    <?php echo e(__('Report Type')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-radio-cards">
                                    <div class="create-radio-card">
                                        <input type="radio" name="report_type" id="type_fuel" value="fuel_consumption" 
                                               <?php echo e(old('report_type', $selectedType) == 'fuel_consumption' ? 'checked' : ''); ?>>
                                        <label for="type_fuel" class="create-radio-card-label">
                                            <i class="bi bi-fuel-pump text-warning"></i>
                                            <?php echo e(__('Fuel Consumption')); ?>

                                        </label>
                                    </div>
                                    <div class="create-radio-card">
                                        <input type="radio" name="report_type" id="type_trip" value="trip_summary"
                                               <?php echo e(old('report_type', $selectedType) == 'trip_summary' ? 'checked' : ''); ?>>
                                        <label for="type_trip" class="create-radio-card-label">
                                            <i class="bi bi-geo-alt text-primary"></i>
                                            <?php echo e(__('Trip Summary')); ?>

                                        </label>
                                    </div>
                                    <div class="create-radio-card">
                                        <input type="radio" name="report_type" id="type_vehicle" value="vehicle_utilization"
                                               <?php echo e(old('report_type', $selectedType) == 'vehicle_utilization' ? 'checked' : ''); ?>>
                                        <label for="type_vehicle" class="create-radio-card-label">
                                            <i class="bi bi-truck text-info"></i>
                                            <?php echo e(__('Vehicle Utilization')); ?>

                                        </label>
                                    </div>
                                    <div class="create-radio-card">
                                        <input type="radio" name="report_type" id="type_driver" value="driver_performance"
                                               <?php echo e(old('report_type', $selectedType) == 'driver_performance' ? 'checked' : ''); ?>>
                                        <label for="type_driver" class="create-radio-card-label">
                                            <i class="bi bi-person-badge text-success"></i>
                                            <?php echo e(__('Driver Performance')); ?>

                                        </label>
                                    </div>
                                    <div class="create-radio-card">
                                        <input type="radio" name="report_type" id="type_cost" value="cost_analysis"
                                               <?php echo e(old('report_type', $selectedType) == 'cost_analysis' ? 'checked' : ''); ?>>
                                        <label for="type_cost" class="create-radio-card-label">
                                            <i class="bi bi-currency-dollar text-danger"></i>
                                            <?php echo e(__('Cost Analysis')); ?>

                                        </label>
                                    </div>
                                    <div class="create-radio-card">
                                        <input type="radio" name="report_type" id="type_delivery" value="delivery_performance"
                                               <?php echo e(old('report_type', $selectedType) == 'delivery_performance' ? 'checked' : ''); ?>>
                                        <label for="type_delivery" class="create-radio-card-label">
                                            <i class="bi bi-box-seam text-secondary"></i>
                                            <?php echo e(__('Delivery Performance')); ?>

                                        </label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['report_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group full-width">
                                <label class="create-form-label">
                                    <i class="bi bi-journal-text"></i>
                                    <?php echo e(__('Description')); ?>

                                    <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                                </label>
                                <textarea name="description" 
                                          id="description"
                                          class="create-textarea <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                          rows="3"
                                          placeholder="<?php echo e(__('Brief description of what this report covers...')); ?>"><?php echo e(old('description')); ?></textarea>
                                <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon info">
                            <i class="bi bi-calendar-range"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title"><?php echo e(__('Date Range & Filters')); ?></h5>
                            <p class="create-card-subtitle"><?php echo e(__('Define the time period and scope of the report')); ?></p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-calendar-plus"></i>
                                    <?php echo e(__('Start Date')); ?>

                                    <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="date" 
                                           name="date_from" 
                                           id="date_from"
                                           class="create-input <?php $__errorArgs = ['date_from'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('date_from')); ?>">
                                    <i class="bi bi-calendar-event create-input-icon"></i>
                                </div>
                                <?php $__errorArgs = ['date_from'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-calendar-minus"></i>
                                    <?php echo e(__('End Date')); ?>

                                    <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="date" 
                                           name="date_to" 
                                           id="date_to"
                                           class="create-input <?php $__errorArgs = ['date_to'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('date_to')); ?>">
                                    <i class="bi bi-calendar-event create-input-icon"></i>
                                </div>
                                <?php $__errorArgs = ['date_to'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <p class="create-form-hint">
                                    <i class="bi bi-info-circle"></i>
                                    <?php echo e(__('Leave empty for all-time report')); ?>

                                </p>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-truck"></i>
                                    <?php echo e(__('Filter by Vehicle')); ?>

                                    <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                                </label>
                                <select name="vehicle_id" 
                                        id="vehicle_id"
                                        class="create-select <?php $__errorArgs = ['vehicle_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <option value=""><?php echo e(__('All Vehicles')); ?></option>
                                    <?php $__currentLoopData = $vehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($vehicle->id); ?>" <?php echo e(old('vehicle_id') == $vehicle->id ? 'selected' : ''); ?>>
                                            <?php echo e($vehicle->vehicle_number); ?> - <?php echo e($vehicle->vehicleType->name ?? ''); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['vehicle_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-person"></i>
                                    <?php echo e(__('Filter by Driver')); ?>

                                    <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                                </label>
                                <select name="driver_id" 
                                        id="driver_id"
                                        class="create-select <?php $__errorArgs = ['driver_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <option value=""><?php echo e(__('All Drivers')); ?></option>
                                    <?php $__currentLoopData = $drivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($driver->id); ?>" <?php echo e(old('driver_id') == $driver->id ? 'selected' : ''); ?>>
                                            <?php echo e($driver->name); ?> - <?php echo e($driver->mobile); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['driver_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-truck-front"></i>
                                    <?php echo e(__('Filter by Vehicle Type')); ?>

                                    <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                                </label>
                                <select name="vehicle_type_id" 
                                        id="vehicle_type_id"
                                        class="create-select <?php $__errorArgs = ['vehicle_type_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <option value=""><?php echo e(__('All Vehicle Types')); ?></option>
                                    <?php $__currentLoopData = $vehicleTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($type->id); ?>" <?php echo e(old('vehicle_type_id') == $type->id ? 'selected' : ''); ?>>
                                            <?php echo e($type->name); ?> (<?php echo e($type->capacity); ?>)
                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['vehicle_type_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon warning">
                            <i class="bi bi-gear"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title"><?php echo e(__('Output Settings')); ?></h5>
                            <p class="create-card-subtitle"><?php echo e(__('Choose export format and scheduling options')); ?></p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-file-earmark"></i>
                                    <?php echo e(__('Output Format')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-radio-cards small">
                                    <div class="create-radio-card">
                                        <input type="radio" name="format" id="format_pdf" value="pdf" 
                                               <?php echo e(old('format', 'pdf') == 'pdf' ? 'checked' : ''); ?>>
                                        <label for="format_pdf" class="create-radio-card-label">
                                            <i class="bi bi-file-pdf text-danger"></i>
                                            <?php echo e(__('PDF')); ?>

                                        </label>
                                    </div>
                                    <div class="create-radio-card">
                                        <input type="radio" name="format" id="format_excel" value="excel"
                                               <?php echo e(old('format') == 'excel' ? 'checked' : ''); ?>>
                                        <label for="format_excel" class="create-radio-card-label">
                                            <i class="bi bi-file-earmark-excel text-success"></i>
                                            <?php echo e(__('Excel')); ?>

                                        </label>
                                    </div>
                                    <div class="create-radio-card">
                                        <input type="radio" name="format" id="format_csv" value="csv"
                                               <?php echo e(old('format') == 'csv' ? 'checked' : ''); ?>>
                                        <label for="format_csv" class="create-radio-card-label">
                                            <i class="bi bi-filetype-csv text-info"></i>
                                            <?php echo e(__('CSV')); ?>

                                        </label>
                                    </div>
                                    <div class="create-radio-card">
                                        <input type="radio" name="format" id="format_html" value="html"
                                               <?php echo e(old('format') == 'html' ? 'checked' : ''); ?>>
                                        <label for="format_html" class="create-radio-card-label">
                                            <i class="bi bi-filetype-html text-primary"></i>
                                            <?php echo e(__('HTML')); ?>

                                        </label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['format'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-arrow-repeat"></i>
                                    <?php echo e(__('Schedule Report')); ?>

                                </label>
                                <div class="create-checkbox-wrapper">
                                    <input type="checkbox" 
                                           name="is_scheduled" 
                                           id="is_scheduled"
                                           class="create-checkbox"
                                           value="1"
                                           <?php echo e(old('is_scheduled') ? 'checked' : ''); ?>>
                                    <label for="is_scheduled" class="create-checkbox-label">
                                        <?php echo e(__('Enable recurring generation')); ?>

                                    </label>
                                </div>
                            </div>

                            <div class="create-form-group" id="frequency_group" style="<?php echo e(old('is_scheduled') ? '' : 'display: none;'); ?>">
                                <label class="create-form-label">
                                    <i class="bi bi-calendar-week"></i>
                                    <?php echo e(__('Frequency')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <select name="schedule_frequency" 
                                        id="schedule_frequency"
                                        class="create-select <?php $__errorArgs = ['schedule_frequency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <option value=""><?php echo e(__('Select Frequency')); ?></option>
                                    <option value="daily" <?php echo e(old('schedule_frequency') == 'daily' ? 'selected' : ''); ?>><?php echo e(__('Daily')); ?></option>
                                    <option value="weekly" <?php echo e(old('schedule_frequency') == 'weekly' ? 'selected' : ''); ?>><?php echo e(__('Weekly')); ?></option>
                                    <option value="monthly" <?php echo e(old('schedule_frequency') == 'monthly' ? 'selected' : ''); ?>><?php echo e(__('Monthly')); ?></option>
                                    <option value="quarterly" <?php echo e(old('schedule_frequency') == 'quarterly' ? 'selected' : ''); ?>><?php echo e(__('Quarterly')); ?></option>
                                </select>
                                <?php $__errorArgs = ['schedule_frequency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="create-form-actions">
                    <a href="<?php echo e(route('admin.reports.index')); ?>" class="create-btn create-btn-secondary">
                        <i class="bi bi-x-lg"></i>
                        <?php echo e(__('Cancel')); ?>

                    </a>
                    <button type="submit" class="create-btn create-btn-primary">
                        <i class="bi bi-check-lg"></i>
                        <?php echo e(__('Save as Draft')); ?>

                    </button>
                    <button type="submit" name="generate_now" value="1" class="create-btn create-btn-success">
                        <i class="bi bi-play-fill"></i>
                        <?php echo e(__('Save & Generate')); ?>

                    </button>
                </div>
            </div>

            
            <div class="create-form-sidebar">
                
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon info">
                            <i class="bi bi-info-circle"></i>
                        </div>
                        <h5 class="create-sidebar-title"><?php echo e(__('Report Types')); ?></h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-tips-list">
                            <div class="tip-item">
                                <i class="bi bi-fuel-pump text-warning"></i>
                                <div>
                                    <strong><?php echo e(__('Fuel Consumption')); ?></strong>
                                    <small><?php echo e(__('Analyze fuel usage and costs')); ?></small>
                                </div>
                            </div>
                            <div class="tip-item">
                                <i class="bi bi-geo-alt text-primary"></i>
                                <div>
                                    <strong><?php echo e(__('Trip Summary')); ?></strong>
                                    <small><?php echo e(__('Overview of all trips')); ?></small>
                                </div>
                            </div>
                            <div class="tip-item">
                                <i class="bi bi-truck text-info"></i>
                                <div>
                                    <strong><?php echo e(__('Vehicle Utilization')); ?></strong>
                                    <small><?php echo e(__('Track vehicle efficiency')); ?></small>
                                </div>
                            </div>
                            <div class="tip-item">
                                <i class="bi bi-person-badge text-success"></i>
                                <div>
                                    <strong><?php echo e(__('Driver Performance')); ?></strong>
                                    <small><?php echo e(__('Evaluate driver metrics')); ?></small>
                                </div>
                            </div>
                            <div class="tip-item">
                                <i class="bi bi-currency-dollar text-danger"></i>
                                <div>
                                    <strong><?php echo e(__('Cost Analysis')); ?></strong>
                                    <small><?php echo e(__('Breakdown of expenses')); ?></small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon warning">
                            <i class="bi bi-lightbulb"></i>
                        </div>
                        <h5 class="create-sidebar-title"><?php echo e(__('Quick Tips')); ?></h5>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                <?php echo e(__('Use date filters for specific periods')); ?>

                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                <?php echo e(__('Schedule recurring reports for automation')); ?>

                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                <?php echo e(__('PDF is best for printing')); ?>

                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                <?php echo e(__('Excel allows further analysis')); ?>

                            </li>
                        </ul>
                    </div>
                </div>

                
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon primary">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h5 class="create-sidebar-title"><?php echo e(__('Quick Actions')); ?></h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="<?php echo e(route('admin.reports.index')); ?>" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                <?php echo e(__('View All Reports')); ?>

                            </a>
                            <a href="<?php echo e(route('admin.trips.index')); ?>" class="create-quick-action-btn">
                                <i class="bi bi-geo-alt"></i>
                                <?php echo e(__('Manage Trips')); ?>

                            </a>
                            <a href="<?php echo e(route('admin.fuel-logs.index')); ?>" class="create-quick-action-btn">
                                <i class="bi bi-fuel-pump"></i>
                                <?php echo e(__('Fuel Logs')); ?>

                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<?php $__env->startPush('styles'); ?>
<style>
.create-radio-cards.small .create-radio-card-label {
    padding: 0.75rem 1rem;
    font-size: 0.875rem;
}

.create-radio-cards.small .create-radio-card-label i {
    font-size: 1.25rem;
}

.tip-item {
    display: flex;
    align-items: flex-start;
    gap: 0.75rem;
    padding: 0.75rem 0;
    border-bottom: 1px solid var(--border-color);
}

.tip-item:last-child {
    border-bottom: none;
    padding-bottom: 0;
}

.tip-item i {
    font-size: 1.25rem;
    flex-shrink: 0;
    margin-top: 0.125rem;
}

.tip-item div {
    display: flex;
    flex-direction: column;
    gap: 0.125rem;
}

.tip-item strong {
    font-size: 0.875rem;
    font-weight: 600;
    color: var(--text-primary);
}

.tip-item small {
    font-size: 0.75rem;
    color: var(--text-secondary);
}

.create-btn-success {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: #ffffff;
    border: none;
}

.create-btn-success:hover {
    background: linear-gradient(135deg, #059669 0%, #047857 100%);
    color: #ffffff;
    transform: translateY(-1px);
}
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const isScheduled = document.getElementById('is_scheduled');
    const frequencyGroup = document.getElementById('frequency_group');
    const frequencySelect = document.getElementById('schedule_frequency');

    isScheduled.addEventListener('change', function() {
        if (this.checked) {
            frequencyGroup.style.display = 'block';
            frequencySelect.required = true;
        } else {
            frequencyGroup.style.display = 'none';
            frequencySelect.required = false;
            frequencySelect.value = '';
        }
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\fleet-management\resources\views/admin/reports/create.blade.php ENDPATH**/ ?>