<?php $__env->startSection('title', __('Reports') . ' - ' . __('app_name')); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/adminlistpage.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-file-earmark-bar-graph"></i>
                <?php echo e(__('Reports')); ?>

            </h1>
            <p class="list-page-subtitle"><?php echo e(__('Generate and manage fleet analytics reports')); ?></p>
        </div>
        <div class="list-page-header-actions">
            <?php if(auth()->user()->hasPermission('reports.create')): ?>
            <a href="<?php echo e(route('admin.reports.create')); ?>" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                <?php echo e(__('New Report')); ?>

            </a>
            <?php endif; ?>
        </div>
    </div>

    
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-check-circle me-2"></i><?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i><?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    
    <div class="list-stats-bar">
        <div class="list-stat-card gradient-violet">
            <div class="list-stat-icon">
                <i class="bi bi-file-earmark-bar-graph"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($stats['total']); ?></div>
                <div class="list-stat-label"><?php echo e(__('Total Reports')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-graph-up-arrow"></i>
                <?php echo e(__('All time')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-cyan">
            <div class="list-stat-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($stats['completed']); ?></div>
                <div class="list-stat-label"><?php echo e(__('Completed')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-check2-all"></i>
                <?php echo e(__('Generated')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-rose">
            <div class="list-stat-icon">
                <i class="bi bi-hourglass-split"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($stats['pending']); ?></div>
                <div class="list-stat-label"><?php echo e(__('Pending')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-clock"></i>
                <?php echo e(__('Awaiting')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-amber">
            <div class="list-stat-icon">
                <i class="bi bi-calendar-check"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($stats['scheduled']); ?></div>
                <div class="list-stat-label"><?php echo e(__('Scheduled')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-arrow-repeat"></i>
                <?php echo e(__('Recurring')); ?>

            </div>
        </div>
    </div>

    
    <div class="list-card mb-4">
        <div class="list-card-header">
            <h5 class="list-card-title">
                <i class="bi bi-lightning me-2"></i>
                <?php echo e(__('Quick Reports')); ?>

            </h5>
        </div>
        <div class="list-card-body">
            <div class="row g-3">
                <div class="col-md-4 col-lg-2">
                    <a href="<?php echo e(route('admin.reports.create', ['type' => 'fuel_consumption'])); ?>" class="quick-report-card">
                        <div class="quick-report-icon bg-warning bg-opacity-10 text-warning">
                            <i class="bi bi-fuel-pump"></i>
                        </div>
                        <span class="quick-report-label"><?php echo e(__('Fuel Consumption')); ?></span>
                    </a>
                </div>
                <div class="col-md-4 col-lg-2">
                    <a href="<?php echo e(route('admin.reports.create', ['type' => 'trip_summary'])); ?>" class="quick-report-card">
                        <div class="quick-report-icon bg-primary bg-opacity-10 text-primary">
                            <i class="bi bi-geo-alt"></i>
                        </div>
                        <span class="quick-report-label"><?php echo e(__('Trip Summary')); ?></span>
                    </a>
                </div>
                <div class="col-md-4 col-lg-2">
                    <a href="<?php echo e(route('admin.reports.create', ['type' => 'vehicle_utilization'])); ?>" class="quick-report-card">
                        <div class="quick-report-icon bg-info bg-opacity-10 text-info">
                            <i class="bi bi-truck"></i>
                        </div>
                        <span class="quick-report-label"><?php echo e(__('Vehicle Utilization')); ?></span>
                    </a>
                </div>
                <div class="col-md-4 col-lg-2">
                    <a href="<?php echo e(route('admin.reports.create', ['type' => 'driver_performance'])); ?>" class="quick-report-card">
                        <div class="quick-report-icon bg-success bg-opacity-10 text-success">
                            <i class="bi bi-person-badge"></i>
                        </div>
                        <span class="quick-report-label"><?php echo e(__('Driver Performance')); ?></span>
                    </a>
                </div>
                <div class="col-md-4 col-lg-2">
                    <a href="<?php echo e(route('admin.reports.create', ['type' => 'cost_analysis'])); ?>" class="quick-report-card">
                        <div class="quick-report-icon bg-danger bg-opacity-10 text-danger">
                            <i class="bi bi-currency-dollar"></i>
                        </div>
                        <span class="quick-report-label"><?php echo e(__('Cost Analysis')); ?></span>
                    </a>
                </div>
                <div class="col-md-4 col-lg-2">
                    <a href="<?php echo e(route('admin.reports.create', ['type' => 'delivery_performance'])); ?>" class="quick-report-card">
                        <div class="quick-report-icon bg-secondary bg-opacity-10 text-secondary">
                            <i class="bi bi-box-seam"></i>
                        </div>
                        <span class="quick-report-label"><?php echo e(__('Delivery Performance')); ?></span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    
    <div class="list-filter-bar">
        <div class="list-filter-header">
            <div class="list-filter-title">
                <i class="bi bi-funnel"></i>
                <?php echo e(__('Filters')); ?>

            </div>
            <?php if(request()->hasAny(['search', 'report_type', 'status', 'format', 'date_from', 'date_to'])): ?>
                <a href="<?php echo e(route('admin.reports.index')); ?>" class="list-filter-clear">
                    <i class="bi bi-x-circle"></i>
                    <?php echo e(__('Clear Filters')); ?>

                </a>
            <?php endif; ?>
        </div>
        <form action="<?php echo e(route('admin.reports.index')); ?>" method="GET">
            <div class="list-filter-row">
                <div class="list-filter-group search-group">
                    <label><?php echo e(__('Search')); ?></label>
                    <div class="list-search-box">
                        <i class="bi bi-search"></i>
                        <input type="text" name="search" class="form-control" 
                               placeholder="<?php echo e(__('Search by report number or title...')); ?>"
                               value="<?php echo e(request('search')); ?>">
                    </div>
                </div>
                <div class="list-filter-group">
                    <label><?php echo e(__('Report Type')); ?></label>
                    <select name="report_type" class="form-select">
                        <option value=""><?php echo e(__('All Types')); ?></option>
                        <option value="fuel_consumption" <?php echo e(request('report_type') === 'fuel_consumption' ? 'selected' : ''); ?>><?php echo e(__('Fuel Consumption')); ?></option>
                        <option value="trip_summary" <?php echo e(request('report_type') === 'trip_summary' ? 'selected' : ''); ?>><?php echo e(__('Trip Summary')); ?></option>
                        <option value="vehicle_utilization" <?php echo e(request('report_type') === 'vehicle_utilization' ? 'selected' : ''); ?>><?php echo e(__('Vehicle Utilization')); ?></option>
                        <option value="driver_performance" <?php echo e(request('report_type') === 'driver_performance' ? 'selected' : ''); ?>><?php echo e(__('Driver Performance')); ?></option>
                        <option value="cost_analysis" <?php echo e(request('report_type') === 'cost_analysis' ? 'selected' : ''); ?>><?php echo e(__('Cost Analysis')); ?></option>
                        <option value="delivery_performance" <?php echo e(request('report_type') === 'delivery_performance' ? 'selected' : ''); ?>><?php echo e(__('Delivery Performance')); ?></option>
                    </select>
                </div>
                <div class="list-filter-group">
                    <label><?php echo e(__('Status')); ?></label>
                    <select name="status" class="form-select">
                        <option value=""><?php echo e(__('All Statuses')); ?></option>
                        <option value="draft" <?php echo e(request('status') === 'draft' ? 'selected' : ''); ?>><?php echo e(__('Draft')); ?></option>
                        <option value="generating" <?php echo e(request('status') === 'generating' ? 'selected' : ''); ?>><?php echo e(__('Generating')); ?></option>
                        <option value="completed" <?php echo e(request('status') === 'completed' ? 'selected' : ''); ?>><?php echo e(__('Completed')); ?></option>
                        <option value="failed" <?php echo e(request('status') === 'failed' ? 'selected' : ''); ?>><?php echo e(__('Failed')); ?></option>
                        <option value="scheduled" <?php echo e(request('status') === 'scheduled' ? 'selected' : ''); ?>><?php echo e(__('Scheduled')); ?></option>
                    </select>
                </div>
                <div class="list-filter-group">
                    <label><?php echo e(__('Format')); ?></label>
                    <select name="format" class="form-select">
                        <option value=""><?php echo e(__('All Formats')); ?></option>
                        <option value="pdf" <?php echo e(request('format') === 'pdf' ? 'selected' : ''); ?>><?php echo e(__('PDF')); ?></option>
                        <option value="excel" <?php echo e(request('format') === 'excel' ? 'selected' : ''); ?>><?php echo e(__('Excel')); ?></option>
                        <option value="csv" <?php echo e(request('format') === 'csv' ? 'selected' : ''); ?>><?php echo e(__('CSV')); ?></option>
                    </select>
                </div>
                <div class="list-filter-buttons">
                    <button type="submit" class="btn-filter btn-filter-primary">
                        <i class="bi bi-search"></i>
                        <?php echo e(__('Apply')); ?>

                    </button>
                </div>
            </div>
        </form>
    </div>

    
    <div class="list-card">
        <?php if($reports->count() > 0): ?>
            <div class="list-table-responsive">
                <table class="list-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('Report #')); ?></th>
                            <th><?php echo e(__('Title')); ?></th>
                            <th><?php echo e(__('Type')); ?></th>
                            <th><?php echo e(__('Date Range')); ?></th>
                            <th><?php echo e(__('Format')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Generated')); ?></th>
                            <th class="text-center"><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $statusClasses = [
                                    'draft' => 'secondary',
                                    'generating' => 'info',
                                    'completed' => 'success',
                                    'failed' => 'danger',
                                    'scheduled' => 'warning',
                                ];
                                $typeClasses = [
                                    'fuel_consumption' => 'warning',
                                    'trip_summary' => 'primary',
                                    'vehicle_utilization' => 'info',
                                    'driver_performance' => 'success',
                                    'cost_analysis' => 'danger',
                                    'delivery_performance' => 'secondary',
                                    'custom' => 'dark',
                                ];
                                $typeIcons = [
                                    'fuel_consumption' => 'fuel-pump',
                                    'trip_summary' => 'geo-alt',
                                    'vehicle_utilization' => 'truck',
                                    'driver_performance' => 'person-badge',
                                    'cost_analysis' => 'currency-dollar',
                                    'delivery_performance' => 'box-seam',
                                    'custom' => 'file-earmark',
                                ];
                            ?>
                            <tr>
                                <td>
                                    <div class="table-primary-text">
                                        <a href="<?php echo e(route('admin.reports.show', $report)); ?>">
                                            <?php echo e($report->report_number); ?>

                                        </a>
                                    </div>
                                    <?php if($report->is_scheduled): ?>
                                        <span class="badge bg-warning badge-sm">
                                            <i class="bi bi-arrow-repeat"></i> <?php echo e(__('Scheduled')); ?>

                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="table-primary-text"><?php echo e(Str::limit($report->title, 40)); ?></div>
                                    <div class="table-secondary-text"><?php echo e($report->creator->name ?? '-'); ?></div>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($typeClasses[$report->report_type] ?? 'secondary'); ?>">
                                        <i class="bi bi-<?php echo e($typeIcons[$report->report_type] ?? 'file-earmark'); ?> me-1"></i>
                                        <?php echo e(__(ucwords(str_replace('_', ' ', $report->report_type)))); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="table-primary-text"><?php echo e($report->date_range); ?></div>
                                </td>
                                <td>
                                    <span class="badge bg-light text-dark">
                                        <i class="bi bi-file-earmark me-1"></i>
                                        <?php echo e(strtoupper($report->format)); ?>

                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($statusClasses[$report->status] ?? 'secondary'); ?>">
                                        <?php echo e(__(ucfirst($report->status))); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php if($report->generated_at): ?>
                                        <div class="table-primary-text"><?php echo e($report->generated_at->format('M d, Y')); ?></div>
                                        <div class="table-secondary-text"><?php echo e($report->generated_at->format('h:i A')); ?></div>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="table-actions">
                                        <?php if(auth()->user()->hasPermission('reports.view')): ?>
                                            <a href="<?php echo e(route('admin.reports.show', $report)); ?>" 
                                               class="btn-table-action btn-table-view" 
                                               title="<?php echo e(__('View')); ?>">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                        <?php endif; ?>
                                        <?php if($report->isDownloadable() && auth()->user()->hasPermission('reports.export')): ?>
                                            <a href="<?php echo e(route('admin.reports.download', $report)); ?>" 
                                               class="btn-table-action btn-table-edit" 
                                               title="<?php echo e(__('Download')); ?>">
                                                <i class="bi bi-download"></i>
                                            </a>
                                        <?php endif; ?>
                                        <?php if(in_array($report->status, ['draft', 'failed']) && auth()->user()->hasPermission('reports.edit')): ?>
                                            <a href="<?php echo e(route('admin.reports.edit', $report)); ?>" 
                                               class="btn-table-action btn-table-edit" 
                                               title="<?php echo e(__('Edit')); ?>">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                        <?php endif; ?>
                                        <?php if(auth()->user()->hasPermission('reports.delete')): ?>
                                            <form action="<?php echo e(route('admin.reports.destroy', $report)); ?>" method="POST" class="d-inline"
                                                  onsubmit="return confirm('<?php echo e(__('Are you sure you want to delete this report?')); ?>')">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" 
                                                        class="btn-table-action btn-table-delete" 
                                                        title="<?php echo e(__('Delete')); ?>">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            
            <?php if($reports->hasPages()): ?>
            <div class="list-pagination">
                <div class="list-pagination-info">
                    <?php echo e(__('Showing')); ?> <?php echo e($reports->firstItem()); ?> <?php echo e(__('to')); ?> <?php echo e($reports->lastItem()); ?> <?php echo e(__('of')); ?> <?php echo e($reports->total()); ?> <?php echo e(__('results')); ?>

                </div>
                <nav class="list-pagination-nav">
                    <?php echo e($reports->links()); ?>

                </nav>
            </div>
            <?php endif; ?>
        <?php else: ?>
            
            <div class="list-empty-state">
                <div class="list-empty-state-icon">
                    <i class="bi bi-file-earmark-bar-graph"></i>
                </div>
                <h4 class="list-empty-state-title"><?php echo e(__('No Reports Found')); ?></h4>
                <p class="list-empty-state-text">
                    <?php echo e(__('There are no reports matching your criteria. Create a new report to get started.')); ?>

                </p>
                <?php if(auth()->user()->hasPermission('reports.create')): ?>
                <a href="<?php echo e(route('admin.reports.create')); ?>" class="btn-create">
                    <i class="bi bi-plus-lg"></i>
                    <?php echo e(__('Create First Report')); ?>

                </a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
.list-card-header {
    padding: 1rem 1.5rem;
    border-bottom: 1px solid var(--border-color);
}

.list-card-title {
    margin: 0;
    font-size: 1rem;
    font-weight: 600;
    color: var(--text-primary);
}

.list-card-body {
    padding: 1.5rem;
}

.quick-report-card {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.75rem;
    padding: 1.25rem 1rem;
    background: var(--card-bg);
    border: 1px solid var(--border-color);
    border-radius: 12px;
    text-decoration: none;
    transition: all 0.2s ease;
}

.quick-report-card:hover {
    border-color: var(--primary-color);
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.quick-report-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.quick-report-icon i {
    font-size: 1.5rem;
}

.quick-report-label {
    font-size: 0.8125rem;
    font-weight: 500;
    color: var(--text-primary);
    text-align: center;
}
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\fleet-management\resources\views/admin/reports/index.blade.php ENDPATH**/ ?>