<?php $__env->startSection('title', __('Live Tracking') . ' - ' . __('app_name')); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/adminlistpage.css')); ?>">
<!-- Leaflet CSS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<style>
    /* Map Container Styles */
    .tracking-map-container {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 14px;
        overflow: hidden;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
    }

    [data-theme="dark"] .tracking-map-container {
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
    }

    .tracking-map-header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 1rem 1.25rem;
        border-bottom: 1px solid var(--border-color);
        background: var(--body-bg);
    }

    .tracking-map-title {
        font-size: 1rem;
        font-weight: 600;
        color: var(--text-primary);
        display: flex;
        align-items: center;
        gap: 0.5rem;
        margin: 0;
    }

    .tracking-map-title i {
        color: var(--primary-color);
    }

    #map {
        height: 70vh;
        min-height: 500px;
    }

    /* Driver List Styles */
    .tracking-driver-list {
        background: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: 14px;
        overflow: hidden;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
    }

    [data-theme="dark"] .tracking-driver-list {
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
    }

    .tracking-driver-header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 1rem 1.25rem;
        border-bottom: 1px solid var(--border-color);
        background: var(--body-bg);
    }

    .tracking-driver-title {
        font-size: 1rem;
        font-weight: 600;
        color: var(--text-primary);
        display: flex;
        align-items: center;
        gap: 0.5rem;
        margin: 0;
    }

    .tracking-driver-title i {
        color: var(--primary-color);
    }

    .tracking-driver-body {
        max-height: 65vh;
        overflow-y: auto;
    }

    .driver-list-item {
        display: block;
        padding: 1rem 1.25rem;
        border-bottom: 1px solid var(--border-color);
        text-decoration: none;
        color: var(--text-primary);
        transition: all 0.2s ease;
    }

    .driver-list-item:last-child {
        border-bottom: none;
    }

    .driver-list-item:hover {
        background: var(--body-bg);
        color: var(--text-primary);
    }

    .driver-list-content {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
    }

    .driver-list-info {
        flex: 1;
    }

    .driver-list-name {
        font-weight: 600;
        font-size: 0.95rem;
        margin-bottom: 0.25rem;
        color: var(--text-primary);
    }

    .driver-list-vehicle {
        font-size: 0.85rem;
        color: var(--text-secondary);
        margin-bottom: 0.5rem;
    }

    .driver-list-status {
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .driver-list-meta {
        text-align: right;
    }

    .driver-list-online {
        display: flex;
        align-items: center;
        gap: 0.35rem;
        font-size: 0.75rem;
        color: var(--success-color);
        margin-bottom: 0.25rem;
    }

    .driver-list-online i {
        font-size: 0.5rem;
    }

    .driver-list-speed {
        font-size: 0.85rem;
        color: var(--text-secondary);
        font-weight: 500;
    }

    .driver-list-time {
        font-size: 0.75rem;
        color: var(--text-muted);
        margin-top: 0.5rem;
        display: flex;
        align-items: center;
        gap: 0.35rem;
    }

    .driver-list-empty {
        padding: 2rem;
        text-align: center;
        color: var(--text-muted);
    }

    .driver-list-empty i {
        font-size: 2rem;
        margin-bottom: 0.75rem;
        display: block;
    }

    /* Online Badge */
    .online-badge {
        display: inline-flex;
        align-items: center;
        gap: 0.4rem;
        padding: 0.5rem 1rem;
        background: rgba(25, 135, 84, 0.1);
        color: #198754;
        border-radius: 50px;
        font-size: 0.85rem;
        font-weight: 600;
    }

    .online-badge i {
        font-size: 0.6rem;
    }

    /* Refresh Button */
    .btn-refresh {
        display: inline-flex;
        align-items: center;
        gap: 0.4rem;
        padding: 0.5rem 1rem;
        border-radius: 10px;
        font-size: 0.85rem;
        font-weight: 500;
        background: var(--primary-color);
        color: #ffffff;
        border: none;
        cursor: pointer;
        transition: all 0.2s ease;
    }

    .btn-refresh:hover {
        background: var(--primary-hover);
        transform: translateY(-1px);
    }

    /* Status Badges */
    .tracking-badge {
        display: inline-flex;
        align-items: center;
        gap: 0.3rem;
        padding: 0.3rem 0.6rem;
        border-radius: 6px;
        font-size: 0.75rem;
        font-weight: 500;
    }

    .tracking-badge-trip {
        background: rgba(13, 110, 253, 0.1);
        color: #0d6efd;
    }

    .tracking-badge-available {
        background: rgba(25, 135, 84, 0.1);
        color: #198754;
    }

    /* Leaflet Popup Customization */
    .leaflet-popup-content-wrapper {
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
    }

    .leaflet-popup-content {
        margin: 0;
        min-width: 200px;
    }

    .popup-content {
        padding: 0.75rem;
    }

    .popup-content h6 {
        font-weight: 600;
        margin-bottom: 0.5rem;
        color: var(--text-primary);
    }

    .popup-content p {
        margin-bottom: 0.35rem;
        font-size: 0.85rem;
    }

    .custom-driver-marker {
        background: transparent !important;
        border: none !important;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-geo-alt-fill"></i>
                <?php echo e(__('Live Driver Tracking')); ?>

            </h1>
            <p class="list-page-subtitle"><?php echo e(__('Monitor real-time driver locations and trip status')); ?></p>
        </div>
        <div class="list-page-header-actions">
            <span class="online-badge">
                <i class="bi bi-circle-fill"></i>
                <span id="onlineCount">0</span> <?php echo e(__('Online')); ?>

            </span>
            <button class="btn-refresh" onclick="refreshLocations()">
                <i class="bi bi-arrow-clockwise"></i>
                <?php echo e(__('Refresh')); ?>

            </button>
        </div>
    </div>

    
    <div class="list-stats-bar">
        <div class="list-stat-card gradient-green">
            <div class="list-stat-icon">
                <i class="bi bi-broadcast"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value" id="statOnline">0</div>
                <div class="list-stat-label"><?php echo e(__('Online Drivers')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-wifi"></i>
                <?php echo e(__('Connected')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-blue">
            <div class="list-stat-icon">
                <i class="bi bi-truck"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value" id="statOnTrip">0</div>
                <div class="list-stat-label"><?php echo e(__('On Trip')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-geo-alt"></i>
                <?php echo e(__('In transit')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-violet">
            <div class="list-stat-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value" id="statAvailable">0</div>
                <div class="list-stat-label"><?php echo e(__('Available')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-person-check"></i>
                <?php echo e(__('Ready')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-amber">
            <div class="list-stat-icon">
                <i class="bi bi-speedometer2"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value" id="statAvgSpeed">0</div>
                <div class="list-stat-label"><?php echo e(__('Avg Speed (km/h)')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-graph-up"></i>
                <?php echo e(__('Real-time')); ?>

            </div>
        </div>
    </div>

    
    <div class="row g-4">
        
        <div class="col-lg-9">
            <div class="tracking-map-container">
                <div class="tracking-map-header">
                    <h5 class="tracking-map-title">
                        <i class="bi bi-map"></i>
                        <?php echo e(__('Live Map')); ?>

                    </h5>
                    <span class="text-muted small">
                        <i class="bi bi-clock me-1"></i>
                        <?php echo e(__('Auto-refresh: 10s')); ?>

                    </span>
                </div>
                <div id="map"></div>
            </div>
        </div>

        
        <div class="col-lg-3">
            <div class="tracking-driver-list">
                <div class="tracking-driver-header">
                    <h5 class="tracking-driver-title">
                        <i class="bi bi-people"></i>
                        <?php echo e(__('Active Drivers')); ?>

                    </h5>
                </div>
                <div class="tracking-driver-body" id="driverList">
                    <div class="driver-list-empty">
                        <i class="bi bi-search"></i>
                        <p class="mb-0"><?php echo e(__('Loading drivers...')); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- Leaflet JS -->
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<!-- Tracking JavaScript -->
<script>
console.log('🔧 Script loaded!');

let map;
let markers = {};
let driverLocations = {};
let refreshInterval;

function initMap() {
    console.log('🗺️ Initializing map...');
    map = L.map('map').setView([13.0827, 80.2707], 12);
    
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors',
        maxZoom: 19
    }).addTo(map);
    
    console.log('✅ Map initialized');
}

const driverIcon = L.divIcon({
    html: `<div style="background-color: #28a745; width: 40px; height: 40px; border-radius: 50%; border: 3px solid white; box-shadow: 0 2px 5px rgba(0,0,0,0.3); display: flex; align-items: center; justify-content: center;">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="white" viewBox="0 0 16 16">
                <path d="M0 3.5A1.5 1.5 0 0 1 1.5 2h9A1.5 1.5 0 0 1 12 3.5V5h1.02a1.5 1.5 0 0 1 1.17.563l1.481 1.85a1.5 1.5 0 0 1 .329.938V10.5a1.5 1.5 0 0 1-1.5 1.5H14a2 2 0 1 1-4 0H5a2 2 0 1 1-3.998-.085A1.5 1.5 0 0 1 0 10.5v-7zm1.294 7.456A1.999 1.999 0 0 1 4.732 11h5.536a2.01 2.01 0 0 1 .732-.732V3.5a.5.5 0 0 0-.5-.5h-9a.5.5 0 0 0-.5.5v7a.5.5 0 0 0 .294.456zM12 10a2 2 0 0 1 1.732 1h.768a.5.5 0 0 0 .5-.5V8.35a.5.5 0 0 0-.11-.312l-1.48-1.85A.5.5 0 0 0 13.02 6H12v4zm-9 1a1 1 0 1 0 0 2 1 1 0 0 0 0-2zm9 0a1 1 0 1 0 0 2 1 1 0 0 0 0-2z"/>
            </svg>
           </div>`,
    className: 'custom-driver-marker',
    iconSize: [40, 40],
    iconAnchor: [20, 20]
});

const tripDriverIcon = L.divIcon({
    html: `<div style="background-color: #007bff; width: 40px; height: 40px; border-radius: 50%; border: 3px solid white; box-shadow: 0 2px 5px rgba(0,0,0,0.3); display: flex; align-items: center; justify-content: center;">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="white" viewBox="0 0 16 16">
                <path d="M0 3.5A1.5 1.5 0 0 1 1.5 2h9A1.5 1.5 0 0 1 12 3.5V5h1.02a1.5 1.5 0 0 1 1.17.563l1.481 1.85a1.5 1.5 0 0 1 .329.938V10.5a1.5 1.5 0 0 1-1.5 1.5H14a2 2 0 1 1-4 0H5a2 2 0 1 1-3.998-.085A1.5 1.5 0 0 1 0 10.5v-7zm1.294 7.456A1.999 1.999 0 0 1 4.732 11h5.536a2.01 2.01 0 0 1 .732-.732V3.5a.5.5 0 0 0-.5-.5h-9a.5.5 0 0 0-.5.5v7a.5.5 0 0 0 .294.456zM12 10a2 2 0 0 1 1.732 1h.768a.5.5 0 0 0 .5-.5V8.35a.5.5 0 0 0-.11-.312l-1.48-1.85A.5.5 0 0 0 13.02 6H12v4zm-9 1a1 1 0 1 0 0 2 1 1 0 0 0 0-2zm9 0a1 1 0 1 0 0 2 1 1 0 0 0 0-2z"/>
            </svg>
           </div>`,
    className: 'custom-driver-marker',
    iconSize: [40, 40],
    iconAnchor: [20, 20]
});

async function fetchDriverLocations() {
    try {
        console.log('📡 Fetching driver locations...');
        const response = await fetch('<?php echo e(route("admin.tracking.locations")); ?>');
        
        if (!response.ok) {
            throw new Error(`HTTP ${response.status}`);
        }
        
        const locations = await response.json();
        console.log(`✅ Fetched ${locations.length} driver(s)`, locations);
        
        updateMap(locations);
        updateDriverList(locations);
        updateStats(locations);
        
        document.getElementById('onlineCount').textContent = locations.length;
    } catch (error) {
        console.error('❌ Error:', error);
        showError('Failed to fetch: ' + error.message);
    }
}

function updateStats(locations) {
    const onlineCount = locations.length;
    const onTripCount = locations.filter(l => l.trip_id).length;
    const availableCount = onlineCount - onTripCount;
    const avgSpeed = locations.length > 0 
        ? (locations.reduce((sum, l) => sum + l.speed, 0) / locations.length).toFixed(1)
        : 0;

    document.getElementById('statOnline').textContent = onlineCount;
    document.getElementById('statOnTrip').textContent = onTripCount;
    document.getElementById('statAvailable').textContent = availableCount;
    document.getElementById('statAvgSpeed').textContent = avgSpeed;
}

function updateMap(locations) {
    const currentDriverIds = new Set();

    locations.forEach(location => {
        const driverId = 'driver_' + location.driver_id;
        currentDriverIds.add(driverId);

        const latlng = [location.latitude, location.longitude];
        const icon = location.trip_id ? tripDriverIcon : driverIcon;

        if (markers[driverId]) {
            markers[driverId].setLatLng(latlng);
            markers[driverId].setIcon(icon);
        } else {
            const marker = L.marker(latlng, { icon }).addTo(map);
            
            const popupContent = `
                <div class="popup-content">
                    <h6>${location.driver_name}</h6>
                    <p class="mb-1"><strong>Vehicle:</strong> ${location.vehicle_number}</p>
                    ${location.trip_id ? `<p class="mb-1"><strong>Trip:</strong> #${location.trip_id}</p>` : ''}
                    <p class="mb-1"><strong>Speed:</strong> ${location.speed.toFixed(1)} km/h</p>
                    <p class="mb-1"><strong>Status:</strong> 
                        <span class="badge ${location.trip_id ? 'bg-primary' : 'bg-success'}">${location.status}</span>
                    </p>
                    <p class="mb-0 text-muted small">Updated: ${new Date(location.last_updated).toLocaleTimeString()}</p>
                </div>
            `;
            marker.bindPopup(popupContent);
            markers[driverId] = marker;
        }

        driverLocations[driverId] = location;
    });

    Object.keys(markers).forEach(driverId => {
        if (!currentDriverIds.has(driverId)) {
            map.removeLayer(markers[driverId]);
            delete markers[driverId];
            delete driverLocations[driverId];
        }
    });

    if (locations.length > 0) {
        const bounds = L.latLngBounds(locations.map(loc => [loc.latitude, loc.longitude]));
        map.fitBounds(bounds, { padding: [50, 50] });
    }
}

function updateDriverList(locations) {
    const listContainer = document.getElementById('driverList');
    
    if (locations.length === 0) {
        listContainer.innerHTML = `
            <div class="driver-list-empty">
                <i class="bi bi-wifi-off"></i>
                <p class="mb-0"><?php echo e(__('No drivers online')); ?></p>
            </div>
        `;
        return;
    }

    listContainer.innerHTML = locations.map(location => `
        <a href="#" class="driver-list-item" onclick="focusDriver('driver_${location.driver_id}'); return false;">
            <div class="driver-list-content">
                <div class="driver-list-info">
                    <div class="driver-list-name">${location.driver_name}</div>
                    <div class="driver-list-vehicle">${location.vehicle_number}</div>
                    <div class="driver-list-status">
                        ${location.trip_id 
                            ? `<span class="tracking-badge tracking-badge-trip"><i class="bi bi-truck"></i> Trip #${location.trip_id}</span>` 
                            : '<span class="tracking-badge tracking-badge-available"><i class="bi bi-check-circle"></i> Available</span>'}
                    </div>
                </div>
                <div class="driver-list-meta">
                    <div class="driver-list-online">
                        <i class="bi bi-circle-fill"></i>
                        Online
                    </div>
                    <div class="driver-list-speed">${location.speed.toFixed(0)} km/h</div>
                </div>
            </div>
            <div class="driver-list-time">
                <i class="bi bi-clock"></i>
                ${new Date(location.last_updated).toLocaleTimeString()}
            </div>
        </a>
    `).join('');
}

function focusDriver(driverId) {
    if (markers[driverId]) {
        const loc = driverLocations[driverId];
        map.setView([loc.latitude, loc.longitude], 16);
        markers[driverId].openPopup();
    }
}

function refreshLocations() {
    console.log('🔄 Manual refresh');
    fetchDriverLocations();
}

function showError(message) {
    document.getElementById('driverList').innerHTML = `
        <div class="driver-list-empty">
            <i class="bi bi-exclamation-triangle text-danger"></i>
            <p class="mb-2 text-danger">${message}</p>
            <button class="btn btn-sm btn-outline-danger" onclick="refreshLocations()">
                <i class="bi bi-arrow-clockwise"></i> <?php echo e(__('Retry')); ?>

            </button>
        </div>
    `;
}

window.refreshLocations = refreshLocations;
window.focusDriver = focusDriver;

document.addEventListener('DOMContentLoaded', function() {
    console.log('🚀 Initializing...');
    initMap();
    fetchDriverLocations();
    
    refreshInterval = setInterval(fetchDriverLocations, 10000);
    console.log('⏱️ Auto-refresh: 10s');
});

window.addEventListener('beforeunload', function() {
    if (refreshInterval) {
        clearInterval(refreshInterval);
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\fleet-management\resources\views/admin/tracking/index.blade.php ENDPATH**/ ?>