<?php $__env->startSection('title', __('Create Shipment') . ' - ' . __('app_name')); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/admincreatepage.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="create-page-container">
    
    <div class="create-page-header">
        <div class="create-page-header-content">
            <div class="create-page-breadcrumb">
                <a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                <i class="bi bi-chevron-right"></i>
                <a href="<?php echo e(route('admin.shipments.index')); ?>"><?php echo e(__('Shipments')); ?></a>
                <i class="bi bi-chevron-right"></i>
                <span><?php echo e(__('Create')); ?></span>
            </div>
            <h1 class="create-page-title">
                <div class="create-page-title-icon">
                    <i class="bi bi-plus-lg"></i>
                </div>
                <?php echo e(__('Create New Shipment')); ?>

            </h1>
            <p class="create-page-subtitle"><?php echo e(__('Fill in the details below to create a new shipment')); ?></p>
        </div>
        <div class="create-page-actions">
            <a href="<?php echo e(route('admin.shipments.index')); ?>" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                <?php echo e(__('Back to List')); ?>

            </a>
        </div>
    </div>

    
    <?php if($errors->any()): ?>
        <div class="create-alert danger">
            <div class="create-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="create-alert-content">
                <div class="create-alert-title"><?php echo e(__('Please fix the following errors')); ?></div>
                <div class="create-alert-text">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('admin.shipments.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="create-form-layout">
            
            <div class="create-form-main">
                
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon primary">
                            <i class="bi bi-info-circle"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title"><?php echo e(__('Basic Information')); ?></h5>
                            <p class="create-card-subtitle"><?php echo e(__('Enter the shipment identification details')); ?></p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-group">
                            <label class="create-form-label">
                                <i class="bi bi-hash"></i>
                                <?php echo e(__('Shipment Number')); ?>

                                <span class="create-form-required">*</span>
                            </label>
                            <div class="create-input-icon-wrapper">
                                <input type="text" 
                                       name="shipment_number" 
                                       id="shipment_number"
                                       class="create-input <?php $__errorArgs = ['shipment_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       value="<?php echo e(old('shipment_number')); ?>"
                                       placeholder="SH-2025-0001"
                                       required>
                                <i class="bi bi-upc-scan create-input-icon"></i>
                            </div>
                            <?php $__errorArgs = ['shipment_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="create-form-error">
                                    <i class="bi bi-exclamation-circle"></i>
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <p class="create-form-hint">
                                <i class="bi bi-lightbulb"></i>
                                <?php echo e(__('Enter a unique shipment number (e.g., SH-2025-0001)')); ?>

                            </p>
                        </div>
                    </div>
                </div>

                
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon info">
                            <i class="bi bi-truck"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title"><?php echo e(__('Vehicle & Cargo Details')); ?></h5>
                            <p class="create-card-subtitle"><?php echo e(__('Specify the vehicle type and cargo information')); ?></p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-truck-front"></i>
                                    <?php echo e(__('Vehicle Type')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <select name="vehicle_type_id" 
                                        id="vehicle_type_id"
                                        class="create-select <?php $__errorArgs = ['vehicle_type_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        required>
                                    <option value=""><?php echo e(__('Select Vehicle Type')); ?></option>
                                    <?php $__currentLoopData = $vehicleTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($type->id); ?>" 
                                                <?php echo e(old('vehicle_type_id') == $type->id ? 'selected' : ''); ?>>
                                            <?php echo e($type->name); ?> (<?php echo e($type->capacity); ?>)
                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['vehicle_type_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <p class="create-form-hint">
                                    <i class="bi bi-info-circle"></i>
                                    <?php echo e(__('This determines which vehicles can be assigned to this shipment')); ?>

                                </p>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-box-seam"></i>
                                    <?php echo e(__('Cargo Weight (Tons)')); ?>

                                    <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                                </label>
                                <div class="create-input-group">
                                    <input type="number" 
                                           name="cargo_weight"
                                           id="cargo_weight"
                                           class="create-input <?php $__errorArgs = ['cargo_weight'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('cargo_weight')); ?>"
                                           placeholder="0.00"
                                           step="0.01"
                                           min="0">
                                    <span class="create-input-addon">T</span>
                                </div>
                                <?php $__errorArgs = ['cargo_weight'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon warning">
                            <i class="bi bi-flag"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title"><?php echo e(__('Priority Level')); ?></h5>
                            <p class="create-card-subtitle"><?php echo e(__('Set the urgency level for this shipment')); ?></p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-group">
                            <div class="create-radio-cards">
                                <div class="create-radio-card">
                                    <input type="radio" name="priority" id="priority_normal" value="normal" 
                                           <?php echo e(old('priority', 'normal') == 'normal' ? 'checked' : ''); ?>>
                                    <label for="priority_normal" class="create-radio-card-label priority-normal">
                                        <i class="bi bi-flag"></i>
                                        <?php echo e(__('Normal')); ?>

                                    </label>
                                </div>
                                <div class="create-radio-card">
                                    <input type="radio" name="priority" id="priority_high" value="high"
                                           <?php echo e(old('priority') == 'high' ? 'checked' : ''); ?>>
                                    <label for="priority_high" class="create-radio-card-label priority-high">
                                        <i class="bi bi-flag-fill"></i>
                                        <?php echo e(__('High')); ?>

                                    </label>
                                </div>
                                <div class="create-radio-card">
                                    <input type="radio" name="priority" id="priority_urgent" value="urgent"
                                           <?php echo e(old('priority') == 'urgent' ? 'checked' : ''); ?>>
                                    <label for="priority_urgent" class="create-radio-card-label priority-urgent">
                                        <i class="bi bi-exclamation-triangle-fill"></i>
                                        <?php echo e(__('Urgent')); ?>

                                    </label>
                                </div>
                            </div>
                            <?php $__errorArgs = ['priority'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="create-form-error">
                                    <i class="bi bi-exclamation-circle"></i>
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    
                    <div class="create-card-actions">
                        <div class="create-card-actions-left">
                            <a href="<?php echo e(route('admin.shipments.index')); ?>" class="create-btn create-btn-secondary">
                                <i class="bi bi-x-circle"></i>
                                <?php echo e(__('Cancel')); ?>

                            </a>
                        </div>
                        <div class="create-card-actions-right">
                            <button type="submit" class="create-btn create-btn-primary">
                                <i class="bi bi-save"></i>
                                <?php echo e(__('Create Shipment')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="create-form-sidebar">
                
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon info">
                            <i class="bi bi-lightbulb"></i>
                        </div>
                        <h5 class="create-sidebar-title"><?php echo e(__('Quick Tips')); ?></h5>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span><?php echo e(__('Use a unique shipment number for easy identification and tracking')); ?></span>
                            </li>
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span><?php echo e(__('Select the appropriate vehicle type based on your cargo size and weight')); ?></span>
                            </li>
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span><?php echo e(__('Set priority to urgent only for time-critical deliveries')); ?></span>
                            </li>
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span><?php echo e(__('After creating, you can assign a vehicle and driver to this shipment')); ?></span>
                            </li>
                        </ul>
                    </div>
                </div>

                
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon warning">
                            <i class="bi bi-clock"></i>
                        </div>
                        <h5 class="create-sidebar-title"><?php echo e(__('Initial Status')); ?></h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-status-preview">
                            <span class="create-status-badge pending">
                                <i class="bi bi-clock"></i>
                                <?php echo e(__('Pending')); ?>

                            </span>
                            <p class="create-status-description">
                                <?php echo e(__('New shipments are created with pending status. You can assign a vehicle and driver after creation.')); ?>

                            </p>
                        </div>
                    </div>
                </div>

                
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon success">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h5 class="create-sidebar-title"><?php echo e(__('Quick Actions')); ?></h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="<?php echo e(route('admin.shipments.index')); ?>" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                <?php echo e(__('View All Shipments')); ?>

                            </a>
                            <a href="<?php echo e(route('admin.vehicle-types.index')); ?>" class="create-quick-action-btn">
                                <i class="bi bi-truck"></i>
                                <?php echo e(__('Manage Vehicle Types')); ?>

                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\fleet-management\resources\views/admin/shipments/create.blade.php ENDPATH**/ ?>