<?php $__env->startSection('title', __('Trips') . ' - ' . __('app_name')); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/adminlistpage.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-geo-alt"></i>
                <?php echo e(__('Trips')); ?>

            </h1>
            <p class="list-page-subtitle"><?php echo e(__('Manage and track all your trips and routes')); ?></p>
        </div>
        <div class="list-page-header-actions">
            <a href="<?php echo e(route('admin.trips.create')); ?>" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                <?php echo e(__('New Trip')); ?>

            </a>
        </div>
    </div>

    
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-check-circle me-2"></i><?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i><?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    
    <div class="list-stats-bar">
        <div class="list-stat-card gradient-blue">
            <div class="list-stat-icon">
                <i class="bi bi-geo-alt"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($trips->total()); ?></div>
                <div class="list-stat-label"><?php echo e(__('Total Trips')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-graph-up-arrow"></i>
                <?php echo e(__('All time')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-purple">
            <div class="list-stat-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($trips->where('status', 'assigned')->count()); ?></div>
                <div class="list-stat-label"><?php echo e(__('Assigned')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-clipboard-check"></i>
                <?php echo e(__('Ready')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-cyan">
            <div class="list-stat-icon">
                <i class="bi bi-truck"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($trips->where('status', 'in_transit')->count()); ?></div>
                <div class="list-stat-label"><?php echo e(__('In Transit')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-geo-alt"></i>
                <?php echo e(__('On route')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-green">
            <div class="list-stat-icon">
                <i class="bi bi-check-all"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($trips->where('status', 'delivered')->count()); ?></div>
                <div class="list-stat-label"><?php echo e(__('Delivered')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-check2-all"></i>
                <?php echo e(__('Completed')); ?>

            </div>
        </div>
    </div>

    
    <div class="list-filter-bar">
        <div class="list-filter-header">
            <div class="list-filter-title">
                <i class="bi bi-funnel"></i>
                <?php echo e(__('Filters')); ?>

            </div>
            <?php if(request()->hasAny(['search', 'status'])): ?>
                <a href="<?php echo e(route('admin.trips.index')); ?>" class="list-filter-clear">
                    <i class="bi bi-x-circle"></i>
                    <?php echo e(__('Clear Filters')); ?>

                </a>
            <?php endif; ?>
        </div>
        <form action="<?php echo e(route('admin.trips.index')); ?>" method="GET">
            <div class="list-filter-row">
                <div class="list-filter-group search-group">
                    <label><?php echo e(__('Search')); ?></label>
                    <div class="list-search-box">
                        <i class="bi bi-search"></i>
                        <input type="text" name="search" class="form-control" 
                               placeholder="<?php echo e(__('Search by trip number, reference...')); ?>"
                               value="<?php echo e(request('search')); ?>">
                    </div>
                </div>
                <div class="list-filter-group">
                    <label><?php echo e(__('Status')); ?></label>
                    <select name="status" class="form-select">
                        <option value=""><?php echo e(__('All Statuses')); ?></option>
                        <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>><?php echo e(__('Pending')); ?></option>
                        <option value="assigned" <?php echo e(request('status') === 'assigned' ? 'selected' : ''); ?>><?php echo e(__('Assigned')); ?></option>
                        <option value="in_transit" <?php echo e(request('status') === 'in_transit' ? 'selected' : ''); ?>><?php echo e(__('In Transit')); ?></option>
                        <option value="delivered" <?php echo e(request('status') === 'delivered' ? 'selected' : ''); ?>><?php echo e(__('Delivered')); ?></option>
                        <option value="cancelled" <?php echo e(request('status') === 'cancelled' ? 'selected' : ''); ?>><?php echo e(__('Cancelled')); ?></option>
                    </select>
                </div>
                <div class="list-filter-buttons">
                    <button type="submit" class="btn-filter btn-filter-primary">
                        <i class="bi bi-search"></i>
                        <?php echo e(__('Apply')); ?>

                    </button>
                </div>
            </div>
        </form>
    </div>

    
    <div class="list-table-container">
        <div class="list-table-header">
            <h5 class="list-table-title">
                <?php echo e(__('Trips List')); ?>

                <span class="list-table-count">(<?php echo e($trips->total()); ?> <?php echo e(__('records')); ?>)</span>
            </h5>
        </div>

        <?php if($trips->count() > 0): ?>
            <div class="table-responsive">
                <table class="list-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('Trip #')); ?></th>
                            <th><?php echo e(__('Vehicle')); ?></th>
                            <th><?php echo e(__('Driver')); ?></th>
                            <th><?php echo e(__('Pickup Location')); ?></th>
                            <th><?php echo e(__('Drop Location')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Created At')); ?></th>
                            <th><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $statusClasses = [
                                'pending' => 'pending',
                                'assigned' => 'assigned',
                                'in_transit' => 'in-transit',
                                'delivered' => 'delivered',
                                'cancelled' => 'cancelled'
                            ];
                            $statusIcons = [
                                'pending' => 'clock',
                                'assigned' => 'check-circle',
                                'in_transit' => 'truck',
                                'delivered' => 'check-all',
                                'cancelled' => 'x-circle'
                            ];
                        ?>
                        <?php $__currentLoopData = $trips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="table-cell-id">
                                    <a href="<?php echo e(route('admin.trips.show', $trip)); ?>">
                                        <?php echo e($trip->trip_number); ?>

                                    </a>
                                </td>
                                <td>
                                    <?php if($trip->vehicle): ?>
                                        <div class="table-cell-vehicle">
                                            <div class="table-cell-vehicle-icon">
                                                <i class="bi bi-truck"></i>
                                            </div>
                                            <div class="table-cell-vehicle-info">
                                                <span class="vehicle-number"><?php echo e($trip->vehicle->vehicle_number); ?></span>
                                                <span class="vehicle-type"><?php echo e($trip->vehicle->vehicleType->name ?? '-'); ?></span>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($trip->driver): ?>
                                        <div class="table-cell-user">
                                            <div class="table-cell-user-avatar">
                                                <i class="bi bi-person"></i>
                                            </div>
                                            <span><?php echo e($trip->driver->name); ?></span>
                                        </div>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="table-cell-location" title="<?php echo e($trip->pickup_location); ?>">
                                        <i class="bi bi-geo-alt text-success"></i>
                                        <?php echo e(Str::limit($trip->pickup_location, 30)); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php if($trip->has_multiple_locations): ?>
                                        <span class="table-badge table-badge-info">
                                            <i class="bi bi-pin-map"></i>
                                            <?php echo e(__('Multiple')); ?>

                                        </span>
                                    <?php elseif($trip->drop_location): ?>
                                        <span class="table-cell-location" title="<?php echo e($trip->drop_location); ?>">
                                            <i class="bi bi-geo-alt-fill text-danger"></i>
                                            <?php echo e(Str::limit($trip->drop_location, 30)); ?>

                                        </span>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="table-badge table-badge-<?php echo e($statusClasses[$trip->status] ?? 'pending'); ?>">
                                        <i class="bi bi-<?php echo e($statusIcons[$trip->status] ?? 'circle'); ?>"></i>
                                        <?php echo e(__(ucfirst(str_replace('_', ' ', $trip->status)))); ?>

                                    </span>
                                </td>
                                <td class="table-cell-date">
                                    <i class="bi bi-calendar"></i>
                                    <?php echo e($trip->created_at->format('d M Y, h:i A')); ?>

                                </td>
                                <td>
                                    <div class="table-actions">
                                        <a href="<?php echo e(route('admin.trips.show', $trip)); ?>" 
                                           class="btn-table-action btn-table-view" 
                                           title="<?php echo e(__('View')); ?>">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        <?php if($trip->status === 'pending'): ?>
                                            <a href="<?php echo e(route('admin.trips.edit', $trip)); ?>" 
                                               class="btn-table-action btn-table-edit" 
                                               title="<?php echo e(__('Edit')); ?>">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <form action="<?php echo e(route('admin.trips.destroy', $trip)); ?>" 
                                                  method="POST" 
                                                  class="d-inline"
                                                  onsubmit="return confirm('<?php echo e(__('Are you sure you want to delete this trip?')); ?>')">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" 
                                                        class="btn-table-action btn-table-delete" 
                                                        title="<?php echo e(__('Delete')); ?>">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                        <?php if($trip->status === 'cancelled'): ?>
                                            <form action="<?php echo e(route('admin.trips.destroy', $trip)); ?>" 
                                                  method="POST" 
                                                  class="d-inline"
                                                  onsubmit="return confirm('<?php echo e(__('Are you sure you want to delete this cancelled trip?')); ?>')">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" 
                                                        class="btn-table-action btn-table-delete" 
                                                        title="<?php echo e(__('Delete')); ?>">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            
            <?php if($trips->hasPages()): ?>
            <div class="list-pagination">
                <div class="list-pagination-info">
                    <?php echo e(__('Showing')); ?> <?php echo e($trips->firstItem()); ?> <?php echo e(__('to')); ?> <?php echo e($trips->lastItem()); ?> <?php echo e(__('of')); ?> <?php echo e($trips->total()); ?> <?php echo e(__('results')); ?>

                </div>
                <nav class="list-pagination-nav">
                    <?php echo e($trips->links()); ?>

                </nav>
            </div>
            <?php endif; ?>
        <?php else: ?>
            
            <div class="list-empty-state">
                <div class="list-empty-state-icon">
                    <i class="bi bi-geo-alt"></i>
                </div>
                <h4 class="list-empty-state-title"><?php echo e(__('No Trips Found')); ?></h4>
                <p class="list-empty-state-text">
                    <?php echo e(__('There are no trips matching your criteria. Create a new trip to get started.')); ?>

                </p>
                <a href="<?php echo e(route('admin.trips.create')); ?>" class="btn-create">
                    <i class="bi bi-plus-lg"></i>
                    <?php echo e(__('Create First Trip')); ?>

                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\fleet-management\resources\views/admin/trips/index.blade.php ENDPATH**/ ?>