<?php $__env->startSection('title', __('drivers') . ' - ' . __('app_name')); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/adminlistpage.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-people"></i>
                <?php echo e(__('drivers')); ?>

            </h1>
            <p class="list-page-subtitle"><?php echo e(__('Manage driver information and vehicle assignments')); ?></p>
        </div>
        <div class="list-page-header-actions">
            <a href="<?php echo e(route('admin.drivers.create')); ?>" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                <?php echo e(__('add_driver')); ?>

            </a>
        </div>
    </div>

    
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i><?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i><?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    
    <div class="list-stats-bar">
        <div class="list-stat-card gradient-violet">
            <div class="list-stat-icon">
                <i class="bi bi-people"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($drivers->total()); ?></div>
                <div class="list-stat-label"><?php echo e(__('Total Drivers')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-database"></i>
                <?php echo e(__('All records')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-green">
            <div class="list-stat-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($drivers->where('status', 'active')->count()); ?></div>
                <div class="list-stat-label"><?php echo e(__('active')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-person-check"></i>
                <?php echo e(__('Available')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-amber">
            <div class="list-stat-icon">
                <i class="bi bi-truck"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($drivers->where('status', 'on_trip')->count()); ?></div>
                <div class="list-stat-label"><?php echo e(__('on_trip')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-geo-alt"></i>
                <?php echo e(__('On route')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-blue">
            <div class="list-stat-icon">
                <i class="bi bi-truck-front"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($drivers->where('driver_type', 'own_vehicle')->count()); ?></div>
                <div class="list-stat-label"><?php echo e(__('own_vehicle')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-key"></i>
                <?php echo e(__('With vehicle')); ?>

            </div>
        </div>
    </div>

    
    <div class="list-filter-bar">
        <form action="<?php echo e(route('admin.drivers.index')); ?>" method="GET">
            <div class="list-filter-row">
                <div class="list-filter-group search-group">
                    <div class="list-search-box">
                        <input type="text" 
                               name="search" 
                               placeholder="<?php echo e(__('search')); ?> <?php echo e(__('driver_name')); ?>, <?php echo e(__('mobile')); ?>..." 
                               value="<?php echo e(request('search')); ?>">
                        <i class="bi bi-search"></i>
                    </div>
                </div>
                <div class="list-filter-group">
                    <select name="driver_type" class="form-select">
                        <option value=""><?php echo e(__('driver_type')); ?> - <?php echo e(__('All')); ?></option>
                        <option value="own_vehicle" <?php echo e(request('driver_type') === 'own_vehicle' ? 'selected' : ''); ?>>
                            <?php echo e(__('own_vehicle')); ?>

                        </option>
                        <option value="driver_only" <?php echo e(request('driver_type') === 'driver_only' ? 'selected' : ''); ?>>
                            <?php echo e(__('driver_only')); ?>

                        </option>
                    </select>
                </div>
                <div class="list-filter-group">
                    <select name="status" class="form-select">
                        <option value=""><?php echo e(__('status')); ?> - <?php echo e(__('All')); ?></option>
                        <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>
                            <?php echo e(__('active')); ?>

                        </option>
                        <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>>
                            <?php echo e(__('inactive')); ?>

                        </option>
                        <option value="on_trip" <?php echo e(request('status') === 'on_trip' ? 'selected' : ''); ?>>
                            <?php echo e(__('on_trip')); ?>

                        </option>
                    </select>
                </div>
                <div class="list-filter-buttons">
                    <button type="submit" class="btn-filter btn-filter-primary">
                        <i class="bi bi-funnel"></i>
                        <?php echo e(__('filter')); ?>

                    </button>
                    <a href="<?php echo e(route('admin.drivers.index')); ?>" class="btn-filter btn-filter-outline">
                        <i class="bi bi-x-circle"></i>
                        <?php echo e(__('clear')); ?>

                    </a>
                </div>
            </div>
        </form>
    </div>

    
    <div class="list-table-container">
        <div class="list-table-header">
            <h5 class="list-table-title">
                <i class="bi bi-table me-2"></i>
                <?php echo e(__('drivers')); ?>

                <span class="list-table-count">(<?php echo e($drivers->total()); ?> <?php echo e(__('records')); ?>)</span>
            </h5>
        </div>

        <?php if($drivers->isEmpty()): ?>
            <div class="list-empty-state">
                <div class="list-empty-icon">
                    <i class="bi bi-people"></i>
                </div>
                <h4><?php echo e(__('no_records')); ?></h4>
                <p><?php echo e(__('No drivers found. Add your first driver to get started.')); ?></p>
                <a href="<?php echo e(route('admin.drivers.create')); ?>" class="btn-create">
                    <i class="bi bi-plus-lg"></i>
                    <?php echo e(__('add_driver')); ?>

                </a>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="list-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('driver_name')); ?></th>
                            <th><?php echo e(__('mobile')); ?></th>
                            <th><?php echo e(__('license_number')); ?></th>
                            <th><?php echo e(__('driver_type')); ?></th>
                            <th><?php echo e(__('vehicle')); ?></th>
                            <th><?php echo e(__('status')); ?></th>
                            <th class="text-center"><?php echo e(__('actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $drivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <div class="table-cell-user">
                                    <div class="table-cell-user-avatar">
                                        <i class="bi bi-person"></i>
                                    </div>
                                    <div>
                                        <strong><?php echo e($driver->name); ?></strong>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="table-cell-date">
                                    <i class="bi bi-telephone"></i>
                                    <?php echo e($driver->mobile); ?>

                                </span>
                            </td>
                            <td>
                                <code><?php echo e($driver->license_number); ?></code>
                            </td>
                            <td>
                                <?php if($driver->driver_type === 'own_vehicle'): ?>
                                    <span class="table-badge table-badge-assigned">
                                        <i class="bi bi-truck-front"></i>
                                        <?php echo e(__('own_vehicle')); ?>

                                    </span>
                                <?php else: ?>
                                    <span class="table-badge table-badge-info">
                                        <i class="bi bi-person"></i>
                                        <?php echo e(__('driver_only')); ?>

                                    </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($driver->ownVehicle): ?>
                                    <span class="table-badge table-badge-in-transit">
                                        <i class="bi bi-truck"></i>
                                        <?php echo e($driver->ownVehicle->vehicle_number); ?>

                                    </span>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($driver->status === 'active'): ?>
                                    <span class="table-badge table-badge-delivered">
                                        <i class="bi bi-check-circle"></i>
                                        <?php echo e(__('active')); ?>

                                    </span>
                                <?php elseif($driver->status === 'inactive'): ?>
                                    <span class="table-badge table-badge-cancelled">
                                        <i class="bi bi-x-circle"></i>
                                        <?php echo e(__('inactive')); ?>

                                    </span>
                                <?php elseif($driver->status === 'on_trip'): ?>
                                    <span class="table-badge table-badge-pending">
                                        <i class="bi bi-truck"></i>
                                        <?php echo e(__('on_trip')); ?>

                                    </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="table-actions">
                                    <a href="<?php echo e(route('admin.drivers.edit', $driver)); ?>" 
                                       class="btn-table-action btn-table-edit" 
                                       title="<?php echo e(__('edit')); ?>">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form action="<?php echo e(route('admin.drivers.destroy', $driver)); ?>" 
                                          method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" 
                                                class="btn-table-action btn-table-delete delete-confirm" 
                                                title="<?php echo e(__('delete')); ?>">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            
            <?php if($drivers->hasPages()): ?>
            <div class="list-pagination">
                <div class="pagination-info">
                    <?php echo e(__('Showing')); ?> <?php echo e($drivers->firstItem()); ?> <?php echo e(__('to')); ?> <?php echo e($drivers->lastItem()); ?> <?php echo e(__('of')); ?> <?php echo e($drivers->total()); ?> <?php echo e(__('entries')); ?>

                </div>
                <div class="pagination-links">
                    <?php echo e($drivers->links()); ?>

                </div>
            </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\fleet-management\resources\views/admin/drivers/index.blade.php ENDPATH**/ ?>