<?php $__env->startSection('title', $fuelLog->fuel_number . ' - ' . __('Fuel Log Details')); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/admindetailpage.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    
    <div class="page-header">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.fuel-logs.index')); ?>"><?php echo e(__('Fuel Logs')); ?></a></li>
                    <li class="breadcrumb-item active"><?php echo e($fuelLog->fuel_number); ?></li>
                </ol>
            </nav>
        </div>
    </div>

    
    <?php if(session('success')): ?>
        <div class="detail-alert detail-alert-info">
            <div class="detail-alert-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title"><?php echo e(__('Success')); ?></div>
                <div class="detail-alert-text"><?php echo e(session('success')); ?></div>
            </div>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="detail-alert detail-alert-warning">
            <div class="detail-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title"><?php echo e(__('Error')); ?></div>
                <div class="detail-alert-text"><?php echo e(session('error')); ?></div>
            </div>
        </div>
    <?php endif; ?>

    <?php
        $fuelTypeClasses = [
            'diesel' => 'warning',
            'petrol' => 'info',
            'cng' => 'success',
            'electric' => 'primary'
        ];
        $paymentClasses = [
            'cash' => 'success',
            'card' => 'info',
            'company_account' => 'primary',
            'fuel_card' => 'warning'
        ];
    ?>

    
    <div class="detail-hero">
        <div class="detail-hero-header">
            <div class="detail-hero-content">
                <div class="detail-hero-icon">
                    <i class="bi bi-fuel-pump"></i>
                </div>
                <div class="detail-hero-info">
                    <h1 class="detail-hero-title"><?php echo e($fuelLog->fuel_number); ?></h1>
                    <p class="detail-hero-subtitle"><?php echo e($fuelLog->vehicle->vehicle_number); ?> · <?php echo e(__('Filled')); ?> <?php echo e($fuelLog->fill_date->format('M d, Y')); ?></p>
                    <div class="detail-hero-badges">
                        <span class="status-badge status-badge-<?php echo e($fuelTypeClasses[$fuelLog->fuel_type] ?? 'secondary'); ?>">
                            <i class="bi bi-droplet"></i>
                            <?php echo e(__(ucfirst($fuelLog->fuel_type))); ?>

                        </span>
                        <span class="status-badge status-badge-<?php echo e($paymentClasses[$fuelLog->payment_method] ?? 'secondary'); ?>">
                            <i class="bi bi-credit-card"></i>
                            <?php echo e(__(ucfirst(str_replace('_', ' ', $fuelLog->payment_method)))); ?>

                        </span>
                        <?php if($fuelLog->is_full_tank): ?>
                        <span class="status-badge status-badge-delivered">
                            <i class="bi bi-check-circle"></i>
                            <?php echo e(__('Full Tank')); ?>

                        </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="detail-actions">
                <?php if(auth()->user()->hasPermission('fuel.edit')): ?>
                <a href="<?php echo e(route('admin.fuel-logs.edit', $fuelLog)); ?>" class="btn-detail btn-detail-warning">
                    <i class="bi bi-pencil"></i>
                    <?php echo e(__('Edit')); ?>

                </a>
                <?php endif; ?>
                <a href="<?php echo e(route('admin.fuel-logs.index')); ?>" class="btn-detail btn-detail-outline">
                    <i class="bi bi-arrow-left"></i>
                    <?php echo e(__('Back to List')); ?>

                </a>
            </div>
        </div>
        <div class="detail-hero-body">
            <div class="hero-stat">
                <div class="hero-stat-value"><?php echo e(number_format($fuelLog->quantity, 2)); ?></div>
                <div class="hero-stat-label"><?php echo e(__('Liters')); ?></div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value">$<?php echo e(number_format($fuelLog->price_per_unit, 2)); ?></div>
                <div class="hero-stat-label"><?php echo e(__('Price/Unit')); ?></div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value text-success">$<?php echo e(number_format($fuelLog->total_cost, 2)); ?></div>
                <div class="hero-stat-label"><?php echo e(__('Total Cost')); ?></div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value"><?php echo e($fuelLog->fuel_efficiency ? number_format($fuelLog->fuel_efficiency, 2) : '-'); ?></div>
                <div class="hero-stat-label"><?php echo e(__('km/L Efficiency')); ?></div>
            </div>
        </div>
    </div>

    <div class="row">
        
        <div class="col-lg-8">
            
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon primary">
                        <i class="bi bi-truck"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Vehicle Information')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="entity-card">
                        <div class="entity-card-avatar primary">
                            <i class="bi bi-truck"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-name"><?php echo e($fuelLog->vehicle->vehicle_number); ?></h6>
                            <p class="entity-card-subtitle"><?php echo e($fuelLog->vehicle->vehicleType->name ?? '-'); ?></p>
                            <div class="entity-card-meta">
                                <?php if($fuelLog->vehicle->brand): ?>
                                <span><i class="bi bi-tag"></i> <?php echo e($fuelLog->vehicle->brand); ?> <?php echo e($fuelLog->vehicle->model ?? ''); ?></span>
                                <?php endif; ?>
                                <span><i class="bi bi-palette"></i> <?php echo e($fuelLog->vehicle->color ?? '-'); ?></span>
                            </div>
                        </div>
                        <div class="entity-card-action">
                            <a href="<?php echo e(route('admin.fuel-logs.vehicle-history', $fuelLog->vehicle)); ?>" class="btn-detail btn-detail-outline btn-sm">
                                <i class="bi bi-clock-history"></i>
                                <?php echo e(__('View Fuel History')); ?>

                            </a>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon info">
                        <i class="bi bi-droplet"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Fuel Details')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Fuel Type')); ?></span>
                            <span class="info-item-value">
                                <span class="badge bg-<?php echo e($fuelTypeClasses[$fuelLog->fuel_type] ?? 'secondary'); ?>">
                                    <?php echo e(__(ucfirst($fuelLog->fuel_type))); ?>

                                </span>
                            </span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Quantity')); ?></span>
                            <span class="info-item-value highlight"><?php echo e(number_format($fuelLog->quantity, 2)); ?> <?php echo e($fuelLog->fuel_type === 'electric' ? 'kWh' : 'L'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Price Per Unit')); ?></span>
                            <span class="info-item-value">$<?php echo e(number_format($fuelLog->price_per_unit, 2)); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Total Cost')); ?></span>
                            <span class="info-item-value highlight text-success">$<?php echo e(number_format($fuelLog->total_cost, 2)); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Full Tank')); ?></span>
                            <span class="info-item-value">
                                <?php if($fuelLog->is_full_tank): ?>
                                    <span class="badge bg-success"><i class="bi bi-check"></i> <?php echo e(__('Yes')); ?></span>
                                <?php else: ?>
                                    <span class="badge bg-secondary"><?php echo e(__('No')); ?></span>
                                <?php endif; ?>
                            </span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Payment Method')); ?></span>
                            <span class="info-item-value">
                                <span class="badge bg-<?php echo e($paymentClasses[$fuelLog->payment_method] ?? 'secondary'); ?>">
                                    <?php echo e(__(ucfirst(str_replace('_', ' ', $fuelLog->payment_method)))); ?>

                                </span>
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon warning">
                        <i class="bi bi-speedometer2"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Odometer & Efficiency')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Odometer Reading')); ?></span>
                            <span class="info-item-value highlight"><?php echo e($fuelLog->odometer_reading ? number_format($fuelLog->odometer_reading) . ' km' : '-'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Previous Reading')); ?></span>
                            <span class="info-item-value"><?php echo e($fuelLog->previous_odometer ? number_format($fuelLog->previous_odometer) . ' km' : '-'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Distance Traveled')); ?></span>
                            <span class="info-item-value"><?php echo e($fuelLog->distance_traveled ? number_format($fuelLog->distance_traveled) . ' km' : '-'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Fuel Efficiency')); ?></span>
                            <span class="info-item-value">
                                <?php if($fuelLog->fuel_efficiency): ?>
                                    <span class="badge bg-success fs-6">
                                        <i class="bi bi-speedometer2 me-1"></i>
                                        <?php echo e(number_format($fuelLog->fuel_efficiency, 2)); ?> km/L
                                    </span>
                                <?php else: ?>
                                    <span class="text-muted"><?php echo e(__('Not calculated')); ?></span>
                                <?php endif; ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            
            <?php if($fuelLog->fuel_station || $fuelLog->station_location || $fuelLog->receipt_number): ?>
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon success">
                        <i class="bi bi-geo-alt"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Station Details')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        <?php if($fuelLog->fuel_station): ?>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Fuel Station')); ?></span>
                            <span class="info-item-value"><?php echo e($fuelLog->fuel_station); ?></span>
                        </div>
                        <?php endif; ?>
                        <?php if($fuelLog->station_location): ?>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Station Location')); ?></span>
                            <span class="info-item-value"><?php echo e($fuelLog->station_location); ?></span>
                        </div>
                        <?php endif; ?>
                        <?php if($fuelLog->receipt_number): ?>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Receipt Number')); ?></span>
                            <span class="info-item-value highlight"><?php echo e($fuelLog->receipt_number); ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            
            <?php if($fuelLog->notes): ?>
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon secondary">
                        <i class="bi bi-journal-text"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Notes')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <p class="mb-0"><?php echo e($fuelLog->notes); ?></p>
                </div>
            </div>
            <?php endif; ?>
        </div>

        
        <div class="col-lg-4">
            
            <?php if($fuelLog->driver): ?>
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon info">
                        <i class="bi bi-person"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Driver')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="entity-card">
                        <div class="entity-card-avatar info">
                            <i class="bi bi-person"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-name"><?php echo e($fuelLog->driver->name); ?></h6>
                            <div class="entity-card-meta">
                                <span><i class="bi bi-telephone"></i> <?php echo e($fuelLog->driver->mobile); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            
            <?php if($fuelLog->trip): ?>
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon warning">
                        <i class="bi bi-signpost"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Linked Trip')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="data-list">
                        <div class="data-list-item">
                            <span class="data-list-item-label"><?php echo e(__('Trip Number')); ?></span>
                            <span class="data-list-item-value">
                                <a href="<?php echo e(route('admin.trips.show', $fuelLog->trip)); ?>"><?php echo e($fuelLog->trip->trip_number); ?></a>
                            </span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label"><?php echo e(__('Status')); ?></span>
                            <span class="data-list-item-value">
                                <span class="badge bg-<?php echo e($fuelLog->trip->status === 'delivered' ? 'success' : 'warning'); ?>">
                                    <?php echo e(__(ucfirst($fuelLog->trip->status))); ?>

                                </span>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon success">
                        <i class="bi bi-graph-up"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Vehicle Fuel Stats')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="data-list">
                        <div class="data-list-item">
                            <span class="data-list-item-label"><?php echo e(__('Total Cost')); ?></span>
                            <span class="data-list-item-value text-success fw-bold">$<?php echo e(number_format($vehicleStats['total_cost'] ?? 0, 2)); ?></span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label"><?php echo e(__('Total Fuel')); ?></span>
                            <span class="data-list-item-value"><?php echo e(number_format($vehicleStats['total_quantity'] ?? 0, 2)); ?> L</span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label"><?php echo e(__('Avg Efficiency')); ?></span>
                            <span class="data-list-item-value"><?php echo e(($vehicleStats['avg_efficiency'] ?? false) ? number_format($vehicleStats['avg_efficiency'], 2) . ' km/L' : '-'); ?></span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label"><?php echo e(__('Fill Count')); ?></span>
                            <span class="data-list-item-value"><?php echo e($vehicleStats['fill_count'] ?? 0); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon secondary">
                        <i class="bi bi-clock-history"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Activity')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <?php if($fuelLog->creator): ?>
                    <div class="entity-card mb-3">
                        <div class="entity-card-avatar secondary">
                            <i class="bi bi-person-badge"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-name"><?php echo e($fuelLog->creator->name); ?></h6>
                            <p class="entity-card-subtitle"><?php echo e(__('Created by')); ?></p>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="detail-timeline">
                        <div class="timeline-item">
                            <div class="timeline-marker info"></div>
                            <div class="timeline-content">
                                <div class="timeline-title"><?php echo e(__('Fill Date')); ?></div>
                                <div class="timeline-date">
                                    <?php echo e($fuelLog->fill_date->format('M d, Y')); ?>

                                    <?php if($fuelLog->fill_time): ?>
                                        · <?php echo e(\Carbon\Carbon::parse($fuelLog->fill_time)->format('h:i A')); ?>

                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="timeline-item">
                            <div class="timeline-marker success"></div>
                            <div class="timeline-content">
                                <div class="timeline-title"><?php echo e(__('Record Created')); ?></div>
                                <div class="timeline-date"><?php echo e($fuelLog->created_at->format('M d, Y h:i A')); ?></div>
                            </div>
                        </div>
                        <?php if($fuelLog->updated_at != $fuelLog->created_at): ?>
                        <div class="timeline-item">
                            <div class="timeline-marker warning"></div>
                            <div class="timeline-content">
                                <div class="timeline-title"><?php echo e(__('Last Updated')); ?></div>
                                <div class="timeline-date"><?php echo e($fuelLog->updated_at->format('M d, Y h:i A')); ?></div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            
            <?php if(auth()->user()->hasPermission('fuel.delete')): ?>
            <div class="detail-card border-danger">
                <div class="detail-card-header bg-danger bg-opacity-10">
                    <div class="detail-card-header-icon" style="background: rgba(220, 53, 69, 0.1); color: #dc3545;">
                        <i class="bi bi-exclamation-triangle"></i>
                    </div>
                    <h5 class="detail-card-title text-danger"><?php echo e(__('Danger Zone')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <p class="text-muted small mb-3"><?php echo e(__('Once you delete this fuel log, there is no going back. Please be certain.')); ?></p>
                    <form action="<?php echo e(route('admin.fuel-logs.destroy', $fuelLog)); ?>" method="POST"
                          onsubmit="return confirm('<?php echo e(__('Are you sure you want to delete this fuel log?')); ?>')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="bi bi-trash me-1"></i>
                            <?php echo e(__('Delete Fuel Log')); ?>

                        </button>
                    </form>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\fleet-management\resources\views/admin/fuel-logs/show.blade.php ENDPATH**/ ?>