<?php $__env->startSection('title', __('add_driver') . ' - ' . __('app_name')); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/admincreatepage.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="create-page-container">
    
    <div class="create-page-header">
        <div class="create-page-header-content">
            <nav class="create-page-breadcrumb">
                <a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('dashboard')); ?></a>
                <i class="bi bi-chevron-right"></i>
                <a href="<?php echo e(route('admin.drivers.index')); ?>"><?php echo e(__('drivers')); ?></a>
                <i class="bi bi-chevron-right"></i>
                <span><?php echo e(__('add_driver')); ?></span>
            </nav>
            <h1 class="create-page-title">
                <span class="create-page-title-icon">
                    <i class="bi bi-plus-circle"></i>
                </span>
                <?php echo e(__('add_driver')); ?>

            </h1>
            <p class="create-page-subtitle"><?php echo e(__('Register a new driver in the system')); ?></p>
        </div>
        <div class="create-page-actions">
            <a href="<?php echo e(route('admin.drivers.index')); ?>" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                <?php echo e(__('back')); ?>

            </a>
        </div>
    </div>

    
    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i><?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('admin.drivers.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="create-form-layout">
            
            <div class="create-form-main">
                
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon primary">
                            <i class="bi bi-person-circle"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title"><?php echo e(__('Basic Information')); ?></h3>
                            <p class="create-card-subtitle"><?php echo e(__('Driver personal details')); ?></p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="name" class="create-form-label">
                                    <?php echo e(__('driver_name')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="text" 
                                       class="create-input <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="name" 
                                       name="name" 
                                       value="<?php echo e(old('name')); ?>" 
                                       placeholder="<?php echo e(__('Full Name')); ?>" 
                                       required>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="create-form-error"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <span class="create-form-hint"><?php echo e(__('Enter driver\'s full legal name')); ?></span>
                            </div>
                            <div class="create-form-group">
                                <label for="mobile" class="create-form-label">
                                    <?php echo e(__('mobile')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="tel" 
                                       class="create-input <?php $__errorArgs = ['mobile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="mobile" 
                                       name="mobile" 
                                       value="<?php echo e(old('mobile')); ?>" 
                                       placeholder="+91 98765 43210" 
                                       required>
                                <?php $__errorArgs = ['mobile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="create-form-error"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <span class="create-form-hint"><?php echo e(__('Primary contact number')); ?></span>
                            </div>
                        </div>
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="password" class="create-form-label">
                                    <?php echo e(__('password')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="password" 
                                       class="create-input <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="password" 
                                       name="password" 
                                       required>
                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="create-form-error"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <span class="create-form-hint"><?php echo e(__('For mobile app login (min 6 characters)')); ?></span>
                            </div>
                            <div class="create-form-group">
                                <label for="license_number" class="create-form-label">
                                    <?php echo e(__('license_number')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="text" 
                                       class="create-input <?php $__errorArgs = ['license_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="license_number" 
                                       name="license_number" 
                                       value="<?php echo e(old('license_number')); ?>" 
                                       placeholder="DL-123456789" 
                                       required>
                                <?php $__errorArgs = ['license_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="create-form-error"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <span class="create-form-hint"><?php echo e(__('Valid driving license number')); ?></span>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon info">
                            <i class="bi bi-truck-front"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title"><?php echo e(__('Driver Type & Vehicle')); ?></h3>
                            <p class="create-card-subtitle"><?php echo e(__('Assignment configuration')); ?></p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <?php if($availableVehicles->isEmpty()): ?>
                            <div class="create-alert create-alert-warning">
                                <div class="create-alert-icon">
                                    <i class="bi bi-exclamation-triangle"></i>
                                </div>
                                <div class="create-alert-content">
                                    <h6 class="create-alert-title"><?php echo e(__('No Vehicles Available')); ?></h6>
                                    <p class="create-alert-text"><?php echo e(__('All vehicles are already assigned to drivers. You can only create "Driver Only" type drivers.')); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="driver_type" class="create-form-label">
                                    <?php echo e(__('driver_type')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <select class="create-select <?php $__errorArgs = ['driver_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="driver_type" 
                                        name="driver_type" 
                                        required>
                                    <option value=""><?php echo e(__('select_option')); ?></option>
                                    <option value="driver_only" <?php echo e(old('driver_type') === 'driver_only' ? 'selected' : ''); ?>>
                                        <?php echo e(__('driver_only')); ?> - <?php echo e(__('Driver without own vehicle')); ?>

                                    </option>
                                    <option value="own_vehicle" <?php echo e(old('driver_type') === 'own_vehicle' ? 'selected' : ''); ?>>
                                        <?php echo e(__('own_vehicle')); ?> - <?php echo e(__('Driver with own vehicle')); ?>

                                    </option>
                                </select>
                                <?php $__errorArgs = ['driver_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="create-form-error"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <span class="create-form-hint"><?php echo e(__('Select driver classification')); ?></span>
                            </div>
                            <div class="create-form-group" id="vehicle_field" style="display: none;">
                                <label for="own_vehicle_id" class="create-form-label">
                                    <?php echo e(__('vehicle')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <select class="create-select <?php $__errorArgs = ['own_vehicle_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="own_vehicle_id" 
                                        name="own_vehicle_id">
                                    <option value=""><?php echo e(__('select_option')); ?></option>
                                    <?php $__currentLoopData = $availableVehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($vehicle->id); ?>" <?php echo e(old('own_vehicle_id') == $vehicle->id ? 'selected' : ''); ?>>
                                            <?php echo e($vehicle->vehicle_number); ?> - <?php echo e($vehicle->vehicleType->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['own_vehicle_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="create-form-error"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <span class="create-form-hint"><?php echo e(__('Only vehicles without assigned drivers')); ?></span>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon success">
                            <i class="bi bi-gear"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title"><?php echo e(__('Status & Contact')); ?></h3>
                            <p class="create-card-subtitle"><?php echo e(__('Additional driver information')); ?></p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="status" class="create-form-label">
                                    <?php echo e(__('status')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <select class="create-select <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="status" 
                                        name="status" 
                                        required>
                                    <option value="active" <?php echo e(old('status', 'active') === 'active' ? 'selected' : ''); ?>>
                                        <?php echo e(__('active')); ?>

                                    </option>
                                    <option value="inactive" <?php echo e(old('status') === 'inactive' ? 'selected' : ''); ?>>
                                        <?php echo e(__('inactive')); ?>

                                    </option>
                                </select>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="create-form-error"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="create-form-group">
                                <label for="emergency_contact" class="create-form-label">
                                    <?php echo e(__('emergency_contact')); ?>

                                    <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                                </label>
                                <input type="tel" 
                                       class="create-input <?php $__errorArgs = ['emergency_contact'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="emergency_contact" 
                                       name="emergency_contact" 
                                       value="<?php echo e(old('emergency_contact')); ?>" 
                                       placeholder="+91 98765 00000">
                                <?php $__errorArgs = ['emergency_contact'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="create-form-error"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <span class="create-form-hint"><?php echo e(__('Emergency contact number')); ?></span>
                            </div>
                        </div>
                        <div class="create-form-group">
                            <label for="address" class="create-form-label">
                                <?php echo e(__('address')); ?>

                                <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                            </label>
                            <textarea class="create-textarea <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="address" 
                                      name="address" 
                                      rows="3" 
                                      placeholder="<?php echo e(__('Full address...')); ?>"><?php echo e(old('address')); ?></textarea>
                            <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="create-form-error"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    
                    <div class="create-card-actions">
                        <div class="create-card-actions-left">
                            <a href="<?php echo e(route('admin.drivers.index')); ?>" class="create-btn create-btn-secondary">
                                <i class="bi bi-x-lg"></i>
                                <?php echo e(__('cancel')); ?>

                            </a>
                        </div>
                        <div class="create-card-actions-right">
                            <button type="submit" class="create-btn create-btn-primary">
                                <i class="bi bi-check-lg"></i>
                                <?php echo e(__('save')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="create-form-sidebar">
                
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-lightbulb"></i>
                        </div>
                        <h4 class="create-sidebar-title"><?php echo e(__('Quick Tips')); ?></h4>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                <?php echo e(__('Driver name should match their ID document')); ?>

                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                <?php echo e(__('Mobile number is used for app login')); ?>

                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                <?php echo e(__('Password must be at least 6 characters')); ?>

                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                <?php echo e(__('Own Vehicle drivers are tied to specific vehicles')); ?>

                            </li>
                        </ul>
                    </div>
                </div>

                
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-info-circle"></i>
                        </div>
                        <h4 class="create-sidebar-title"><?php echo e(__('Driver Types')); ?></h4>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-status-preview">
                            <span class="create-status-badge" style="background-color: rgba(13, 110, 253, 0.1); color: #0d6efd;">
                                <i class="bi bi-truck-front"></i>
                                <?php echo e(__('own_vehicle')); ?>

                            </span>
                            <p class="create-status-description"><?php echo e(__('Driver owns and operates their specific vehicle')); ?></p>
                        </div>
                        <div class="create-status-preview">
                            <span class="create-status-badge" style="background-color: rgba(13, 202, 240, 0.1); color: #0dcaf0;">
                                <i class="bi bi-person"></i>
                                <?php echo e(__('driver_only')); ?>

                            </span>
                            <p class="create-status-description"><?php echo e(__('Driver can be assigned to any available vehicle')); ?></p>
                        </div>
                    </div>
                </div>

                
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h4 class="create-sidebar-title"><?php echo e(__('Quick Actions')); ?></h4>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="<?php echo e(route('admin.drivers.index')); ?>" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                <?php echo e(__('View All Drivers')); ?>

                            </a>
                            <a href="<?php echo e(route('admin.vehicles.index')); ?>" class="create-quick-action-btn">
                                <i class="bi bi-truck"></i>
                                <?php echo e(__('Manage Vehicles')); ?>

                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const driverType = document.getElementById('driver_type');
    const vehicleField = document.getElementById('vehicle_field');
    const vehicleSelect = document.getElementById('own_vehicle_id');

    function toggleVehicleField() {
        if (driverType.value === 'own_vehicle') {
            vehicleField.style.display = 'block';
            vehicleSelect.required = true;
        } else {
            vehicleField.style.display = 'none';
            vehicleSelect.required = false;
            vehicleSelect.value = '';
        }
    }

    // Initial check
    toggleVehicleField();

    // Listen for changes
    driverType.addEventListener('change', toggleVehicleField);
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\fleet-management\resources\views/admin/drivers/create.blade.php ENDPATH**/ ?>