<?php $__env->startSection('title', __('costs') . ' - ' . __('app_name')); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/adminlistpage.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-currency-dollar"></i>
                <?php echo e(__('costs')); ?>

            </h1>
            <p class="list-page-subtitle"><?php echo e(__('manage')); ?> <?php echo e(__('trip')); ?> <?php echo e(__('costs')); ?> <?php echo e(__('and')); ?> <?php echo e(__('expenses')); ?></p>
        </div>
        <div class="list-page-header-actions">
            <?php if(auth()->user()->hasPermission('trips.create')): ?>
            <a href="<?php echo e(route('admin.costs.create')); ?>" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                <?php echo e(__('add')); ?> <?php echo e(__('costs')); ?>

            </a>
            <?php endif; ?>
        </div>
    </div>

    
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-check-circle me-2"></i><?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i><?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    
    <div class="list-stats-bar">
        <div class="list-stat-card gradient-violet">
            <div class="list-stat-icon">
                <i class="bi bi-receipt"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($costs->total()); ?></div>
                <div class="list-stat-label"><?php echo e(__('total')); ?> <?php echo e(__('records')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-graph-up-arrow"></i>
                <?php echo e(__('All time')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-blue">
            <div class="list-stat-icon">
                <i class="bi bi-cash"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">$<?php echo e(number_format($costs->sum('base_cost'), 0)); ?></div>
                <div class="list-stat-label"><?php echo e(__('base_cost')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-truck"></i>
                <?php echo e(__('Transportation')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-amber">
            <div class="list-stat-icon">
                <i class="bi bi-fuel-pump"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">$<?php echo e(number_format($costs->sum('fuel_cost'), 0)); ?></div>
                <div class="list-stat-label"><?php echo e(__('fuel_cost')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-droplet"></i>
                <?php echo e(__('Fuel')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-green">
            <div class="list-stat-icon">
                <i class="bi bi-calculator"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">$<?php echo e(number_format($costs->sum('total_cost'), 0)); ?></div>
                <div class="list-stat-label"><?php echo e(__('total_cost')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-check-circle"></i>
                <?php echo e(__('Grand Total')); ?>

            </div>
        </div>
    </div>

    
    <div class="list-filter-bar">
        <form method="GET" action="<?php echo e(route('admin.costs.index')); ?>">
            <div class="list-filter-row">
                <div class="list-filter-group search-group">
                    <div class="list-search-box">
                        <input type="text" 
                               name="search" 
                               placeholder="<?php echo e(__('search')); ?> <?php echo e(__('trip_number')); ?>..." 
                               value="<?php echo e(request('search')); ?>">
                        <i class="bi bi-search"></i>
                    </div>
                </div>
                <div class="list-filter-actions">
                    <button type="submit" class="btn-filter">
                        <i class="bi bi-funnel"></i>
                        <?php echo e(__('filter')); ?>

                    </button>
                    <a href="<?php echo e(route('admin.costs.index')); ?>" class="btn-filter-clear">
                        <i class="bi bi-x-circle"></i>
                        <?php echo e(__('clear')); ?>

                    </a>
                </div>
            </div>
        </form>
    </div>

    
    <div class="list-table-container">
        <div class="list-table-header">
            <h5 class="list-table-title">
                <i class="bi bi-table me-2"></i>
                <?php echo e(__('cost')); ?> <?php echo e(__('records')); ?>

                <span class="list-table-count">(<?php echo e($costs->total()); ?> <?php echo e(__('total')); ?>)</span>
            </h5>
        </div>

        <?php if($costs->isEmpty()): ?>
            <div class="list-empty-state">
                <div class="list-empty-icon">
                    <i class="bi bi-currency-dollar"></i>
                </div>
                <h4><?php echo e(__('no_records')); ?></h4>
                <p><?php echo e(__('no')); ?> <?php echo e(__('cost')); ?> <?php echo e(__('records')); ?> <?php echo e(__('found')); ?>. <?php echo e(__('add')); ?> <?php echo e(__('costs')); ?> <?php echo e(__('for')); ?> <?php echo e(__('completed')); ?> <?php echo e(__('trips')); ?>.</p>
                <?php if(auth()->user()->hasPermission('trips.create')): ?>
                <a href="<?php echo e(route('admin.costs.create')); ?>" class="btn-create">
                    <i class="bi bi-plus-lg"></i>
                    <?php echo e(__('add')); ?> <?php echo e(__('costs')); ?>

                </a>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="list-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo e(__('trip_number')); ?></th>
                            <th><?php echo e(__('vehicle')); ?></th>
                            <th><?php echo e(__('driver')); ?></th>
                            <th class="text-end"><?php echo e(__('base_cost')); ?></th>
                            <th class="text-end"><?php echo e(__('toll_cost')); ?></th>
                            <th class="text-end"><?php echo e(__('fuel_cost')); ?></th>
                            <th class="text-end"><?php echo e(__('other_costs')); ?></th>
                            <th class="text-end"><?php echo e(__('total_cost')); ?></th>
                            <th class="text-center"><?php echo e(__('actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $costs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <span class="text-muted"><?php echo e($costs->firstItem() + $loop->index); ?></span>
                            </td>
                            <td>
                                <a href="<?php echo e(route('admin.trips.show', $cost->trip)); ?>" class="table-cell-id">
                                    <?php echo e($cost->trip->trip_number); ?>

                                </a>
                            </td>
                            <td>
                                <span class="table-badge table-badge-info">
                                    <i class="bi bi-truck"></i>
                                    <?php echo e($cost->trip->vehicle->vehicle_number ?? 'N/A'); ?>

                                </span>
                            </td>
                            <td>
                                <div class="table-cell-user">
                                    <div class="table-cell-user-avatar">
                                        <i class="bi bi-person"></i>
                                    </div>
                                    <span><?php echo e($cost->trip->driver->name ?? 'N/A'); ?></span>
                                </div>
                            </td>
                            <td class="text-end">
                                <span class="cost-value">
                                    <span class="cost-currency">$</span><?php echo e(number_format($cost->base_cost, 2)); ?>

                                </span>
                            </td>
                            <td class="text-end">
                                <span class="cost-value">
                                    <span class="cost-currency">$</span><?php echo e(number_format($cost->toll_cost, 2)); ?>

                                </span>
                            </td>
                            <td class="text-end">
                                <span class="cost-value">
                                    <span class="cost-currency">$</span><?php echo e(number_format($cost->fuel_cost, 2)); ?>

                                </span>
                            </td>
                            <td class="text-end">
                                <span class="cost-value">
                                    <span class="cost-currency">$</span><?php echo e(number_format($cost->other_costs, 2)); ?>

                                </span>
                            </td>
                            <td class="text-end">
                                <span class="cost-total">
                                    <span class="cost-currency">$</span><?php echo e(number_format($cost->total_cost, 2)); ?>

                                </span>
                            </td>
                            <td>
                                <div class="table-actions">
                                    <a href="<?php echo e(route('admin.trips.show', $cost->trip)); ?>" 
                                       class="btn-table-action btn-table-view" 
                                       title="<?php echo e(__('view')); ?> <?php echo e(__('trip')); ?>">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <?php if(auth()->user()->hasPermission('trips.edit')): ?>
                                    <a href="<?php echo e(route('admin.costs.edit', $cost)); ?>" 
                                       class="btn-table-action btn-table-edit" 
                                       title="<?php echo e(__('edit')); ?>">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr class="table-totals-row">
                            <td colspan="4" class="text-end fw-bold"><?php echo e(__('total')); ?>:</td>
                            <td class="text-end">
                                <span class="cost-total-footer">
                                    <span class="cost-currency">$</span><?php echo e(number_format($costs->sum('base_cost'), 2)); ?>

                                </span>
                            </td>
                            <td class="text-end">
                                <span class="cost-total-footer">
                                    <span class="cost-currency">$</span><?php echo e(number_format($costs->sum('toll_cost'), 2)); ?>

                                </span>
                            </td>
                            <td class="text-end">
                                <span class="cost-total-footer">
                                    <span class="cost-currency">$</span><?php echo e(number_format($costs->sum('fuel_cost'), 2)); ?>

                                </span>
                            </td>
                            <td class="text-end">
                                <span class="cost-total-footer">
                                    <span class="cost-currency">$</span><?php echo e(number_format($costs->sum('other_costs'), 2)); ?>

                                </span>
                            </td>
                            <td class="text-end">
                                <span class="cost-grand-total">
                                    <span class="cost-currency">$</span><?php echo e(number_format($costs->sum('total_cost'), 2)); ?>

                                </span>
                            </td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>

            
            <?php if($costs->hasPages()): ?>
            <div class="list-pagination">
                <div class="pagination-info">
                    <?php echo e(__('Showing')); ?> <?php echo e($costs->firstItem()); ?> <?php echo e(__('to')); ?> <?php echo e($costs->lastItem()); ?> <?php echo e(__('of')); ?> <?php echo e($costs->total()); ?> <?php echo e(__('entries')); ?>

                </div>
                <div class="pagination-links">
                    <?php echo e($costs->links()); ?>

                </div>
            </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>

    
    <?php if(!$costs->isEmpty()): ?>
    <div class="cost-summary-grid">
        <div class="cost-summary-card">
            <div class="cost-summary-icon" style="background: linear-gradient(135deg, #7c3aed 0%, #a78bfa 100%);">
                <i class="bi bi-currency-dollar"></i>
            </div>
            <div class="cost-summary-content">
                <span class="cost-summary-label"><?php echo e(__('total')); ?> <?php echo e(__('base_cost')); ?></span>
                <span class="cost-summary-value">$<?php echo e(number_format($costs->sum('base_cost'), 2)); ?></span>
            </div>
        </div>
        <div class="cost-summary-card">
            <div class="cost-summary-icon" style="background: linear-gradient(135deg, #d97706 0%, #fbbf24 100%);">
                <i class="bi bi-signpost-split"></i>
            </div>
            <div class="cost-summary-content">
                <span class="cost-summary-label"><?php echo e(__('total')); ?> <?php echo e(__('toll_cost')); ?></span>
                <span class="cost-summary-value">$<?php echo e(number_format($costs->sum('toll_cost'), 2)); ?></span>
            </div>
        </div>
        <div class="cost-summary-card">
            <div class="cost-summary-icon" style="background: linear-gradient(135deg, #dc2626 0%, #f87171 100%);">
                <i class="bi bi-fuel-pump"></i>
            </div>
            <div class="cost-summary-content">
                <span class="cost-summary-label"><?php echo e(__('total')); ?> <?php echo e(__('fuel_cost')); ?></span>
                <span class="cost-summary-value">$<?php echo e(number_format($costs->sum('fuel_cost'), 2)); ?></span>
            </div>
        </div>
        <div class="cost-summary-card">
            <div class="cost-summary-icon" style="background: linear-gradient(135deg, #059669 0%, #34d399 100%);">
                <i class="bi bi-calculator"></i>
            </div>
            <div class="cost-summary-content">
                <span class="cost-summary-label"><?php echo e(__('total')); ?> <?php echo e(__('costs')); ?></span>
                <span class="cost-summary-value">$<?php echo e(number_format($costs->sum('total_cost'), 2)); ?></span>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<style>
/* Cost Value Styles */
.cost-value {
    font-weight: 500;
    color: var(--text-primary);
}

.cost-currency {
    color: var(--text-muted);
    font-size: 0.85em;
}

.cost-total {
    font-weight: 700;
    color: var(--success-color);
    font-size: 1rem;
}

.cost-total-footer {
    font-weight: 600;
    color: var(--text-primary);
}

.cost-grand-total {
    font-weight: 700;
    color: var(--success-color);
    font-size: 1.1rem;
}

/* Table Totals Row */
.table-totals-row {
    background: var(--body-bg);
}

.table-totals-row td {
    border-top: 2px solid var(--border-color);
    padding-top: 1rem !important;
    padding-bottom: 1rem !important;
}

/* Cost Summary Grid */
.cost-summary-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.25rem;
    margin-top: 1.5rem;
}

.cost-summary-card {
    display: flex;
    align-items: center;
    gap: 1rem;
    background: var(--card-bg);
    border: 1px solid var(--border-color);
    border-radius: 14px;
    padding: 1.25rem 1.5rem;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
    transition: all 0.3s ease;
}

.cost-summary-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.cost-summary-icon {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.cost-summary-icon i {
    font-size: 1.25rem;
    color: #ffffff;
}

.cost-summary-content {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.cost-summary-label {
    font-size: 0.8rem;
    color: var(--text-muted);
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.3px;
}

.cost-summary-value {
    font-size: 1.35rem;
    font-weight: 700;
    color: var(--text-primary);
}

[data-theme="dark"] .cost-summary-card {
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
}

[data-theme="dark"] .cost-summary-card:hover {
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
}

@media (max-width: 767.98px) {
    .cost-summary-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .cost-summary-card {
        padding: 1rem;
    }
    
    .cost-summary-icon {
        width: 42px;
        height: 42px;
    }
    
    .cost-summary-value {
        font-size: 1.1rem;
    }
}

@media (max-width: 480px) {
    .cost-summary-grid {
        grid-template-columns: 1fr;
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\fleet-management\resources\views/admin/costs/index.blade.php ENDPATH**/ ?>