<?php $__env->startSection('title', __('Fuel Logs') . ' - ' . __('app_name')); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/adminlistpage.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-fuel-pump"></i>
                <?php echo e(__('Fuel Logs')); ?>

            </h1>
            <p class="list-page-subtitle"><?php echo e(__('Track fuel consumption and costs for your fleet')); ?></p>
        </div>
        <div class="list-page-header-actions">
            <?php if(auth()->user()->hasPermission('fuel.create')): ?>
            <a href="<?php echo e(route('admin.fuel-logs.create')); ?>" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                <?php echo e(__('Add Fuel Log')); ?>

            </a>
            <?php endif; ?>
        </div>
    </div>

    
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-check-circle me-2"></i><?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i><?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    
    <div class="list-stats-bar">
        <div class="list-stat-card gradient-violet">
            <div class="list-stat-icon">
                <i class="bi bi-fuel-pump"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($fuelLogs->total()); ?></div>
                <div class="list-stat-label"><?php echo e(__('Total Records')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-graph-up-arrow"></i>
                <?php echo e(__('All time')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-rose">
            <div class="list-stat-icon">
                <i class="bi bi-droplet"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e(number_format($stats['total_quantity'] ?? 0, 0)); ?></div>
                <div class="list-stat-label"><?php echo e(__('Total Liters')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-water"></i>
                <?php echo e(__('Fuel consumed')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-cyan">
            <div class="list-stat-icon">
                <i class="bi bi-currency-dollar"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">$<?php echo e(number_format($stats['total_cost'] ?? 0, 0)); ?></div>
                <div class="list-stat-label"><?php echo e(__('Total Cost')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-cash-stack"></i>
                <?php echo e(__('All expenses')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-amber">
            <div class="list-stat-icon">
                <i class="bi bi-speedometer2"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($stats['avg_efficiency'] ? number_format($stats['avg_efficiency'], 1) : '-'); ?></div>
                <div class="list-stat-label"><?php echo e(__('Avg km/L')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-lightning"></i>
                <?php echo e(__('Efficiency')); ?>

            </div>
        </div>
    </div>

    
    <div class="list-filter-bar">
        <div class="list-filter-header">
            <div class="list-filter-title">
                <i class="bi bi-funnel"></i>
                <?php echo e(__('Filters')); ?>

            </div>
            <?php if(request()->hasAny(['search', 'vehicle_id', 'driver_id', 'fuel_type', 'payment_method', 'date_from', 'date_to'])): ?>
                <a href="<?php echo e(route('admin.fuel-logs.index')); ?>" class="list-filter-clear">
                    <i class="bi bi-x-circle"></i>
                    <?php echo e(__('Clear Filters')); ?>

                </a>
            <?php endif; ?>
        </div>
        <form action="<?php echo e(route('admin.fuel-logs.index')); ?>" method="GET">
            <div class="list-filter-row">
                <div class="list-filter-group search-group">
                    <label><?php echo e(__('Search')); ?></label>
                    <div class="list-search-box">
                        <i class="bi bi-search"></i>
                        <input type="text" name="search" class="form-control" 
                               placeholder="<?php echo e(__('Search by fuel number...')); ?>"
                               value="<?php echo e(request('search')); ?>">
                    </div>
                </div>
                <div class="list-filter-group">
                    <label><?php echo e(__('Vehicle')); ?></label>
                    <select name="vehicle_id" class="form-select">
                        <option value=""><?php echo e(__('All Vehicles')); ?></option>
                        <?php $__currentLoopData = $vehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($vehicle->id); ?>" <?php echo e(request('vehicle_id') == $vehicle->id ? 'selected' : ''); ?>>
                                <?php echo e($vehicle->vehicle_number); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="list-filter-group">
                    <label><?php echo e(__('Fuel Type')); ?></label>
                    <select name="fuel_type" class="form-select">
                        <option value=""><?php echo e(__('All Types')); ?></option>
                        <option value="diesel" <?php echo e(request('fuel_type') === 'diesel' ? 'selected' : ''); ?>><?php echo e(__('Diesel')); ?></option>
                        <option value="petrol" <?php echo e(request('fuel_type') === 'petrol' ? 'selected' : ''); ?>><?php echo e(__('Petrol')); ?></option>
                        <option value="cng" <?php echo e(request('fuel_type') === 'cng' ? 'selected' : ''); ?>><?php echo e(__('CNG')); ?></option>
                        <option value="electric" <?php echo e(request('fuel_type') === 'electric' ? 'selected' : ''); ?>><?php echo e(__('Electric')); ?></option>
                    </select>
                </div>
                <div class="list-filter-group">
                    <label><?php echo e(__('Payment')); ?></label>
                    <select name="payment_method" class="form-select">
                        <option value=""><?php echo e(__('All Methods')); ?></option>
                        <option value="cash" <?php echo e(request('payment_method') === 'cash' ? 'selected' : ''); ?>><?php echo e(__('Cash')); ?></option>
                        <option value="card" <?php echo e(request('payment_method') === 'card' ? 'selected' : ''); ?>><?php echo e(__('Card')); ?></option>
                        <option value="company_account" <?php echo e(request('payment_method') === 'company_account' ? 'selected' : ''); ?>><?php echo e(__('Company Account')); ?></option>
                        <option value="fuel_card" <?php echo e(request('payment_method') === 'fuel_card' ? 'selected' : ''); ?>><?php echo e(__('Fuel Card')); ?></option>
                    </select>
                </div>
                <div class="list-filter-group">
                    <label><?php echo e(__('Date From')); ?></label>
                    <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from')); ?>">
                </div>
                <div class="list-filter-group">
                    <label><?php echo e(__('Date To')); ?></label>
                    <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to')); ?>">
                </div>
                <div class="list-filter-buttons">
                    <button type="submit" class="btn-filter btn-filter-primary">
                        <i class="bi bi-search"></i>
                        <?php echo e(__('Apply')); ?>

                    </button>
                </div>
            </div>
        </form>
    </div>

    
    <div class="list-card">
        <?php if($fuelLogs->count() > 0): ?>
            <div class="list-table-responsive">
                <table class="list-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('Fuel #')); ?></th>
                            <th><?php echo e(__('Vehicle')); ?></th>
                            <th><?php echo e(__('Fill Date')); ?></th>
                            <th><?php echo e(__('Fuel Type')); ?></th>
                            <th><?php echo e(__('Quantity')); ?></th>
                            <th><?php echo e(__('Total Cost')); ?></th>
                            <th><?php echo e(__('Efficiency')); ?></th>
                            <th><?php echo e(__('Payment')); ?></th>
                            <th class="text-center"><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $fuelLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fuelLog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $fuelTypeClasses = [
                                    'diesel' => 'warning',
                                    'petrol' => 'info',
                                    'cng' => 'success',
                                    'electric' => 'primary'
                                ];
                                $paymentClasses = [
                                    'cash' => 'success',
                                    'card' => 'info',
                                    'company_account' => 'primary',
                                    'fuel_card' => 'warning'
                                ];
                            ?>
                            <tr>
                                <td>
                                    <div class="table-primary-text">
                                        <a href="<?php echo e(route('admin.fuel-logs.show', $fuelLog)); ?>">
                                            <?php echo e($fuelLog->fuel_number); ?>

                                        </a>
                                    </div>
                                    <?php if($fuelLog->is_full_tank): ?>
                                        <span class="badge bg-success badge-sm"><?php echo e(__('Full Tank')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="table-primary-text"><?php echo e($fuelLog->vehicle->vehicle_number); ?></div>
                                    <div class="table-secondary-text"><?php echo e($fuelLog->vehicle->vehicleType->name ?? '-'); ?></div>
                                </td>
                                <td>
                                    <div class="table-primary-text"><?php echo e($fuelLog->fill_date->format('M d, Y')); ?></div>
                                    <?php if($fuelLog->fill_time): ?>
                                        <div class="table-secondary-text"><?php echo e(\Carbon\Carbon::parse($fuelLog->fill_time)->format('h:i A')); ?></div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($fuelTypeClasses[$fuelLog->fuel_type] ?? 'secondary'); ?>">
                                        <?php echo e(__(ucfirst($fuelLog->fuel_type))); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="table-primary-text"><?php echo e(number_format($fuelLog->quantity, 2)); ?> L</div>
                                    <div class="table-secondary-text">$<?php echo e(number_format($fuelLog->price_per_unit, 2)); ?>/L</div>
                                </td>
                                <td>
                                    <div class="table-primary-text text-success fw-semibold">$<?php echo e(number_format($fuelLog->total_cost, 2)); ?></div>
                                </td>
                                <td>
                                    <?php if($fuelLog->fuel_efficiency): ?>
                                        <span class="badge bg-success"><?php echo e(number_format($fuelLog->fuel_efficiency, 2)); ?> km/L</span>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($paymentClasses[$fuelLog->payment_method] ?? 'secondary'); ?>">
                                        <?php echo e(__(ucfirst(str_replace('_', ' ', $fuelLog->payment_method)))); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="table-actions">
                                        <?php if(auth()->user()->hasPermission('fuel.view')): ?>
                                            <a href="<?php echo e(route('admin.fuel-logs.show', $fuelLog)); ?>" 
                                               class="btn-table-action btn-table-view" 
                                               title="<?php echo e(__('View')); ?>">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                        <?php endif; ?>
                                        <?php if(auth()->user()->hasPermission('fuel.edit')): ?>
                                            <a href="<?php echo e(route('admin.fuel-logs.edit', $fuelLog)); ?>" 
                                               class="btn-table-action btn-table-edit" 
                                               title="<?php echo e(__('Edit')); ?>">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                        <?php endif; ?>
                                        <?php if(auth()->user()->hasPermission('fuel.delete')): ?>
                                            <form action="<?php echo e(route('admin.fuel-logs.destroy', $fuelLog)); ?>" method="POST" class="d-inline"
                                                  onsubmit="return confirm('<?php echo e(__('Are you sure you want to delete this fuel log?')); ?>')">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" 
                                                        class="btn-table-action btn-table-delete" 
                                                        title="<?php echo e(__('Delete')); ?>">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            
            <?php if($fuelLogs->hasPages()): ?>
            <div class="list-pagination">
                <div class="list-pagination-info">
                    <?php echo e(__('Showing')); ?> <?php echo e($fuelLogs->firstItem()); ?> <?php echo e(__('to')); ?> <?php echo e($fuelLogs->lastItem()); ?> <?php echo e(__('of')); ?> <?php echo e($fuelLogs->total()); ?> <?php echo e(__('results')); ?>

                </div>
                <nav class="list-pagination-nav">
                    <?php echo e($fuelLogs->links()); ?>

                </nav>
            </div>
            <?php endif; ?>
        <?php else: ?>
            
            <div class="list-empty-state">
                <div class="list-empty-state-icon">
                    <i class="bi bi-fuel-pump"></i>
                </div>
                <h4 class="list-empty-state-title"><?php echo e(__('No Fuel Logs Found')); ?></h4>
                <p class="list-empty-state-text">
                    <?php echo e(__('There are no fuel logs matching your criteria. Add a new fuel log to get started.')); ?>

                </p>
                <?php if(auth()->user()->hasPermission('fuel.create')): ?>
                <a href="<?php echo e(route('admin.fuel-logs.create')); ?>" class="btn-create">
                    <i class="bi bi-plus-lg"></i>
                    <?php echo e(__('Add First Fuel Log')); ?>

                </a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\fleet-management\resources\views/admin/fuel-logs/index.blade.php ENDPATH**/ ?>