<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="description" content="LogiFleet - Fleet Management Software for Smart, Safe & Efficient Logistics Operations">
    <title><?php echo e(__('app_name')); ?> - <?php echo e(__('fleet_management_software')); ?></title>
    
    <!-- Bootstrap 5.3 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    
    <!-- Poppins Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        :root {
            /* Orange Theme - Matching Admin Panel */
            --primary: #f97316;
            --primary-hover: #ea580c;
            --primary-light: #ffedd5;
            --primary-dark: #c2410c;
            --primary-gradient: linear-gradient(135deg, #f97316 0%, #ea580c 100%);
            
            /* Secondary & Accent */
            --secondary: #64748b;
            --accent-blue: #3b82f6;
            --accent-green: #10b981;
            --accent-purple: #8b5cf6;
            --accent-pink: #ec4899;
            --accent-cyan: #06b6d4;
            --accent-red: #ef4444;
            
            /* Neutrals */
            --dark: #1e293b;
            --gray-700: #334155;
            --gray-600: #475569;
            --gray-500: #64748b;
            --gray-400: #94a3b8;
            --gray-300: #cbd5e1;
            --gray-200: #e2e8f0;
            --gray-100: #f1f5f9;
            --gray-50: #f8fafc;
            --white: #ffffff;
        }
        
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; color: var(--dark); overflow-x: hidden; line-height: 1.6; }
        
        /* Navbar */
        .navbar-custom { background: rgba(255,255,255,0.98); backdrop-filter: blur(20px); box-shadow: 0 2px 20px rgba(0,0,0,0.06); padding: 12px 0; position: fixed; width: 100%; top: 0; z-index: 1000; }
        .navbar-brand { display: flex; align-items: center; gap: 12px; font-weight: 700; font-size: 1.5rem; color: var(--dark) !important; text-decoration: none; }
        .brand-icon { width: 45px; height: 45px; background: var(--primary-gradient); border-radius: 12px; display: flex; align-items: center; justify-content: center; color: white; font-size: 1.4rem; box-shadow: 0 4px 15px rgba(249,115,22,0.3); }
        .nav-link-custom { color: var(--gray-600) !important; font-weight: 500; padding: 10px 18px !important; transition: all 0.3s; border-radius: 8px; text-decoration: none}
        .nav-link-custom:hover { color: var(--primary) !important; background: var(--primary-light); }
        .btn-login-nav { background: var(--primary-gradient); color: white !important; padding: 10px 24px !important; border-radius: 10px; font-weight: 600; transition: all 0.3s; border: none; }
        .btn-login-nav:hover { transform: translateY(-2px); box-shadow: 0 8px 25px rgba(249,115,22,0.4); }
        
        /* Hero Section */
        .hero-section { background: linear-gradient(135deg, #fff7ed 0%, #ffedd5 50%, #fed7aa 100%); min-height: 100vh; padding: 140px 0 100px; position: relative; overflow: hidden; }
        .hero-section::before { content: ''; position: absolute; width: 800px; height: 800px; background: radial-gradient(circle, rgba(249,115,22,0.08) 0%, transparent 70%); top: -300px; right: -300px; border-radius: 50%; }
        .hero-badge { display: inline-flex; align-items: center; gap: 10px; background: white; padding: 10px 20px; border-radius: 50px; font-size: 0.9rem; font-weight: 600; color: var(--primary); box-shadow: 0 4px 20px rgba(249,115,22,0.15); margin-bottom: 28px; border: 1px solid var(--primary-light); }
        .hero-badge i { color: var(--accent-green); font-size: 1rem; }
        .hero-title { font-size: 3.5rem; font-weight: 800; line-height: 1.15; color: var(--dark); margin-bottom: 24px; }
        .hero-title span { background: var(--primary-gradient); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; }
        .hero-description { font-size: 1.15rem; color: var(--gray-600); line-height: 1.8; margin-bottom: 36px; max-width: 560px; }
        .hero-features-list { list-style: none; padding: 0; margin: 0 0 36px 0; }
        .hero-features-list li { display: flex; align-items: center; gap: 12px; padding: 8px 0; color: var(--gray-700); font-weight: 500; }
        .hero-features-list li i { color: var(--primary); font-size: 1.1rem; }
        .hero-buttons { display: flex; gap: 16px; flex-wrap: wrap; }
        .btn-hero-primary { background: var(--primary-gradient); color: white; padding: 16px 32px; border-radius: 12px; font-weight: 600; font-size: 1rem; text-decoration: none; display: inline-flex; align-items: center; gap: 10px; transition: all 0.3s; border: none; }
        .btn-hero-primary:hover { transform: translateY(-3px); box-shadow: 0 12px 35px rgba(249,115,22,0.4); color: white; }
        .btn-hero-secondary { background: white; color: var(--dark); padding: 16px 32px; border-radius: 12px; font-weight: 600; font-size: 1rem; text-decoration: none; display: inline-flex; align-items: center; gap: 10px; transition: all 0.3s; border: 2px solid var(--gray-200); }
        .btn-hero-secondary:hover { border-color: var(--primary); color: var(--primary); transform: translateY(-3px); }
        .hero-stats { display: flex; gap: 48px; margin-top: 56px; padding-top: 32px; border-top: 1px solid rgba(249,115,22,0.2); }
        .stat-item { text-align: left; }
        .stat-number { font-size: 2.75rem; font-weight: 800; color: var(--primary); line-height: 1; }
        .stat-label { color: var(--gray-600); font-size: 0.9rem; font-weight: 500; margin-top: 4px; }
        
        /* Login Card */
        .login-card { background: white; border-radius: 24px; padding: 44px; box-shadow: 0 25px 60px rgba(0,0,0,0.12); position: relative; z-index: 10; border: 1px solid rgba(249,115,22,0.1); }
        .login-header { text-align: center; margin-bottom: 36px; }
        .login-icon-wrapper { width: 72px; height: 72px; background: var(--primary-gradient); border-radius: 18px; display: flex; align-items: center; justify-content: center; margin: 0 auto 18px; font-size: 2rem; color: white; box-shadow: 0 8px 25px rgba(249,115,22,0.3); }
        .login-title { font-size: 1.6rem; font-weight: 700; color: var(--dark); margin-bottom: 6px; }
        .login-subtitle { color: var(--gray-400); font-size: 0.95rem; }
        .form-label { font-weight: 600; color: var(--gray-700); margin-bottom: 10px; font-size: 0.9rem; }
        .input-group-custom { position: relative; }
        .input-group-custom .input-icon { position: absolute; left: 18px; top: 50%; transform: translateY(-50%); color: var(--gray-400); z-index: 5; font-size: 1.1rem; }
        .input-group-custom .form-control { padding: 16px 18px 16px 52px; border: 2px solid var(--gray-200); border-radius: 12px; font-size: 0.95rem; transition: all 0.3s; background: var(--gray-50); }
        .input-group-custom .form-control:focus { border-color: var(--primary); box-shadow: 0 0 0 4px rgba(249,115,22,0.1); background: white; }
        .form-check-input:checked { background-color: var(--primary); border-color: var(--primary); }
        .btn-login { width: 100%; padding: 16px; background: var(--primary-gradient); border: none; border-radius: 12px; font-weight: 600; font-size: 1rem; color: white; transition: all 0.3s; margin-top: 10px; }
        .btn-login:hover { transform: translateY(-2px); box-shadow: 0 10px 30px rgba(249,115,22,0.4); }
        .login-footer { text-align: center; margin-top: 28px; padding-top: 24px; border-top: 1px solid var(--gray-100); }
        .login-footer small { color: var(--gray-400); font-size: 0.85rem; }
        .language-select { margin-top: 24px; display: flex; justify-content: center; }
        .language-select .dropdown-toggle { border-radius: 10px; padding: 10px 18px; font-size: 0.85rem; border-color: var(--gray-200); color: var(--gray-600); font-weight: 500; }
        .language-select .dropdown-toggle:hover { border-color: var(--primary); color: var(--primary); }
        
        /* Features Section */
        .features-section { padding: 120px 0; background: white; }
        .section-badge { display: inline-flex; align-items: center; gap: 8px; background: var(--primary-light); padding: 10px 20px; border-radius: 50px; font-size: 0.85rem; font-weight: 600; color: var(--primary); margin-bottom: 20px; }
        .section-title { font-size: 2.75rem; font-weight: 800; color: var(--dark); margin-bottom: 18px; }
        .section-description { font-size: 1.1rem; color: var(--gray-600); max-width: 650px; margin: 0 auto 70px; line-height: 1.8; }
        .feature-card { background: white; border-radius: 20px; padding: 36px; height: 100%; border: 2px solid var(--gray-100); transition: all 0.4s; position: relative; overflow: hidden; }
        .feature-card::before { content: ''; position: absolute; top: 0; left: 0; width: 100%; height: 4px; background: var(--primary-gradient); transform: scaleX(0); transition: transform 0.4s; }
        .feature-card:hover { border-color: transparent; box-shadow: 0 20px 50px rgba(0,0,0,0.1); transform: translateY(-8px); }
        .feature-card:hover::before { transform: scaleX(1); }
        .feature-icon { width: 68px; height: 68px; border-radius: 16px; display: flex; align-items: center; justify-content: center; font-size: 1.8rem; margin-bottom: 24px; }
        .feature-icon.orange { background: rgba(249,115,22,0.1); color: var(--primary); }
        .feature-icon.green { background: rgba(16,185,129,0.1); color: var(--accent-green); }
        .feature-icon.blue { background: rgba(59,130,246,0.1); color: var(--accent-blue); }
        .feature-icon.purple { background: rgba(139,92,246,0.1); color: var(--accent-purple); }
        .feature-icon.pink { background: rgba(236,72,153,0.1); color: var(--accent-pink); }
        .feature-icon.cyan { background: rgba(6,182,212,0.1); color: var(--accent-cyan); }
        .feature-icon.red { background: rgba(239,68,68,0.1); color: var(--accent-red); }
        .feature-icon.dark { background: rgba(30,41,59,0.1); color: var(--dark); }
        .feature-title { font-size: 1.3rem; font-weight: 700; color: var(--dark); margin-bottom: 14px; }
        .feature-description { color: var(--gray-600); font-size: 0.95rem; line-height: 1.7; margin-bottom: 20px; }
        .feature-list { list-style: none; padding: 0; margin: 0; }
        .feature-list li { display: flex; align-items: center; gap: 10px; padding: 6px 0; color: var(--gray-600); font-size: 0.9rem; }
        .feature-list li i { color: var(--primary); font-size: 0.85rem; }
        
        /* How It Works */
        .how-it-works-section { padding: 120px 0; background: var(--gray-50); }
        .step-card { text-align: center; padding: 40px 30px; position: relative; }
        .step-number { width: 80px; height: 80px; background: var(--primary-gradient); border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 2rem; font-weight: 800; color: white; margin: 0 auto 24px; box-shadow: 0 10px 30px rgba(249,115,22,0.3); }
        .step-title { font-size: 1.3rem; font-weight: 700; color: var(--dark); margin-bottom: 14px; }
        .step-description { color: var(--gray-600); font-size: 0.95rem; line-height: 1.7; }
        .step-connector { position: absolute; top: 80px; right: -50%; width: 100%; height: 3px; background: linear-gradient(90deg, var(--primary), var(--primary-light)); z-index: 0; }
        @media (max-width: 992px) { .step-connector { display: none; } }
        
        /* Mobile App Section */
        .app-section { padding: 120px 0; background: linear-gradient(135deg, var(--dark) 0%, #0f172a 100%); position: relative; overflow: hidden; }
        .app-section::before { content: ''; position: absolute; width: 600px; height: 600px; background: radial-gradient(circle, rgba(249,115,22,0.12) 0%, transparent 70%); top: -200px; left: -200px; border-radius: 50%; }
        .app-content { position: relative; z-index: 2; }
        .app-badge { display: inline-flex; align-items: center; gap: 8px; background: rgba(249,115,22,0.15); padding: 10px 20px; border-radius: 50px; font-size: 0.85rem; font-weight: 600; color: var(--primary); margin-bottom: 20px; }
        .app-title { font-size: 2.75rem; font-weight: 800; color: white; margin-bottom: 24px; line-height: 1.2; }
        .app-description { font-size: 1.1rem; color: rgba(255,255,255,0.7); line-height: 1.8; margin-bottom: 40px; }
        .app-features { margin-bottom: 48px; }
        .app-feature-item { display: flex; align-items: flex-start; gap: 18px; padding: 20px 0; border-bottom: 1px solid rgba(255,255,255,0.08); }
        .app-feature-item:last-child { border-bottom: none; }
        .app-feature-icon { width: 52px; height: 52px; background: rgba(249,115,22,0.15); border-radius: 14px; display: flex; align-items: center; justify-content: center; color: var(--primary); font-size: 1.3rem; flex-shrink: 0; }
        .app-feature-text h5 { color: white; font-size: 1.1rem; font-weight: 600; margin-bottom: 6px; }
        .app-feature-text p { color: rgba(255,255,255,0.6); font-size: 0.9rem; margin: 0; line-height: 1.6; }
        .btn-playstore { display: inline-flex; align-items: center; gap: 14px; background: white; color: var(--dark); padding: 16px 32px; border-radius: 14px; font-weight: 600; text-decoration: none; transition: all 0.3s; box-shadow: 0 4px 20px rgba(0,0,0,0.2); }
        .btn-playstore:hover { transform: translateY(-4px); box-shadow: 0 15px 40px rgba(0,0,0,0.3); color: var(--dark); }
        .btn-playstore i { font-size: 2rem; color: var(--primary); }
        .btn-playstore .btn-small { font-size: 0.75rem; color: var(--gray-500); display: block; font-weight: 500; }
        .btn-playstore .btn-main { font-size: 1.1rem; font-weight: 700; }
        .app-platform-badge { background: rgba(249,115,22,0.2); color: var(--primary); padding: 8px 16px; border-radius: 8px; font-size: 0.85rem; font-weight: 600; display: inline-flex; align-items: center; }
        .phone-platforms { display: flex; justify-content: center; gap: 12px; }
        .phone-mockup { text-align: center; }
        .phone-frame { background: linear-gradient(135deg, #374151 0%, #1f2937 100%); border-radius: 44px; padding: 14px; display: inline-block; box-shadow: 0 40px 80px rgba(0,0,0,0.5); }
        .phone-screen { background: var(--primary-gradient); border-radius: 34px; width: 280px; height: 560px; display: flex; flex-direction: column; align-items: center; justify-content: center; color: white; padding: 40px; position: relative; overflow: hidden; }
        .phone-screen::before { content: ''; position: absolute; width: 200%; height: 200%; background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 50%); top: -100%; left: -50%; }
        .phone-screen i.main-icon { font-size: 4.5rem; margin-bottom: 24px; opacity: 0.95; }
        .phone-screen h4 { font-weight: 800; font-size: 1.6rem; margin-bottom: 8px; }
        .phone-screen p { font-size: 0.95rem; opacity: 0.85; }
        .phone-features { display: flex; flex-wrap: wrap; justify-content: center; gap: 16px; margin-top: 32px; }
        .phone-feature-badge { background: rgba(255,255,255,0.2); padding: 10px 16px; border-radius: 10px; font-size: 0.8rem; font-weight: 600; display: flex; align-items: center; gap: 6px; }
        
        /* Benefits Section */
        .benefits-section { padding: 120px 0; background: white; }
        .benefit-card { background: var(--gray-50); border-radius: 20px; padding: 40px; height: 100%; transition: all 0.3s; border: 1px solid var(--gray-100); }
        .benefit-card:hover { background: white; box-shadow: 0 20px 50px rgba(0,0,0,0.08); transform: translateY(-5px); }
        .benefit-icon { width: 60px; height: 60px; background: var(--primary-gradient); border-radius: 14px; display: flex; align-items: center; justify-content: center; font-size: 1.6rem; color: white; margin-bottom: 24px; }
        .benefit-title { font-size: 1.25rem; font-weight: 700; color: var(--dark); margin-bottom: 14px; }
        .benefit-description { color: var(--gray-600); font-size: 0.95rem; line-height: 1.7; }
        
        /* CTA Section */
        .cta-section { padding: 100px 0; background: var(--primary-gradient); position: relative; overflow: hidden; }
        .cta-section::before { content: ''; position: absolute; width: 400px; height: 400px; background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%); top: -200px; right: -100px; border-radius: 50%; }
        .cta-title { font-size: 2.5rem; font-weight: 800; color: white; margin-bottom: 20px; }
        .cta-description { font-size: 1.15rem; color: rgba(255,255,255,0.85); margin-bottom: 36px; max-width: 600px; margin-left: auto; margin-right: auto; }
        .btn-cta { background: white; color: var(--primary); padding: 18px 40px; border-radius: 14px; font-weight: 700; font-size: 1.05rem; text-decoration: none; display: inline-flex; align-items: center; gap: 10px; transition: all 0.3s; }
        .btn-cta:hover { transform: translateY(-3px); box-shadow: 0 15px 40px rgba(0,0,0,0.2); color: var(--primary-dark); }
        
        /* Footer */
        .footer { background: var(--dark); padding: 80px 0 30px; }
        .footer-brand { display: flex; align-items: center; gap: 14px; color: white; font-weight: 700; font-size: 1.4rem; margin-bottom: 20px; }
        .footer-brand .brand-icon { width: 44px; height: 44px; font-size: 1.3rem; }
        .footer-text { color: rgba(255,255,255,0.6); font-size: 0.95rem; margin-bottom: 28px; line-height: 1.7; max-width: 320px; }
        .footer-social { display: flex; gap: 12px; }
        .footer-social a { width: 42px; height: 42px; background: rgba(255,255,255,0.08); border-radius: 10px; display: flex; align-items: center; justify-content: center; color: rgba(255,255,255,0.6); text-decoration: none; transition: all 0.3s; }
        .footer-social a:hover { background: var(--primary); color: white; transform: translateY(-3px); }
        .footer-links h6 { color: white; font-weight: 700; margin-bottom: 24px; font-size: 1rem; }
        .footer-links ul { list-style: none; padding: 0; margin: 0; }
        .footer-links li { margin-bottom: 14px; }
        .footer-links a { color: rgba(255,255,255,0.6); text-decoration: none; transition: all 0.3s; font-size: 0.95rem; display: flex; align-items: center; gap: 8px; }
        .footer-links a:hover { color: var(--primary); padding-left: 5px; }
        .footer-links a i { font-size: 0.85rem; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.08); padding-top: 30px; margin-top: 60px; }
        .footer-bottom p { color: rgba(255,255,255,0.5); font-size: 0.9rem; margin: 0; }
        .footer-bottom a { color: var(--primary); text-decoration: none; }
        
        .invalid-feedback { display: block; margin-top: 8px; color: #dc2626; font-size: 0.85rem; }
        
        /* Responsive */
        @media (max-width: 1200px) { .hero-title { font-size: 3rem; } .section-title { font-size: 2.25rem; } }
        @media (max-width: 992px) { .hero-title { font-size: 2.5rem; } .hero-stats { gap: 32px; } .stat-number { font-size: 2rem; } .login-card { margin-top: 60px; } .app-title { font-size: 2.25rem; } }
        @media (max-width: 768px) { .hero-section { padding: 120px 0 60px; } .hero-title { font-size: 2rem; } .hero-description { font-size: 1rem; } .hero-stats { flex-wrap: wrap; gap: 24px; } .hero-buttons { flex-direction: column; } .section-title { font-size: 1.85rem; } .app-title { font-size: 1.85rem; } .phone-mockup { margin-top: 60px; } .login-card { padding: 32px; } .cta-title { font-size: 1.85rem; } }
        
        html { scroll-behavior: smooth; }
        @keyframes float { 0%, 100% { transform: translateY(0); } 50% { transform: translateY(-12px); } }
        .float-animation { animation: float 4s ease-in-out infinite; }
        @keyframes pulse { 0%, 100% { box-shadow: 0 0 0 0 rgba(249,115,22,0.4); } 50% { box-shadow: 0 0 0 15px rgba(249,115,22,0); } }
        .pulse-animation { animation: pulse 2s ease-in-out infinite; }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar-custom">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center">
                <a class="navbar-brand" href="#">
                    <div class="brand-icon"><i class="bi bi-truck"></i></div>
                    LogiFleet
                </a>
                <div class="d-none d-lg-flex align-items-center gap-1">
                    <a href="#features" class="nav-link-custom"><?php echo e(__('features')); ?></a>
                    <a href="#how-it-works" class="nav-link-custom"><?php echo e(__('how_it_works')); ?></a>
                    <a href="#mobile-app" class="nav-link-custom"><?php echo e(__('mobile_app')); ?></a>
                    <a href="#benefits" class="nav-link-custom"><?php echo e(__('benefits')); ?></a>
                    <a href="#login-section" class="btn btn-login-nav ms-3"><i class="bi bi-box-arrow-in-right me-2"></i> <?php echo e(__('login')); ?></a>
                </div>
                <button class="navbar-toggler d-lg-none btn" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMobile"><i class="bi bi-list fs-4"></i></button>
            </div>
            <div class="collapse d-lg-none mt-3" id="navbarMobile">
                <a href="#features" class="nav-link-custom d-block py-2"><?php echo e(__('features')); ?></a>
                <a href="#how-it-works" class="nav-link-custom d-block py-2"><?php echo e(__('how_it_works')); ?></a>
                <a href="#mobile-app" class="nav-link-custom d-block py-2"><?php echo e(__('mobile_app')); ?></a>
                <a href="#benefits" class="nav-link-custom d-block py-2"><?php echo e(__('benefits')); ?></a>
                <a href="#login-section" class="btn btn-login-nav mt-3 d-block text-center"><?php echo e(__('login')); ?></a>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section" id="login-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="hero-badge"><i class="bi bi-patch-check-fill"></i> <?php echo e(__('trusted_fleet_solution')); ?></div>
                    <h1 class="hero-title"><?php echo e(__('fleet_management_headline')); ?> <span><?php echo e(__('smart_safe_efficient')); ?></span></h1>
                    <p class="hero-description"><?php echo e(__('hero_description')); ?></p>
                    
                    <ul class="hero-features-list">
                        <li><i class="bi bi-check-circle-fill"></i> <?php echo e(__('hero_feature_1')); ?></li>
                        <li><i class="bi bi-check-circle-fill"></i> <?php echo e(__('hero_feature_2')); ?></li>
                        <li><i class="bi bi-check-circle-fill"></i> <?php echo e(__('hero_feature_3')); ?></li>
                        <li><i class="bi bi-check-circle-fill"></i> <?php echo e(__('hero_feature_4')); ?></li>
                    </ul>
                    
                    <div class="hero-buttons">
                        <a href="#features" class="btn-hero-primary"><i class="bi bi-grid-3x3-gap"></i> <?php echo e(__('explore_features')); ?></a>
                        <a href="#mobile-app" class="btn-hero-secondary"><i class="bi bi-phone"></i> <?php echo e(__('get_driver_app')); ?></a>
                    </div>
                    
                    <div class="hero-stats">
                        <div class="stat-item"><div class="stat-number">8+</div><div class="stat-label"><?php echo e(__('core_modules')); ?></div></div>
                        <div class="stat-item"><div class="stat-number">4</div><div class="stat-label"><?php echo e(__('languages_supported')); ?></div></div>
                        <div class="stat-item"><div class="stat-number">24/7</div><div class="stat-label"><?php echo e(__('live_tracking')); ?></div></div>
                        <div class="stat-item"><div class="stat-number">100%</div><div class="stat-label"><?php echo e(__('cloud_based')); ?></div></div>
                    </div>
                </div>
                
                <div class="col-lg-5 offset-lg-1">
                    <div class="login-card float-animation">
                        <div class="login-header">
                            <div class="login-icon-wrapper"><i class="bi bi-person-check"></i></div>
                            <h3 class="login-title"><?php echo e(__('welcome_back')); ?></h3>
                            <p class="login-subtitle"><?php echo e(__('sign_in_continue')); ?></p>
                        </div>
                        
                        <form method="POST" action="<?php echo e(route('login')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="mb-4">
                                <label for="email" class="form-label"><?php echo e(__('email_address')); ?></label>
                                <div class="input-group-custom">
                                    <i class="bi bi-envelope input-icon"></i>
                                    <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="email" name="email" value="<?php echo e(old('email')); ?>" placeholder="<?php echo e(__('enter_email')); ?>" required autofocus>
                                </div>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            
                            <div class="mb-4">
                                <label for="password" class="form-label"><?php echo e(__('password')); ?></label>
                                <div class="input-group-custom">
                                    <i class="bi bi-lock input-icon"></i>
                                    <input type="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="password" name="password" placeholder="<?php echo e(__('enter_password')); ?>" required>
                                </div>
                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            
                            <div class="mb-4 d-flex justify-content-between align-items-center">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="remember" id="remember">
                                    <label class="form-check-label" for="remember" style="color: var(--gray-600); font-size: 0.9rem;"><?php echo e(__('remember_me')); ?></label>
                                </div>
                            </div>
                            
                            <button type="submit" class="btn btn-login"><i class="bi bi-box-arrow-in-right me-2"></i> <?php echo e(__('sign_in_to_dashboard')); ?></button>
                        </form>
                        
                    
                        
                        <div class="language-select">
                            <div class="dropdown">
                                <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown"><i class="bi bi-translate me-2"></i> <?php echo e(__('language')); ?></button>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li><a class="dropdown-item" href="<?php echo e(route('lang.switch', 'en')); ?>">🇺🇸 English</a></li>
                                    <li><a class="dropdown-item" href="<?php echo e(route('lang.switch', 'hi')); ?>">🇮🇳 हिंदी</a></li>
                                    <li><a class="dropdown-item" href="<?php echo e(route('lang.switch', 'es')); ?>">🇪🇸 Español</a></li>
                                    
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="features-section" id="features">
        <div class="container">
            <div class="text-center">
                <div class="section-badge"><i class="bi bi-lightning-charge-fill"></i> <?php echo e(__('powerful_features')); ?></div>
                <h2 class="section-title"><?php echo e(__('everything_you_need')); ?></h2>
                <p class="section-description"><?php echo e(__('features_description')); ?></p>
            </div>
            
            <div class="row g-4">
                <div class="col-md-6 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon orange"><i class="bi bi-box-seam-fill"></i></div>
                        <h4 class="feature-title"><?php echo e(__('shipments_management')); ?></h4>
                        <p class="feature-description"><?php echo e(__('shipments_desc')); ?></p>
                        <ul class="feature-list">
                            <li><i class="bi bi-check2"></i> <?php echo e(__('shipment_feature_1')); ?></li>
                            <li><i class="bi bi-check2"></i> <?php echo e(__('shipment_feature_2')); ?></li>
                            <li><i class="bi bi-check2"></i> <?php echo e(__('shipment_feature_3')); ?></li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon green"><i class="bi bi-signpost-split-fill"></i></div>
                        <h4 class="feature-title"><?php echo e(__('trips_dispatch')); ?></h4>
                        <p class="feature-description"><?php echo e(__('trips_desc')); ?></p>
                        <ul class="feature-list">
                            <li><i class="bi bi-check2"></i> <?php echo e(__('trip_feature_1')); ?></li>
                            <li><i class="bi bi-check2"></i> <?php echo e(__('trip_feature_2')); ?></li>
                            <li><i class="bi bi-check2"></i> <?php echo e(__('trip_feature_3')); ?></li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon blue"><i class="bi bi-clipboard2-check-fill"></i></div>
                        <h4 class="feature-title"><?php echo e(__('deliveries')); ?></h4>
                        <p class="feature-description"><?php echo e(__('deliveries_desc')); ?></p>
                        <ul class="feature-list">
                            <li><i class="bi bi-check2"></i> <?php echo e(__('delivery_feature_1')); ?></li>
                            <li><i class="bi bi-check2"></i> <?php echo e(__('delivery_feature_2')); ?></li>
                            <li><i class="bi bi-check2"></i> <?php echo e(__('delivery_feature_3')); ?></li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon purple"><i class="bi bi-truck-front-fill"></i></div>
                        <h4 class="feature-title"><?php echo e(__('vehicles_management')); ?></h4>
                        <p class="feature-description"><?php echo e(__('vehicles_desc')); ?></p>
                        <ul class="feature-list">
                            <li><i class="bi bi-check2"></i> <?php echo e(__('vehicle_feature_1')); ?></li>
                            <li><i class="bi bi-check2"></i> <?php echo e(__('vehicle_feature_2')); ?></li>
                            <li><i class="bi bi-check2"></i> <?php echo e(__('vehicle_feature_3')); ?></li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon cyan"><i class="bi bi-person-badge-fill"></i></div>
                        <h4 class="feature-title"><?php echo e(__('driver_management')); ?></h4>
                        <p class="feature-description"><?php echo e(__('driver_desc')); ?></p>
                        <ul class="feature-list">
                            <li><i class="bi bi-check2"></i> <?php echo e(__('driver_feature_1')); ?></li>
                            <li><i class="bi bi-check2"></i> <?php echo e(__('driver_feature_2')); ?></li>
                            <li><i class="bi bi-check2"></i> <?php echo e(__('driver_feature_3')); ?></li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon pink"><i class="bi bi-cash-stack"></i></div>
                        <h4 class="feature-title"><?php echo e(__('cost_management')); ?></h4>
                        <p class="feature-description"><?php echo e(__('cost_desc')); ?></p>
                        <ul class="feature-list">
                            <li><i class="bi bi-check2"></i> <?php echo e(__('cost_feature_1')); ?></li>
                            <li><i class="bi bi-check2"></i> <?php echo e(__('cost_feature_2')); ?></li>
                            <li><i class="bi bi-check2"></i> <?php echo e(__('cost_feature_3')); ?></li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon red"><i class="bi bi-geo-alt-fill"></i></div>
                        <h4 class="feature-title"><?php echo e(__('live_tracking')); ?></h4>
                        <p class="feature-description"><?php echo e(__('tracking_desc')); ?></p>
                        <ul class="feature-list">
                            <li><i class="bi bi-check2"></i> <?php echo e(__('tracking_feature_1')); ?></li>
                            <li><i class="bi bi-check2"></i> <?php echo e(__('tracking_feature_2')); ?></li>
                            <li><i class="bi bi-check2"></i> <?php echo e(__('tracking_feature_3')); ?></li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="feature-card">
                        <div class="feature-icon dark"><i class="bi bi-people-fill"></i></div>
                        <h4 class="feature-title"><?php echo e(__('users_management')); ?></h4>
                        <p class="feature-description"><?php echo e(__('users_desc')); ?></p>
                        <ul class="feature-list">
                            <li><i class="bi bi-check2"></i> <?php echo e(__('users_feature_1')); ?></li>
                            <li><i class="bi bi-check2"></i> <?php echo e(__('users_feature_2')); ?></li>
                            <li><i class="bi bi-check2"></i> <?php echo e(__('users_feature_3')); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- How It Works -->
    <section class="how-it-works-section" id="how-it-works">
        <div class="container">
            <div class="text-center">
                <div class="section-badge"><i class="bi bi-gear-fill"></i> <?php echo e(__('how_it_works')); ?></div>
                <h2 class="section-title"><?php echo e(__('simple_steps_title')); ?></h2>
                <p class="section-description"><?php echo e(__('simple_steps_description')); ?></p>
            </div>
            
            <div class="row">
                <div class="col-lg-3 col-md-6">
                    <div class="step-card">
                        <div class="step-connector d-none d-lg-block"></div>
                        <div class="step-number position-relative">1</div>
                        <h4 class="step-title"><?php echo e(__('step_1_title')); ?></h4>
                        <p class="step-description"><?php echo e(__('step_1_desc')); ?></p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="step-card">
                        <div class="step-connector d-none d-lg-block"></div>
                        <div class="step-number position-relative">2</div>
                        <h4 class="step-title"><?php echo e(__('step_2_title')); ?></h4>
                        <p class="step-description"><?php echo e(__('step_2_desc')); ?></p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="step-card">
                        <div class="step-connector d-none d-lg-block"></div>
                        <div class="step-number position-relative">3</div>
                        <h4 class="step-title"><?php echo e(__('step_3_title')); ?></h4>
                        <p class="step-description"><?php echo e(__('step_3_desc')); ?></p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="step-card">
                        <div class="step-number position-relative pulse-animation">4</div>
                        <h4 class="step-title"><?php echo e(__('step_4_title')); ?></h4>
                        <p class="step-description"><?php echo e(__('step_4_desc')); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Mobile App Section -->
    <section class="app-section" id="mobile-app">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="app-content">
                        <div class="app-badge"><i class="bi bi-phone-fill"></i> <?php echo e(__('driver_mobile_app')); ?></div>
                        <h2 class="app-title"><?php echo e(__('app_headline')); ?></h2>
                        <p class="app-description"><?php echo e(__('app_description')); ?></p>
                        
                        <div class="d-flex gap-3 mb-4">
                            <div class="app-platform-badge"><i class="bi bi-android2 me-2"></i> Android</div>
                            <div class="app-platform-badge"><i class="bi bi-apple me-2"></i> iOS</div>
                        </div>
                        
                        <div class="app-features">
                            <div class="app-feature-item">
                                <div class="app-feature-icon"><i class="bi bi-person-vcard-fill"></i></div>
                                <div class="app-feature-text"><h5><?php echo e(__('driver_profile')); ?></h5><p><?php echo e(__('driver_profile_desc')); ?></p></div>
                            </div>
                            <div class="app-feature-item">
                                <div class="app-feature-icon"><i class="bi bi-camera-fill"></i></div>
                                <div class="app-feature-text"><h5><?php echo e(__('pod_proof')); ?></h5><p><?php echo e(__('pod_desc')); ?></p></div>
                            </div>
                            <div class="app-feature-item">
                                <div class="app-feature-icon"><i class="bi bi-shield-lock-fill"></i></div>
                                <div class="app-feature-text"><h5><?php echo e(__('otp_verification')); ?></h5><p><?php echo e(__('otp_desc')); ?></p></div>
                            </div>
                            <div class="app-feature-item">
                                <div class="app-feature-icon"><i class="bi bi-broadcast-pin"></i></div>
                                <div class="app-feature-text"><h5><?php echo e(__('live_gps_tracking')); ?></h5><p><?php echo e(__('live_gps_desc')); ?></p></div>
                            </div>
                            <div class="app-feature-item">
                                <div class="app-feature-icon"><i class="bi bi-list-check"></i></div>
                                <div class="app-feature-text"><h5><?php echo e(__('shipment_details')); ?></h5><p><?php echo e(__('shipment_details_desc')); ?></p></div>
                            </div>
                        </div>
                        
                        <div class="d-flex flex-wrap gap-3">
                            <a href="https://play.google.com/store/apps/details?id=com.pictuscode.logifleet" target="_blank" class="btn-playstore">
                                <i class="bi bi-google-play"></i>
                                <span><span class="btn-small"><?php echo e(__('get_it_on')); ?></span><span class="btn-main">Google Play</span></span>
                            </a>
                            <a href="#" target="_blank" class="btn-playstore">
                                <i class="bi bi-apple"></i>
                                <span><span class="btn-small"><?php echo e(__('download_on')); ?></span><span class="btn-main">App Store</span></span>
                            </a>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-5 offset-lg-1">
                    <div class="phone-mockup">
                        <div class="phone-frame">
                            <div class="phone-screen">
                                <i class="bi bi-truck main-icon"></i>
                                <h4>LogiFleet</h4>
                                <p><?php echo e(__('driver_app')); ?></p>
                                <div class="phone-features">
                                    <div class="phone-feature-badge"><i class="bi bi-geo-alt-fill"></i> GPS</div>
                                    <div class="phone-feature-badge"><i class="bi bi-camera-fill"></i> POD</div>
                                    <div class="phone-feature-badge"><i class="bi bi-key-fill"></i> OTP</div>
                                </div>
                                <div class="phone-platforms mt-4">
                                    <span class="phone-feature-badge"><i class="bi bi-android2"></i> Android</span>
                                    <span class="phone-feature-badge"><i class="bi bi-apple"></i> iOS</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Benefits Section -->
    <section class="benefits-section" id="benefits">
        <div class="container">
            <div class="text-center">
                <div class="section-badge"><i class="bi bi-star-fill"></i> <?php echo e(__('why_choose_us')); ?></div>
                <h2 class="section-title"><?php echo e(__('benefits_title')); ?></h2>
                <p class="section-description"><?php echo e(__('benefits_description')); ?></p>
            </div>
            
            <div class="row g-4">
                <div class="col-md-6 col-lg-4">
                    <div class="benefit-card">
                        <div class="benefit-icon"><i class="bi bi-speedometer2"></i></div>
                        <h4 class="benefit-title"><?php echo e(__('benefit_1_title')); ?></h4>
                        <p class="benefit-description"><?php echo e(__('benefit_1_desc')); ?></p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="benefit-card">
                        <div class="benefit-icon"><i class="bi bi-piggy-bank"></i></div>
                        <h4 class="benefit-title"><?php echo e(__('benefit_2_title')); ?></h4>
                        <p class="benefit-description"><?php echo e(__('benefit_2_desc')); ?></p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="benefit-card">
                        <div class="benefit-icon"><i class="bi bi-shield-check"></i></div>
                        <h4 class="benefit-title"><?php echo e(__('benefit_3_title')); ?></h4>
                        <p class="benefit-description"><?php echo e(__('benefit_3_desc')); ?></p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="benefit-card">
                        <div class="benefit-icon"><i class="bi bi-graph-up-arrow"></i></div>
                        <h4 class="benefit-title"><?php echo e(__('benefit_4_title')); ?></h4>
                        <p class="benefit-description"><?php echo e(__('benefit_4_desc')); ?></p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="benefit-card">
                        <div class="benefit-icon"><i class="bi bi-cloud-check"></i></div>
                        <h4 class="benefit-title"><?php echo e(__('benefit_5_title')); ?></h4>
                        <p class="benefit-description"><?php echo e(__('benefit_5_desc')); ?></p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="benefit-card">
                        <div class="benefit-icon"><i class="bi bi-headset"></i></div>
                        <h4 class="benefit-title"><?php echo e(__('benefit_6_title')); ?></h4>
                        <p class="benefit-description"><?php echo e(__('benefit_6_desc')); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container text-center">
            <h2 class="cta-title"><?php echo e(__('cta_title')); ?></h2>
            <p class="cta-description"><?php echo e(__('cta_description')); ?></p>
            <a href="#login-section" class="btn-cta"><i class="bi bi-rocket-takeoff"></i> <?php echo e(__('get_started_now')); ?></a>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 mb-5 mb-lg-0">
                    <div class="footer-brand"><div class="brand-icon"><i class="bi bi-truck"></i></div> LogiFleet</div>
                    <p class="footer-text"><?php echo e(__('footer_description')); ?></p>
                    <div class="footer-social">
                        <a href="#"><i class="bi bi-facebook"></i></a>
                        <a href="#"><i class="bi bi-twitter-x"></i></a>
                        <a href="#"><i class="bi bi-linkedin"></i></a>
                        <a href="#"><i class="bi bi-instagram"></i></a>
                    </div>
                </div>
                <div class="col-6 col-lg-2 mb-4 mb-lg-0 footer-links">
                    <h6><?php echo e(__('platform')); ?></h6>
                    <ul>
                        <li><a href="#features"><i class="bi bi-chevron-right"></i> <?php echo e(__('features')); ?></a></li>
                        <li><a href="#mobile-app"><i class="bi bi-chevron-right"></i> <?php echo e(__('mobile_app')); ?></a></li>
                        <li><a href="#login-section"><i class="bi bi-chevron-right"></i> <?php echo e(__('admin_panel')); ?></a></li>
                        <li><a href="#benefits"><i class="bi bi-chevron-right"></i> <?php echo e(__('benefits')); ?></a></li>
                    </ul>
                </div>
                <div class="col-6 col-lg-2 mb-4 mb-lg-0 footer-links">
                    <h6><?php echo e(__('modules')); ?></h6>
                    <ul>
                        <li><a href="#"><i class="bi bi-chevron-right"></i> <?php echo e(__('shipments')); ?></a></li>
                        <li><a href="#"><i class="bi bi-chevron-right"></i> <?php echo e(__('trips')); ?></a></li>
                        <li><a href="#"><i class="bi bi-chevron-right"></i> <?php echo e(__('vehicles')); ?></a></li>
                        <li><a href="#"><i class="bi bi-chevron-right"></i> <?php echo e(__('drivers')); ?></a></li>
                        <li><a href="#"><i class="bi bi-chevron-right"></i> <?php echo e(__('deliveries')); ?></a></li>
                    </ul>
                </div>
                <div class="col-6 col-lg-2 mb-4 mb-lg-0 footer-links">
                    <h6><?php echo e(__('resources')); ?></h6>
                    <ul>
                        <li><a href="#"><i class="bi bi-chevron-right"></i> <?php echo e(__('documentation')); ?></a></li>
                        <li><a href="#"><i class="bi bi-chevron-right"></i> <?php echo e(__('api_reference')); ?></a></li>
                        <li><a href="#"><i class="bi bi-chevron-right"></i> <?php echo e(__('support_center')); ?></a></li>
                        <li><a href="#"><i class="bi bi-chevron-right"></i> <?php echo e(__('faqs')); ?></a></li>
                    </ul>
                </div>
                <div class="col-6 col-lg-2 footer-links">
                    <h6><?php echo e(__('legal')); ?></h6>
                    <ul>
                    
                        <li><a href="#"><i class="bi bi-chevron-right"></i> <?php echo e(__('terms_of_service')); ?></a></li>
                        <li><a href="#"><i class="bi bi-chevron-right"></i> <?php echo e(__('cookie_policy')); ?></a></li>
                    </ul>
                </div>
            </div>
            <div class="footer-bottom d-flex flex-column flex-md-row justify-content-center align-items-center">
                <p>&copy; <?php echo e(date('Y')); ?> LogiFleet. <?php echo e(__('all_rights_reserved')); ?></p>

            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar-custom');
            navbar.style.boxShadow = window.scrollY > 50 ? '0 4px 30px rgba(0,0,0,0.1)' : '0 2px 20px rgba(0,0,0,0.06)';
        });
    </script>
</body>
</html><?php /**PATH D:\Laravel\fleet-management\resources\views/auth/login.blade.php ENDPATH**/ ?>