<?php $__env->startSection('title', __('Edit Fuel Log') . ' - ' . $fuelLog->fuel_number); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/admincreatepage.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="create-page-container">
    
    <div class="create-page-header">
        <div class="create-page-header-content">
            <div class="create-page-breadcrumb">
                <a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                <i class="bi bi-chevron-right"></i>
                <a href="<?php echo e(route('admin.fuel-logs.index')); ?>"><?php echo e(__('Fuel Logs')); ?></a>
                <i class="bi bi-chevron-right"></i>
                <a href="<?php echo e(route('admin.fuel-logs.show', $fuelLog)); ?>"><?php echo e($fuelLog->fuel_number); ?></a>
                <i class="bi bi-chevron-right"></i>
                <span><?php echo e(__('Edit')); ?></span>
            </div>
            <h1 class="create-page-title">
                <div class="create-page-title-icon">
                    <i class="bi bi-pencil"></i>
                </div>
                <?php echo e(__('Edit Fuel Log')); ?>

            </h1>
            <p class="create-page-subtitle"><?php echo e(__('Update the fuel log details below')); ?></p>
        </div>
        <div class="create-page-actions">
            <a href="<?php echo e(route('admin.fuel-logs.show', $fuelLog)); ?>" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                <?php echo e(__('Back to Details')); ?>

            </a>
        </div>
    </div>

    
    <?php if($errors->any()): ?>
        <div class="create-alert danger">
            <div class="create-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="create-alert-content">
                <div class="create-alert-title"><?php echo e(__('Please fix the following errors')); ?></div>
                <div class="create-alert-text">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('admin.fuel-logs.update', $fuelLog)); ?>" method="POST" id="fuelLogForm">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="create-form-layout">
            
            <div class="create-form-main">
                
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon primary">
                            <i class="bi bi-fuel-pump"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title"><?php echo e(__('Basic Information')); ?></h5>
                            <p class="create-card-subtitle"><?php echo e(__('Fuel log identification and vehicle assignment')); ?></p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-hash"></i>
                                    <?php echo e(__('Fuel Log Number')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" 
                                           name="fuel_number" 
                                           id="fuel_number"
                                           class="create-input <?php $__errorArgs = ['fuel_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('fuel_number', $fuelLog->fuel_number)); ?>"
                                           placeholder="FUEL-2025-0001"
                                           required>
                                    <i class="bi bi-upc-scan create-input-icon"></i>
                                </div>
                                <?php $__errorArgs = ['fuel_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-truck"></i>
                                    <?php echo e(__('Vehicle')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <select name="vehicle_id" 
                                        id="vehicle_id"
                                        class="create-select <?php $__errorArgs = ['vehicle_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        required>
                                    <option value=""><?php echo e(__('Select Vehicle')); ?></option>
                                    <?php $__currentLoopData = $vehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($vehicle->id); ?>" <?php echo e(old('vehicle_id', $fuelLog->vehicle_id) == $vehicle->id ? 'selected' : ''); ?>>
                                            <?php echo e($vehicle->vehicle_number); ?> - <?php echo e($vehicle->vehicleType->name ?? ''); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['vehicle_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-person"></i>
                                    <?php echo e(__('Driver')); ?>

                                    <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                                </label>
                                <select name="driver_id" 
                                        id="driver_id"
                                        class="create-select <?php $__errorArgs = ['driver_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <option value=""><?php echo e(__('Select Driver')); ?></option>
                                    <?php $__currentLoopData = $drivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($driver->id); ?>" <?php echo e(old('driver_id', $fuelLog->driver_id) == $driver->id ? 'selected' : ''); ?>>
                                            <?php echo e($driver->name); ?> - <?php echo e($driver->mobile); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['driver_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-signpost"></i>
                                    <?php echo e(__('Link to Trip')); ?>

                                    <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                                </label>
                                <select name="trip_id" 
                                        id="trip_id"
                                        class="create-select <?php $__errorArgs = ['trip_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <option value=""><?php echo e(__('No Trip')); ?></option>
                                    <?php $__currentLoopData = $trips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($trip->id); ?>" <?php echo e(old('trip_id', $fuelLog->trip_id) == $trip->id ? 'selected' : ''); ?>>
                                            <?php echo e($trip->trip_number); ?> - <?php echo e($trip->vehicle->vehicle_number ?? ''); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['trip_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon info">
                            <i class="bi bi-droplet"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title"><?php echo e(__('Fuel Details')); ?></h5>
                            <p class="create-card-subtitle"><?php echo e(__('Fuel type, quantity and pricing information')); ?></p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-droplet-fill"></i>
                                    <?php echo e(__('Fuel Type')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <select name="fuel_type" 
                                        id="fuel_type"
                                        class="create-select <?php $__errorArgs = ['fuel_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        required>
                                    <option value="diesel" <?php echo e(old('fuel_type', $fuelLog->fuel_type) == 'diesel' ? 'selected' : ''); ?>><?php echo e(__('Diesel')); ?></option>
                                    <option value="petrol" <?php echo e(old('fuel_type', $fuelLog->fuel_type) == 'petrol' ? 'selected' : ''); ?>><?php echo e(__('Petrol')); ?></option>
                                    <option value="cng" <?php echo e(old('fuel_type', $fuelLog->fuel_type) == 'cng' ? 'selected' : ''); ?>><?php echo e(__('CNG')); ?></option>
                                    <option value="electric" <?php echo e(old('fuel_type', $fuelLog->fuel_type) == 'electric' ? 'selected' : ''); ?>><?php echo e(__('Electric')); ?></option>
                                </select>
                                <?php $__errorArgs = ['fuel_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-water"></i>
                                    <?php echo e(__('Quantity')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-group">
                                    <input type="number" 
                                           name="quantity" 
                                           id="quantity"
                                           class="create-input <?php $__errorArgs = ['quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('quantity', $fuelLog->quantity)); ?>"
                                           placeholder="0.00"
                                           step="0.01"
                                           min="0.01"
                                           required>
                                    <span class="create-input-addon">L</span>
                                </div>
                                <?php $__errorArgs = ['quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-currency-dollar"></i>
                                    <?php echo e(__('Price Per Unit')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-group">
                                    <span class="create-input-addon">$</span>
                                    <input type="number" 
                                           name="price_per_unit" 
                                           id="price_per_unit"
                                           class="create-input <?php $__errorArgs = ['price_per_unit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('price_per_unit', $fuelLog->price_per_unit)); ?>"
                                           placeholder="0.00"
                                           step="0.01"
                                           min="0.01"
                                           required>
                                </div>
                                <?php $__errorArgs = ['price_per_unit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-calculator"></i>
                                    <?php echo e(__('Total Cost')); ?>

                                </label>
                                <div class="create-input-group">
                                    <span class="create-input-addon">$</span>
                                    <input type="text" 
                                           id="total_cost_display"
                                           class="create-input" 
                                           value="<?php echo e(number_format($fuelLog->total_cost, 2)); ?>"
                                           readonly
                                           disabled>
                                </div>
                                <p class="create-form-hint">
                                    <i class="bi bi-info-circle"></i>
                                    <?php echo e(__('Auto-calculated from quantity × price')); ?>

                                </p>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-check2-square"></i>
                                    <?php echo e(__('Full Tank Fill')); ?>

                                </label>
                                <div class="create-checkbox-wrapper">
                                    <input type="checkbox" 
                                           name="is_full_tank" 
                                           id="is_full_tank"
                                           class="create-checkbox"
                                           value="1"
                                           <?php echo e(old('is_full_tank', $fuelLog->is_full_tank) ? 'checked' : ''); ?>>
                                    <label for="is_full_tank" class="create-checkbox-label">
                                        <?php echo e(__('This was a full tank fill-up')); ?>

                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon warning">
                            <i class="bi bi-speedometer2"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title"><?php echo e(__('Odometer & Date')); ?></h5>
                            <p class="create-card-subtitle"><?php echo e(__('Mileage reading and fill-up date/time')); ?></p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-speedometer"></i>
                                    <?php echo e(__('Odometer Reading')); ?>

                                    <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                                </label>
                                <div class="create-input-group">
                                    <input type="number" 
                                           name="odometer_reading" 
                                           id="odometer_reading"
                                           class="create-input <?php $__errorArgs = ['odometer_reading'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('odometer_reading', $fuelLog->odometer_reading)); ?>"
                                           placeholder="0"
                                           min="0">
                                    <span class="create-input-addon">km</span>
                                </div>
                                <?php $__errorArgs = ['odometer_reading'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <?php if($fuelLog->previous_odometer): ?>
                                    <p class="create-form-hint">
                                        <i class="bi bi-info-circle"></i>
                                        <?php echo e(__('Previous reading')); ?>: <?php echo e(number_format($fuelLog->previous_odometer)); ?> km
                                    </p>
                                <?php endif; ?>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-credit-card"></i>
                                    <?php echo e(__('Payment Method')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <select name="payment_method" 
                                        id="payment_method"
                                        class="create-select <?php $__errorArgs = ['payment_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        required>
                                    <option value="cash" <?php echo e(old('payment_method', $fuelLog->payment_method) == 'cash' ? 'selected' : ''); ?>><?php echo e(__('Cash')); ?></option>
                                    <option value="card" <?php echo e(old('payment_method', $fuelLog->payment_method) == 'card' ? 'selected' : ''); ?>><?php echo e(__('Card')); ?></option>
                                    <option value="company_account" <?php echo e(old('payment_method', $fuelLog->payment_method) == 'company_account' ? 'selected' : ''); ?>><?php echo e(__('Company Account')); ?></option>
                                    <option value="fuel_card" <?php echo e(old('payment_method', $fuelLog->payment_method) == 'fuel_card' ? 'selected' : ''); ?>><?php echo e(__('Fuel Card')); ?></option>
                                </select>
                                <?php $__errorArgs = ['payment_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-calendar"></i>
                                    <?php echo e(__('Fill Date')); ?>

                                    <span class="create-form-required">*</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="date" 
                                           name="fill_date" 
                                           id="fill_date"
                                           class="create-input <?php $__errorArgs = ['fill_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('fill_date', $fuelLog->fill_date->format('Y-m-d'))); ?>"
                                           required>
                                    <i class="bi bi-calendar-event create-input-icon"></i>
                                </div>
                                <?php $__errorArgs = ['fill_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-clock"></i>
                                    <?php echo e(__('Fill Time')); ?>

                                    <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="time" 
                                           name="fill_time" 
                                           id="fill_time"
                                           class="create-input <?php $__errorArgs = ['fill_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('fill_time', $fuelLog->fill_time)); ?>">
                                    <i class="bi bi-clock create-input-icon"></i>
                                </div>
                                <?php $__errorArgs = ['fill_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon success">
                            <i class="bi bi-geo-alt"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title"><?php echo e(__('Station & Receipt')); ?></h5>
                            <p class="create-card-subtitle"><?php echo e(__('Fuel station details and receipt information')); ?></p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-building"></i>
                                    <?php echo e(__('Fuel Station')); ?>

                                    <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" 
                                           name="fuel_station" 
                                           id="fuel_station"
                                           class="create-input <?php $__errorArgs = ['fuel_station'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('fuel_station', $fuelLog->fuel_station)); ?>"
                                           placeholder="<?php echo e(__('e.g., Shell, BP, Petron')); ?>">
                                    <i class="bi bi-building create-input-icon"></i>
                                </div>
                                <?php $__errorArgs = ['fuel_station'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-receipt"></i>
                                    <?php echo e(__('Receipt Number')); ?>

                                    <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" 
                                           name="receipt_number" 
                                           id="receipt_number"
                                           class="create-input <?php $__errorArgs = ['receipt_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('receipt_number', $fuelLog->receipt_number)); ?>"
                                           placeholder="<?php echo e(__('Receipt/Invoice number')); ?>">
                                    <i class="bi bi-receipt create-input-icon"></i>
                                </div>
                                <?php $__errorArgs = ['receipt_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group full-width">
                                <label class="create-form-label">
                                    <i class="bi bi-pin-map"></i>
                                    <?php echo e(__('Station Location')); ?>

                                    <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                                </label>
                                <div class="create-input-icon-wrapper">
                                    <input type="text" 
                                           name="station_location" 
                                           id="station_location"
                                           class="create-input <?php $__errorArgs = ['station_location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           value="<?php echo e(old('station_location', $fuelLog->station_location)); ?>"
                                           placeholder="<?php echo e(__('Address or location of the fuel station')); ?>">
                                    <i class="bi bi-geo-alt create-input-icon"></i>
                                </div>
                                <?php $__errorArgs = ['station_location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="create-form-row">
                            <div class="create-form-group full-width">
                                <label class="create-form-label">
                                    <i class="bi bi-journal-text"></i>
                                    <?php echo e(__('Notes')); ?>

                                    <span class="create-form-optional">(<?php echo e(__('Optional')); ?>)</span>
                                </label>
                                <textarea name="notes" 
                                          id="notes"
                                          class="create-textarea <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                          rows="3"
                                          placeholder="<?php echo e(__('Any additional notes or remarks...')); ?>"><?php echo e(old('notes', $fuelLog->notes)); ?></textarea>
                                <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="create-form-actions">
                    <a href="<?php echo e(route('admin.fuel-logs.show', $fuelLog)); ?>" class="create-btn create-btn-secondary">
                        <i class="bi bi-x-lg"></i>
                        <?php echo e(__('Cancel')); ?>

                    </a>
                    <button type="submit" class="create-btn create-btn-primary">
                        <i class="bi bi-check-lg"></i>
                        <?php echo e(__('Update Fuel Log')); ?>

                    </button>
                </div>
            </div>

            
            <div class="create-form-sidebar">
                
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon info">
                            <i class="bi bi-info-circle"></i>
                        </div>
                        <h5 class="create-sidebar-title"><?php echo e(__('Current Record')); ?></h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-status-preview">
                            <div class="status-preview-item">
                                <span class="status-preview-label"><?php echo e(__('Fuel #')); ?></span>
                                <span class="status-preview-value"><?php echo e($fuelLog->fuel_number); ?></span>
                            </div>
                            <div class="status-preview-item">
                                <span class="status-preview-label"><?php echo e(__('Vehicle')); ?></span>
                                <span class="status-preview-value"><?php echo e($fuelLog->vehicle->vehicle_number); ?></span>
                            </div>
                            <div class="status-preview-item">
                                <span class="status-preview-label"><?php echo e(__('Created')); ?></span>
                                <span class="status-preview-value"><?php echo e($fuelLog->created_at->format('M d, Y')); ?></span>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon primary">
                            <i class="bi bi-calculator"></i>
                        </div>
                        <h5 class="create-sidebar-title"><?php echo e(__('Cost Summary')); ?></h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-status-preview">
                            <div class="status-preview-item">
                                <span class="status-preview-label"><?php echo e(__('Quantity')); ?></span>
                                <span class="status-preview-value" id="summary_quantity"><?php echo e(number_format($fuelLog->quantity, 2)); ?> L</span>
                            </div>
                            <div class="status-preview-item">
                                <span class="status-preview-label"><?php echo e(__('Price/Unit')); ?></span>
                                <span class="status-preview-value" id="summary_price">$<?php echo e(number_format($fuelLog->price_per_unit, 2)); ?></span>
                            </div>
                            <div class="status-preview-divider"></div>
                            <div class="status-preview-item highlight">
                                <span class="status-preview-label"><?php echo e(__('Total Cost')); ?></span>
                                <span class="status-preview-value text-success fw-bold" id="summary_total">$<?php echo e(number_format($fuelLog->total_cost, 2)); ?></span>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon primary">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h5 class="create-sidebar-title"><?php echo e(__('Quick Actions')); ?></h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="<?php echo e(route('admin.fuel-logs.show', $fuelLog)); ?>" class="create-quick-action-btn">
                                <i class="bi bi-eye"></i>
                                <?php echo e(__('View Details')); ?>

                            </a>
                            <a href="<?php echo e(route('admin.fuel-logs.vehicle-history', $fuelLog->vehicle)); ?>" class="create-quick-action-btn">
                                <i class="bi bi-clock-history"></i>
                                <?php echo e(__('Vehicle History')); ?>

                            </a>
                            <a href="<?php echo e(route('admin.fuel-logs.index')); ?>" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                <?php echo e(__('View All Fuel Logs')); ?>

                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const quantityInput = document.getElementById('quantity');
    const priceInput = document.getElementById('price_per_unit');
    const totalDisplay = document.getElementById('total_cost_display');
    const summaryQuantity = document.getElementById('summary_quantity');
    const summaryPrice = document.getElementById('summary_price');
    const summaryTotal = document.getElementById('summary_total');

    // Calculate total cost
    function calculateTotal() {
        const quantity = parseFloat(quantityInput.value) || 0;
        const price = parseFloat(priceInput.value) || 0;
        const total = quantity * price;

        totalDisplay.value = total.toFixed(2);
        summaryQuantity.textContent = quantity.toFixed(2) + ' L';
        summaryPrice.textContent = '$' + price.toFixed(2);
        summaryTotal.textContent = '$' + total.toFixed(2);
    }

    quantityInput.addEventListener('input', calculateTotal);
    priceInput.addEventListener('input', calculateTotal);
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\fleet-management\resources\views/admin/fuel-logs/edit.blade.php ENDPATH**/ ?>