<?php $__env->startSection('title', __('Shipments') . ' - ' . __('app_name')); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/adminlistpage.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-box-seam"></i>
                <?php echo e(__('Shipments')); ?>

            </h1>
            <p class="list-page-subtitle"><?php echo e(__('Manage and track all your shipments')); ?></p>
        </div>
        <div class="list-page-header-actions">
            <a href="<?php echo e(route('admin.shipments.create')); ?>" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                <?php echo e(__('New Shipment')); ?>

            </a>
        </div>
    </div>

    
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-check-circle me-2"></i><?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i><?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    
    <div class="list-stats-bar">
        <div class="list-stat-card gradient-violet">
            <div class="list-stat-icon">
                <i class="bi bi-box-seam"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($shipments->total()); ?></div>
                <div class="list-stat-label"><?php echo e(__('Total Shipments')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-graph-up-arrow"></i>
                <?php echo e(__('All time')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-rose">
            <div class="list-stat-icon">
                <i class="bi bi-clock"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($shipments->where('status', 'pending')->count()); ?></div>
                <div class="list-stat-label"><?php echo e(__('Pending')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-hourglass-split"></i>
                <?php echo e(__('Awaiting')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-cyan">
            <div class="list-stat-icon">
                <i class="bi bi-truck"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($shipments->where('status', 'in_transit')->count()); ?></div>
                <div class="list-stat-label"><?php echo e(__('In Transit')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-geo-alt"></i>
                <?php echo e(__('On route')); ?>

            </div>
        </div>
        <div class="list-stat-card gradient-amber">
            <div class="list-stat-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value"><?php echo e($shipments->where('status', 'delivered')->count()); ?></div>
                <div class="list-stat-label"><?php echo e(__('Delivered')); ?></div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-check2-all"></i>
                <?php echo e(__('Completed')); ?>

            </div>
        </div>
    </div>

    
    <div class="list-filter-bar">
        <div class="list-filter-header">
            <div class="list-filter-title">
                <i class="bi bi-funnel"></i>
                <?php echo e(__('Filters')); ?>

            </div>
            <?php if(request()->hasAny(['search', 'status', 'priority', 'vehicle_type'])): ?>
                <a href="<?php echo e(route('admin.shipments.index')); ?>" class="list-filter-clear">
                    <i class="bi bi-x-circle"></i>
                    <?php echo e(__('Clear Filters')); ?>

                </a>
            <?php endif; ?>
        </div>
        <form action="<?php echo e(route('admin.shipments.index')); ?>" method="GET">
            <div class="list-filter-row">
                <div class="list-filter-group search-group">
                    <label><?php echo e(__('Search')); ?></label>
                    <div class="list-search-box">
                        <i class="bi bi-search"></i>
                        <input type="text" name="search" class="form-control" 
                               placeholder="<?php echo e(__('Search by shipment number...')); ?>"
                               value="<?php echo e(request('search')); ?>">
                    </div>
                </div>
                <div class="list-filter-group">
                    <label><?php echo e(__('Status')); ?></label>
                    <select name="status" class="form-select">
                        <option value=""><?php echo e(__('All Statuses')); ?></option>
                        <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>><?php echo e(__('Pending')); ?></option>
                        <option value="assigned" <?php echo e(request('status') === 'assigned' ? 'selected' : ''); ?>><?php echo e(__('Assigned')); ?></option>
                        <option value="in_transit" <?php echo e(request('status') === 'in_transit' ? 'selected' : ''); ?>><?php echo e(__('In Transit')); ?></option>
                        <option value="delivered" <?php echo e(request('status') === 'delivered' ? 'selected' : ''); ?>><?php echo e(__('Delivered')); ?></option>
                        <option value="cancelled" <?php echo e(request('status') === 'cancelled' ? 'selected' : ''); ?>><?php echo e(__('Cancelled')); ?></option>
                    </select>
                </div>
                <div class="list-filter-group">
                    <label><?php echo e(__('Priority')); ?></label>
                    <select name="priority" class="form-select">
                        <option value=""><?php echo e(__('All Priorities')); ?></option>
                        <option value="normal" <?php echo e(request('priority') === 'normal' ? 'selected' : ''); ?>><?php echo e(__('Normal')); ?></option>
                        <option value="high" <?php echo e(request('priority') === 'high' ? 'selected' : ''); ?>><?php echo e(__('High')); ?></option>
                        <option value="urgent" <?php echo e(request('priority') === 'urgent' ? 'selected' : ''); ?>><?php echo e(__('Urgent')); ?></option>
                    </select>
                </div>
                <div class="list-filter-group">
                    <label><?php echo e(__('Vehicle Type')); ?></label>
                    <select name="vehicle_type" class="form-select">
                        <option value=""><?php echo e(__('All Types')); ?></option>
                        <?php $__currentLoopData = $vehicleTypes ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type->id); ?>" <?php echo e(request('vehicle_type') == $type->id ? 'selected' : ''); ?>>
                                <?php echo e($type->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="list-filter-buttons">
                    <button type="submit" class="btn-filter btn-filter-primary">
                        <i class="bi bi-search"></i>
                        <?php echo e(__('Apply')); ?>

                    </button>
                </div>
            </div>
        </form>
    </div>

    
    <div class="list-table-container">
        <div class="list-table-header">
            <h5 class="list-table-title">
                <?php echo e(__('Shipments List')); ?>

                <span class="list-table-count">(<?php echo e($shipments->total()); ?> <?php echo e(__('records')); ?>)</span>
            </h5>
        </div>

        <?php if($shipments->count() > 0): ?>
            <div class="table-responsive">
                <table class="list-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('Shipment #')); ?></th>
                            <th><?php echo e(__('Vehicle Type')); ?></th>
                            <th><?php echo e(__('Cargo Weight')); ?></th>
                            <th><?php echo e(__('Priority')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Created By')); ?></th>
                            <th><?php echo e(__('Created At')); ?></th>
                            <th><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $statusClasses = [
                                'pending' => 'pending',
                                'assigned' => 'assigned',
                                'in_transit' => 'in-transit',
                                'delivered' => 'delivered',
                                'cancelled' => 'cancelled'
                            ];
                            $statusIcons = [
                                'pending' => 'clock',
                                'assigned' => 'check-circle',
                                'in_transit' => 'truck',
                                'delivered' => 'check-all',
                                'cancelled' => 'x-circle'
                            ];
                            $priorityClasses = [
                                'normal' => 'normal',
                                'high' => 'high',
                                'urgent' => 'urgent'
                            ];
                        ?>
                        <?php $__currentLoopData = $shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="table-cell-id">
                                    <a href="<?php echo e(route('admin.shipments.show', $shipment)); ?>">
                                        <?php echo e($shipment->shipment_number); ?>

                                    </a>
                                </td>
                                <td>
                                    <span class="d-flex align-items-center gap-2">
                                        <i class="bi bi-truck text-muted"></i>
                                        <?php echo e($shipment->vehicleType->name); ?>

                                    </span>
                                </td>
                                <td><?php echo e($shipment->cargo_weight ? number_format($shipment->cargo_weight, 2) . ' T' : '-'); ?></td>
                                <td>
                                    <span class="table-badge table-badge-<?php echo e($priorityClasses[$shipment->priority] ?? 'normal'); ?>">
                                        <?php echo e(__(ucfirst($shipment->priority))); ?>

                                    </span>
                                </td>
                                <td>
                                    <span class="table-badge table-badge-<?php echo e($statusClasses[$shipment->status] ?? 'pending'); ?>">
                                        <i class="bi bi-<?php echo e($statusIcons[$shipment->status] ?? 'circle'); ?>"></i>
                                        <?php echo e(__(ucfirst(str_replace('_', ' ', $shipment->status)))); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="table-cell-user">
                                        <div class="table-cell-user-avatar">
                                            <i class="bi bi-person"></i>
                                        </div>
                                        <span><?php echo e($shipment->creator->name); ?></span>
                                    </div>
                                </td>
                                <td class="table-cell-date">
                                    <i class="bi bi-calendar"></i>
                                    <?php echo e($shipment->created_at->format('d M Y, h:i A')); ?>

                                </td>
                                <td>
                                    <div class="table-actions">
                                        <a href="<?php echo e(route('admin.shipments.show', $shipment)); ?>" 
                                           class="btn-table-action btn-table-view" 
                                           title="<?php echo e(__('View')); ?>">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        <?php if($shipment->status === 'pending'): ?>
                                            <a href="<?php echo e(route('admin.shipments.edit', $shipment)); ?>" 
                                               class="btn-table-action btn-table-edit" 
                                               title="<?php echo e(__('Edit')); ?>">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <form action="<?php echo e(route('admin.shipments.destroy', $shipment)); ?>" 
                                                  method="POST" 
                                                  class="d-inline"
                                                  onsubmit="return confirm('<?php echo e(__('Are you sure?')); ?>')">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" 
                                                        class="btn-table-action btn-table-delete" 
                                                        title="<?php echo e(__('Delete')); ?>">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            
            <?php if($shipments->hasPages()): ?>
            <div class="list-pagination">
                <div class="list-pagination-info">
                    <?php echo e(__('Showing')); ?> <?php echo e($shipments->firstItem()); ?> <?php echo e(__('to')); ?> <?php echo e($shipments->lastItem()); ?> <?php echo e(__('of')); ?> <?php echo e($shipments->total()); ?> <?php echo e(__('results')); ?>

                </div>
                <nav class="list-pagination-nav">
                    <?php echo e($shipments->links()); ?>

                </nav>
            </div>
            <?php endif; ?>
        <?php else: ?>
            
            <div class="list-empty-state">
                <div class="list-empty-state-icon">
                    <i class="bi bi-box-seam"></i>
                </div>
                <h4 class="list-empty-state-title"><?php echo e(__('No Shipments Found')); ?></h4>
                <p class="list-empty-state-text">
                    <?php echo e(__('There are no shipments matching your criteria. Create a new shipment to get started.')); ?>

                </p>
                <a href="<?php echo e(route('admin.shipments.create')); ?>" class="btn-create">
                    <i class="bi bi-plus-lg"></i>
                    <?php echo e(__('Create First Shipment')); ?>

                </a>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\fleet-management\resources\views/admin/shipments/index.blade.php ENDPATH**/ ?>