<?php $__env->startSection('title', __('Trip Report')); ?>
<?php $__env->startSection('page-title', __('Trip Report')); ?>
<?php $__env->startSection('page-subtitle', __('Analyze trip performance and status')); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/adminlistpage.css')); ?>">
<style>
    .report-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 1.5rem;
    }
    .export-dropdown .dropdown-menu {
        min-width: 150px;
    }
    .summary-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
        gap: 1rem;
        margin-bottom: 1.5rem;
    }
    .summary-card {
        background: linear-gradient(135deg, #eff6ff 0%, #dbeafe 100%);
        border-radius: 12px;
        padding: 1.25rem;
        border: 1px solid #bfdbfe;
    }
    .summary-card.success { background: linear-gradient(135deg, #dcfce7 0%, #bbf7d0 100%); border-color: #86efac; }
    .summary-card.warning { background: linear-gradient(135deg, #fef9c3 0%, #fef08a 100%); border-color: #fde047; }
    .summary-card.danger { background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%); border-color: #fca5a5; }
    .summary-card.info { background: linear-gradient(135deg, #e0e7ff 0%, #c7d2fe 100%); border-color: #a5b4fc; }
    .summary-card-value {
        font-size: 1.75rem;
        font-weight: 700;
        color: #1e40af;
    }
    .summary-card.success .summary-card-value { color: #16a34a; }
    .summary-card.warning .summary-card-value { color: #ca8a04; }
    .summary-card.danger .summary-card-value { color: #dc2626; }
    .summary-card.info .summary-card-value { color: #4f46e5; }
    .summary-card-label {
        font-size: 0.75rem;
        color: #1e40af;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    .summary-card.success .summary-card-label { color: #166534; }
    .summary-card.warning .summary-card-label { color: #854d0e; }
    .summary-card.danger .summary-card-label { color: #991b1b; }
    .summary-card.info .summary-card-label { color: #3730a3; }
    .filter-section {
        background: white;
        border-radius: 12px;
        padding: 1.25rem;
        margin-bottom: 1.5rem;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .chart-section {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
        gap: 1.5rem;
        margin-bottom: 1.5rem;
    }
    .chart-card {
        background: white;
        border-radius: 12px;
        padding: 1.25rem;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .chart-card-title {
        font-weight: 600;
        color: #374151;
        margin-bottom: 1rem;
        padding-bottom: 0.5rem;
        border-bottom: 1px solid #e5e7eb;
    }
    .data-table-card {
        background: white;
        border-radius: 12px;
        padding: 1.25rem;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .mini-table {
        width: 100%;
    }
    .mini-table th {
        font-size: 0.7rem;
        text-transform: uppercase;
        color: #6b7280;
        font-weight: 600;
        padding: 0.5rem;
        border-bottom: 2px solid #e5e7eb;
    }
    .mini-table td {
        padding: 0.5rem;
        font-size: 0.85rem;
        border-bottom: 1px solid #f3f4f6;
    }
    .status-badge {
        padding: 0.25rem 0.5rem;
        border-radius: 4px;
        font-size: 0.7rem;
        font-weight: 600;
    }
    .status-badge.completed { background: #dcfce7; color: #16a34a; }
    .status-badge.in_transit { background: #dbeafe; color: #2563eb; }
    .status-badge.pending { background: #fef9c3; color: #ca8a04; }
    .status-badge.cancelled { background: #fee2e2; color: #dc2626; }
    .status-badge.scheduled { background: #e0e7ff; color: #4f46e5; }
    .completion-rate {
        font-size: 0.8rem;
        padding: 0.25rem 0.5rem;
        border-radius: 4px;
    }
    .completion-rate.high { background: #dcfce7; color: #16a34a; }
    .completion-rate.medium { background: #fef9c3; color: #ca8a04; }
    .completion-rate.low { background: #fee2e2; color: #dc2626; }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    
    <div class="report-header">
        <div>
            <h4 class="mb-1"><i class="bi bi-signpost-split text-primary me-2"></i><?php echo e(__('Trip Summary Report')); ?></h4>
            <p class="text-muted mb-0"><?php echo e(__('Overview of trip performance and completion rates')); ?></p>
        </div>
        <div class="d-flex gap-2">
            <div class="dropdown export-dropdown">
                <button class="btn btn-success dropdown-toggle" type="button" data-bs-toggle="dropdown">
                    <i class="bi bi-download me-1"></i> <?php echo e(__('Export')); ?>

                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                        <a class="dropdown-item" href="<?php echo e(route('admin.reports.trip.export', array_merge(request()->query(), ['format' => 'pdf']))); ?>">
                            <i class="bi bi-file-pdf text-danger me-2"></i> <?php echo e(__('Export as PDF')); ?>

                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item" href="<?php echo e(route('admin.reports.trip.export', array_merge(request()->query(), ['format' => 'csv']))); ?>">
                            <i class="bi bi-filetype-csv text-success me-2"></i> <?php echo e(__('Export as CSV')); ?>

                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item" href="<?php echo e(route('admin.reports.trip.export', array_merge(request()->query(), ['format' => 'html']))); ?>">
                            <i class="bi bi-filetype-html text-primary me-2"></i> <?php echo e(__('Export as HTML')); ?>

                        </a>
                    </li>
                </ul>
            </div>
            <a href="<?php echo e(route('admin.trips.index')); ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-1"></i> <?php echo e(__('Back to Trips')); ?>

            </a>
        </div>
    </div>

    
    <div class="summary-cards">
        <div class="summary-card">
            <div class="summary-card-value"><?php echo e($summary['total_trips']); ?></div>
            <div class="summary-card-label"><?php echo e(__('Total Trips')); ?></div>
        </div>
        <div class="summary-card success">
            <div class="summary-card-value"><?php echo e($summary['completed']); ?></div>
            <div class="summary-card-label"><?php echo e(__('Completed')); ?></div>
        </div>
        <div class="summary-card info">
            <div class="summary-card-value"><?php echo e($summary['in_transit']); ?></div>
            <div class="summary-card-label"><?php echo e(__('In Transit')); ?></div>
        </div>
        <div class="summary-card warning">
            <div class="summary-card-value"><?php echo e($summary['pending']); ?></div>
            <div class="summary-card-label"><?php echo e(__('Pending')); ?></div>
        </div>
        <div class="summary-card danger">
            <div class="summary-card-value"><?php echo e($summary['cancelled']); ?></div>
            <div class="summary-card-label"><?php echo e(__('Cancelled')); ?></div>
        </div>
    </div>

    
    <div class="filter-section">
        <form action="<?php echo e(route('admin.reports.trip.index')); ?>" method="GET">
            <div class="row g-3">
                <div class="col-md-2">
                    <label class="form-label"><?php echo e(__('Date From')); ?></label>
                    <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from')); ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label"><?php echo e(__('Date To')); ?></label>
                    <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to')); ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label"><?php echo e(__('Vehicle')); ?></label>
                    <select name="vehicle_id" class="form-select">
                        <option value=""><?php echo e(__('All Vehicles')); ?></option>
                        <?php $__currentLoopData = $vehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($vehicle->id); ?>" <?php echo e(request('vehicle_id') == $vehicle->id ? 'selected' : ''); ?>>
                                <?php echo e($vehicle->vehicle_number); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label"><?php echo e(__('Driver')); ?></label>
                    <select name="driver_id" class="form-select">
                        <option value=""><?php echo e(__('All Drivers')); ?></option>
                        <?php $__currentLoopData = $drivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($driver->id); ?>" <?php echo e(request('driver_id') == $driver->id ? 'selected' : ''); ?>>
                                <?php echo e($driver->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label"><?php echo e(__('Status')); ?></label>
                    <select name="status" class="form-select">
                        <option value=""><?php echo e(__('All Status')); ?></option>
                        <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>><?php echo e(__('Pending')); ?></option>
                        <option value="scheduled" <?php echo e(request('status') == 'scheduled' ? 'selected' : ''); ?>><?php echo e(__('Scheduled')); ?></option>
                        <option value="in_transit" <?php echo e(request('status') == 'in_transit' ? 'selected' : ''); ?>><?php echo e(__('In Transit')); ?></option>
                        <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>><?php echo e(__('Completed')); ?></option>
                        <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>><?php echo e(__('Cancelled')); ?></option>
                    </select>
                </div>
                <div class="col-md-2 d-flex align-items-end gap-2">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-funnel me-1"></i> <?php echo e(__('Filter')); ?>

                    </button>
                    <a href="<?php echo e(route('admin.reports.trip.index')); ?>" class="btn btn-outline-secondary">
                        <i class="bi bi-x-lg"></i>
                    </a>
                </div>
            </div>
        </form>
    </div>

    
    <div class="chart-section">
        
        <div class="chart-card">
            <h6 class="chart-card-title"><i class="bi bi-pie-chart me-2"></i><?php echo e(__('By Status')); ?></h6>
            <?php if($byStatus->count() > 0): ?>
                <table class="mini-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('Status')); ?></th>
                            <th class="text-end"><?php echo e(__('Count')); ?></th>
                            <th class="text-end"><?php echo e(__('Percentage')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $byStatus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $percentage = $summary['total_trips'] > 0 ? round(($item->count / $summary['total_trips']) * 100, 1) : 0;
                        ?>
                        <tr>
                            <td><span class="status-badge <?php echo e($item->status); ?>"><?php echo e(ucfirst(str_replace('_', ' ', $item->status))); ?></span></td>
                            <td class="text-end"><?php echo e($item->count); ?></td>
                            <td class="text-end"><?php echo e($percentage); ?>%</td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-muted text-center py-3"><?php echo e(__('No data available')); ?></p>
            <?php endif; ?>
        </div>

        
        <div class="chart-card">
            <h6 class="chart-card-title"><i class="bi bi-truck me-2"></i><?php echo e(__('By Vehicle')); ?></h6>
            <?php if($byVehicle->count() > 0): ?>
                <table class="mini-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('Vehicle')); ?></th>
                            <th class="text-end"><?php echo e(__('Total')); ?></th>
                            <th class="text-end"><?php echo e(__('Completed')); ?></th>
                            <th class="text-end"><?php echo e(__('Rate')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $byVehicle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $rate = $item->total_trips > 0 ? round(($item->completed / $item->total_trips) * 100, 1) : 0;
                            $rateClass = $rate >= 80 ? 'high' : ($rate >= 50 ? 'medium' : 'low');
                        ?>
                        <tr>
                            <td><?php echo e($item->vehicle->vehicle_number ?? '-'); ?></td>
                            <td class="text-end"><?php echo e($item->total_trips); ?></td>
                            <td class="text-end"><?php echo e($item->completed); ?></td>
                            <td class="text-end"><span class="completion-rate <?php echo e($rateClass); ?>"><?php echo e($rate); ?>%</span></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-muted text-center py-3"><?php echo e(__('No data available')); ?></p>
            <?php endif; ?>
        </div>

        
        <div class="chart-card">
            <h6 class="chart-card-title"><i class="bi bi-person-badge me-2"></i><?php echo e(__('By Driver')); ?></h6>
            <?php if($byDriver->count() > 0): ?>
                <table class="mini-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('Driver')); ?></th>
                            <th class="text-end"><?php echo e(__('Total')); ?></th>
                            <th class="text-end"><?php echo e(__('Completed')); ?></th>
                            <th class="text-end"><?php echo e(__('Rate')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $byDriver; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $rate = $item->total_trips > 0 ? round(($item->completed / $item->total_trips) * 100, 1) : 0;
                            $rateClass = $rate >= 80 ? 'high' : ($rate >= 50 ? 'medium' : 'low');
                        ?>
                        <tr>
                            <td><?php echo e($item->driver->name ?? '-'); ?></td>
                            <td class="text-end"><?php echo e($item->total_trips); ?></td>
                            <td class="text-end"><?php echo e($item->completed); ?></td>
                            <td class="text-end"><span class="completion-rate <?php echo e($rateClass); ?>"><?php echo e($rate); ?>%</span></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-muted text-center py-3"><?php echo e(__('No data available')); ?></p>
            <?php endif; ?>
        </div>
    </div>

    
    <div class="data-table-card">
        <h6 class="chart-card-title"><i class="bi bi-table me-2"></i><?php echo e(__('Trip Details')); ?></h6>
        
        <?php if($trips->count() > 0): ?>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead>
                        <tr>
                            <th><?php echo e(__('Trip Number')); ?></th>
                            <th><?php echo e(__('Scheduled Date')); ?></th>
                            <th><?php echo e(__('Vehicle')); ?></th>
                            <th><?php echo e(__('Driver')); ?></th>
                            <th><?php echo e(__('Origin')); ?></th>
                            <th><?php echo e(__('Destination')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Start Time')); ?></th>
                            <th><?php echo e(__('End Time')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $trips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><strong><?php echo e($trip->trip_number); ?></strong></td>
                            <td><?php echo e($trip->scheduled_date); ?></td>
                            <td><?php echo e($trip->vehicle->vehicle_number ?? '-'); ?></td>
                            <td><?php echo e($trip->driver->name ?? '-'); ?></td>
                            <td><?php echo e($trip->origin ?? '-'); ?></td>
                            <td><?php echo e($trip->destination ?? '-'); ?></td>
                            <td><span class="status-badge <?php echo e($trip->status); ?>"><?php echo e(ucfirst(str_replace('_', ' ', $trip->status))); ?></span></td>
                            <td><?php echo e($trip->actual_start_time ?? '-'); ?></td>
                            <td><?php echo e($trip->actual_end_time ?? '-'); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                <?php echo e($trips->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-signpost-split display-4 text-muted"></i>
                <p class="text-muted mt-2"><?php echo e(__('No trips found for the selected filters')); ?></p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\fleet-management\resources\views/admin/reports/trip/index.blade.php ENDPATH**/ ?>