<?php $__env->startSection('title', __('dashboard') . ' - ' . __('app_name')); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/dashboard.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Premium Dashboard Header -->
<div class="dashboard-header">
    <div class="dashboard-header-content">
        <div class="dashboard-welcome">
            <p class="greeting"><?php echo e(__('welcome_back')); ?></p>
            <h1><?php echo e(auth()->user()->name); ?></h1>
            <p class="date-time">
                <i class="bi bi-calendar3"></i>
                <span id="currentDateTime"><?php echo e(now()->format('l, F j, Y')); ?></span>
            </p>
        </div>
        <div class="dashboard-actions">
            <a href="<?php echo e(route('admin.trips.create')); ?>" class="btn">
                <i class="bi bi-plus-lg"></i> <?php echo e(__('new_trip')); ?>

            </a>
            <a href="<?php echo e(route('admin.tracking.index')); ?>" class="btn">
                <i class="bi bi-geo-alt"></i> <?php echo e(__('live_tracking')); ?>

            </a>
        </div>
    </div>
</div>

<!-- Premium Stats Cards -->
<div class="stats-grid">
    <!-- Total Vehicles Card -->
    <div class="stat-card vehicles hover-lift">
        <div class="stat-card-header">
            <div class="stat-icon">
                <i class="bi bi-truck-front"></i>
            </div>
            <span class="stat-trend up">
                <i class="bi bi-arrow-up"></i> 12%
            </span>
        </div>
        <div class="stat-card-body">
            <h3 class="counter-animate"><?php echo e($totalVehicles); ?></h3>
            <p><?php echo e(__('total_vehicles')); ?></p>
        </div>
        <div class="stat-card-footer">
            <div class="stat-progress">
                <div class="stat-progress-bar" style="width: <?php echo e(min(($totalVehicles / max($totalVehicles + 10, 1)) * 100, 100)); ?>%"></div>
            </div>
            <div class="stat-progress-label">
                <span><?php echo e(__('active_fleet')); ?></span>
                <span><?php echo e($totalVehicles); ?> <?php echo e(__('units')); ?></span>
            </div>
        </div>
    </div>

    <!-- Active Drivers Card -->
    <div class="stat-card drivers hover-lift">
        <div class="stat-card-header">
            <div class="stat-icon">
                <i class="bi bi-person-badge"></i>
            </div>
            <span class="stat-trend up">
                <i class="bi bi-arrow-up"></i> 8%
            </span>
        </div>
        <div class="stat-card-body">
            <h3 class="counter-animate"><?php echo e($activeDrivers); ?></h3>
            <p><?php echo e(__('active_drivers')); ?></p>
        </div>
        <div class="stat-card-footer">
            <div class="stat-progress">
                <div class="stat-progress-bar" style="width: <?php echo e(min(($activeDrivers / max($activeDrivers + 5, 1)) * 100, 100)); ?>%"></div>
            </div>
            <div class="stat-progress-label">
                <span><?php echo e(__('on_duty')); ?></span>
                <span><?php echo e($activeDrivers); ?> <?php echo e(__('drivers')); ?></span>
            </div>
        </div>
    </div>

    <!-- Active Trips Card -->
    <div class="stat-card trips hover-lift">
        <div class="stat-card-header">
            <div class="stat-icon">
                <i class="bi bi-geo-alt"></i>
            </div>
            <span class="stat-trend neutral">
                <span class="pulse-dot active"></span> <?php echo e(__('live')); ?>

            </span>
        </div>
        <div class="stat-card-body">
            <h3 class="counter-animate"><?php echo e($activeTrips); ?></h3>
            <p><?php echo e(__('active_trips')); ?></p>
        </div>
        <div class="stat-card-footer">
            <div class="stat-progress">
                <div class="stat-progress-bar" style="width: <?php echo e($activeTrips > 0 ? 65 : 0); ?>%"></div>
            </div>
            <div class="stat-progress-label">
                <span><?php echo e(__('in_progress')); ?></span>
                <span><?php echo e($activeTrips); ?> <?php echo e(__('trips')); ?></span>
            </div>
        </div>
    </div>

    <!-- Deliveries This Month Card -->
    <div class="stat-card deliveries hover-lift">
        <div class="stat-card-header">
            <div class="stat-icon">
                <i class="bi bi-clipboard-check"></i>
            </div>
            <span class="stat-trend up">
                <i class="bi bi-arrow-up"></i> 24%
            </span>
        </div>
        <div class="stat-card-body">
            <h3 class="counter-animate"><?php echo e($deliveriesThisMonth); ?></h3>
            <p><?php echo e(__('deliveries_month')); ?></p>
        </div>
        <div class="stat-card-footer">
            <div class="stat-progress">
                <div class="stat-progress-bar" style="width: <?php echo e(min(($deliveriesThisMonth / max($deliveriesThisMonth + 20, 1)) * 100, 100)); ?>%"></div>
            </div>
            <div class="stat-progress-label">
                <span><?php echo e(__('this_month')); ?></span>
                <span><?php echo e($deliveriesThisMonth); ?> <?php echo e(__('completed')); ?></span>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row - Revenue & Trip Distribution -->
<div class="charts-row">
    <!-- Revenue & Trip Count Trend Chart -->
    <div class="chart-card hover-lift">
        <div class="chart-card-header">
            <h5><i class="bi bi-graph-up-arrow"></i> <?php echo e(__('revenue_trip_trend')); ?></h5>
            <div class="chart-actions">
                <button class="btn btn-sm btn-outline-secondary" data-period="month"><?php echo e(__('month')); ?></button>
                <button class="btn btn-sm btn-primary" data-period="year"><?php echo e(__('year')); ?></button>
            </div>
        </div>
        <div class="chart-card-body">
            <div class="chart-container">
                <canvas id="revenueTrendChart"></canvas>
            </div>
        </div>
    </div>

    <!-- Trip Status Distribution Chart -->
    <div class="chart-card hover-lift">
        <div class="chart-card-header">
            <h5><i class="bi bi-pie-chart"></i> <?php echo e(__('trip_distribution')); ?></h5>
        </div>
        <div class="chart-card-body">
            <div class="chart-container">
                <canvas id="tripDistributionChart"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row - Cost & Vehicle Type -->
<div class="charts-row-equal">
    <!-- Cost Breakdown Chart -->
    <div class="chart-card hover-lift">
        <div class="chart-card-header">
            <h5><i class="bi bi-wallet2"></i> <?php echo e(__('cost_breakdown')); ?></h5>
        </div>
        <div class="chart-card-body">
            <div class="chart-container chart-container-sm">
                <canvas id="costBreakdownChart"></canvas>
            </div>
        </div>
    </div>

    <!-- Vehicle Type Distribution Chart -->
    <div class="chart-card hover-lift">
        <div class="chart-card-header">
            <h5><i class="bi bi-bar-chart"></i> <?php echo e(__('vehicle_type_distribution')); ?></h5>
        </div>
        <div class="chart-card-body">
            <div class="chart-container chart-container-sm">
                <canvas id="vehicleTypeChart"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Recent Trips Section -->
<div class="recent-trips-card hover-lift">
    <div class="recent-trips-header">
        <h5><i class="bi bi-clock-history"></i> <?php echo e(__('recent_trips')); ?></h5>
        <a href="<?php echo e(route('admin.trips.index')); ?>" class="view-all-btn">
            <?php echo e(__('view_all')); ?> <i class="bi bi-arrow-right"></i>
        </a>
    </div>
    <div class="recent-trips-body">
        <?php if($recentTrips->count() > 0): ?>
        <div class="table-responsive">
            <table class="dashboard-table">
                <thead>
                    <tr>
                        <th><?php echo e(__('trip_number')); ?></th>
                        <th><?php echo e(__('vehicle')); ?></th>
                        <th><?php echo e(__('driver')); ?></th>
                        <th><?php echo e(__('shipment_reference')); ?></th>
                        <th><?php echo e(__('status')); ?></th>
                        <th><?php echo e(__('actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $recentTrips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <span class="trip-number">
                                <i class="bi bi-hash"></i>
                                <?php echo e($trip->trip_number); ?>

                            </span>
                        </td>
                        <td>
                            <div class="vehicle-info">
                                <div class="vehicle-avatar">
                                    <i class="bi bi-truck"></i>
                                </div>
                                <div class="vehicle-details">
                                    <span class="vehicle-number"><?php echo e($trip->vehicle->vehicle_number); ?></span>
                                    <span class="vehicle-type"><?php echo e($trip->vehicle->vehicleType->name ?? '-'); ?></span>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div class="driver-info">
                                <div class="driver-avatar">
                                    <?php echo e(strtoupper(substr($trip->driver->name, 0, 2))); ?>

                                </div>
                                <div class="driver-details">
                                    <span class="driver-name"><?php echo e($trip->driver->name); ?></span>
                                    <span class="driver-phone"><?php echo e($trip->driver->phone ?? '-'); ?></span>
                                </div>
                            </div>
                        </td>
                        <td>
                            <?php if($trip->shipment_reference): ?>
                                <span class="shipment-ref"><?php echo e($trip->shipment_reference); ?></span>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="status-badge <?php echo e($trip->status); ?>">
                                <?php if($trip->status === 'in_transit'): ?>
                                    <span class="pulse-dot active"></span>
                                <?php else: ?>
                                    <i class="bi bi-circle-fill"></i>
                                <?php endif; ?>
                                <?php echo e(__($trip->status)); ?>

                            </span>
                        </td>
                        <td>
                            <a href="<?php echo e(route('admin.trips.show', $trip)); ?>" class="action-btn view">
                                <i class="bi bi-eye"></i> <?php echo e(__('view')); ?>

                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <div class="no-records">
            <div class="no-records-icon">
                <i class="bi bi-inbox"></i>
            </div>
            <h6><?php echo e(__('no_trips_yet')); ?></h6>
            <p><?php echo e(__('create_first_trip_message')); ?></p>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<script>
    // Premium Chart Colors with Gradients
    const chartColors = {
        primary: '#f97316',
        primaryLight: 'rgba(249, 115, 22, 0.1)',
        success: '#10b981',
        successLight: 'rgba(16, 185, 129, 0.1)',
        warning: '#f59e0b',
        warningLight: 'rgba(245, 158, 11, 0.1)',
        danger: '#ef4444',
        info: '#06b6d4',
        purple: '#8b5cf6',
        pink: '#ec4899',
        orange: '#f97316',
        teal: '#14b8a6'
    };

    // Create gradient for Revenue Chart
    function createGradient(ctx, color1, color2) {
        const gradient = ctx.createLinearGradient(0, 0, 0, 350);
        gradient.addColorStop(0, color1);
        gradient.addColorStop(1, color2);
        return gradient;
    }

    // Revenue & Trip Count Trend Chart
    const revenueTrendCtx = document.getElementById('revenueTrendChart').getContext('2d');
    const revenueGradient = createGradient(revenueTrendCtx, 'rgba(249, 115, 22, 0.3)', 'rgba(249, 115, 22, 0.02)');
    const tripGradient = createGradient(revenueTrendCtx, 'rgba(16, 185, 129, 0.3)', 'rgba(16, 185, 129, 0.02)');

    new Chart(revenueTrendCtx, {
        type: 'line',
        data: {
            labels: <?php echo json_encode($revenueData['months'], 15, 512) ?>,
            datasets: [
                {
                    label: '<?php echo e(__("revenue")); ?> ($)',
                    data: <?php echo json_encode($revenueData['revenue'], 15, 512) ?>,
                    borderColor: chartColors.primary,
                    backgroundColor: revenueGradient,
                    fill: true,
                    yAxisID: 'y',
                    tension: 0.4,
                    borderWidth: 3,
                    pointRadius: 4,
                    pointBackgroundColor: chartColors.primary,
                    pointBorderColor: '#ffffff',
                    pointBorderWidth: 2,
                    pointHoverRadius: 6,
                    pointHoverBackgroundColor: chartColors.primary,
                    pointHoverBorderColor: '#ffffff',
                    pointHoverBorderWidth: 3
                },
                {
                    label: '<?php echo e(__("trip_count")); ?>',
                    data: <?php echo json_encode($revenueData['tripCount'], 15, 512) ?>,
                    borderColor: chartColors.success,
                    backgroundColor: tripGradient,
                    fill: true,
                    yAxisID: 'y1',
                    tension: 0.4,
                    borderWidth: 3,
                    pointRadius: 4,
                    pointBackgroundColor: chartColors.success,
                    pointBorderColor: '#ffffff',
                    pointBorderWidth: 2,
                    pointHoverRadius: 6,
                    pointHoverBackgroundColor: chartColors.success,
                    pointHoverBorderColor: '#ffffff',
                    pointHoverBorderWidth: 3
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            interaction: {
                mode: 'index',
                intersect: false,
            },
            plugins: {
                legend: {
                    position: 'top',
                    align: 'end',
                    labels: {
                        usePointStyle: true,
                        pointStyle: 'circle',
                        padding: 20,
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 12,
                            weight: 500
                        }
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(30, 41, 59, 0.95)',
                    titleFont: {
                        family: "'Poppins', sans-serif",
                        size: 13,
                        weight: 600
                    },
                    bodyFont: {
                        family: "'Poppins', sans-serif",
                        size: 12
                    },
                    padding: 12,
                    cornerRadius: 10,
                    displayColors: true,
                    usePointStyle: true
                }
            },
            scales: {
                x: {
                    grid: {
                        display: false
                    },
                    ticks: {
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 11
                        }
                    }
                },
                y: {
                    type: 'linear',
                    display: true,
                    position: 'left',
                    title: {
                        display: true,
                        text: '<?php echo e(__("revenue")); ?> ($)',
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 12,
                            weight: 500
                        }
                    },
                    grid: {
                        color: 'rgba(0, 0, 0, 0.05)'
                    },
                    ticks: {
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 11
                        }
                    }
                },
                y1: {
                    type: 'linear',
                    display: true,
                    position: 'right',
                    title: {
                        display: true,
                        text: '<?php echo e(__("trip_count")); ?>',
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 12,
                            weight: 500
                        }
                    },
                    grid: {
                        drawOnChartArea: false,
                    },
                    ticks: {
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 11
                        }
                    }
                }
            }
        }
    });

    // Trip Status Distribution Chart (Doughnut)
    const tripDistributionCtx = document.getElementById('tripDistributionChart').getContext('2d');
    new Chart(tripDistributionCtx, {
        type: 'doughnut',
        data: {
            labels: <?php echo json_encode(array_map(function($item) { return __($item['status']); }, $tripDistribution), 512) ?>,
            datasets: [{
                data: <?php echo json_encode(array_column($tripDistribution, 'count'), 512) ?>,
                backgroundColor: [
                    chartColors.warning,
                    chartColors.info,
                    chartColors.purple,
                    chartColors.success,
                    chartColors.danger
                ],
                borderWidth: 0,
                hoverOffset: 10,
                spacing: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            cutout: '70%',
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        usePointStyle: true,
                        pointStyle: 'circle',
                        padding: 15,
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 11,
                            weight: 500
                        }
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(30, 41, 59, 0.95)',
                    titleFont: {
                        family: "'Poppins', sans-serif",
                        size: 13,
                        weight: 600
                    },
                    bodyFont: {
                        family: "'Poppins', sans-serif",
                        size: 12
                    },
                    padding: 12,
                    cornerRadius: 10
                }
            }
        }
    });

    // Cost Breakdown Chart (Doughnut)
    const costBreakdownCtx = document.getElementById('costBreakdownChart').getContext('2d');
    new Chart(costBreakdownCtx, {
        type: 'doughnut',
        data: {
            labels: <?php echo json_encode($costBreakdown['labels'], 15, 512) ?>,
            datasets: [{
                data: <?php echo json_encode($costBreakdown['values'], 15, 512) ?>,
                backgroundColor: [
                    chartColors.primary,
                    chartColors.success,
                    chartColors.orange,
                    chartColors.info,
                    chartColors.purple
                ],
                borderWidth: 0,
                hoverOffset: 8,
                spacing: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            cutout: '65%',
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        usePointStyle: true,
                        pointStyle: 'circle',
                        padding: 12,
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 11,
                            weight: 500
                        }
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(30, 41, 59, 0.95)',
                    titleFont: {
                        family: "'Poppins', sans-serif",
                        size: 13,
                        weight: 600
                    },
                    bodyFont: {
                        family: "'Poppins', sans-serif",
                        size: 12
                    },
                    padding: 12,
                    cornerRadius: 10,
                    callbacks: {
                        label: function(context) {
                            return context.label + ': $' + context.parsed.toLocaleString();
                        }
                    }
                }
            }
        }
    });

    // Vehicle Type Distribution Chart (Bar)
    const vehicleTypeCtx = document.getElementById('vehicleTypeChart').getContext('2d');
    new Chart(vehicleTypeCtx, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($vehicleTypeDistribution['labels'], 15, 512) ?>,
            datasets: [{
                label: '<?php echo e(__("vehicles")); ?>',
                data: <?php echo json_encode($vehicleTypeDistribution['values'], 15, 512) ?>,
                backgroundColor: function(context) {
                    const colors = [
                        chartColors.primary,
                        chartColors.success,
                        chartColors.info,
                        chartColors.warning,
                        chartColors.purple
                    ];
                    return colors[context.dataIndex % colors.length];
                },
                borderRadius: 8,
                borderSkipped: false,
                barThickness: 40,
                maxBarThickness: 50
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    backgroundColor: 'rgba(30, 41, 59, 0.95)',
                    titleFont: {
                        family: "'Poppins', sans-serif",
                        size: 13,
                        weight: 600
                    },
                    bodyFont: {
                        family: "'Poppins', sans-serif",
                        size: 12
                    },
                    padding: 12,
                    cornerRadius: 10
                }
            },
            scales: {
                x: {
                    grid: {
                        display: false
                    },
                    ticks: {
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 11
                        }
                    }
                },
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(0, 0, 0, 0.05)'
                    },
                    ticks: {
                        stepSize: 1,
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 11
                        }
                    }
                }
            }
        }
    });

    // Counter Animation
    document.addEventListener('DOMContentLoaded', function() {
        const counters = document.querySelectorAll('.counter-animate');
        counters.forEach(counter => {
            const target = parseInt(counter.innerText);
            const duration = 1500;
            const start = 0;
            const increment = target / (duration / 16);
            let current = start;
            
            const timer = setInterval(() => {
                current += increment;
                if (current >= target) {
                    counter.innerText = target;
                    clearInterval(timer);
                } else {
                    counter.innerText = Math.floor(current);
                }
            }, 16);
        });
    });

    // Update DateTime
    function updateDateTime() {
        const now = new Date();
        const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
        document.getElementById('currentDateTime').textContent = now.toLocaleDateString('<?php echo e(app()->getLocale()); ?>', options);
    }
    setInterval(updateDateTime, 60000);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\fleet-management\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>