<?php $__env->startSection('title', $trip->trip_number . ' - ' . __('Trip Details')); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/admindetailpage.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    
    <div class="page-header">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.trips.index')); ?>"><?php echo e(__('Trips')); ?></a></li>
                    <li class="breadcrumb-item active"><?php echo e($trip->trip_number); ?></li>
                </ol>
            </nav>
        </div>
    </div>

    
    <?php if(session('success')): ?>
        <div class="detail-alert detail-alert-info">
            <div class="detail-alert-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title"><?php echo e(__('Success')); ?></div>
                <div class="detail-alert-text"><?php echo e(session('success')); ?></div>
            </div>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="detail-alert detail-alert-warning">
            <div class="detail-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title"><?php echo e(__('Error')); ?></div>
                <div class="detail-alert-text"><?php echo e(session('error')); ?></div>
            </div>
        </div>
    <?php endif; ?>

    
    <div class="detail-hero">
        <div class="detail-hero-header">
            <div class="detail-hero-content">
                <div class="detail-hero-icon">
                    <i class="bi bi-geo-alt"></i>
                </div>
                <div class="detail-hero-info">
                    <h1 class="detail-hero-title"><?php echo e($trip->trip_number); ?></h1>
                    <p class="detail-hero-subtitle">
                        <?php echo e($trip->vehicle->vehicle_number ?? '-'); ?> · <?php echo e($trip->driver->name ?? '-'); ?> · <?php echo e(__('Created')); ?> <?php echo e($trip->created_at->format('M d, Y')); ?>

                    </p>
                    <div class="detail-hero-badges">
                        <?php
                            $statusClasses = [
                                'pending' => 'pending',
                                'assigned' => 'assigned',
                                'in_transit' => 'in-transit',
                                'delivered' => 'delivered',
                                'cancelled' => 'cancelled'
                            ];
                            $statusIcons = [
                                'pending' => 'clock',
                                'assigned' => 'check-circle',
                                'in_transit' => 'truck',
                                'delivered' => 'check-all',
                                'cancelled' => 'x-circle'
                            ];
                        ?>
                        <span class="hero-badge hero-badge-<?php echo e($statusClasses[$trip->status] ?? 'pending'); ?>">
                            <i class="bi bi-<?php echo e($statusIcons[$trip->status] ?? 'circle'); ?>"></i>
                            <?php echo e(__(ucfirst(str_replace('_', ' ', $trip->status)))); ?>

                        </span>
                        <?php if($trip->has_multiple_locations): ?>
                            <span class="hero-badge hero-badge-info">
                                <i class="bi bi-pin-map"></i>
                                <?php echo e(__('Multiple Locations')); ?>

                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        
        <?php if(!in_array($trip->status, ['cancelled'])): ?>
        <div class="detail-hero-progress">
            <div class="progress-steps">
                <div class="progress-step <?php echo e(in_array($trip->status, ['assigned', 'in_transit', 'delivered']) ? 'completed' : 'active'); ?>">
                    <div class="progress-step-icon">
                        <i class="bi bi-<?php echo e(in_array($trip->status, ['assigned', 'in_transit', 'delivered']) ? 'check-lg' : 'clipboard-check'); ?>"></i>
                    </div>
                    <div class="progress-step-label"><?php echo e(__('Assigned')); ?></div>
                </div>
                <div class="progress-step <?php echo e(in_array($trip->status, ['in_transit', 'delivered']) ? 'completed' : ($trip->status === 'assigned' ? 'active' : '')); ?>">
                    <div class="progress-step-icon">
                        <i class="bi bi-<?php echo e(in_array($trip->status, ['in_transit', 'delivered']) ? 'check-lg' : 'truck'); ?>"></i>
                    </div>
                    <div class="progress-step-label"><?php echo e(__('In Transit')); ?></div>
                </div>
                <div class="progress-step <?php echo e($trip->status === 'delivered' ? 'completed' : ($trip->status === 'in_transit' ? 'active' : '')); ?>">
                    <div class="progress-step-icon">
                        <i class="bi bi-<?php echo e($trip->status === 'delivered' ? 'check-lg' : 'box-arrow-in-down'); ?>"></i>
                    </div>
                    <div class="progress-step-label"><?php echo e(__('Delivered')); ?></div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <div class="row">
        
        <div class="col-lg-8">
            
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon primary">
                        <i class="bi bi-info-circle"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Trip Information')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Trip Number')); ?></span>
                            <span class="info-item-value highlight"><?php echo e($trip->trip_number); ?></span>
                        </div>
                        <?php if($trip->shipment): ?>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Linked Shipment')); ?></span>
                            <span class="info-item-value">
                                <a href="<?php echo e(route('admin.shipments.show', $trip->shipment)); ?>" class="item-link">
                                    <?php echo e($trip->shipment->shipment_number); ?>

                                </a>
                            </span>
                        </div>
                        <?php endif; ?>
                        <?php if($trip->shipment_reference): ?>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Shipment Reference')); ?></span>
                            <span class="info-item-value"><?php echo e($trip->shipment_reference); ?></span>
                        </div>
                        <?php endif; ?>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Delivery Type')); ?></span>
                            <span class="info-item-value">
                                <?php if($trip->has_multiple_locations): ?>
                                    <span class="status-badge status-badge-info">
                                        <i class="bi bi-pin-map"></i>
                                        <?php echo e(__('Multiple Locations')); ?>

                                    </span>
                                <?php else: ?>
                                    <span class="status-badge status-badge-success">
                                        <i class="bi bi-geo"></i>
                                        <?php echo e(__('Single Location')); ?>

                                    </span>
                                <?php endif; ?>
                            </span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Status')); ?></span>
                            <span class="status-badge status-badge-<?php echo e($statusClasses[$trip->status] ?? 'pending'); ?>">
                                <i class="bi bi-<?php echo e($statusIcons[$trip->status] ?? 'circle'); ?>"></i>
                                <?php echo e(__(ucfirst(str_replace('_', ' ', $trip->status)))); ?>

                            </span>
                        </div>
                        <?php if($trip->start_date): ?>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Start Date')); ?></span>
                            <span class="info-item-value"><?php echo e($trip->start_date->format('d M Y, h:i A')); ?></span>
                        </div>
                        <?php endif; ?>
                        <?php if($trip->end_date): ?>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Expected End Date')); ?></span>
                            <span class="info-item-value"><?php echo e($trip->end_date->format('d M Y, h:i A')); ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                
                <?php if($trip->status === 'pending'): ?>
                <div class="detail-actions">
                    <a href="<?php echo e(route('admin.trips.edit', $trip)); ?>" class="btn-detail btn-detail-warning">
                        <i class="bi bi-pencil"></i>
                        <?php echo e(__('Edit Trip')); ?>

                    </a>
                    <form action="<?php echo e(route('admin.trips.destroy', $trip)); ?>" method="POST" class="d-inline" onsubmit="return confirm('<?php echo e(__('Are you sure you want to delete this trip?')); ?>')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn-detail btn-detail-danger">
                            <i class="bi bi-trash"></i>
                            <?php echo e(__('Delete Trip')); ?>

                        </button>
                    </form>
                    <a href="<?php echo e(route('admin.trips.index')); ?>" class="btn-detail btn-detail-outline">
                        <i class="bi bi-arrow-left"></i>
                        <?php echo e(__('Back to List')); ?>

                    </a>
                </div>
                <?php else: ?>
                <div class="detail-actions">
                    <a href="<?php echo e(route('admin.trips.index')); ?>" class="btn-detail btn-detail-outline">
                        <i class="bi bi-arrow-left"></i>
                        <?php echo e(__('Back to List')); ?>

                    </a>
                </div>
                <?php endif; ?>
            </div>

            
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon success">
                        <i class="bi bi-geo-alt"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Location Details')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="location-timeline">
                        
                        <div class="location-item pickup">
                            <div class="location-marker">
                                <i class="bi bi-geo-alt"></i>
                            </div>
                            <div class="location-content">
                                <h6 class="location-title"><?php echo e(__('Pickup Location')); ?></h6>
                                <p class="location-address"><?php echo e($trip->pickup_location); ?></p>
                            </div>
                        </div>

                        
                        <?php if($trip->has_multiple_locations): ?>
                            <div class="location-item multiple">
                                <div class="location-marker">
                                    <i class="bi bi-pin-map"></i>
                                </div>
                                <div class="location-content">
                                    <h6 class="location-title"><?php echo e(__('Multiple Drop Locations')); ?></h6>
                                    <p class="location-address text-muted"><?php echo e(__('This trip has multiple delivery points. See deliveries section below.')); ?></p>
                                </div>
                            </div>
                        <?php elseif($trip->drop_location): ?>
                            <div class="location-item drop">
                                <div class="location-marker">
                                    <i class="bi bi-geo-alt-fill"></i>
                                </div>
                                <div class="location-content">
                                    <h6 class="location-title"><?php echo e(__('Drop Location')); ?></h6>
                                    <p class="location-address"><?php echo e($trip->drop_location); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            
            <?php if($trip->trip_instructions): ?>
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon warning">
                        <i class="bi bi-card-text"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Trip Instructions')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="instructions-content">
                        <?php echo nl2br(e($trip->trip_instructions)); ?>

                    </div>
                </div>
            </div>
            <?php endif; ?>

            
            <?php if($trip->cost): ?>
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon info">
                        <i class="bi bi-currency-dollar"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Trip Cost')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Base Price')); ?></span>
                            <span class="info-item-value">$<?php echo e(number_format($trip->cost->base_price, 2)); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Per KM Rate')); ?></span>
                            <span class="info-item-value">$<?php echo e(number_format($trip->cost->per_km_rate, 2)); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Total Distance')); ?></span>
                            <span class="info-item-value"><?php echo e(number_format($trip->cost->total_distance, 2)); ?> km</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Additional Charges')); ?></span>
                            <span class="info-item-value">$<?php echo e(number_format($trip->cost->additional_charges, 2)); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Discount')); ?></span>
                            <span class="info-item-value text-danger">-$<?php echo e(number_format($trip->cost->discount, 2)); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Total Amount')); ?></span>
                            <span class="info-item-value highlight large">$<?php echo e(number_format($trip->cost->total_amount, 2)); ?></span>
                        </div>
                    </div>
                    <?php if($trip->cost->notes): ?>
                    <div class="mt-3">
                        <span class="info-item-label"><?php echo e(__('Notes')); ?></span>
                        <p class="mt-1"><?php echo e($trip->cost->notes); ?></p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>

            
            <?php if($trip->delivery): ?>
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon success">
                        <i class="bi bi-box-arrow-in-down"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Delivery Details')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Customer Name')); ?></span>
                            <span class="info-item-value"><?php echo e($trip->delivery->customer_name); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Customer Phone')); ?></span>
                            <span class="info-item-value"><?php echo e($trip->delivery->customer_phone ?? '-'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Delivery Address')); ?></span>
                            <span class="info-item-value"><?php echo e($trip->delivery->delivery_address); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Delivery Status')); ?></span>
                            <?php
                                $deliveryStatusClasses = [
                                    'pending' => 'pending',
                                    'delivered' => 'delivered',
                                    'failed' => 'cancelled'
                                ];
                            ?>
                            <span class="status-badge status-badge-<?php echo e($deliveryStatusClasses[$trip->delivery->delivery_status] ?? 'pending'); ?>">
                                <?php echo e(__(ucfirst($trip->delivery->delivery_status))); ?>

                            </span>
                        </div>
                        <?php if($trip->delivery->delivered_at): ?>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Delivered At')); ?></span>
                            <span class="info-item-value"><?php echo e($trip->delivery->delivered_at->format('d M Y, h:i A')); ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php if($trip->delivery->delivery_notes): ?>
                    <div class="mt-3">
                        <span class="info-item-label"><?php echo e(__('Delivery Notes')); ?></span>
                        <p class="mt-1"><?php echo e($trip->delivery->delivery_notes); ?></p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>

            
            <?php if($trip->files->count() > 0): ?>
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon secondary">
                        <i class="bi bi-paperclip"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Trip Files')); ?> (<?php echo e($trip->files->count()); ?>)</h5>
                </div>
                <div class="detail-card-body">
                    <div class="files-grid">
                        <?php $__currentLoopData = $trip->files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="file-item">
                            <div class="file-icon">
                                <?php if(Str::startsWith($file->file_type, 'image/')): ?>
                                    <i class="bi bi-file-image"></i>
                                <?php elseif($file->file_type === 'application/pdf'): ?>
                                    <i class="bi bi-file-pdf"></i>
                                <?php else: ?>
                                    <i class="bi bi-file-earmark"></i>
                                <?php endif; ?>
                            </div>
                            <div class="file-info">
                                <span class="file-name"><?php echo e($file->file_name); ?></span>
                                <span class="file-meta"><?php echo e($file->uploader->name ?? '-'); ?> · <?php echo e($file->created_at->format('d M Y')); ?></span>
                            </div>
                            <a href="<?php echo e(Storage::url($file->file_path)); ?>" target="_blank" class="file-action">
                                <i class="bi bi-download"></i>
                            </a>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>

        
        <div class="col-lg-4">
            
            <?php if($trip->vehicle): ?>
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon primary">
                        <i class="bi bi-truck"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Vehicle')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="entity-card">
                        <div class="entity-card-avatar primary">
                            <i class="bi bi-truck-front"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-title"><?php echo e($trip->vehicle->vehicle_number); ?></h6>
                            <p class="entity-card-subtitle"><?php echo e($trip->vehicle->vehicleType->name ?? '-'); ?></p>
                        </div>
                    </div>
                    <div class="data-list mt-3">
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-speedometer2"></i>
                                <?php echo e(__('Capacity')); ?>

                            </span>
                            <span class="data-list-item-value"><?php echo e($trip->vehicle->vehicleType->capacity ?? '-'); ?></span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-circle-fill"></i>
                                <?php echo e(__('Status')); ?>

                            </span>
                            <span class="data-list-item-value">
                                <span class="status-badge status-badge-<?php echo e($trip->vehicle->status === 'active' ? 'success' : 'secondary'); ?>" style="font-size: 0.75rem;">
                                    <?php echo e(__(ucfirst($trip->vehicle->status))); ?>

                                </span>
                            </span>
                        </div>
                    </div>
                    
                </div>
            </div>
            <?php endif; ?>

            
            <?php if($trip->driver): ?>
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon info">
                        <i class="bi bi-person"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Driver')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="entity-card">
                        <div class="entity-card-avatar info">
                            <i class="bi bi-person-fill"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-title"><?php echo e($trip->driver->name); ?></h6>
                            <p class="entity-card-subtitle"><?php echo e($trip->driver->mobile); ?></p>
                        </div>
                    </div>
                    <div class="data-list mt-3">
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-card-text"></i>
                                <?php echo e(__('License')); ?>

                            </span>
                            <span class="data-list-item-value"><?php echo e($trip->driver->license_number); ?></span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-truck"></i>
                                <?php echo e(__('Driver Type')); ?>

                            </span>
                            <span class="data-list-item-value">
                                <?php if($trip->driver->driver_type === 'own_vehicle'): ?>
                                    <span class="status-badge status-badge-info" style="font-size: 0.75rem;"><?php echo e(__('Own Vehicle')); ?></span>
                                <?php else: ?>
                                    <span class="status-badge status-badge-secondary" style="font-size: 0.75rem;"><?php echo e(__('Driver Only')); ?></span>
                                <?php endif; ?>
                            </span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-circle-fill"></i>
                                <?php echo e(__('Status')); ?>

                            </span>
                            <span class="data-list-item-value">
                                <?php
                                    $driverStatusColors = [
                                        'active' => 'success',
                                        'on_trip' => 'info',
                                        'inactive' => 'secondary'
                                    ];
                                ?>
                                <span class="status-badge status-badge-<?php echo e($driverStatusColors[$trip->driver->status] ?? 'secondary'); ?>" style="font-size: 0.75rem;">
                                    <?php echo e(__(ucfirst(str_replace('_', ' ', $trip->driver->status)))); ?>

                                </span>
                            </span>
                        </div>
                    </div>
                   
                </div>
            </div>
            <?php endif; ?>

            
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon secondary">
                        <i class="bi bi-clock-history"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Activity')); ?></h5>
                </div>
                <div class="detail-card-body">
                    
                    <?php if($trip->creator): ?>
                    <div class="entity-card mb-3">
                        <div class="entity-card-avatar secondary">
                            <i class="bi bi-person"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-title"><?php echo e($trip->creator->name); ?></h6>
                            <p class="entity-card-subtitle"><?php echo e(__('Created By')); ?></p>
                        </div>
                    </div>
                    <?php endif; ?>

                    
                    <div class="detail-timeline">
                        <div class="timeline-item">
                            <div class="timeline-marker primary">
                                <i class="bi bi-plus"></i>
                            </div>
                            <div class="timeline-content">
                                <h6 class="timeline-title"><?php echo e(__('Trip Created')); ?></h6>
                                <p class="timeline-time"><?php echo e($trip->created_at->format('M d, Y \a\t h:i A')); ?></p>
                            </div>
                        </div>

                        <?php if($trip->status !== 'pending'): ?>
                        <div class="timeline-item">
                            <div class="timeline-marker info">
                                <i class="bi bi-check"></i>
                            </div>
                            <div class="timeline-content">
                                <h6 class="timeline-title"><?php echo e(__('Status Updated')); ?></h6>
                                <p class="timeline-time"><?php echo e(__('Changed to')); ?> <?php echo e(__(ucfirst(str_replace('_', ' ', $trip->status)))); ?></p>
                            </div>
                        </div>
                        <?php endif; ?>

                        <div class="timeline-item">
                            <div class="timeline-marker secondary">
                                <i class="bi bi-pencil"></i>
                            </div>
                            <div class="timeline-content">
                                <h6 class="timeline-title"><?php echo e(__('Last Updated')); ?></h6>
                                <p class="timeline-time"><?php echo e($trip->updated_at->format('M d, Y \a\t h:i A')); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon warning">
                        <i class="bi bi-lightning"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Quick Actions')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="quick-actions-list">
                        <?php if(!$trip->cost): ?>
                        <a href="<?php echo e(route('admin.costs.create')); ?>?trip_id=<?php echo e($trip->id); ?>" class="quick-action-item">
                            <div class="quick-action-icon primary">
                                <i class="bi bi-currency-dollar"></i>
                            </div>
                            <div class="quick-action-content">
                                <span class="quick-action-title"><?php echo e(__('Add Trip Cost')); ?></span>
                                <span class="quick-action-desc"><?php echo e(__('Set pricing for this trip')); ?></span>
                            </div>
                            <i class="bi bi-chevron-right"></i>
                        </a>
                        <?php endif; ?>

                        <?php if(!$trip->delivery && $trip->status !== 'pending'): ?>
                        <a href="<?php echo e(route('admin.deliveries.create')); ?>?trip_id=<?php echo e($trip->id); ?>" class="quick-action-item">
                            <div class="quick-action-icon success">
                                <i class="bi bi-box-arrow-in-down"></i>
                            </div>
                            <div class="quick-action-content">
                                <span class="quick-action-title"><?php echo e(__('Add Delivery')); ?></span>
                                <span class="quick-action-desc"><?php echo e(__('Record delivery details')); ?></span>
                            </div>
                            <i class="bi bi-chevron-right"></i>
                        </a>
                        <?php endif; ?>

                        <?php if($trip->shipment): ?>
                        <a href="<?php echo e(route('admin.shipments.show', $trip->shipment)); ?>" class="quick-action-item">
                            <div class="quick-action-icon info">
                                <i class="bi bi-box-seam"></i>
                            </div>
                            <div class="quick-action-content">
                                <span class="quick-action-title"><?php echo e(__('View Shipment')); ?></span>
                                <span class="quick-action-desc"><?php echo e($trip->shipment->shipment_number); ?></span>
                            </div>
                            <i class="bi bi-chevron-right"></i>
                        </a>
                        <?php endif; ?>

                        <a href="<?php echo e(route('admin.trips.index')); ?>" class="quick-action-item">
                            <div class="quick-action-icon secondary">
                                <i class="bi bi-list-ul"></i>
                            </div>
                            <div class="quick-action-content">
                                <span class="quick-action-title"><?php echo e(__('All Trips')); ?></span>
                                <span class="quick-action-desc"><?php echo e(__('View all trips')); ?></span>
                            </div>
                            <i class="bi bi-chevron-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* Location Timeline Styles */
.location-timeline {
    position: relative;
    padding-left: 30px;
}

.location-timeline::before {
    content: '';
    position: absolute;
    left: 11px;
    top: 24px;
    bottom: 24px;
    width: 2px;
    background: linear-gradient(to bottom, var(--success-color), var(--danger-color));
    border-radius: 2px;
}

.location-item {
    position: relative;
    padding: 15px 0;
}

.location-item:first-child {
    padding-top: 0;
}

.location-item:last-child {
    padding-bottom: 0;
}

.location-marker {
    position: absolute;
    left: -30px;
    top: 50%;
    transform: translateY(-50%);
    width: 24px;
    height: 24px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 12px;
    color: white;
    z-index: 1;
}

.location-item.pickup .location-marker {
    background: var(--success-color);
}

.location-item.drop .location-marker {
    background: var(--danger-color);
}

.location-item.multiple .location-marker {
    background: var(--info-color);
}

.location-content {
    background: var(--body-bg);
    border: 1px solid var(--border-color);
    border-radius: 10px;
    padding: 15px;
}

.location-title {
    font-size: 0.85rem;
    font-weight: 600;
    color: var(--text-secondary);
    margin: 0 0 5px 0;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.location-address {
    font-size: 0.95rem;
    color: var(--text-primary);
    margin: 0;
    line-height: 1.5;
}

/* Instructions Content */
.instructions-content {
    background: var(--body-bg);
    border: 1px solid var(--border-color);
    border-radius: 10px;
    padding: 15px;
    color: var(--text-primary);
    line-height: 1.6;
}

/* Files Grid */
.files-grid {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.file-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 12px;
    background: var(--body-bg);
    border: 1px solid var(--border-color);
    border-radius: 10px;
    transition: all 0.2s ease;
}

.file-item:hover {
    border-color: var(--primary-color);
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}

.file-icon {
    width: 40px;
    height: 40px;
    background: var(--primary-light);
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--primary-color);
    font-size: 1.2rem;
    flex-shrink: 0;
}

.file-info {
    flex: 1;
    min-width: 0;
}

.file-name {
    display: block;
    font-weight: 500;
    color: var(--text-primary);
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.file-meta {
    font-size: 0.8rem;
    color: var(--text-muted);
}

.file-action {
    width: 36px;
    height: 36px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 8px;
    color: var(--primary-color);
    transition: all 0.2s ease;
}

.file-action:hover {
    background: var(--primary-light);
}

/* Quick Actions List */
.quick-actions-list {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.quick-action-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 12px;
    background: var(--body-bg);
    border: 1px solid var(--border-color);
    border-radius: 10px;
    text-decoration: none;
    transition: all 0.2s ease;
}

.quick-action-item:hover {
    border-color: var(--primary-color);
    transform: translateX(5px);
}

.quick-action-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.1rem;
    flex-shrink: 0;
}

.quick-action-icon.primary {
    background: var(--primary-light);
    color: var(--primary-color);
}

.quick-action-icon.success {
    background: rgba(16, 185, 129, 0.1);
    color: var(--success-color);
}

.quick-action-icon.info {
    background: rgba(59, 130, 246, 0.1);
    color: var(--info-color);
}

.quick-action-icon.warning {
    background: rgba(245, 158, 11, 0.1);
    color: var(--warning-color);
}

.quick-action-icon.secondary {
    background: var(--body-bg);
    color: var(--text-secondary);
    border: 1px solid var(--border-color);
}

.quick-action-content {
    flex: 1;
    min-width: 0;
}

.quick-action-title {
    display: block;
    font-weight: 500;
    color: var(--text-primary);
}

.quick-action-desc {
    display: block;
    font-size: 0.8rem;
    color: var(--text-muted);
}

.quick-action-item > .bi-chevron-right {
    color: var(--text-muted);
    font-size: 0.9rem;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\fleet-management\resources\views/admin/trips/show.blade.php ENDPATH**/ ?>