<?php $__env->startSection('title', $report->report_number . ' - ' . __('Report Details')); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/admindetailpage.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    
    <div class="page-header">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.reports.index')); ?>"><?php echo e(__('Reports')); ?></a></li>
                    <li class="breadcrumb-item active"><?php echo e($report->report_number); ?></li>
                </ol>
            </nav>
        </div>
    </div>

    
    <?php if(session('success')): ?>
        <div class="detail-alert detail-alert-info">
            <div class="detail-alert-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title"><?php echo e(__('Success')); ?></div>
                <div class="detail-alert-text"><?php echo e(session('success')); ?></div>
            </div>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="detail-alert detail-alert-warning">
            <div class="detail-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title"><?php echo e(__('Error')); ?></div>
                <div class="detail-alert-text"><?php echo e(session('error')); ?></div>
            </div>
        </div>
    <?php endif; ?>

    <?php if(session('info')): ?>
        <div class="detail-alert detail-alert-info">
            <div class="detail-alert-icon">
                <i class="bi bi-info-circle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title"><?php echo e(__('Info')); ?></div>
                <div class="detail-alert-text"><?php echo e(session('info')); ?></div>
            </div>
        </div>
    <?php endif; ?>

    <?php
        $statusClasses = [
            'draft' => 'pending',
            'generating' => 'assigned',
            'completed' => 'delivered',
            'failed' => 'cancelled',
            'scheduled' => 'in-transit',
        ];
        $typeClasses = [
            'fuel_consumption' => 'warning',
            'trip_summary' => 'primary',
            'vehicle_utilization' => 'info',
            'driver_performance' => 'success',
            'cost_analysis' => 'danger',
            'delivery_performance' => 'secondary',
            'custom' => 'dark',
        ];
        $typeIcons = [
            'fuel_consumption' => 'fuel-pump',
            'trip_summary' => 'geo-alt',
            'vehicle_utilization' => 'truck',
            'driver_performance' => 'person-badge',
            'cost_analysis' => 'currency-dollar',
            'delivery_performance' => 'box-seam',
            'custom' => 'file-earmark',
        ];
    ?>

    
    <div class="detail-hero">
        <div class="detail-hero-header">
            <div class="detail-hero-content">
                <div class="detail-hero-icon">
                    <i class="bi bi-file-earmark-bar-graph"></i>
                </div>
                <div class="detail-hero-info">
                    <h1 class="detail-hero-title"><?php echo e($report->report_number); ?></h1>
                    <p class="detail-hero-subtitle"><?php echo e($report->title); ?> · <?php echo e(__('Created')); ?> <?php echo e($report->created_at->format('M d, Y')); ?></p>
                    <div class="detail-hero-badges">
                        <span class="status-badge status-badge-<?php echo e($statusClasses[$report->status] ?? 'pending'); ?>">
                            <i class="bi bi-<?php echo e($report->status === 'completed' ? 'check-circle' : ($report->status === 'failed' ? 'x-circle' : 'clock')); ?>"></i>
                            <?php echo e(__(ucfirst($report->status))); ?>

                        </span>
                        <span class="status-badge status-badge-<?php echo e($typeClasses[$report->report_type] ?? 'secondary'); ?>">
                            <i class="bi bi-<?php echo e($typeIcons[$report->report_type] ?? 'file-earmark'); ?>"></i>
                            <?php echo e(__(ucwords(str_replace('_', ' ', $report->report_type)))); ?>

                        </span>
                        <?php if($report->is_scheduled): ?>
                        <span class="status-badge status-badge-in-transit">
                            <i class="bi bi-arrow-repeat"></i>
                            <?php echo e(__(ucfirst($report->schedule_frequency))); ?>

                        </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="detail-actions">
                <?php if($report->status === 'completed' && auth()->user()->hasPermission('reports.export')): ?>
                <a href="<?php echo e(route('admin.reports.download', $report)); ?>" class="btn-detail btn-detail-success">
                    <i class="bi bi-download"></i>
                    <?php echo e(__('Download')); ?>

                </a>
                <?php endif; ?>
                <?php if(in_array($report->status, ['draft', 'completed', 'failed']) && auth()->user()->hasPermission('reports.edit')): ?>
                <form action="<?php echo e(route('admin.reports.generate', $report)); ?>" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn-detail btn-detail-primary">
                        <i class="bi bi-play-fill"></i>
                        <?php echo e($report->status === 'completed' ? __('Regenerate') : __('Generate')); ?>

                    </button>
                </form>
                <?php endif; ?>
                <?php if(in_array($report->status, ['draft', 'failed']) && auth()->user()->hasPermission('reports.edit')): ?>
                <a href="<?php echo e(route('admin.reports.edit', $report)); ?>" class="btn-detail btn-detail-warning">
                    <i class="bi bi-pencil"></i>
                    <?php echo e(__('Edit')); ?>

                </a>
                <?php endif; ?>
                <a href="<?php echo e(route('admin.reports.index')); ?>" class="btn-detail btn-detail-outline">
                    <i class="bi bi-arrow-left"></i>
                    <?php echo e(__('Back to List')); ?>

                </a>
            </div>
        </div>
        <div class="detail-hero-body">
            <div class="hero-stat">
                <div class="hero-stat-value"><?php echo e(strtoupper($report->format)); ?></div>
                <div class="hero-stat-label"><?php echo e(__('Format')); ?></div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value"><?php echo e($report->date_range); ?></div>
                <div class="hero-stat-label"><?php echo e(__('Date Range')); ?></div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value"><?php echo e($report->generated_at ? $report->generated_at->format('M d') : '-'); ?></div>
                <div class="hero-stat-label"><?php echo e(__('Generated')); ?></div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value"><?php echo e($report->formatted_file_size); ?></div>
                <div class="hero-stat-label"><?php echo e(__('File Size')); ?></div>
            </div>
        </div>
    </div>

    
    <?php if($report->status === 'failed' && $report->error_message): ?>
    <div class="detail-alert detail-alert-warning mb-4">
        <div class="detail-alert-icon">
            <i class="bi bi-exclamation-triangle"></i>
        </div>
        <div class="detail-alert-content">
            <div class="detail-alert-title"><?php echo e(__('Report Generation Failed')); ?></div>
            <div class="detail-alert-text"><?php echo e($report->error_message); ?></div>
        </div>
    </div>
    <?php endif; ?>

    <div class="row">
        
        <div class="col-lg-8">
            
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon primary">
                        <i class="bi bi-gear"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Report Configuration')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Report Number')); ?></span>
                            <span class="info-item-value highlight"><?php echo e($report->report_number); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Title')); ?></span>
                            <span class="info-item-value"><?php echo e($report->title); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Report Type')); ?></span>
                            <span class="info-item-value">
                                <span class="badge bg-<?php echo e($typeClasses[$report->report_type] ?? 'secondary'); ?>">
                                    <i class="bi bi-<?php echo e($typeIcons[$report->report_type] ?? 'file-earmark'); ?> me-1"></i>
                                    <?php echo e(__(ucwords(str_replace('_', ' ', $report->report_type)))); ?>

                                </span>
                            </span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Output Format')); ?></span>
                            <span class="info-item-value"><?php echo e(strtoupper($report->format)); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Date From')); ?></span>
                            <span class="info-item-value"><?php echo e($report->date_from ? $report->date_from->format('M d, Y') : __('All Time')); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Date To')); ?></span>
                            <span class="info-item-value"><?php echo e($report->date_to ? $report->date_to->format('M d, Y') : __('Present')); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            
            <?php if($report->vehicle || $report->driver || $report->vehicleType): ?>
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon info">
                        <i class="bi bi-funnel"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Filters Applied')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        <?php if($report->vehicle): ?>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Vehicle')); ?></span>
                            <span class="info-item-value"><?php echo e($report->vehicle->vehicle_number); ?></span>
                        </div>
                        <?php endif; ?>
                        <?php if($report->driver): ?>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Driver')); ?></span>
                            <span class="info-item-value"><?php echo e($report->driver->name); ?></span>
                        </div>
                        <?php endif; ?>
                        <?php if($report->vehicleType): ?>
                        <div class="info-item">
                            <span class="info-item-label"><?php echo e(__('Vehicle Type')); ?></span>
                            <span class="info-item-value"><?php echo e($report->vehicleType->name); ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            
            <?php if($report->status === 'completed' && $reportData): ?>
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon success">
                        <i class="bi bi-bar-chart"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Report Summary')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <?php if(isset($reportData['summary'])): ?>
                    <div class="row g-3 mb-4">
                        <?php $__currentLoopData = $reportData['summary']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4 col-lg-3">
                            <div class="summary-stat-card">
                                <div class="summary-stat-value">
                                    <?php if(is_numeric($value)): ?>
                                        <?php if(str_contains($key, 'cost') || str_contains($key, 'total')): ?>
                                            $<?php echo e(number_format($value, 2)); ?>

                                        <?php elseif(str_contains($key, 'rate') || str_contains($key, 'efficiency')): ?>
                                            <?php echo e(number_format($value, 1)); ?>%
                                        <?php else: ?>
                                            <?php echo e(number_format($value, is_float($value) ? 2 : 0)); ?>

                                        <?php endif; ?>
                                    <?php else: ?>
                                        <?php echo e($value); ?>

                                    <?php endif; ?>
                                </div>
                                <div class="summary-stat-label"><?php echo e(__(ucwords(str_replace('_', ' ', $key)))); ?></div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php endif; ?>

                    
                    <?php if(isset($reportData['by_vehicle']) && count($reportData['by_vehicle']) > 0): ?>
                    <h6 class="mb-3"><i class="bi bi-truck me-2"></i><?php echo e(__('By Vehicle')); ?></h6>
                    <div class="table-responsive mb-4">
                        <table class="table table-sm table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th><?php echo e(__('Vehicle')); ?></th>
                                    <?php if(isset($reportData['by_vehicle'][0]['total_quantity'])): ?>
                                    <th class="text-end"><?php echo e(__('Quantity')); ?></th>
                                    <?php endif; ?>
                                    <?php if(isset($reportData['by_vehicle'][0]['total_cost'])): ?>
                                    <th class="text-end"><?php echo e(__('Cost')); ?></th>
                                    <?php endif; ?>
                                    <?php if(isset($reportData['by_vehicle'][0]['trip_count'])): ?>
                                    <th class="text-end"><?php echo e(__('Trips')); ?></th>
                                    <?php endif; ?>
                                    <?php if(isset($reportData['by_vehicle'][0]['avg_efficiency'])): ?>
                                    <th class="text-end"><?php echo e(__('Avg km/L')); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $reportData['by_vehicle']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($item['vehicle'] ?? '-'); ?></td>
                                    <?php if(isset($item['total_quantity'])): ?>
                                    <td class="text-end"><?php echo e(number_format($item['total_quantity'], 2)); ?> L</td>
                                    <?php endif; ?>
                                    <?php if(isset($item['total_cost'])): ?>
                                    <td class="text-end text-success">$<?php echo e(number_format($item['total_cost'], 2)); ?></td>
                                    <?php endif; ?>
                                    <?php if(isset($item['trip_count'])): ?>
                                    <td class="text-end"><?php echo e($item['trip_count']); ?></td>
                                    <?php endif; ?>
                                    <?php if(isset($item['avg_efficiency'])): ?>
                                    <td class="text-end"><?php echo e($item['avg_efficiency'] ? number_format($item['avg_efficiency'], 2) : '-'); ?></td>
                                    <?php endif; ?>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php endif; ?>

                    <?php if(isset($reportData['by_status']) && count($reportData['by_status']) > 0): ?>
                    <h6 class="mb-3"><i class="bi bi-pie-chart me-2"></i><?php echo e(__('By Status')); ?></h6>
                    <div class="table-responsive mb-4">
                        <table class="table table-sm table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <th class="text-end"><?php echo e(__('Count')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $reportData['by_status']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($item['status'] ?? '-'); ?></td>
                                    <td class="text-end"><?php echo e($item['count'] ?? 0); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php endif; ?>

                    <?php if(isset($reportData['drivers']) && count($reportData['drivers']) > 0): ?>
                    <h6 class="mb-3"><i class="bi bi-people me-2"></i><?php echo e(__('Driver Performance')); ?></h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th><?php echo e(__('Driver')); ?></th>
                                    <th class="text-end"><?php echo e(__('Trips')); ?></th>
                                    <th class="text-end"><?php echo e(__('Completed')); ?></th>
                                    <th class="text-end"><?php echo e(__('Rate')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $reportData['drivers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($driver['name'] ?? '-'); ?></td>
                                    <td class="text-end"><?php echo e($driver['total_trips'] ?? 0); ?></td>
                                    <td class="text-end"><?php echo e($driver['completed_trips'] ?? 0); ?></td>
                                    <td class="text-end">
                                        <span class="badge bg-<?php echo e(($driver['completion_rate'] ?? 0) >= 80 ? 'success' : (($driver['completion_rate'] ?? 0) >= 50 ? 'warning' : 'danger')); ?>">
                                            <?php echo e($driver['completion_rate'] ?? 0); ?>%
                                        </span>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>

            
            <?php if($report->description): ?>
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon secondary">
                        <i class="bi bi-journal-text"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Description')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <p class="mb-0"><?php echo e($report->description); ?></p>
                </div>
            </div>
            <?php endif; ?>
        </div>

        
        <div class="col-lg-4">
            
            <?php if($report->is_scheduled): ?>
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon warning">
                        <i class="bi bi-calendar-check"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Schedule')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <div class="data-list">
                        <div class="data-list-item">
                            <span class="data-list-item-label"><?php echo e(__('Frequency')); ?></span>
                            <span class="data-list-item-value"><?php echo e(__(ucfirst($report->schedule_frequency))); ?></span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label"><?php echo e(__('Next Run')); ?></span>
                            <span class="data-list-item-value">
                                <?php echo e($report->next_run_at ? $report->next_run_at->format('M d, Y h:i A') : '-'); ?>

                            </span>
                        </div>
                        <?php if($report->last_run_at): ?>
                        <div class="data-list-item">
                            <span class="data-list-item-label"><?php echo e(__('Last Run')); ?></span>
                            <span class="data-list-item-value"><?php echo e($report->last_run_at->format('M d, Y h:i A')); ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon secondary">
                        <i class="bi bi-clock-history"></i>
                    </div>
                    <h5 class="detail-card-title"><?php echo e(__('Activity')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <?php if($report->creator): ?>
                    <div class="entity-card mb-3">
                        <div class="entity-card-avatar secondary">
                            <i class="bi bi-person-badge"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-name"><?php echo e($report->creator->name); ?></h6>
                            <p class="entity-card-subtitle"><?php echo e(__('Created by')); ?></p>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="detail-timeline">
                        <div class="timeline-item">
                            <div class="timeline-marker success"></div>
                            <div class="timeline-content">
                                <div class="timeline-title"><?php echo e(__('Created')); ?></div>
                                <div class="timeline-date"><?php echo e($report->created_at->format('M d, Y h:i A')); ?></div>
                            </div>
                        </div>
                        <?php if($report->generated_at): ?>
                        <div class="timeline-item">
                            <div class="timeline-marker info"></div>
                            <div class="timeline-content">
                                <div class="timeline-title"><?php echo e(__('Generated')); ?></div>
                                <div class="timeline-date"><?php echo e($report->generated_at->format('M d, Y h:i A')); ?></div>
                            </div>
                        </div>
                        <?php endif; ?>
                        <?php if($report->updated_at != $report->created_at): ?>
                        <div class="timeline-item">
                            <div class="timeline-marker warning"></div>
                            <div class="timeline-content">
                                <div class="timeline-title"><?php echo e(__('Last Updated')); ?></div>
                                <div class="timeline-date"><?php echo e($report->updated_at->format('M d, Y h:i A')); ?></div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            
            <?php if(auth()->user()->hasPermission('reports.delete')): ?>
            <div class="detail-card border-danger">
                <div class="detail-card-header bg-danger bg-opacity-10">
                    <div class="detail-card-header-icon" style="background: rgba(220, 53, 69, 0.1); color: #dc3545;">
                        <i class="bi bi-exclamation-triangle"></i>
                    </div>
                    <h5 class="detail-card-title text-danger"><?php echo e(__('Danger Zone')); ?></h5>
                </div>
                <div class="detail-card-body">
                    <p class="text-muted small mb-3"><?php echo e(__('Once you delete this report, there is no going back. Please be certain.')); ?></p>
                    <form action="<?php echo e(route('admin.reports.destroy', $report)); ?>" method="POST"
                          onsubmit="return confirm('<?php echo e(__('Are you sure you want to delete this report?')); ?>')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="bi bi-trash me-1"></i>
                            <?php echo e(__('Delete Report')); ?>

                        </button>
                    </form>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
.summary-stat-card {
    background: var(--body-bg);
    border: 1px solid var(--border-color);
    border-radius: 12px;
    padding: 1rem;
    text-align: center;
}

.summary-stat-value {
    font-size: 1.5rem;
    font-weight: 700;
    color: var(--text-primary);
    line-height: 1.2;
}

.summary-stat-label {
    font-size: 0.75rem;
    color: var(--text-secondary);
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-top: 0.25rem;
}
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel\fleet-management\resources\views/admin/reports/show.blade.php ENDPATH**/ ?>