@extends('layouts.app')

@section('title', __('dashboard') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/dashboard.css') }}">
@endpush

@section('content')
<!-- Premium Dashboard Header -->
<div class="dashboard-header">
    <div class="dashboard-header-content">
        <div class="dashboard-welcome">
            <p class="greeting">{{ __('welcome_back') }}</p>
            <h1>{{ auth()->user()->name }}</h1>
            <p class="date-time">
                <i class="bi bi-calendar3"></i>
                <span id="currentDateTime">{{ now()->format('l, F j, Y') }}</span>
            </p>
        </div>
        <div class="dashboard-actions">
            <a href="{{ route('admin.trips.create') }}" class="btn">
                <i class="bi bi-plus-lg"></i> {{ __('new_trip') }}
            </a>
            <a href="{{ route('admin.tracking.index') }}" class="btn">
                <i class="bi bi-geo-alt"></i> {{ __('live_tracking') }}
            </a>
        </div>
    </div>
</div>

<!-- Premium Stats Cards -->
<div class="stats-grid">
    <!-- Total Vehicles Card -->
    <div class="stat-card vehicles hover-lift">
        <div class="stat-card-header">
            <div class="stat-icon">
                <i class="bi bi-truck-front"></i>
            </div>
            <span class="stat-trend up">
                <i class="bi bi-arrow-up"></i> 12%
            </span>
        </div>
        <div class="stat-card-body">
            <h3 class="counter-animate">{{ $totalVehicles }}</h3>
            <p>{{ __('total_vehicles') }}</p>
        </div>
        <div class="stat-card-footer">
            <div class="stat-progress">
                <div class="stat-progress-bar" style="width: {{ min(($totalVehicles / max($totalVehicles + 10, 1)) * 100, 100) }}%"></div>
            </div>
            <div class="stat-progress-label">
                <span>{{ __('active_fleet') }}</span>
                <span>{{ $totalVehicles }} {{ __('units') }}</span>
            </div>
        </div>
    </div>

    <!-- Active Drivers Card -->
    <div class="stat-card drivers hover-lift">
        <div class="stat-card-header">
            <div class="stat-icon">
                <i class="bi bi-person-badge"></i>
            </div>
            <span class="stat-trend up">
                <i class="bi bi-arrow-up"></i> 8%
            </span>
        </div>
        <div class="stat-card-body">
            <h3 class="counter-animate">{{ $activeDrivers }}</h3>
            <p>{{ __('active_drivers') }}</p>
        </div>
        <div class="stat-card-footer">
            <div class="stat-progress">
                <div class="stat-progress-bar" style="width: {{ min(($activeDrivers / max($activeDrivers + 5, 1)) * 100, 100) }}%"></div>
            </div>
            <div class="stat-progress-label">
                <span>{{ __('on_duty') }}</span>
                <span>{{ $activeDrivers }} {{ __('drivers') }}</span>
            </div>
        </div>
    </div>

    <!-- Active Trips Card -->
    <div class="stat-card trips hover-lift">
        <div class="stat-card-header">
            <div class="stat-icon">
                <i class="bi bi-geo-alt"></i>
            </div>
            <span class="stat-trend neutral">
                <span class="pulse-dot active"></span> {{ __('live') }}
            </span>
        </div>
        <div class="stat-card-body">
            <h3 class="counter-animate">{{ $activeTrips }}</h3>
            <p>{{ __('active_trips') }}</p>
        </div>
        <div class="stat-card-footer">
            <div class="stat-progress">
                <div class="stat-progress-bar" style="width: {{ $activeTrips > 0 ? 65 : 0 }}%"></div>
            </div>
            <div class="stat-progress-label">
                <span>{{ __('in_progress') }}</span>
                <span>{{ $activeTrips }} {{ __('trips') }}</span>
            </div>
        </div>
    </div>

    <!-- Deliveries This Month Card -->
    <div class="stat-card deliveries hover-lift">
        <div class="stat-card-header">
            <div class="stat-icon">
                <i class="bi bi-clipboard-check"></i>
            </div>
            <span class="stat-trend up">
                <i class="bi bi-arrow-up"></i> 24%
            </span>
        </div>
        <div class="stat-card-body">
            <h3 class="counter-animate">{{ $deliveriesThisMonth }}</h3>
            <p>{{ __('deliveries_month') }}</p>
        </div>
        <div class="stat-card-footer">
            <div class="stat-progress">
                <div class="stat-progress-bar" style="width: {{ min(($deliveriesThisMonth / max($deliveriesThisMonth + 20, 1)) * 100, 100) }}%"></div>
            </div>
            <div class="stat-progress-label">
                <span>{{ __('this_month') }}</span>
                <span>{{ $deliveriesThisMonth }} {{ __('completed') }}</span>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row - Revenue & Trip Distribution -->
<div class="charts-row">
    <!-- Revenue & Trip Count Trend Chart -->
    <div class="chart-card hover-lift">
        <div class="chart-card-header">
            <h5><i class="bi bi-graph-up-arrow"></i> {{ __('revenue_trip_trend') }}</h5>
            <div class="chart-actions">
                <button class="btn btn-sm btn-outline-secondary" data-period="month">{{ __('month') }}</button>
                <button class="btn btn-sm btn-primary" data-period="year">{{ __('year') }}</button>
            </div>
        </div>
        <div class="chart-card-body">
            <div class="chart-container">
                <canvas id="revenueTrendChart"></canvas>
            </div>
        </div>
    </div>

    <!-- Trip Status Distribution Chart -->
    <div class="chart-card hover-lift">
        <div class="chart-card-header">
            <h5><i class="bi bi-pie-chart"></i> {{ __('trip_distribution') }}</h5>
        </div>
        <div class="chart-card-body">
            <div class="chart-container">
                <canvas id="tripDistributionChart"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row - Cost & Vehicle Type -->
<div class="charts-row-equal">
    <!-- Cost Breakdown Chart -->
    <div class="chart-card hover-lift">
        <div class="chart-card-header">
            <h5><i class="bi bi-wallet2"></i> {{ __('cost_breakdown') }}</h5>
        </div>
        <div class="chart-card-body">
            <div class="chart-container chart-container-sm">
                <canvas id="costBreakdownChart"></canvas>
            </div>
        </div>
    </div>

    <!-- Vehicle Type Distribution Chart -->
    <div class="chart-card hover-lift">
        <div class="chart-card-header">
            <h5><i class="bi bi-bar-chart"></i> {{ __('vehicle_type_distribution') }}</h5>
        </div>
        <div class="chart-card-body">
            <div class="chart-container chart-container-sm">
                <canvas id="vehicleTypeChart"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Recent Trips Section -->
<div class="recent-trips-card hover-lift">
    <div class="recent-trips-header">
        <h5><i class="bi bi-clock-history"></i> {{ __('recent_trips') }}</h5>
        <a href="{{ route('admin.trips.index') }}" class="view-all-btn">
            {{ __('view_all') }} <i class="bi bi-arrow-right"></i>
        </a>
    </div>
    <div class="recent-trips-body">
        @if($recentTrips->count() > 0)
        <div class="table-responsive">
            <table class="dashboard-table">
                <thead>
                    <tr>
                        <th>{{ __('trip_number') }}</th>
                        <th>{{ __('vehicle') }}</th>
                        <th>{{ __('driver') }}</th>
                        <th>{{ __('shipment_reference') }}</th>
                        <th>{{ __('status') }}</th>
                        <th>{{ __('actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($recentTrips as $trip)
                    <tr>
                        <td>
                            <span class="trip-number">
                                <i class="bi bi-hash"></i>
                                {{ $trip->trip_number }}
                            </span>
                        </td>
                        <td>
                            <div class="vehicle-info">
                                <div class="vehicle-avatar">
                                    <i class="bi bi-truck"></i>
                                </div>
                                <div class="vehicle-details">
                                    <span class="vehicle-number">{{ $trip->vehicle->vehicle_number }}</span>
                                    <span class="vehicle-type">{{ $trip->vehicle->vehicleType->name ?? '-' }}</span>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div class="driver-info">
                                <div class="driver-avatar">
                                    {{ strtoupper(substr($trip->driver->name, 0, 2)) }}
                                </div>
                                <div class="driver-details">
                                    <span class="driver-name">{{ $trip->driver->name }}</span>
                                    <span class="driver-phone">{{ $trip->driver->phone ?? '-' }}</span>
                                </div>
                            </div>
                        </td>
                        <td>
                            @if($trip->shipment_reference)
                                <span class="shipment-ref">{{ $trip->shipment_reference }}</span>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            <span class="status-badge {{ $trip->status }}">
                                @if($trip->status === 'in_transit')
                                    <span class="pulse-dot active"></span>
                                @else
                                    <i class="bi bi-circle-fill"></i>
                                @endif
                                {{ __($trip->status) }}
                            </span>
                        </td>
                        <td>
                            <a href="{{ route('admin.trips.show', $trip) }}" class="action-btn view">
                                <i class="bi bi-eye"></i> {{ __('view') }}
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <div class="no-records">
            <div class="no-records-icon">
                <i class="bi bi-inbox"></i>
            </div>
            <h6>{{ __('no_trips_yet') }}</h6>
            <p>{{ __('create_first_trip_message') }}</p>
        </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<script>
    // Premium Chart Colors with Gradients
    const chartColors = {
        primary: '#f97316',
        primaryLight: 'rgba(249, 115, 22, 0.1)',
        success: '#10b981',
        successLight: 'rgba(16, 185, 129, 0.1)',
        warning: '#f59e0b',
        warningLight: 'rgba(245, 158, 11, 0.1)',
        danger: '#ef4444',
        info: '#06b6d4',
        purple: '#8b5cf6',
        pink: '#ec4899',
        orange: '#f97316',
        teal: '#14b8a6'
    };

    // Create gradient for Revenue Chart
    function createGradient(ctx, color1, color2) {
        const gradient = ctx.createLinearGradient(0, 0, 0, 350);
        gradient.addColorStop(0, color1);
        gradient.addColorStop(1, color2);
        return gradient;
    }

    // Revenue & Trip Count Trend Chart
    const revenueTrendCtx = document.getElementById('revenueTrendChart').getContext('2d');
    const revenueGradient = createGradient(revenueTrendCtx, 'rgba(249, 115, 22, 0.3)', 'rgba(249, 115, 22, 0.02)');
    const tripGradient = createGradient(revenueTrendCtx, 'rgba(16, 185, 129, 0.3)', 'rgba(16, 185, 129, 0.02)');

    new Chart(revenueTrendCtx, {
        type: 'line',
        data: {
            labels: @json($revenueData['months']),
            datasets: [
                {
                    label: '{{ __("revenue") }} ($)',
                    data: @json($revenueData['revenue']),
                    borderColor: chartColors.primary,
                    backgroundColor: revenueGradient,
                    fill: true,
                    yAxisID: 'y',
                    tension: 0.4,
                    borderWidth: 3,
                    pointRadius: 4,
                    pointBackgroundColor: chartColors.primary,
                    pointBorderColor: '#ffffff',
                    pointBorderWidth: 2,
                    pointHoverRadius: 6,
                    pointHoverBackgroundColor: chartColors.primary,
                    pointHoverBorderColor: '#ffffff',
                    pointHoverBorderWidth: 3
                },
                {
                    label: '{{ __("trip_count") }}',
                    data: @json($revenueData['tripCount']),
                    borderColor: chartColors.success,
                    backgroundColor: tripGradient,
                    fill: true,
                    yAxisID: 'y1',
                    tension: 0.4,
                    borderWidth: 3,
                    pointRadius: 4,
                    pointBackgroundColor: chartColors.success,
                    pointBorderColor: '#ffffff',
                    pointBorderWidth: 2,
                    pointHoverRadius: 6,
                    pointHoverBackgroundColor: chartColors.success,
                    pointHoverBorderColor: '#ffffff',
                    pointHoverBorderWidth: 3
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            interaction: {
                mode: 'index',
                intersect: false,
            },
            plugins: {
                legend: {
                    position: 'top',
                    align: 'end',
                    labels: {
                        usePointStyle: true,
                        pointStyle: 'circle',
                        padding: 20,
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 12,
                            weight: 500
                        }
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(30, 41, 59, 0.95)',
                    titleFont: {
                        family: "'Poppins', sans-serif",
                        size: 13,
                        weight: 600
                    },
                    bodyFont: {
                        family: "'Poppins', sans-serif",
                        size: 12
                    },
                    padding: 12,
                    cornerRadius: 10,
                    displayColors: true,
                    usePointStyle: true
                }
            },
            scales: {
                x: {
                    grid: {
                        display: false
                    },
                    ticks: {
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 11
                        }
                    }
                },
                y: {
                    type: 'linear',
                    display: true,
                    position: 'left',
                    title: {
                        display: true,
                        text: '{{ __("revenue") }} ($)',
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 12,
                            weight: 500
                        }
                    },
                    grid: {
                        color: 'rgba(0, 0, 0, 0.05)'
                    },
                    ticks: {
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 11
                        }
                    }
                },
                y1: {
                    type: 'linear',
                    display: true,
                    position: 'right',
                    title: {
                        display: true,
                        text: '{{ __("trip_count") }}',
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 12,
                            weight: 500
                        }
                    },
                    grid: {
                        drawOnChartArea: false,
                    },
                    ticks: {
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 11
                        }
                    }
                }
            }
        }
    });

    // Trip Status Distribution Chart (Doughnut)
    const tripDistributionCtx = document.getElementById('tripDistributionChart').getContext('2d');
    new Chart(tripDistributionCtx, {
        type: 'doughnut',
        data: {
            labels: @json(array_map(function($item) { return __($item['status']); }, $tripDistribution)),
            datasets: [{
                data: @json(array_column($tripDistribution, 'count')),
                backgroundColor: [
                    chartColors.warning,
                    chartColors.info,
                    chartColors.purple,
                    chartColors.success,
                    chartColors.danger
                ],
                borderWidth: 0,
                hoverOffset: 10,
                spacing: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            cutout: '70%',
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        usePointStyle: true,
                        pointStyle: 'circle',
                        padding: 15,
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 11,
                            weight: 500
                        }
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(30, 41, 59, 0.95)',
                    titleFont: {
                        family: "'Poppins', sans-serif",
                        size: 13,
                        weight: 600
                    },
                    bodyFont: {
                        family: "'Poppins', sans-serif",
                        size: 12
                    },
                    padding: 12,
                    cornerRadius: 10
                }
            }
        }
    });

    // Cost Breakdown Chart (Doughnut)
    const costBreakdownCtx = document.getElementById('costBreakdownChart').getContext('2d');
    new Chart(costBreakdownCtx, {
        type: 'doughnut',
        data: {
            labels: @json($costBreakdown['labels']),
            datasets: [{
                data: @json($costBreakdown['values']),
                backgroundColor: [
                    chartColors.primary,
                    chartColors.success,
                    chartColors.orange,
                    chartColors.info,
                    chartColors.purple
                ],
                borderWidth: 0,
                hoverOffset: 8,
                spacing: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            cutout: '65%',
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        usePointStyle: true,
                        pointStyle: 'circle',
                        padding: 12,
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 11,
                            weight: 500
                        }
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(30, 41, 59, 0.95)',
                    titleFont: {
                        family: "'Poppins', sans-serif",
                        size: 13,
                        weight: 600
                    },
                    bodyFont: {
                        family: "'Poppins', sans-serif",
                        size: 12
                    },
                    padding: 12,
                    cornerRadius: 10,
                    callbacks: {
                        label: function(context) {
                            return context.label + ': $' + context.parsed.toLocaleString();
                        }
                    }
                }
            }
        }
    });

    // Vehicle Type Distribution Chart (Bar)
    const vehicleTypeCtx = document.getElementById('vehicleTypeChart').getContext('2d');
    new Chart(vehicleTypeCtx, {
        type: 'bar',
        data: {
            labels: @json($vehicleTypeDistribution['labels']),
            datasets: [{
                label: '{{ __("vehicles") }}',
                data: @json($vehicleTypeDistribution['values']),
                backgroundColor: function(context) {
                    const colors = [
                        chartColors.primary,
                        chartColors.success,
                        chartColors.info,
                        chartColors.warning,
                        chartColors.purple
                    ];
                    return colors[context.dataIndex % colors.length];
                },
                borderRadius: 8,
                borderSkipped: false,
                barThickness: 40,
                maxBarThickness: 50
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    backgroundColor: 'rgba(30, 41, 59, 0.95)',
                    titleFont: {
                        family: "'Poppins', sans-serif",
                        size: 13,
                        weight: 600
                    },
                    bodyFont: {
                        family: "'Poppins', sans-serif",
                        size: 12
                    },
                    padding: 12,
                    cornerRadius: 10
                }
            },
            scales: {
                x: {
                    grid: {
                        display: false
                    },
                    ticks: {
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 11
                        }
                    }
                },
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(0, 0, 0, 0.05)'
                    },
                    ticks: {
                        stepSize: 1,
                        font: {
                            family: "'Poppins', sans-serif",
                            size: 11
                        }
                    }
                }
            }
        }
    });

    // Counter Animation
    document.addEventListener('DOMContentLoaded', function() {
        const counters = document.querySelectorAll('.counter-animate');
        counters.forEach(counter => {
            const target = parseInt(counter.innerText);
            const duration = 1500;
            const start = 0;
            const increment = target / (duration / 16);
            let current = start;
            
            const timer = setInterval(() => {
                current += increment;
                if (current >= target) {
                    counter.innerText = target;
                    clearInterval(timer);
                } else {
                    counter.innerText = Math.floor(current);
                }
            }, 16);
        });
    });

    // Update DateTime
    function updateDateTime() {
        const now = new Date();
        const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
        document.getElementById('currentDateTime').textContent = now.toLocaleDateString('{{ app()->getLocale() }}', options);
    }
    setInterval(updateDateTime, 60000);
</script>
@endpush