@extends('layouts.app')

@section('title', __('edit') . ' ' . __('deliveries') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admincreatepage.css') }}">
@endpush

@section('content')
<div class="create-page-container">
    {{-- Page Header --}}
    <div class="create-page-header">
        <div class="create-page-header-content">
            <div class="create-page-breadcrumb">
                <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.deliveries.index') }}">{{ __('deliveries') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.deliveries.show', $delivery) }}">{{ $delivery->trip->trip_number }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ __('edit') }}</span>
            </div>
            <h1 class="create-page-title">
                <div class="create-page-title-icon">
                    <i class="bi bi-pencil"></i>
                </div>
                {{ __('edit') }} {{ __('deliveries') }}
            </h1>
            <p class="create-page-subtitle">{{ __('Update the delivery details below') }}</p>
        </div>
        <div class="create-page-actions">
            <a href="{{ route('admin.deliveries.show', $delivery) }}" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('Back to Details') }}
            </a>
        </div>
    </div>

    {{-- Validation Errors --}}
    @if($errors->any())
        <div class="create-alert danger">
            <div class="create-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="create-alert-content">
                <div class="create-alert-title">{{ __('Validation Error') }}</div>
                <div class="create-alert-text">{{ __('Please check the form and fix the errors below.') }}</div>
            </div>
        </div>
    @endif

    <form action="{{ route('admin.deliveries.update', $delivery) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <div class="create-form-layout">
            {{-- Main Form --}}
            <div class="create-form-main">
                {{-- Trip Information Card (Read-only) --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-icon primary">
                            <i class="bi bi-geo-alt"></i>
                        </div>
                        <div>
                            <h5 class="create-card-title">{{ __('trip_details') }}</h5>
                            <p class="create-card-subtitle">{{ __('Associated trip information') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-info-grid">
                            <div class="create-info-item">
                                <span class="create-info-label">{{ __('trip_number') }}</span>
                                <span class="create-info-value highlight">
                                    <a href="{{ route('admin.trips.show', $delivery->trip) }}">
                                        {{ $delivery->trip->trip_number }}
                                    </a>
                                </span>
                            </div>
                            <div class="create-info-item">
                                <span class="create-info-label">{{ __('vehicle') }}</span>
                                <span class="create-info-value">
                                    <i class="bi bi-truck"></i>
                                    {{ $delivery->trip->vehicle->vehicle_number ?? 'N/A' }}
                                </span>
                            </div>
                            <div class="create-info-item">
                                <span class="create-info-label">{{ __('driver') }}</span>
                                <span class="create-info-value">
                                    <i class="bi bi-person"></i>
                                    {{ $delivery->trip->driver->name ?? 'N/A' }}
                                </span>
                            </div>
                            <div class="create-info-item">
                                <span class="create-info-label">{{ __('Trip Status') }}</span>
                                <span class="create-info-value">
                                    <span class="create-status-badge success">
                                        {{ __(ucfirst($delivery->trip->status)) }}
                                    </span>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Customer Information Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-icon info">
                            <i class="bi bi-person"></i>
                        </div>
                        <div>
                            <h5 class="create-card-title">{{ __('customer_details') }}</h5>
                            <p class="create-card-subtitle">{{ __('Update customer information') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="customer_name" class="create-label required">{{ __('customer_name') }}</label>
                                <input type="text" 
                                       class="create-input @error('customer_name') is-invalid @enderror" 
                                       id="customer_name" 
                                       name="customer_name" 
                                       value="{{ old('customer_name', $delivery->customer_name) }}"
                                       placeholder="{{ __('Enter customer name') }}"
                                       required>
                                @error('customer_name')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="create-form-group">
                                <label for="customer_phone" class="create-label">{{ __('customer_phone') }}</label>
                                <input type="tel" 
                                       class="create-input @error('customer_phone') is-invalid @enderror" 
                                       id="customer_phone" 
                                       name="customer_phone" 
                                       value="{{ old('customer_phone', $delivery->customer_phone) }}"
                                       placeholder="+91 98765 43210">
                                @error('customer_phone')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-group">
                            <label for="customer_email" class="create-label">{{ __('customer_email') }}</label>
                            <input type="email" 
                                   class="create-input @error('customer_email') is-invalid @enderror" 
                                   id="customer_email" 
                                   name="customer_email" 
                                   value="{{ old('customer_email', $delivery->customer_email) }}"
                                   placeholder="customer@example.com">
                            @error('customer_email')
                                <div class="create-error">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="create-form-group">
                            <label for="delivery_address" class="create-label required">{{ __('delivery_address') }}</label>
                            <textarea class="create-textarea @error('delivery_address') is-invalid @enderror" 
                                      id="delivery_address" 
                                      name="delivery_address" 
                                      rows="3"
                                      placeholder="{{ __('Enter complete delivery address') }}"
                                      required>{{ old('delivery_address', $delivery->delivery_address) }}</textarea>
                            @error('delivery_address')
                                <div class="create-error">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Delivery Details Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-icon success">
                            <i class="bi bi-clipboard-check"></i>
                        </div>
                        <div>
                            <h5 class="create-card-title">{{ __('delivery_information') }}</h5>
                            <p class="create-card-subtitle">{{ __('Update delivery details and status') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="delivered_at" class="create-label required">{{ __('delivered_at') }}</label>
                                <input type="datetime-local" 
                                       class="create-input @error('delivered_at') is-invalid @enderror" 
                                       id="delivered_at" 
                                       name="delivered_at" 
                                       value="{{ old('delivered_at', \Carbon\Carbon::parse($delivery->delivered_at)->format('Y-m-d\TH:i')) }}"
                                       required>
                                @error('delivered_at')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="create-form-group">
                                <label for="delivery_status" class="create-label required">{{ __('delivery_status') }}</label>
                                <select class="create-select @error('delivery_status') is-invalid @enderror" 
                                        id="delivery_status" 
                                        name="delivery_status" 
                                        required>
                                    <option value="">{{ __('select_option') }}</option>
                                    <option value="pending" {{ old('delivery_status', $delivery->delivery_status) === 'pending' ? 'selected' : '' }}>
                                        {{ __('pending') }}
                                    </option>
                                    <option value="partial" {{ old('delivery_status', $delivery->delivery_status) === 'partial' ? 'selected' : '' }}>
                                        {{ __('partial') }}
                                    </option>
                                    <option value="completed" {{ old('delivery_status', $delivery->delivery_status) === 'completed' ? 'selected' : '' }}>
                                        {{ __('completed') }}
                                    </option>
                                    <option value="failed" {{ old('delivery_status', $delivery->delivery_status) === 'failed' ? 'selected' : '' }}>
                                        {{ __('failed') }}
                                    </option>
                                </select>
                                @error('delivery_status')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="create-form-group">
                            <label for="delivery_remarks" class="create-label">{{ __('delivery_remarks') }}</label>
                            <textarea class="create-textarea @error('delivery_remarks') is-invalid @enderror" 
                                      id="delivery_remarks" 
                                      name="delivery_remarks" 
                                      rows="3"
                                      placeholder="{{ __('Any additional remarks or notes...') }}">{{ old('delivery_remarks', $delivery->delivery_remarks) }}</textarea>
                            @error('delivery_remarks')
                                <div class="create-error">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Documents Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-icon warning">
                            <i class="bi bi-file-earmark-image"></i>
                        </div>
                        <div>
                            <h5 class="create-card-title">{{ __('proof_of_delivery') }}</h5>
                            <p class="create-card-subtitle">{{ __('Update signature and POD documents') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="signature" class="create-label">{{ __('signature') }}</label>
                                @if($delivery->signature_path)
                                <div class="create-current-file">
                                    <a href="{{ Storage::url($delivery->signature_path) }}" target="_blank" class="create-file-preview-btn">
                                        <i class="bi bi-eye"></i>
                                        {{ __('View Current Signature') }}
                                    </a>
                                </div>
                                @endif
                                <div class="create-file-upload">
                                    <input type="file" 
                                           class="create-file-input @error('signature') is-invalid @enderror" 
                                           id="signature" 
                                           name="signature" 
                                           accept="image/jpeg,image/jpg,image/png">
                                    <label for="signature" class="create-file-label">
                                        <i class="bi bi-cloud-upload"></i>
                                        <span>{{ __('Choose new signature file') }}</span>
                                    </label>
                                </div>
                                @error('signature')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                                <small class="create-help">{{ __('Max 2MB. Formats: JPG, PNG. Leave empty to keep existing.') }}</small>
                            </div>

                            <div class="create-form-group">
                                <label for="pod_file" class="create-label">{{ __('pod_file') }}</label>
                                @if($delivery->pod_file_path)
                                <div class="create-current-file">
                                    <a href="{{ Storage::url($delivery->pod_file_path) }}" target="_blank" class="create-file-preview-btn">
                                        <i class="bi bi-eye"></i>
                                        {{ __('View Current POD') }}
                                    </a>
                                </div>
                                @endif
                                <div class="create-file-upload">
                                    <input type="file" 
                                           class="create-file-input @error('pod_file') is-invalid @enderror" 
                                           id="pod_file" 
                                           name="pod_file" 
                                           accept="image/jpeg,image/jpg,image/png,application/pdf">
                                    <label for="pod_file" class="create-file-label">
                                        <i class="bi bi-cloud-upload"></i>
                                        <span>{{ __('Choose new POD file') }}</span>
                                    </label>
                                </div>
                                @error('pod_file')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                                <small class="create-help">{{ __('Max 5MB. Formats: JPG, PNG, PDF. Leave empty to keep existing.') }}</small>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Form Actions --}}
                <div class="create-card">
                    <div class="create-card-body">
                        <div class="create-form-actions">
                            <a href="{{ route('admin.deliveries.show', $delivery) }}" class="create-btn create-btn-secondary">
                                <i class="bi bi-x-lg"></i>
                                {{ __('cancel') }}
                            </a>
                            <button type="submit" class="create-btn create-btn-primary">
                                <i class="bi bi-save"></i>
                                {{ __('Update Delivery') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Sidebar --}}
            <div class="create-form-sidebar">
                {{-- Current Status Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon {{ $delivery->delivery_status === 'completed' ? 'success' : ($delivery->delivery_status === 'failed' ? 'danger' : 'warning') }}">
                            <i class="bi bi-{{ $delivery->delivery_status === 'completed' ? 'check-circle' : ($delivery->delivery_status === 'failed' ? 'x-circle' : 'clock') }}"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Current Status') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-status-preview">
                            @php
                                $statusClass = [
                                    'pending' => 'pending',
                                    'partial' => 'warning',
                                    'completed' => 'success',
                                    'failed' => 'danger'
                                ][$delivery->delivery_status] ?? 'pending';
                            @endphp
                            <span class="create-status-badge {{ $statusClass }}">
                                <i class="bi bi-{{ $delivery->delivery_status === 'completed' ? 'check-circle' : ($delivery->delivery_status === 'failed' ? 'x-circle' : ($delivery->delivery_status === 'partial' ? 'exclamation-circle' : 'clock')) }}"></i>
                                {{ __(ucfirst($delivery->delivery_status)) }}
                            </span>
                            <p class="create-status-description">
                                {{ __('Created') }}: {{ $delivery->created_at->format('d M Y, h:i A') }}
                            </p>
                        </div>
                    </div>
                </div>

                {{-- Delivery Details Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon primary">
                            <i class="bi bi-clipboard-check"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Delivery Details') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-hash"></i>
                                <span><strong>{{ __('ID') }}:</strong> #{{ $delivery->id }}</span>
                            </li>
                            <li>
                                <i class="bi bi-geo-alt"></i>
                                <span><strong>{{ __('Trip') }}:</strong> {{ $delivery->trip->trip_number }}</span>
                            </li>
                            <li>
                                <i class="bi bi-person"></i>
                                <span><strong>{{ __('Created By') }}:</strong> {{ $delivery->creator->name ?? 'N/A' }}</span>
                            </li>
                            @if($delivery->updated_at)
                            <li>
                                <i class="bi bi-clock-history"></i>
                                <span><strong>{{ __('Last Updated') }}:</strong> {{ $delivery->updated_at->diffForHumans() }}</span>
                            </li>
                            @endif
                        </ul>
                    </div>
                </div>

                {{-- Quick Actions Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon success">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Quick Actions') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="{{ route('admin.deliveries.show', $delivery) }}" class="create-quick-action-btn">
                                <i class="bi bi-eye"></i>
                                {{ __('View Details') }}
                            </a>
                            <a href="{{ route('admin.deliveries.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                {{ __('View All Deliveries') }}
                            </a>
                            <a href="{{ route('admin.trips.show', $delivery->trip) }}" class="create-quick-action-btn">
                                <i class="bi bi-geo-alt"></i>
                                {{ __('View Trip') }}
                            </a>
                        </div>
                    </div>
                </div>

                {{-- Documents Status Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon info">
                            <i class="bi bi-file-earmark"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Documents') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-{{ $delivery->signature_path ? 'check-circle-fill text-success' : 'x-circle-fill text-danger' }}"></i>
                                <span>{{ __('Signature') }}: {{ $delivery->signature_path ? __('Available') : __('Not Uploaded') }}</span>
                            </li>
                            <li>
                                <i class="bi bi-{{ $delivery->pod_file_path ? 'check-circle-fill text-success' : 'x-circle-fill text-danger' }}"></i>
                                <span>{{ __('POD File') }}: {{ $delivery->pod_file_path ? __('Available') : __('Not Uploaded') }}</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // File upload preview
    const fileInputs = document.querySelectorAll('.create-file-input');
    fileInputs.forEach(input => {
        input.addEventListener('change', function() {
            const label = this.nextElementSibling;
            const fileName = this.files[0]?.name || 'Choose file';
            label.querySelector('span').textContent = fileName;
        });
    });
});
</script>
@endpush