@extends('layouts.app')

@section('title', $delivery->trip->trip_number . ' - ' . __('Delivery Details'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admindetailpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header with Breadcrumb --}}
    <div class="page-header">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('admin.deliveries.index') }}">{{ __('deliveries') }}</a></li>
                    <li class="breadcrumb-item active">{{ $delivery->trip->trip_number }}</li>
                </ol>
            </nav>
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <div class="detail-alert detail-alert-info">
            <div class="detail-alert-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title">{{ __('Success') }}</div>
                <div class="detail-alert-text">{{ session('success') }}</div>
            </div>
        </div>
    @endif

    @if(session('error'))
        <div class="detail-alert detail-alert-warning">
            <div class="detail-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title">{{ __('Error') }}</div>
                <div class="detail-alert-text">{{ session('error') }}</div>
            </div>
        </div>
    @endif

    @php
        $statusClasses = [
            'pending' => 'pending',
            'partial' => 'assigned',
            'completed' => 'delivered',
            'failed' => 'cancelled'
        ];
        $statusIcons = [
            'pending' => 'clock',
            'partial' => 'exclamation-circle',
            'completed' => 'check-all',
            'failed' => 'x-circle'
        ];
    @endphp

    {{-- Hero Section --}}
    <div class="detail-hero">
        <div class="detail-hero-header">
            <div class="detail-hero-content">
                <div class="detail-hero-icon">
                    <i class="bi bi-clipboard-check"></i>
                </div>
                <div class="detail-hero-info">
                    <h1 class="detail-hero-title">{{ $delivery->trip->trip_number }}</h1>
                    <p class="detail-hero-subtitle">{{ $delivery->customer_name }} · {{ __('Delivered') }} {{ \Carbon\Carbon::parse($delivery->delivered_at)->format('M d, Y') }}</p>
                    <div class="detail-hero-badges">
                        <span class="status-badge status-badge-{{ $statusClasses[$delivery->delivery_status] ?? 'pending' }}">
                            <i class="bi bi-{{ $statusIcons[$delivery->delivery_status] ?? 'circle' }}"></i>
                            {{ __(ucfirst($delivery->delivery_status)) }}
                        </span>
                    </div>
                </div>
            </div>
            <div class="detail-actions">
                @if(auth()->user()->hasPermission('deliveries.edit'))
                <a href="{{ route('admin.deliveries.edit', $delivery) }}" class="btn-detail btn-detail-warning">
                    <i class="bi bi-pencil"></i>
                    {{ __('edit') }}
                </a>
                @endif
                <a href="{{ route('admin.deliveries.index') }}" class="btn-detail btn-detail-outline">
                    <i class="bi bi-arrow-left"></i>
                    {{ __('Back to List') }}
                </a>
            </div>
        </div>
        <div class="detail-hero-body">
            <div class="hero-stat">
                <div class="hero-stat-value">
                    <i class="bi bi-person text-primary"></i>
                </div>
                <div class="hero-stat-label">{{ $delivery->customer_name }}</div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value">
                    <i class="bi bi-truck text-info"></i>
                </div>
                <div class="hero-stat-label">{{ $delivery->trip->vehicle->vehicle_number ?? 'N/A' }}</div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value">
                    <i class="bi bi-person-badge text-success"></i>
                </div>
                <div class="hero-stat-label">{{ $delivery->trip->driver->name ?? 'N/A' }}</div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value">{{ \Carbon\Carbon::parse($delivery->delivered_at)->format('d M') }}</div>
                <div class="hero-stat-label">{{ __('delivered_at') }}</div>
            </div>
        </div>
    </div>

    {{-- Status Progress --}}
    <div class="detail-card mb-4">
        <div class="detail-card-body">
            <div class="progress-steps">
                <div class="progress-step completed">
                    <div class="progress-step-icon">
                        <i class="bi bi-check-lg"></i>
                    </div>
                    <div class="progress-step-label">{{ __('Created') }}</div>
                </div>
                <div class="progress-step {{ in_array($delivery->delivery_status, ['partial', 'completed']) ? 'completed' : ($delivery->delivery_status === 'pending' ? 'active' : '') }}">
                    <div class="progress-step-icon">
                        <i class="bi bi-{{ in_array($delivery->delivery_status, ['partial', 'completed']) ? 'check-lg' : 'clock' }}"></i>
                    </div>
                    <div class="progress-step-label">{{ __('Processing') }}</div>
                </div>
                <div class="progress-step {{ $delivery->delivery_status === 'completed' ? 'completed' : ($delivery->delivery_status === 'partial' ? 'active' : '') }}">
                    <div class="progress-step-icon">
                        <i class="bi bi-{{ $delivery->delivery_status === 'completed' ? 'check-lg' : 'box-arrow-in-down' }}"></i>
                    </div>
                    <div class="progress-step-label">{{ __('completed') }}</div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        {{-- Main Content --}}
        <div class="col-lg-8">
            {{-- Customer Information Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon primary">
                        <i class="bi bi-person"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('customer_details') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-item-label">{{ __('customer_name') }}</span>
                            <span class="info-item-value highlight">{{ $delivery->customer_name }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('customer_phone') }}</span>
                            <span class="info-item-value">
                                @if($delivery->customer_phone)
                                    <a href="tel:{{ $delivery->customer_phone }}">
                                        <i class="bi bi-telephone"></i> {{ $delivery->customer_phone }}
                                    </a>
                                @else
                                    -
                                @endif
                            </span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('customer_email') }}</span>
                            <span class="info-item-value">
                                @if($delivery->customer_email)
                                    <a href="mailto:{{ $delivery->customer_email }}">
                                        <i class="bi bi-envelope"></i> {{ $delivery->customer_email }}
                                    </a>
                                @else
                                    -
                                @endif
                            </span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('delivery_address') }}</span>
                            <span class="info-item-value">
                                <i class="bi bi-geo-alt"></i> {{ $delivery->delivery_address }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Trip Information Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon info">
                        <i class="bi bi-geo-alt"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('trip_details') }}</h5>
                </div>
                <div class="detail-card-body">
                    {{-- Trip Entity Card --}}
                    <div class="entity-card mb-3">
                        <div class="entity-card-avatar primary">
                            <i class="bi bi-geo-alt"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-title">
                                <a href="{{ route('admin.trips.show', $delivery->trip) }}">{{ $delivery->trip->trip_number }}</a>
                            </h6>
                            <p class="entity-card-subtitle">{{ __('Trip Number') }}</p>
                        </div>
                        <a href="{{ route('admin.trips.show', $delivery->trip) }}" class="btn-detail btn-detail-outline btn-sm">
                            <i class="bi bi-arrow-right"></i>
                            {{ __('View Trip') }}
                        </a>
                    </div>

                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-item-label">{{ __('vehicle') }}</span>
                            <span class="info-item-value">
                                <i class="bi bi-truck"></i>
                                {{ $delivery->trip->vehicle->vehicle_number ?? 'N/A' }}
                                @if($delivery->trip->vehicle && $delivery->trip->vehicle->vehicleType)
                                    <small class="text-muted">({{ $delivery->trip->vehicle->vehicleType->name }})</small>
                                @endif
                            </span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('driver') }}</span>
                            <span class="info-item-value">
                                <i class="bi bi-person"></i>
                                {{ $delivery->trip->driver->name ?? 'N/A' }}
                            </span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Trip Status') }}</span>
                            <span class="info-item-value">
                                <span class="status-badge status-badge-delivered">
                                    <i class="bi bi-check-all"></i>
                                    {{ __(ucfirst($delivery->trip->status)) }}
                                </span>
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Delivery Information Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon success">
                        <i class="bi bi-clipboard-check"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('delivery_information') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-item-label">{{ __('delivered_at') }}</span>
                            <span class="info-item-value">
                                <i class="bi bi-calendar"></i>
                                {{ \Carbon\Carbon::parse($delivery->delivered_at)->format('d M Y, h:i A') }}
                            </span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('delivery_status') }}</span>
                            <span class="info-item-value">
                                <span class="status-badge status-badge-{{ $statusClasses[$delivery->delivery_status] ?? 'pending' }}">
                                    <i class="bi bi-{{ $statusIcons[$delivery->delivery_status] ?? 'circle' }}"></i>
                                    {{ __(ucfirst($delivery->delivery_status)) }}
                                </span>
                            </span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('delivery_created_by') }}</span>
                            <span class="info-item-value">
                                <i class="bi bi-person"></i>
                                {{ $delivery->creator->name ?? 'N/A' }}
                            </span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Created At') }}</span>
                            <span class="info-item-value">
                                <i class="bi bi-clock"></i>
                                {{ $delivery->created_at->format('d M Y, h:i A') }}
                            </span>
                        </div>
                    </div>
                    @if($delivery->delivery_remarks)
                    <div class="mt-3 p-3 bg-light rounded">
                        <span class="info-item-label d-block mb-2">{{ __('delivery_remarks') }}</span>
                        <span class="info-item-value">{{ $delivery->delivery_remarks }}</span>
                    </div>
                    @endif
                </div>
            </div>

            {{-- Proof of Delivery Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon warning">
                        <i class="bi bi-file-earmark-image"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('proof_of_delivery') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="row">
                        {{-- Signature --}}
                        <div class="col-md-6 mb-3">
                            <div class="pod-card">
                                <div class="pod-card-header">
                                    <i class="bi bi-pen"></i>
                                    <span>{{ __('signature') }}</span>
                                </div>
                                @if($delivery->signature_path)
                                    <div class="pod-card-preview">
                                        <img src="{{ Storage::url($delivery->signature_path) }}" 
                                             alt="Signature" 
                                             class="pod-image">
                                    </div>
                                    <div class="pod-card-actions">
                                        <a href="{{ Storage::url($delivery->signature_path) }}" 
                                           target="_blank" 
                                           class="btn-detail btn-detail-primary btn-sm">
                                            <i class="bi bi-eye"></i>
                                            {{ __('View') }}
                                        </a>
                                        <a href="{{ route('admin.deliveries.download-signature', $delivery) }}" 
                                           class="btn-detail btn-detail-outline btn-sm">
                                            <i class="bi bi-download"></i>
                                            {{ __('Download') }}
                                        </a>
                                    </div>
                                @else
                                    <div class="pod-card-empty">
                                        <i class="bi bi-pen"></i>
                                        <span>{{ __('no_signature') }}</span>
                                    </div>
                                @endif
                            </div>
                        </div>

                        {{-- POD File --}}
                        <div class="col-md-6 mb-3">
                            <div class="pod-card">
                                <div class="pod-card-header">
                                    <i class="bi bi-file-earmark-pdf"></i>
                                    <span>{{ __('pod_file') }}</span>
                                </div>
                                @if($delivery->pod_file_path)
                                    @php
                                        $extension = pathinfo($delivery->pod_file_path, PATHINFO_EXTENSION);
                                        $isImage = in_array(strtolower($extension), ['jpg', 'jpeg', 'png']);
                                    @endphp
                                    @if($isImage)
                                        <div class="pod-card-preview">
                                            <img src="{{ Storage::url($delivery->pod_file_path) }}" 
                                                 alt="POD" 
                                                 class="pod-image">
                                        </div>
                                    @else
                                        <div class="pod-card-file">
                                            <i class="bi bi-file-earmark-pdf"></i>
                                            <span>PDF {{ __('Document') }}</span>
                                        </div>
                                    @endif
                                    <div class="pod-card-actions">
                                        <a href="{{ Storage::url($delivery->pod_file_path) }}" 
                                           target="_blank" 
                                           class="btn-detail btn-detail-primary btn-sm">
                                            <i class="bi bi-eye"></i>
                                            {{ __('View') }}
                                        </a>
                                        <a href="{{ route('admin.deliveries.download-pod', $delivery) }}" 
                                           class="btn-detail btn-detail-outline btn-sm">
                                            <i class="bi bi-download"></i>
                                            {{ __('Download') }}
                                        </a>
                                    </div>
                                @else
                                    <div class="pod-card-empty">
                                        <i class="bi bi-file-earmark-x"></i>
                                        <span>{{ __('no_pod_file') }}</span>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Sidebar --}}
        <div class="col-lg-4">
            {{-- Actions Card --}}
            @if(auth()->user()->hasPermission('deliveries.edit') || auth()->user()->hasPermission('deliveries.delete'))
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon primary">
                        <i class="bi bi-gear"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('actions') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="d-grid gap-2">
                        @if(auth()->user()->hasPermission('deliveries.edit'))
                        <a href="{{ route('admin.deliveries.edit', $delivery) }}" class="btn-detail btn-detail-warning w-100 justify-content-center">
                            <i class="bi bi-pencil"></i>
                            {{ __('Edit Delivery') }}
                        </a>
                        @endif

                        @if($delivery->signature_path)
                        <a href="{{ route('admin.deliveries.download-signature', $delivery) }}" class="btn-detail btn-detail-primary w-100 justify-content-center">
                            <i class="bi bi-pen"></i>
                            {{ __('download_signature') }}
                        </a>
                        @endif

                        @if($delivery->pod_file_path)
                        <a href="{{ route('admin.deliveries.download-pod', $delivery) }}" class="btn-detail btn-detail-info w-100 justify-content-center">
                            <i class="bi bi-file-earmark-pdf"></i>
                            {{ __('download_pod') }}
                        </a>
                        @endif

                        @if(auth()->user()->hasPermission('deliveries.delete'))
                        <form action="{{ route('admin.deliveries.destroy', $delivery) }}" 
                              method="POST" 
                              onsubmit="return confirm('{{ __('Are you sure you want to delete this delivery?') }}')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn-detail btn-detail-danger w-100 justify-content-center">
                                <i class="bi bi-trash"></i>
                                {{ __('Delete Delivery') }}
                            </button>
                        </form>
                        @endif
                    </div>
                </div>
            </div>
            @endif

            {{-- Creator & Timeline Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon secondary">
                        <i class="bi bi-clock-history"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Activity') }}</h5>
                </div>
                <div class="detail-card-body">
                    {{-- Creator Info --}}
                    <div class="entity-card mb-3">
                        <div class="entity-card-avatar info">
                            <i class="bi bi-person"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-title">{{ $delivery->creator->name ?? 'N/A' }}</h6>
                            <p class="entity-card-subtitle">{{ __('Created By') }}</p>
                        </div>
                    </div>

                    {{-- Timeline --}}
                    <div class="detail-timeline">
                        <div class="timeline-item">
                            <div class="timeline-marker primary">
                                <i class="bi bi-plus"></i>
                            </div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">{{ __('Delivery Created') }}</h6>
                                <p class="timeline-time">{{ $delivery->created_at->format('M d, Y \a\t h:i A') }}</p>
                            </div>
                        </div>
                        
                        <div class="timeline-item">
                            <div class="timeline-marker {{ $delivery->delivery_status === 'completed' ? 'success' : ($delivery->delivery_status === 'failed' ? 'danger' : 'info') }}">
                                <i class="bi bi-{{ $statusIcons[$delivery->delivery_status] ?? 'circle' }}"></i>
                            </div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">{{ __('Status') }}: {{ __(ucfirst($delivery->delivery_status)) }}</h6>
                                <p class="timeline-time">{{ \Carbon\Carbon::parse($delivery->delivered_at)->format('M d, Y \a\t h:i A') }}</p>
                            </div>
                        </div>

                        @if($delivery->updated_at->ne($delivery->created_at))
                        <div class="timeline-item">
                            <div class="timeline-marker secondary">
                                <i class="bi bi-pencil"></i>
                            </div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">{{ __('Last Updated') }}</h6>
                                <p class="timeline-time">{{ $delivery->updated_at->format('M d, Y \a\t h:i A') }}</p>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            {{-- Documents Status Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon warning">
                        <i class="bi bi-file-earmark"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Documents Status') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="data-list">
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-pen"></i>
                                {{ __('signature') }}
                            </span>
                            <span class="data-list-item-value">
                                @if($delivery->signature_path)
                                    <span class="status-badge status-badge-delivered">
                                        <i class="bi bi-check-circle"></i>
                                        {{ __('Available') }}
                                    </span>
                                @else
                                    <span class="status-badge status-badge-cancelled">
                                        <i class="bi bi-x-circle"></i>
                                        {{ __('Not Uploaded') }}
                                    </span>
                                @endif
                            </span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-file-earmark-pdf"></i>
                                {{ __('pod_file') }}
                            </span>
                            <span class="data-list-item-value">
                                @if($delivery->pod_file_path)
                                    <span class="status-badge status-badge-delivered">
                                        <i class="bi bi-check-circle"></i>
                                        {{ __('Available') }}
                                    </span>
                                @else
                                    <span class="status-badge status-badge-cancelled">
                                        <i class="bi bi-x-circle"></i>
                                        {{ __('Not Uploaded') }}
                                    </span>
                                @endif
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Quick Stats Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon info">
                        <i class="bi bi-bar-chart"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Quick Stats') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="data-list">
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-hash"></i>
                                {{ __('Delivery ID') }}
                            </span>
                            <span class="data-list-item-value">#{{ $delivery->id }}</span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-geo-alt"></i>
                                {{ __('Trip') }}
                            </span>
                            <span class="data-list-item-value">
                                <a href="{{ route('admin.trips.show', $delivery->trip) }}">{{ $delivery->trip->trip_number }}</a>
                            </span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-truck"></i>
                                {{ __('Vehicle') }}
                            </span>
                            <span class="data-list-item-value">{{ $delivery->trip->vehicle->vehicle_number ?? 'N/A' }}</span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-calendar"></i>
                                {{ __('Days Since Delivery') }}
                            </span>
                            <span class="data-list-item-value">{{ \Carbon\Carbon::parse($delivery->delivered_at)->diffInDays(now()) }} {{ __('days') }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
/* POD Card Styles */
.pod-card {
    background: var(--body-bg);
    border-radius: 12px;
    overflow: hidden;
}

.pod-card-header {
    padding: 0.75rem 1rem;
    background: var(--card-bg);
    border-bottom: 1px solid var(--border-color);
    font-weight: 600;
    font-size: 0.9rem;
    color: var(--text-primary);
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.pod-card-header i {
    color: var(--primary-color);
}

.pod-card-preview {
    padding: 1rem;
    background: var(--card-bg);
    border-bottom: 1px solid var(--border-color);
}

.pod-image {
    width: 100%;
    height: 150px;
    object-fit: contain;
    border-radius: 8px;
}

.pod-card-file {
    padding: 2rem 1rem;
    background: var(--card-bg);
    border-bottom: 1px solid var(--border-color);
    text-align: center;
}

.pod-card-file i {
    font-size: 3rem;
    color: var(--danger-color);
    display: block;
    margin-bottom: 0.5rem;
}

.pod-card-file span {
    font-size: 0.85rem;
    color: var(--text-secondary);
}

.pod-card-empty {
    padding: 2.5rem 1rem;
    text-align: center;
    color: var(--text-muted);
}

.pod-card-empty i {
    font-size: 2.5rem;
    display: block;
    margin-bottom: 0.5rem;
}

.pod-card-empty span {
    font-size: 0.85rem;
}

.pod-card-actions {
    padding: 1rem;
    display: flex;
    gap: 0.5rem;
}

.pod-card-actions .btn-detail {
    flex: 1;
    justify-content: center;
}

/* Button Info Color */
.btn-detail-info {
    background: var(--info-color);
    color: #ffffff;
}

.btn-detail-info:hover {
    background: #0284c7;
    color: #ffffff;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(14, 165, 233, 0.35);
}
</style>
@endpush